class FA18_DDI_RDR extends FA18_DDI_Page {
    constructor() {
        super(...arguments);
		this._rdr_mode = 0;			
		this._rdr_zoomRanges = [5, 10, 25, 50, 100, 200];
        this._rdr_mapMode = 0;
    }
    get templateID() { return "FA18_DDI_RDR"; }
    init(ddi) {
        super.init(ddi);
	    this.init_rdr();
        this.init_rdr_elements();
	    this.rdr_label1 = this.getElementsByClassName("sk-label-1")[0];
        this.rdr_label2 = this.getElementsByClassName("sk-label-2")[0];
        this.rdr_label3 = this.getElementsByClassName("sk-label-3")[0];
        this.rdr_label4 = this.getElementsByClassName("sk-label-4")[0];
        this.rdr_label5 = this.getElementsByClassName("sk-label-5")[0];
        this.rdr_label6 = this.getElementsByClassName("sk-label-6")[0];	
    }
	 init_rdr() {
		 // let Zoom = this._rdr_map.getZoom()
        this._rdr_map_container = this.ddi.getChildById("radar-main-map");
        this._rdr_camera_container = this.ddi.getChildById("radar-container");
        this._rdr_cameraInstrument = this.ddi.getChildById("rdr-camera");
		this._rdr_scaleValue = this.ddi.getChildById("RdrScaleButton");
		let _a = this._rdr_cameraInstrument;
		_a.init(this);	
		  this._rdr_map =  this.ddi.getChildById("radar-map")
		  let _b = this._rdr_map;
		_b.init(this);	
		this._init_rdr_map_settings();
    }

	_init_rdr_map_settings(){
		this._rdr_map.rotateWithPlane(true);
		diffAndSetAttribute(this._rdr_map, "show-bing-map", "false");
	    diffAndSetAttribute(this._rdr_map, "show-flightplan-waypoints", "true");
		this._rdr_map.zoomRanges = this.getAdaptiveRanges(2.25);
        this._rdr_map.setZoom(0);
        this._rdr_map.setPlaneIcon(2);
        this._rdr_map.showRoads = false;
        this._rdr_map.showObstacles = false;
        this._rdr_map.showAirspaces = false;
        this._rdr_map.showAirways = false;
        this._rdr_map.showObstacles = false;
        this._rdr_map.showCities = false;
        this._rdr_map.showConstraints = false;
        this._rdr_map.showVORs = true;
        this._rdr_map.showIntersections = true;
        this._rdr_map.showNDBs = true;
        this._rdr_map.showAirports = true;
        this._rdr_map.showTraffic = true;
        this._rdr_map.setHideReachedWaypoints(true);
        this._rdr_map.vorMaxRange = Infinity;
        this._rdr_map.ndbMaxRange = Infinity;
        this._rdr_map.smallAirportMaxRange = Infinity;
        this._rdr_map.medAirportMaxRange = Infinity;
        this._rdr_map.largeAirportMaxRange = Infinity;
        this._rdr_map.npcAirplaneMaxRange = Infinity;


	}
    getAdaptiveRanges(_factor) {
        let ranges = Array.from(this._rdr_zoomRanges);
        for (let i = 0; i < ranges.length; i++)
            ranges[i] *= _factor;
        return ranges;
    }
    getDisplayRange() {
        return this._rdr_zoomRanges[this._rdr_map.getZoom()];
    }
    incZoom() {
        let newZoom = this._rdr_map.getZoom() + 1;
        if (newZoom > this._rdr_zoomRanges.length - 1)
            newZoom = 0;
        // this._rdr_map.setZoom(newZoom);
		SimVar.SetSimVarValue("L:RADAR_RANGE", "number", newZoom)
    }
    decZoom() {
        let newZoom = this._rdr_map.getZoom() - 1;
        if (newZoom < 0)
            newZoom = this._rdr_zoomRanges.length - 1;
        // this._rdr_map.setZoom(newZoom);
		SimVar.SetSimVarValue("L:RADAR_RANGE", "number", newZoom)
    }
	
	
	
	
    init_rdr_elements() {
        this._rdr_g = this.ddi.getChildById("rdr-g");
        this._rdr_grid_g = this.ddi.getChildById("rdr-radar-grid");
        this._rdr_horizon_g = this.ddi.getChildById("rdr-horizon-g");
        this._rdr_horizon_line = this.ddi.getChildById("rdr-horizon-line");
        this._rdr_map_grid_g = this.ddi.getChildById("rdr-map-grid");
		
													   												 
    }
    show() {
        super.show();
        this.ddi.onButtonPressed[18] = () => {
            this.ddi.showPage(FA18_DDI_Page_Type.MenuTactical);
        };
		 this.ddi.onButtonPressed[1] = () => {
			this.set_sight_mode(0);
        };
		this.ddi.onButtonPressed[2] = () => {
            this.set_sight_mode(1);
        };
		this.ddi.onButtonPressed[3] = () => {
			// this.set_map_on_off()
			this.set_sight_mode(2);
        };
		this.ddi.onButtonPressed[4] = () => {
            this.set_sight_mode(3);
        };
		this.ddi.onButtonPressed[5] = () => {
            this.set_sight_mode(4);
        };
		this.ddi.onButtonPressed[6] = () => {
            this.set_sight_mode(5);
        };
	    this.ddi.onButtonPressed[8] = () => {
            this.decZoom();
            diffAndSetText(this._rdr_scaleValue, "RNG/" + this.getDisplayRange());
        };
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
	set_sight_mode(_value){
		// this._rdr_mode = _value;
		SimVar.SetSimVarValue("L:RDR_MODE", "number", _value);
	}
	// set_map_on_off(){
	 // let rdr_map =  SimVar.GetSimVarValue("L:RDR_MAP", "Bool");
	 // SimVar.SetSimVarValue("L:RDR_MAP", "Bool", !rdr_map);
	// }
    update(deltaTime) {	 
        super.update(deltaTime);	
        this.update_rdr(deltaTime);
		
		let rdr_map =  SimVar.GetSimVarValue("L:RDR_MAP", "Bool");
		this.rdr_label1.classList.toggle("sk-label-highlight", (this._rdr_mode === 0));
		this.rdr_label2.classList.toggle("sk-label-highlight", (this._rdr_mode === 1));
		this.rdr_label3.classList.toggle("sk-label-highlight", (this._rdr_mode === 2));
		// this.rdr_label3.classList.toggle("sk-label-highlight", (rdr_map));
		this.rdr_label4.classList.toggle("sk-label-highlight", (this._rdr_mode === 3));
		this.rdr_label5.classList.toggle("sk-label-highlight", (this._rdr_mode === 4));
		this.rdr_label6.classList.toggle("sk-label-highlight", (this._rdr_mode === 5));
		

		this._rdr_mode = SimVar.GetSimVarValue("L:RDR_MODE", "number");
		var maprange = SimVar.GetSimVarValue("L:RADAR_RANGE", "number");
		this._rdr_map.setZoom(maprange);
		 diffAndSetText(this._rdr_scaleValue, "RNG/" + this._rdr_zoomRanges[this._rdr_map.getZoom()] + "");				
    }
	update_rdr(deltaTime) {
        switch (this._rdr_mode) {
            case 0:																
                diffAndSetAttribute(this._rdr_g, "display", "block");
                diffAndSetStyle(this._rdr_map_container, "display", "none");
                diffAndSetStyle(this._rdr_camera_container, "display", "none");
                diffAndSetAttribute(this._rdr_grid_g, "display", "block");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "block");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "block");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "none");
				this.update_horizon();
                break;
            case 1:
                diffAndSetAttribute(this._rdr_g, "display", "block");
                diffAndSetStyle(this._rdr_map_container, "display", "none");
                diffAndSetStyle(this._rdr_camera_container, "display", "none");
                diffAndSetAttribute(this._rdr_grid_g, "display", "block");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "block");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "block");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "none");
				this.update_horizon();
                break;				
			case 2:
                diffAndSetAttribute(this._rdr_g, "display", "block");
                if (this._rdr_map) { 
					this._rdr_map.update(deltaTime); 
				}
                diffAndSetStyle(this._rdr_map_container, "display", "block");
                diffAndSetStyle(this._rdr_camera_container, "display", "none");
                diffAndSetAttribute(this._rdr_grid_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "none");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "block");
                break;	
			 case 3:
                diffAndSetAttribute(this._rdr_g, "display", "block");
                if (this._rdr_map) { 
					this._rdr_map.update(deltaTime);
				}
                diffAndSetStyle(this._rdr_map_container, "display", "block");
                diffAndSetStyle(this._rdr_camera_container, "display", "none");
                diffAndSetAttribute(this._rdr_grid_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "none");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "block");
                break;
			 case 4:
                diffAndSetAttribute(this._rdr_g, "display", "block");
                if (this._rdr_map) { 
					this._rdr_map.update(deltaTime); 
				}
                diffAndSetStyle(this._rdr_map_container, "display", "block");
                diffAndSetStyle(this._rdr_camera_container, "display", "none");
                diffAndSetAttribute(this._rdr_grid_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "none");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "block");
                break;
            case 5:
                diffAndSetAttribute(this._rdr_g, "display", "block");
                if (this._rdr_cameraInstrument) { 
					this._rdr_cameraInstrument.update(deltaTime); 				
				}
                diffAndSetStyle(this._rdr_map_container, "display", "none");
                diffAndSetStyle(this._rdr_camera_container, "display", "block");
                diffAndSetAttribute(this._rdr_grid_g, "display", "block");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "block");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "block");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "none");
				this.update_horizon();
                break;
            default:
                diffAndSetStyle(this._rdr_map_container, "display", "none");
                diffAndSetStyle(this._rdr_camera_container, "display", "none");
                diffAndSetAttribute(this._rdr_grid_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_g, "display", "none");
                diffAndSetAttribute(this._rdr_horizon_line, "display", "none");
                diffAndSetAttribute(this._rdr_map_grid_g, "display", "none");
                break;
        }
		this.update_rdr_map_modes();
    }
	update_rdr_map_modes(){
		 switch (this._rdr_mode) {
            case 2:
			     this._rdr_map.showTraffic = true;
                this._rdr_map.showIntersections = true;
                this._rdr_map.showNDBs = true;
                this._rdr_map.showAirports = true;
                this._rdr_map.showVORs = true;
			    this._rdr_map.showAirports = true;
                break;
            case 3:
			    this._rdr_map.showTraffic = true;
                this._rdr_map.showIntersections = false;
                this._rdr_map.showNDBs = false;
                this._rdr_map.showAirports = false;
                this._rdr_map.showVORs = false;
				this._rdr_map.showAirports = false;
                break;
            case 4:
			    this._rdr_map.showTraffic = false;
                this._rdr_map.showConstraints = true;
                this._rdr_map.showIntersections = true;
                this._rdr_map.showNDBs = true;
                this._rdr_map.showAirports = true;
                this._rdr_map.showVORs = false;
				this._rdr_map.showAirports = true;
                break;
            default:
				this._rdr_map.showTraffic = false;
                this._rdr_map.showRoads = false;
                this._rdr_map.showAirways = false;
                this._rdr_map.showObstacles = false;
                this._rdr_map.showCities = false;
                this._rdr_map.showConstraints = false;
                this._rdr_map.showIntersections = false;
                this._rdr_map.showNDBs = false;
                this._rdr_map.showAirports = false;
                this._rdr_map.showVORs = false;
                break;
        }
		// let rdr_map =  SimVar.GetSimVarValue("L:RDR_MAP", "Bool");
		diffAndSetAttribute(this._rdr_map, "show-bing-map", this._rdr_mode == 2 ? "true" : "false");
	}
 	update_horizon() {
		let pitch = Simplane.getPitch();
		let bank = Simplane.getBank();
        let vBodyX = SimVar.GetSimVarValue("VELOCITY BODY X", "feet per second");
        let vBodyY = SimVar.GetSimVarValue("VELOCITY BODY Y", "feet per second");
        let vBodyZ = SimVar.GetSimVarValue("VELOCITY BODY Z", "feet per second");
        let vVectorX = (vBodyX != 0) ? Math.atan(vBodyX / vBodyZ) * Avionics.Utils.RAD2DEG : 0;
        let vVectorY = (vBodyY != 0) ? Math.atan(vBodyY / vBodyZ) * Avionics.Utils.RAD2DEG : 0;
		let yperdegree = 40
		if (Simplane.getGroundSpeed() < 48) {
            vVectorX = 0;
            vVectorY = pitch;
        }
		else{
			let minY = -410 / yperdegree;
            let maxY = 410 / yperdegree;
		    vVectorX = Utils.Clamp(vVectorX, -20, 20);
            vVectorY = Utils.Clamp(vVectorY, minY, maxY);
		}
		diffAndSetAttribute(this._rdr_horizon_g, "transform", " rotate(" + bank.toFixed(5) + " 512 512)");
		diffAndSetAttribute(this._rdr_horizon_line, "transform", "translate(0, " + (-pitch * yperdegree).toFixed(1) + ")");
    }
}
customElements.define("fa18-ddi-rdr", FA18_DDI_RDR);
//# sourceMappingURL=FA18_DDI_IMAGE.js.map

