class FA18_DDI_Map extends MapInstrumentElement {
    constructor() {
        super(...arguments);
        this.zoomRanges = [0.5, 1, 2, 5, 10, 20, 40, 80, 160];
    }
    get isCourseSteering() { var _a; return (_a = this.courseElement) === null || _a === void 0 ? void 0 : _a.isCourseSteering; }
    onTemplateLoaded() {
        super.onTemplateLoaded();
        this.instrument.rotateWithPlane(true);
        this.instrument.zoomRanges = this.getAdaptiveRanges(2.2);
        this.instrument.setZoom(3);
        this.instrument.setPlaneIcon(2);
		this.showFlightPlan();
        this.instrument.showVORs = true;
        this.instrument.showIntersections = true;
        this.instrument.showNDBs = true;
        this.instrument.showAirports = true;
	    this.instrument.showTraffic = true;
        this.instrument.setHideReachedWaypoints(true);
        this.instrument.vorMaxRange = Infinity;
        this.instrument.ndbMaxRange = Infinity;
        this.instrument.smallAirportMaxRange = Infinity;
        this.instrument.medAirportMaxRange = Infinity;
        this.instrument.largeAirportMaxRange = Infinity;
		this.instrument.npcAirplaneMaxRange = Infinity;
        this.courseElement = new FA18_CourseElement(this.gps.getChildById("MapSVG"), this);
        diffAndSetAttribute(this.instrument, "show-flightplan-waypoints", "true");
        // SvgMap.prototype.isLatLongInFrame = function (ll, safetyMarginFactor = 0) {
            // let distance = Avionics.Utils.computeGreatCircleDistance(this.centerCoordinates, ll);
            // return distance < (this.NMWidth / FA18_DDI_Map.FA18_DDI_MAP_ZOOM_FACTOR) * 0.95;
        // };
    }
    getAdaptiveRanges(_factor) {
        let ranges = Array.from(this.zoomRanges);
        for (let i = 0; i < ranges.length; i++)
            ranges[i] *= _factor;
        return ranges;
    }
    getDisplayRange() {
        return this.zoomRanges[this.instrument.getZoom()];
    }
    decZoom() {
        let newZoom = this.instrument.getZoom() - 1;
        if (newZoom < 0)
            newZoom = this.zoomRanges.length - 1;
        this.instrument.setZoom(newZoom);
    }
    get isFlightPlanShown() {
        return this.instrument.showFlightPlan;
    }
    showFlightPlan() {
        diffAndSetAttribute(this.instrument, "show-flightplan", "true");
    }
    hideFlightPlan() {
        diffAndSetAttribute(this.instrument, "show-flightplan", "false");
    }
    get mapConfigId() {
        return this.instrument.mapConfigId;
    }
    set mapConfigId(_id) {
        this.instrument.mapConfigId = _id;
    }
    set shownWaypointIndex(index) {
        diffAndSetAttribute(this.instrument, "shown-waypoint-index", index + '');
    }
    set shownTacanIdent(ident) {
        if (ident) {
            this.showVors();
            diffAndSetAttribute(this.instrument, "shown-vors-ident-list", ident);
        }
        else {
            diffAndSetAttribute(this.instrument, "shown-vors-ident-list", "");
            this.hideVors();
        }
    }
    hideVors() {
        diffAndSetAttribute(this.instrument, "show-vors", "false");
    }
    showVors() {
        diffAndSetAttribute(this.instrument, "show-vors", "true");
    }
    showBingMap() {
            diffAndSetAttribute(this.instrument, "show-bing-map", "true");
    }
    hideBingMap() {
        diffAndSetAttribute(this.instrument, "show-bing-map", "false");
    }
    onEvent(_event, _args) {
        var _a;
        if (_event.startsWith("CRS_")) {
            (_a = this.courseElement) === null || _a === void 0 ? void 0 : _a.onEvent(_event.replace("CRS_", ""), _args);
        }
    }
    onUpdate(_deltaTime, isFullUpdate = false) {
        var _a;
            super.onUpdate(_deltaTime);
            // if (this.isFlightPlanShown && !this.instrument.getFlightPlanIsDashed()) {
                // this.instrument.setFlightPlanAsDashed(true);
			// }
		let selected = Simplane.getAutoPilotHeadingSelected();
        if (selected != this.headingSelected) {
            this.headingSelected = selected;
            if (selected) {
                this.instrument.setFlightPlanAsDashed(true);
            }
            else {
                this.instrument.setFlightPlanAsDashed(false);
            }
        }
        (_a = this.courseElement) === null || _a === void 0 ? void 0 : _a.Update(_deltaTime);
    }
}
FA18_DDI_Map.FA18_DDI_MAP_ZOOM_FACTOR = 4;
class FA18_CourseElement {
    constructor(root, _map) {
        this.tacanBearing = 0;
		this.isTacanOutOfRange = false;
		this.vorBearing = 0;
		this.isVorOutOfRange = false;
		this.ilstBearing= 0;
		this.isIlstOutOfRange = false;
		this.ilsnBearing= 0;
		this.isIlsnOutOfRange = false
        this.waypointBearing = 0;
        this.isWaypoinOutOfRange = false;
        this.outOfRangeRadius = 235;
        this._isCourseSteering = undefined;
        this.currentCourse = undefined;
        this.map = _map;
        this.mainElement = document.createElementNS(Avionics.SVG.NS, "svg");
        diffAndSetAttribute(this.mainElement, "id", this.id());
        diffAndSetAttribute(this.mainElement, "overflow", "visible");
        this.courseArrowBase = document.createElementNS(Avionics.SVG.NS, "path");
        diffAndSetAttribute(this.courseArrowBase, "d", "M 500 -2000 l 0 4000");
        diffAndSetAttribute(this.courseArrowBase, "fill", "transparent");
        diffAndSetAttribute(this.courseArrowBase, "stroke", "lime");
        diffAndSetAttribute(this.courseArrowBase, "stroke-width", "3");
        diffAndSetAttribute(this.courseArrowBase, "clip-path", "url(#circle-clip-path)");
        this.mainElement.appendChild(this.courseArrowBase);
        this.courseArrowHead = document.createElementNS(Avionics.SVG.NS, "path");
        diffAndSetAttribute(this.courseArrowHead, "d", "M 500 500 l -15 15 m 15 -15 l 15 15");
        diffAndSetAttribute(this.courseArrowHead, "fill", "transparent");
        diffAndSetAttribute(this.courseArrowHead, "stroke", "lime");
        diffAndSetAttribute(this.courseArrowHead, "stroke-width", "3");
        this.mainElement.appendChild(this.courseArrowHead);
        this.courseArrowClipPath = document.createElementNS(Avionics.SVG.NS, "clipPath");
        diffAndSetAttribute(this.courseArrowClipPath, "id", "circle-clip-path");
        let circleClipPath = document.createElementNS(Avionics.SVG.NS, "circle");
        diffAndSetAttribute(circleClipPath, "cx", "500px");
        diffAndSetAttribute(circleClipPath, "cy", "500px");
        diffAndSetAttribute(circleClipPath, "r", "240px");
        this.courseArrowClipPath.appendChild(circleClipPath);
        this.mainElement.appendChild(this.courseArrowClipPath);
        root.appendChild(this.mainElement);
        diffAndSetAttribute(this.mainElement, "visibility", this.isCourseSteering ? "visible" : "hidden");
        let outOfRangeGroup = document.createElementNS(Avionics.SVG.NS, "g");
        diffAndSetAttribute(outOfRangeGroup, "id", "out-of-range-elements");
        this.tacanOutOfRangeElement = document.createElementNS(Avionics.SVG.NS, "image");
        diffAndSetAttribute(this.tacanOutOfRangeElement, "id", "out-of-range-tacan");
        diffAndSetAttribute(this.tacanOutOfRangeElement, "class", "map-nrst-vor-icon");
        diffAndSetAttribute(this.tacanOutOfRangeElement, "width", "32");
        diffAndSetAttribute(this.tacanOutOfRangeElement, "height", "32");
        this.tacanOutOfRangeElement.setAttributeNS("http://www.w3.org/1999/xlink", "href", "/Pages/VCockpit/Instruments/FFRIES/QUASAR/Shared/DDI/Images/ICON_MAP_VOR_TACAN.png");
        diffAndSetAttribute(this.tacanOutOfRangeElement, "x", "484");
        diffAndSetAttribute(this.tacanOutOfRangeElement, "y", (500 - this.outOfRangeRadius - 16) + '');
        diffAndSetAttribute(this.tacanOutOfRangeElement, "visibility", "hidden");
        outOfRangeGroup.appendChild(this.tacanOutOfRangeElement);
        this.waypointOutOfRangeElement = document.createElementNS(Avionics.SVG.NS, "image");
        diffAndSetAttribute(this.waypointOutOfRangeElement, "id", "out-of-range-wypt");
        diffAndSetAttribute(this.waypointOutOfRangeElement, "width", "32");
        diffAndSetAttribute(this.waypointOutOfRangeElement, "height", "32");
        this.waypointOutOfRangeElement.setAttributeNS("http://www.w3.org/1999/xlink", "href", "/Pages/VCockpit/Instruments/FFRIES/QUASAR/Shared/DDI/Images/ICON_MAP_INTERSECTION.png");
        diffAndSetAttribute(this.waypointOutOfRangeElement, "x", "484");
        diffAndSetAttribute(this.waypointOutOfRangeElement, "y", (500 - this.outOfRangeRadius - 16) + '');
        diffAndSetAttribute(this.waypointOutOfRangeElement, "visibility", "hidden");
        outOfRangeGroup.appendChild(this.waypointOutOfRangeElement);
        root.appendChild(outOfRangeGroup);
    }
    get isMaster() { return this.ddi.isMaster; }
    get ddi() { return this.map.gps; }
    get isCourseSteering() { return this._isCourseSteering; }
    id() { return "course-map"; }
    onEvent(_event, _args) {
        switch (_event) {
            case "Value_Changed":
                if (this.isMaster && _args.length > 0)
                    this.onCourseChanged(parseInt(_args[0]));
                break;
            case "Set_Steering":
                if (_args.length > 0) {
                    if (this.isCourseSteering === undefined && this.courseSteeringEnableMasterRequestId)
                        clearInterval(this.courseSteeringEnableMasterRequestId);
                    this.setCourseSteering(!!parseInt(_args[0]));
                }
                break;
            case "Value_Set":
                if (!this.isMaster && _args.length > 0) {
                    if (this.currentCourse === undefined && this.courseValueMasterRequestId)
                        clearInterval(this.courseValueMasterRequestId);
                    this.setCourseValue(parseFloat(_args[0]));
                }
                break;
            case "Steering_Enable_Request":
                if (this.isMaster && _args.length > 0)
                    this.sendSteeringEnableInfo(_args[0]);
                break;
            case "Value_Request":
                if (this.isMaster && _args.length > 0)
                    this.sendSteeringCourseValueInfo(_args[0]);
                break;
        }
    }
    sendSteeringEnableInfo(instance) {
        if (instance)
            this.ddi.triggerEventToInstrument(instance, "Map_CRS_Set_Steering", this.isCourseSteering ? '1' : '0');
        else
            this.ddi.triggerEventToMultipleInstruments([...this.ddi.slavesInstances, "AS04F_ACC_UFCD"], "Map_CRS_Set_Steering", this.isCourseSteering ? '1' : '0');
    }
    sendSteeringCourseValueInfo(instance) {
        if (instance)
            this.ddi.triggerEventToInstrument(instance, "Map_CRS_Value_Set", this.currentCourse + '');
        else
            this.ddi.triggerEventToMultipleInstruments(this.ddi.slavesInstances, "Map_CRS_Value_Set", this.currentCourse + '');
    }
    setCourseSteering(_enabled) {
        if (this.isCourseSteering !== _enabled) {
            this._isCourseSteering = _enabled;
            if (this.isMaster) {
                this.sendSteeringEnableInfo();
                if (this.steeringSource === FA18_DDI_Steering_Source.WYPT && this.isCourseSteering)
                    setTimeout(() => { SimVar.SetSimVarValue("K:GPS_OBS_ON", "boolean", true); }, 100);
            }
            return true;
        }
        return false;
    }
    setCourseValue(course) {
        this.currentCourse = Avionics.Utils.clampAngle(course);
        if (this.isMaster) {
            switch (this.steeringSource) {
                case FA18_DDI_Steering_Source.TACAN:
                    SimVar.SetSimVarValue("K:TACAN1_SET", "degree", this.currentCourse);
                    break;
				case FA18_DDI_Steering_Source.ILST:
                    SimVar.SetSimVarValue("K:VOR1_SET", "degree", this.currentCourse);
                    break;
			     case FA18_DDI_Steering_Source.VOR:
                    SimVar.SetSimVarValue("K:VOR1_SET", "degree", this.currentCourse);
                    break;
				 case FA18_DDI_Steering_Source.ILSN:
                    SimVar.SetSimVarValue("K:VOR1_SET", "degree", this.currentCourse);
                    break;
                case FA18_DDI_Steering_Source.WYPT:
                    SimVar.SetSimVarValue("K:GPS_OBS_SET", "degree", this.currentCourse);
                    break;
            }
            SimVar.SetSimVarValue("NAV OBS:1, Degrees", "degree", this.currentCourse);
            this.sendSteeringCourseValueInfo();
        }
    }
    onCourseChanged(increment) {
        if (this.isMaster) {
            if (this.steeringSource !== FA18_DDI_Steering_Source.None) {
                let courseSteeringChanged = this.setCourseSteering(true);
                if (!courseSteeringChanged) {
                    this.setCourseValue(Avionics.Utils.clampAngle(this.currentCourse + increment));
                }
            }
        }
    }
    computeOutOfRangeXY(bearing) {
        let angle = (bearing - 90) * Avionics.Utils.DEG2RAD;
        let x = 500 + Math.round(this.outOfRangeRadius * Math.cos(angle) * 100) / 100;
        let y = 500 + Math.round(this.outOfRangeRadius * Math.sin(angle) * 100) / 100;
        return { x, y };
    }
    get currentSteeringElement() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l,_m, _n, _o, _p, _q, _r, _s, _t;
        switch (this.steeringSource) {
            case FA18_DDI_Steering_Source.TACAN:
                if ((_b = (_a = this.map) === null || _a === void 0 ? void 0 : _a.instrument) === null || _b === void 0 ? void 0 : _b.currentVor)
                    return (_d = (_c = this.map) === null || _c === void 0 ? void 0 : _c.instrument) === null || _d === void 0 ? void 0 : _d.currentVor;
                if (this.isTacanOutOfRange)
                    return this.computeOutOfRangeXY(this.tacanBearing);
			case FA18_DDI_Steering_Source.VOR:
                if ((_j = (_i = this.map) === null || _i === void 0 ? void 0 : _i.instrument) === null || _j === void 0 ? void 0 : _j.currentVor)
                    return (_l = (_k = this.map) === null || _k === void 0 ? void 0 : _k.instrument) === null || _l === void 0 ? void 0 : _l.currentVor;
                if (this.isTacanOutOfRange)
                    return this.computeOutOfRangeXY(this.tacanBearing);
			case FA18_DDI_Steering_Source.ILST:
                if ((_n = (_m = this.map) === null || _m === void 0 ? void 0 : _m.instrument) === null || _n === void 0 ? void 0 : _n.currentVor)
                    return (_p = (_o = this.map) === null || _o === void 0 ? void 0 : _o.instrument) === null || _p === void 0 ? void 0 : _p.currentVor;
                if (this.isTacanOutOfRange)
                    return this.computeOutOfRangeXY(this.tacanBearing);
			case FA18_DDI_Steering_Source.ILSN:
                if ((_r = (_q = this.map) === null || _q === void 0 ? void 0 : _q.instrument) === null || _r === void 0 ? void 0 : _r.currentVor)
                    return (_t = (_s = this.map) === null || _s === void 0 ? void 0 : _s.instrument) === null || _t === void 0 ? void 0 : _t.currentVor;
                if (this.isTacanOutOfRange)
                    return this.computeOutOfRangeXY(this.tacanBearing);
            case FA18_DDI_Steering_Source.WYPT:
                if ((_f = (_e = this.map) === null || _e === void 0 ? void 0 : _e.instrument) === null || _f === void 0 ? void 0 : _f.currentWaypoint)
                    return (_h = (_g = this.map) === null || _g === void 0 ? void 0 : _g.instrument) === null || _h === void 0 ? void 0 : _h.currentWaypoint;
                if (this.isWaypoinOutOfRange)
                    return this.computeOutOfRangeXY(this.waypointBearing);
        }
        return null;
    }
    initializeInfos() {
        if ((this.isCourseSteering !== undefined && this.currentCourse !== undefined && this.steeringSource !== undefined))
            return true;
        if (!this.courseSteeringEnableMasterRequestId) {
            if (this.isMaster) {
                this.courseSteeringEnableMasterRequestId = -1;
                this.setCourseSteering(false);
            }
            else {
                this.courseSteeringEnableMasterRequestId = setInterval(() => {
                    this.ddi.triggerEventToInstrument(this.ddi.masterInstance, "Map_CRS_Steering_Enable_Request", this.ddi.instrumentIdentifier);
                }, 500);
            }
        }
        if (!this.courseValueMasterRequestId) {
            if (this.isMaster) {
                this.courseValueMasterRequestId = -1;
                this.setCourseValue(0);
            }
            else {
                this.courseValueMasterRequestId = setInterval(() => {
                    this.ddi.triggerEventToInstrument(this.ddi.masterInstance, "Map_CRS_Value_Request", this.ddi.instrumentIdentifier);
                }, 500);
            }
        }
        this.steeringSource = this.ddi.steeringSource;
        return (this.isCourseSteering !== undefined && this.currentCourse !== undefined && this.steeringSource !== undefined);
    }
    updateOutOfRangeElements(compass) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        this.isTacanOutOfRange = false;
        this.isWaypoinOutOfRange = false;
        if (this.isCourseSteering) {
            if (this.steeringSource === FA18_DDI_Steering_Source.TACAN) {
                if (SimVar.GetSimVarValue("TACAN STATION DISTANCE:1", "nautical mile") > this.map.getDisplayRange() * 0.90) {
                    this.tacanBearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("TACAN STATION RADIAL:1", "degree") + 180) - compass;
                    diffAndSetAttribute(this.tacanOutOfRangeElement, "transform", "rotate(" + this.tacanBearing + ",500,500)");
                    this.isTacanOutOfRange = ((_b = (_a = this.map) === null || _a === void 0 ? void 0 : _a.instrument) === null || _b === void 0 ? void 0 : _b.currentVor) == null;
                }
            }
			else if (this.steeringSource === FA18_DDI_Steering_Source.ILST) {
                if (SimVar.GetSimVarValue("NAV DME:" +this.ddi.ilstacanindex, "nautical mile") > this.map.getDisplayRange() * 0.90) {
                    this.tacanBearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.ilstacanindex, "degree") + 180) - compass;
                    diffAndSetAttribute(this.tacanOutOfRangeElement, "transform", "rotate(" + this.tacanBearing + ",500,500)");
                    this.isTacanOutOfRange = ((_b = (_a = this.map) === null || _a === void 0 ? void 0 : _a.instrument) === null || _b === void 0 ? void 0 : _b.currentVor) == null;
                }
            }
			else if (this.steeringSource === FA18_DDI_Steering_Source.VOR) {
                if (SimVar.GetSimVarValue("NAV DME:" + this.ddi.navindex, "nautical mile") > this.map.getDisplayRange() * 0.90) {
                    this.tacanBearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180) - compass;
                    diffAndSetAttribute(this.tacanOutOfRangeElement, "transform", "rotate(" + this.tacanBearing + ",500,500)");
                    this.isTacanOutOfRange = ((_b = (_a = this.map) === null || _a === void 0 ? void 0 : _a.instrument) === null || _b === void 0 ? void 0 : _b.currentVor) == null;
                }
            }
			else if (this.steeringSource === FA18_DDI_Steering_Source.ILSN) {
                if (SimVar.GetSimVarValue("NAV DME:" +this.ddi.navindex, "nautical mile") > this.map.getDisplayRange() * 0.90) {
                    this.tacanBearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180) - compass;
                    diffAndSetAttribute(this.tacanOutOfRangeElement, "transform", "rotate(" + this.tacanBearing + ",500,500)");
                    this.isTacanOutOfRange = ((_b = (_a = this.map) === null || _a === void 0 ? void 0 : _a.instrument) === null || _b === void 0 ? void 0 : _b.currentVor) == null;
                }
            }
            else if (this.steeringSource === FA18_DDI_Steering_Source.WYPT) {
                if (((_d = (_c = this.ddi) === null || _c === void 0 ? void 0 : _c.flightPlanManager) === null || _d === void 0 ? void 0 : _d.getDistanceToWaypoint((_f = (_e = this.ddi) === null || _e === void 0 ? void 0 : _e.waypointManager) === null || _f === void 0 ? void 0 : _f.currentWaypoint)) > this.map.getDisplayRange() * 0.95) {
                    this.waypointBearing = ((_h = (_g = this.ddi) === null || _g === void 0 ? void 0 : _g.flightPlanManager) === null || _h === void 0 ? void 0 : _h.getBearingToWaypoint((_k = (_j = this.ddi) === null || _j === void 0 ? void 0 : _j.waypointManager) === null || _k === void 0 ? void 0 : _k.currentWaypoint, true)) - compass;
                    diffAndSetAttribute(this.waypointOutOfRangeElement, "transform", "rotate(" + this.waypointBearing + ",500,500)");
                    this.isWaypoinOutOfRange = ((_m = (_l = this.map) === null || _l === void 0 ? void 0 : _l.instrument) === null || _m === void 0 ? void 0 : _m.currentWaypoint) == null;
                }
            }
        }
        diffAndSetAttribute(this.tacanOutOfRangeElement, "visibility", this.isTacanOutOfRange ? "visible" : "hidden");
        diffAndSetAttribute(this.waypointOutOfRangeElement, "visibility", this.isWaypoinOutOfRange ? "visible" : "hidden");
    }
    Update(_deltaTime) {
        if (this.initializeInfos()) {
            if (this.steeringSource !== this.ddi.steeringSource) {
                if (this.isCourseSteering)
                    this.setCourseSteering(false);
                this.steeringSource = this.ddi.steeringSource;
            }
            let compass = SimVar.GetSimVarValue("L:FA18_DDI_HSI_NORTH_UP", "Bool") ? 0 : SimVar.GetSimVarValue("PLANE HEADING DEGREES MAGNETIC", "degree");
            this.updateOutOfRangeElements(compass);
            if (this.isCourseSteering && this.currentSteeringElement) {
                const course = Avionics.Utils.clampAngle(this.currentCourse - compass);
                diffAndSetAttribute(this.mainElement, "visibility", "visible");
                const { c, d } = this.getLineEquation(this.currentSteeringElement.x, this.currentSteeringElement.y, course);
                const intersections = this.resolveIntersection(this.currentSteeringElement.x, 500, 240, c, d, course);
                this.setArrowBase(this.currentSteeringElement.x, this.currentSteeringElement.y, course, 500);
                if (intersections !== null) {
                    if (course > 0 && course < 180) {
                        this.setArrowHead(intersections.second.x, intersections.second.y, course, 500);
                    }
                    else {
                        this.setArrowHead(intersections.first.x, intersections.first.y, course, 500);
                    }
                }
            }
            else {
                diffAndSetAttribute(this.mainElement, "visibility", "hidden");
            }
        }
    }
    getLineEquation(posX, posY, course) {
        let c, d;
        if (course === 0 || course === 180) {
            c = posX;
            d = 0;
        }
        else {
            c = -1 / Math.tan((course * Math.PI) / 180);
            d = posY - c * posX;
        }
        return {
            c,
            d
        };
    }
    resolveIntersection(posX, center, radius, c, d, course) {
        let equation = undefined;
        if (course === 0 || course === 180) {
            equation = {
                a: 1,
                b: -2 * center,
                c: 2 * Math.pow(center, 2) -
                    2 * center * c +
                    Math.pow(c, 2) -
                    Math.pow(radius, 2)
            };
        }
        else {
            equation = {
                a: Math.pow(c, 2) + 1,
                b: -2 * center + 2 * c * d - 2 * center * c,
                c: 2 * Math.pow(center, 2) +
                    Math.pow(d, 2) -
                    2 * center * d -
                    Math.pow(radius, 2)
            };
        }
        const delta = Math.pow(equation.b, 2) - 4 * equation.a * equation.c;
        if (delta > 0) {
            const x1 = (-equation.b - Math.sqrt(delta)) / (2 * equation.a);
            const y1 = c * x1 + d;
            const x2 = (-equation.b + Math.sqrt(delta)) / (2 * equation.a);
            const y2 = c * x2 + d;
            if (course === 0 || course === 180) {
                return {
                    first: {
                        x: posX,
                        y: x1
                    },
                    second: {
                        x: posX,
                        y: x2
                    }
                };
            }
            else {
                return {
                    first: {
                        x: x1,
                        y: y1
                    },
                    second: {
                        x: x2,
                        y: y2
                    }
                };
            }
        }
        else {
            return null;
        }
    }
    setArrowBase(posX, posY, course, center) {
        diffAndSetAttribute(this.courseArrowBase, "transform", `translate(${posX - center},${posY - center}) rotate(${course}, ${center} ,${center})`);
        diffAndSetAttribute(this.courseArrowClipPath, "transform", `rotate(${-course}, ${center} ,${center}) translate(${center - posX},${center - posY}) `);
    }
    setArrowHead(posX, posY, course, center) {
        diffAndSetAttribute(this.courseArrowHead, "transform", `translate(${posX - center},${posY - center}) rotate(${course}, ${center}, ${center})`);
    }
}
//# sourceMappingURL=FA18_DDI_Map.js.map