class FA18_DDI_IMAGE extends FA18_DDI_Page {
    constructor() {
        super(...arguments);
        this._img_vision_vVectorMinX = -17;
        this._img_vision_vVectorMaxX = 17;
        this._img_vision_vVectorMinY = -8;
        this._img_vision_vVectorMaxY = 6;
        this._img_vision_PeakGValue = 0;
        this._img_vision_projectionOffset = 0;
        this._img_vision_drawn = false;
        this._img_vision_clutterLevel = -1;
        this._img_vision_isCoupled = false;
        this._img_vision_coupledTimer = -1;
        this._img_vision_barometricSettingDisplayTimer = -1;
    }
    get templateID() { return "FA18_DDI_IMAGE"; }
    init(ddi) {
        super.init(ddi);
		this.cameraInstrument = this.ddi.getChildById("CameraInstrument");
		let _a = this.cameraInstrument;
		_a.init(this);	
        FA18_DDI_IMAGE.DEBUG_INSTANCE = this;
        if (!this._img_vision_drawn) {
            this._img_vision_waterLineElement = this.ddi.getChildById("imagevision-waterline");
            // this._img_vision_MainElement = this.ddi.getElementsByClassName("imagevision-display")[0];
            // diffAndSetAttribute(this._img_vision_MainElement, "main_img_vision_", (this.ddi.instrumentIndex == 4) ? "True" : "False");
            this._img_vision_AirspeedElement = this.ddi.getChildById("imagevision-airspeed");
            this._img_vision_VerticalSpeedElement = this.ddi.getChildById("imagevision-vertical-speed");
			this._img_vision_RaltitudeElement = this.ddi.getChildById("imagevision-raltitude");
			this._img_vision_Raltitudetext = this.ddi.getChildById("imagevision-raltitude-text");
            this._img_vision_CommCassElement = this.ddi.getChildById("imagevision-comm-cas");																					
            this._img_vision_AltitudeElement = this.ddi.getChildById("imagevision-altitude");
            this._img_vision_AltitudeElementModeElement = this.ddi.getChildById("imagevision-altitude-mode");
            this._img_vision_BarometricSettingElement = this.ddi.getChildById("imagevision-barometric-setting");
            this._img_vision_AOAElement = this.ddi.getChildById("imagevision-aoa-value");
            this._img_vision_MachLabel = this.ddi.getChildById("imagevision-mach-label");
            this._img_vision_MachElement = this.ddi.getChildById("imagevision-mach-value");
            this._img_vision_CurrentGLabel = this.ddi.getChildById("imagevision-current-g-label");
            this._img_vision_CurrentGElement = this.ddi.getChildById("imagevision-current-g-value");
            this._img_vision_PeakGElement = this.ddi.getChildById("imagevision-peak-g-value");
            this._img_vision_CplModeElement = this.ddi.getChildById("imagevision-cpl-mode");
            this._img_vision_AdvisoryElement = this.ddi.getChildById("imagevision-advisory");
            this._img_vision_SteeringDataElement = this.ddi.getChildById("imagevision-steering-data");
            this._img_vision_SteeringCrsElement = this.ddi.getChildById("imagevision-steering-crs");
            this._img_vision_headingElement = this.ddi.getChildById("imagevision-heading-tape-group");
            this._img_vision_headingCursorElement = this.ddi.getChildById("imagevision-heading-cursor");
            this._img_vision_headingClipElement = this.ddi.getChildById("imagevision-heading-clip");
            this._img_vision_headingSteeringBugElement = this.ddi.getChildById("imagevision-heading-steering-bug");
            this._img_vision_horizonElement = this.ddi.getChildById("imagevision-horizon-group");
            this._img_vision_horizonContainerElement = this.ddi.getChildById("imagevision-horizon-container-group");
            this._img_vision_horizonClipElement = this.ddi.getChildById("imagevision-horizon-clip");
            this._img_vision_eBracketElement = this.ddi.getChildById("imagevision-e-bracket-group");
            this._img_vision_bankCursorElement = this.ddi.getChildById("imagevision-bank-cursor");
            this._img_vision_bankElement = this.ddi.getChildById("imagevision-bank-tape-group");
            this._img_vision_velocityGroupElement = this.ddi.getChildById("imagevision-velocity-vector-group");
            this._img_vision_ghostVelocityElement = this.ddi.getChildById("ghost-imagevision-velocity-vector-group");
            this._img_vision_energyCaretElement = this.ddi.getChildById("imagevision-energy-caret");
            this._img_vision_cselGroupElement = this.ddi.getChildById("imagevision-csel-group");
            this._img_vision_cselDotsLeftGroupElement = this.ddi.getChildById("imagevision-csel-dots-left-group");
            this._img_vision_cselDotsRightGroupElement = this.ddi.getChildById("imagevision-csel-dots-right-group");
            this._img_vision_cselArrowElement = this.ddi.getChildById("imagevision-csel-arrow");
            this._img_vision_WarningElement = this.ddi.getChildById("imagevision-warnings");
            this._img_vision_gsigroup = this.ddi.getChildById("imagevision-gsi-group");
            this._img_vision_cdigroup = this.ddi.getChildById("imagevision-cdi-group");
            this._img_vision_gsideviation = this.ddi.getChildById("imagevision-gsi-deviation");
            this._img_vision_cdideviation = this.ddi.getChildById("imagevision-cdi-deviation");
            for (let i = -3; i < 39; i++) {
                let text = document.createElementNS(Avionics.SVG.NS, "text");
                let s = ((i + 36) % 36).toFixed(0) + "0";
                let Xspacing = 125;
                let yBottom = 145;
                s = s.padStart(3, "0");
                diffAndSetText(text, s);
                diffAndSetAttribute(text, "x", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(text, "y", (yBottom - 25) + "");
                diffAndSetAttribute(text, "font-size", "40");
                diffAndSetAttribute(text, "font-weight", "regular");
                diffAndSetAttribute(text, "text-anchor", "middle");
                diffAndSetAttribute(text, "fill", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                diffAndSetAttribute(text, "clip-path", "url(#imagevision-heading-clip)");
                this._img_vision_headingElement.appendChild(text);
                let lineL = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(lineL, "x1", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(lineL, "y1", (yBottom - 20) + '');
                diffAndSetAttribute(lineL, "x2", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(lineL, "y2", (yBottom) + '');
                diffAndSetAttribute(lineL, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                diffAndSetAttribute(lineL, "stroke-width", "4");
                diffAndSetAttribute(lineL, "clip-path", "url(#imagevision-heading-clip)");
                this._img_vision_headingElement.appendChild(lineL);
                let lineS = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(lineS, "x1", (500 + i * Xspacing + Xspacing / 2).toFixed(0));
                diffAndSetAttribute(lineS, "y1", (yBottom - 10) + '');
                diffAndSetAttribute(lineS, "x2", (500 + i * Xspacing + Xspacing / 2).toFixed(0));
                diffAndSetAttribute(lineS, "y2", (yBottom) + '');
                diffAndSetAttribute(lineS, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                diffAndSetAttribute(lineS, "stroke-width", "4");
                diffAndSetAttribute(lineS, "clip-path", "url(#imagevision-heading-clip)");
                this._img_vision_headingElement.appendChild(lineS);
            }
            for (let i = -17; i < 18; i++) {
                let h = 20;
                if (i === 0) {
                    h = 35;
                }
                else if (i < 0) {
                    h = -20;
                }
                let y = 420 - FA18_DDI_IMAGE.YPERDEGREE * 5 * i;
                let path = document.createElementNS(Avionics.SVG.NS, "g");
                if (i === 0) {
                    let p1 = "0 " + y.toFixed(0);
                    let p2 = "450 " + y.toFixed(0);
                    let p3 = "550 " + y.toFixed(0);
                    let p4 = "1000 " + y.toFixed(0);
                    let d1 = "M" + p1 + " L" + p2 + " M" + p3 + " L" + p4;
                    let path1 = document.createElementNS(Avionics.SVG.NS, "path");
                    diffAndSetAttribute(path1, "d", d1);
                    diffAndSetAttribute(path1, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(path1, "stroke-width", "4");
                    diffAndSetAttribute(path1, "fill", "none");    /** Horizon line fill */
                    diffAndSetAttribute(path1, "clip-path", "url(#imagevision-horizon-clip)");
                    this._img_vision_horizonZeroElement = path1;
                    path.appendChild(path1);
                }
                else {
                    let p1 = "420 " + (y + h).toFixed(0); /* Bottom of left vert line*/
                    let p2 = "420 " + y.toFixed(0);  /* top left point */
                    let p3 = "470 " + (y + h / 5).toFixed(0);  /* left mid horizontal line how far right*/
                    let p4 = "530 " + (y + h / 5).toFixed(0);
                    let p5 = "580 " + y.toFixed(0);
                    let p6 = "580 " + (y + h).toFixed(0);
                    let d1 = "M" + p1 + " L" + p2;
                    let d2 = "M" + p2 + " L" + p3;
                    let d3 = "M" + p4 + " L" + p5;
                    let d4 = "M" + p5 + " L" + p6;
                    let path1 = document.createElementNS(Avionics.SVG.NS, "path");
                    let path2 = document.createElementNS(Avionics.SVG.NS, "path");
                    let path3 = document.createElementNS(Avionics.SVG.NS, "path");
                    let path4 = document.createElementNS(Avionics.SVG.NS, "path");
                    diffAndSetAttribute(path1, "d", d1);
                    diffAndSetAttribute(path2, "d", d2);
                    diffAndSetAttribute(path3, "d", d3);
                    diffAndSetAttribute(path4, "d", d4);
                    diffAndSetAttribute(path1, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(path1, "stroke-width", "4");
                    diffAndSetAttribute(path1, "fill", "none");
                    diffAndSetAttribute(path1, "clip-path", "url(#imagevision-horizon-clip)");
                    diffAndSetAttribute(path2, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(path2, "stroke-width", "4");
                    diffAndSetAttribute(path2, "fill", "none");
                    diffAndSetAttribute(path2, "clip-path", "url(#imagevision-horizon-clip)");
                    diffAndSetAttribute(path3, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(path3, "stroke-width", "4");
                    diffAndSetAttribute(path3, "fill", "none");
                    diffAndSetAttribute(path3, "clip-path", "url(#imagevision-horizon-clip)");
                    diffAndSetAttribute(path4, "stroke", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(path4, "stroke-width", "4");
                    diffAndSetAttribute(path4, "fill", "none");
                    diffAndSetAttribute(path4, "clip-path", "url(#imagevision-horizon-clip)");
                    if (i < 0) {
                        diffAndSetAttribute(path2, "stroke-dasharray", "7, 7");
                        diffAndSetAttribute(path3, "stroke-dasharray", "7, 7");
                    }
                    path.appendChild(path1);
                    path.appendChild(path2);
                    path.appendChild(path3);
                    path.appendChild(path4);
                }
                diffAndSetAttribute(path, "id", "attitude-line-" + (i < 0 ? "minus-" : "") + Math.abs(i * 5).toFixed(0));
                this._img_vision_horizonElement.appendChild(path);
                if (i != 0) {
                    let textPosition = 0;
                    if (i > 0) {
                        textPosition = 20;
                    }
                    let textL = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(textL, Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textL, "id", "attitude-textl-" + (i < 0 ? "minus-" : "") + Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textL, "x", "390");
                    diffAndSetAttribute(textL, "y", (y + textPosition).toFixed(0));
                    diffAndSetAttribute(textL, "font-size", "40");
                    diffAndSetAttribute(textL, "font-weight", "bold");
                    diffAndSetAttribute(textL, "text-anchor", "middle");
                    diffAndSetAttribute(textL, "fill", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(textL, "clip-path", "url(#imagevision-horizon-clip)");
                    this._img_vision_horizonElement.appendChild(textL);
                    let textR = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(textR, Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textR, "id", "attitude-textr-" + (i < 0 ? "minus-" : "") + Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textR, "x", "610");
                    diffAndSetAttribute(textR, "y", (y + textPosition).toFixed(0));
                    diffAndSetAttribute(textR, "font-size", "40");
                    diffAndSetAttribute(textR, "font-weight", "bold");
                    diffAndSetAttribute(textR, "text-anchor", "middle");
                    diffAndSetAttribute(textR, "fill", (this.ddi.instrumentIndex === 4) ? "lime" : "lime");
                    diffAndSetAttribute(textR, "clip-path", "url(#imagevision-horizon-clip)");
                    this._img_vision_horizonElement.appendChild(textR);
                }
            }
            this._img_vision_drawn = true;
        }
    }
    show() {
        super.show();
        this.ddi.onButtonPressed[18] = () => {
            this.ddi.showPage(FA18_DDI_Page_Type.MenuTactical);
        };
    }
    onEvent(_event) {
        super.onEvent(_event);
        switch (_event) {
            case "Altimeter_Standby_Changed":
                if (this.isCurrentDisplayedPage) {
                    this._img_vision_barometricSettingDisplayTimer = 5;
                    diffAndSetAttribute(this._img_vision_BarometricSettingElement, "state", "displayed");
                }
                break;
        }
    }
    update(deltaTime) {	 
        super.update(deltaTime);
							 
		this.cameraInstrument.update(deltaTime);
   
        let airspeed = Simplane.getIndicatedSpeed();
        let commairspeed = Simplane.getAutoPilotAirspeedHoldValue();
        let verticalSpeed = Simplane.getVerticalSpeed();
        let bank = Simplane.getBank();
        this._img_vision_cagedVelocityVector = SimVar.GetSimVarValue("L:XMLVAR_HUD_Push_VelocityVector_Cage", "Bool");
        let altitude = Simplane.getAltitude();
		let radioaltitude = SimVar.GetSimVarValue("RADIO HEIGHT", "feet");
        if (this.previousAltitude == undefined)
            this.previousAltitude = altitude;
        if (this._img_vision_coupledTimer >= 0) {
            this._img_vision_coupledTimer -= (deltaTime / 1000);
        }
        if (this._img_vision_barometricSettingDisplayTimer >= 0) {
            this._img_vision_barometricSettingDisplayTimer -= (deltaTime / 1000);
        }
        if (this.ddi.instrumentIndex === 4) {
            this.update_img_vision_Projection(deltaTime);
        }
        this.update_img_vision_ClutterLevel();
        this.update_img_vision_WithGearPosition();
        diffAndSetText(this._img_vision_AirspeedElement, airspeed.toFixed(0));
        diffAndSetText(this._img_vision_VerticalSpeedElement, verticalSpeed.toFixed(0));
        let displayedAltitude;
        if (SimVar.GetSimVarValue("L:XMLVAR_AS04F_HUD_Alt_Selector", "number") == 1) {
		    diffAndSetStyle(this._img_vision_RaltitudeElement, "visibility", "hidden");
			diffAndSetStyle(this._img_vision_Raltitudetext, "visibility", "hidden");
            displayedAltitude = SimVar.GetSimVarValue("RADIO HEIGHT", "feet");
            // if (displayedAltitude > 5000) {
                // displayedAltitude = altitude;
                // diffAndSetText(this._img_vision_AltitudeElementModeElement, "B");
                // diffAndSetAttribute(this._img_vision_AltitudeElementModeElement, "state", "blink");
            // }
            // else {
                diffAndSetText(this._img_vision_AltitudeElementModeElement, "R");
                diffAndSetAttribute(this._img_vision_AltitudeElementModeElement, "state", "");
            // }
        }
        else {
            displayedAltitude = altitude;
            diffAndSetText(this._img_vision_AltitudeElementModeElement, "");
			diffAndSetStyle(this._img_vision_RaltitudeElement, "visibility", radioaltitude <= 5000 ? "visible" : "hidden");
		    diffAndSetStyle(this._img_vision_Raltitudetext, "visibility", radioaltitude <= 5000 ? "visible" : "hidden");
        }
        diffAndSetText(this._img_vision_AltitudeElement, displayedAltitude.toFixed(0));
		diffAndSetText(this._img_vision_RaltitudeElement, radioaltitude.toFixed(0));
        if (this._img_vision_barometricSettingDisplayTimer <= 0 && this.previousAltitude > 10000 && altitude < 10000 && airspeed < 300) {
            this._img_vision_barometricSettingDisplayTimer = 5;
            diffAndSetAttribute(this._img_vision_BarometricSettingElement, "state", "blink");
        }
        if (this._img_vision_barometricSettingDisplayTimer > 0) {
            diffAndSetText(this._img_vision_BarometricSettingElement, fastToFixed(Simplane.getPressureValue(), 2));
        }
        else {
            diffAndSetAttribute(this._img_vision_BarometricSettingElement, "state", "hidden");
        }
        let heading = Simplane.getHeadingMagnetic();
        diffAndSetAttribute(this._img_vision_headingElement, "transform", "translate(" + (-heading * 12.5) + ", 0)");
        diffAndSetAttribute(this._img_vision_headingClipElement, "transform", "translate(" + (heading * 12.5) + ", 0)");
        let aoa = Simplane.getAngleOfAttack("degree");
        let mach = Simplane.getMachSpeed();
        let pitch = Simplane.getPitch();
        let g = Simplane.getGForce();
        this._img_vision_PeakGValue = Utils.Clamp(this._img_vision_PeakGValue, g, 99);
        diffAndSetText(this._img_vision_CurrentGElement, g.toFixed(1));
        diffAndSetText(this._img_vision_PeakGElement, this._img_vision_PeakGValue.toFixed(1));
        diffAndSetText(this._img_vision_AOAElement, aoa.toFixed(1));
        diffAndSetText(this._img_vision_MachElement, mach.toFixed(3).replace(/^[0]+/, ""));
        this.update_img_vision_LeftInfosVisibility();
        this.update_img_vision_SteeringInfos(heading);
        this.update_img_vision_Situation(pitch, aoa, bank);
        let acceleration = SimVar.GetSimVarValue("ACCELERATION BODY Z", "feet per second squared");
        diffAndSetAttribute(this._img_vision_energyCaretElement, "transform", "translate(0, " + (-acceleration * 4).toFixed(1) + ")");
        diffAndSetAttribute(this._img_vision_energyCaretElement, "visibility", (this._img_vision_clutterLevel == 0 && this._img_vision_gearPosition >= 50) ? "visible" : "hidden");
        this.update_img_vision_WarningTriggers();
        let advisoryText = "";
        let visibility = "hidden";
        if (Simplane.getIsGrounded()) {
            let nwsDegrees = SimVar.GetSimVarValue("NOSEWHEEL MAX STEERING ANGLE", "degrees");
            if (nwsDegrees > 0) {
                if (Math.round(nwsDegrees) == 75)
                    advisoryText = "NWS HI";
                else
                    advisoryText = "NWS";
                visibility = "visible";
            }
        }
        else {
            if (SimVar.GetSimVarValue("AUTOTHROTTLE ACTIVE", "Bool")) {
                visibility = "visible";
                if (Simplane.getAutoPilotAPPRActive() && Simplane.getAutoPilotGlideslopeActive()) { advisoryText = "AWLS"; }
                else {
                    advisoryText = "ATHR";
                }
            }
        }
        diffAndSetStyle(this._img_vision_AdvisoryElement, "visibility", visibility);
        if (advisoryText)
            diffAndSetText(this._img_vision_AdvisoryElement, advisoryText);
        this.previousAltitude = altitude;
        if (SimVar.GetSimVarValue("AUTOTHROTTLE ACTIVE", "Bool")) {
            diffAndSetStyle(this._img_vision_CommCassElement, "visibility", "visible");
            diffAndSetText(this._img_vision_CommCassElement, commairspeed.toFixed(0));
        }
        else { diffAndSetStyle(this._img_vision_CommCassElement, "visibility", "hidden"); }
    }
    update_img_vision_WarningTriggers() {
		// let triggeraltwarnings = false;
		// if (Simplane.getIsGrounded()) { triggeraltwarnings = false; }
		// else if (Simplane.getAltitudeAboveGround() <= SimVar.GetSimVarValue("L:FRIES_Ralt_Low_Limit", "number") ||  Simplane.getAltitude() <= SimVar.GetSimVarValue("L:FRIES_Alert_Baro", "number"))
		// { triggerswarnings = true; }
		let alertsOn = SimVar.GetSimVarValue("L:FRIES_Alert_Active", "boolean");
        let spdWarning =  Simplane.getIndicatedSpeed() > SimVar.GetSimVarValue("L:FRIES_SPD_Limit", "number");
		let raltWarning =  SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false && Simplane.getAltitudeAboveGround() <= SimVar.GetSimVarValue("L:FRIES_Ralt_Low_Limit", "number");
		let baltWarning =  SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false && Simplane.getAltitude() <= SimVar.GetSimVarValue("L:FRIES_Alert_Baro", "number");
		let GWarning = Simplane.getGForce() > SimVar.GetSimVarValue("L:FRIES_G_Limit", "number");
		let terrainWarning = SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false && Simplane.getAltitudeAboveGround() < SimVar.GetSimVarValue("L:FRIES_TF_Low_limit", "number") && Simplane.getIndicatedSpeed() > 200;
		if (GWarning) {
			diffAndSetStyle(this._img_vision_WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._img_vision_WarningElement, "G LIMIT");
		}
		else if (terrainWarning && alertsOn) {
			diffAndSetStyle(this._img_vision_WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._img_vision_WarningElement, "TF LOW");
		}
		else if (raltWarning && alertsOn || baltWarning && alertsOn) {
			diffAndSetStyle(this._img_vision_WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._img_vision_WarningElement, "FLY UP");
		}
		else if (spdWarning) {
			diffAndSetStyle(this._img_vision_WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._img_vision_WarningElement, "AIRSPEED");
		}
		else {
			diffAndSetStyle(this._img_vision_WarningElement, StyleProperty.display, "none");
			diffAndSetText(this._img_vision_WarningElement, "");
		}
    }
    update_img_vision_ClutterLevel() {
        let clutterLevel = SimVar.GetSimVarValue("L:XMLVAR_AS04F_HUD_Symbology_Reject", "number");
        if (clutterLevel != this._img_vision_clutterLevel) {
            this._img_vision_clutterLevel = clutterLevel;
            if (clutterLevel == 2) {
                diffAndSetAttribute(this._img_vision_headingElement, "visibility", "hidden");
                diffAndSetAttribute(this._img_vision_headingCursorElement, "visibility", "hidden");
            }
            else {
                diffAndSetAttribute(this._img_vision_headingCursorElement, "visibility", "visible");
                diffAndSetAttribute(this._img_vision_headingElement, "visibility", "visible");
            }
            if (clutterLevel == 0) {
                diffAndSetAttribute(this._img_vision_bankCursorElement, "visibility", "visible");
                diffAndSetAttribute(this._img_vision_bankElement, "visibility", "visible");
                diffAndSetStyle(this._img_vision_AirspeedElement, StyleProperty.border, "4px solid");
                diffAndSetStyle(this._img_vision_AltitudeElement, StyleProperty.border, "4px solid");
            }
            else {
                this._img_vision_PeakGValue = 0;
                diffAndSetAttribute(this._img_vision_bankCursorElement, "visibility", "hidden");
                diffAndSetAttribute(this._img_vision_bankElement, "visibility", "hidden");
                diffAndSetStyle(this._img_vision_AirspeedElement, StyleProperty.border, "none");
                diffAndSetStyle(this._img_vision_AltitudeElement, StyleProperty.border, "none");
            }
        }
    }
    update_img_vision_LeftInfosVisibility() {
        let visibility = "visible";
        if (this._img_vision_clutterLevel != 0 || this._img_vision_gearPosition >= 50)
            visibility = "hidden";
        diffAndSetStyle(this._img_vision_MachLabel, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._img_vision_MachElement, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._img_vision_CurrentGLabel, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._img_vision_CurrentGElement, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._img_vision_PeakGElement, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._img_vision_PeakGElement, StyleProperty.visibility, (this._img_vision_PeakGValue < 4) ? "hidden" : visibility);
    }
    update_img_vision_WithGearPosition() {
        let gearPosition = Simplane.getGearPosition();
        if (gearPosition != this._img_vision_gearPosition) {
            this._img_vision_gearPosition = gearPosition;
            if (this._img_vision_gearPosition < 50) {
                diffAndSetAttribute(this._img_vision_horizonZeroElement, "d", "M 320 500 L 450 500 M 550 500 L 680 500");

                diffAndSetAttribute(this._img_vision_waterLineElement, "visibility", "visible");
                diffAndSetAttribute(this._img_vision_eBracketElement, "visibility", "hidden");
            }
            else {
                diffAndSetAttribute(this._img_vision_horizonZeroElement, "d", "M0 500 L450 500 M550 500 L1000 500");

                diffAndSetAttribute(this._img_vision_waterLineElement, "visibility", "visible");
                diffAndSetAttribute(this._img_vision_eBracketElement, "visibility", "visible");
            }
        }
    }
    update_img_vision_Situation(pitch, aoa, bank) {
        let vBodyX = SimVar.GetSimVarValue("VELOCITY BODY X", "feet per second");
        let vBodyY = SimVar.GetSimVarValue("VELOCITY BODY Y", "feet per second");
        let vBodyZ = SimVar.GetSimVarValue("VELOCITY BODY Z", "feet per second");
        let vVectorX = (vBodyX != 0) ? Math.atan(vBodyX / vBodyZ) * Avionics.Utils.RAD2DEG : 0;
        let vVectorY = (vBodyY != 0) ? Math.atan(vBodyY / vBodyZ) * Avionics.Utils.RAD2DEG : 0;
        let blink = false;
        if (SimVar.GetSimVarValue("SIM ON GROUND", "Bool") && Simplane.getGroundSpeed() < 50) {
            vVectorX = 0;
            vVectorY = pitch;
        }
        else {
            let minY = this._img_vision_vVectorMinY + this._img_vision_projectionOffset / FA18_DDI_IMAGE.YPERDEGREE;
            let maxY = this._img_vision_vVectorMaxY + this._img_vision_projectionOffset / FA18_DDI_IMAGE.YPERDEGREE;
            blink = (vVectorX < this._img_vision_vVectorMinX || vVectorX > this._img_vision_vVectorMaxX || vVectorY < minY || vVectorY > maxY);
            vVectorX = Utils.Clamp(vVectorX, this._img_vision_vVectorMinX, this._img_vision_vVectorMaxX);
            vVectorY = Utils.Clamp(vVectorY, minY, maxY);
        }
        diffAndSetAttribute(this._img_vision_horizonContainerElement, "transform", "rotate(" + bank.toFixed(1) + " 500 " + (500 + this._img_vision_projectionOffset) + ")");
        diffAndSetAttribute(this._img_vision_waterLineElement, "transform", "translate(0, " + (this._img_vision_projectionOffset - 200) + ")");
        if (this._img_vision_cagedVelocityVector) {
            diffAndSetAttribute(this._img_vision_velocityGroupElement, "transform", "translate(0," + (-vVectorY * FA18_DDI_IMAGE.YPERDEGREE + this._img_vision_projectionOffset).toFixed(1) + ")");
            if (Math.abs(vVectorX) > 2) {
                diffAndSetAttribute(this._img_vision_ghostVelocityElement, "transform", "translate(" + (vVectorX * 12.5).toFixed(0) + ", " + (-vVectorY * FA18_DDI_IMAGE.YPERDEGREE + this._img_vision_projectionOffset).toFixed(1) + ")");
                diffAndSetAttribute(this._img_vision_ghostVelocityElement, "visibility", "visible");
            }
            else {
                diffAndSetAttribute(this._img_vision_ghostVelocityElement, "visibility", "hidden");
            }
            diffAndSetAttribute(this._img_vision_ghostVelocityElement, "state", (blink) ? "blink" : "");
            diffAndSetAttribute(this._img_vision_velocityGroupElement, "state", "");
        }
        else {
            diffAndSetAttribute(this._img_vision_velocityGroupElement, "transform", "translate(" + (vVectorX * 12.5).toFixed(0) + ", " + (-vVectorY * FA18_DDI_IMAGE.YPERDEGREE + this._img_vision_projectionOffset).toFixed(1) + ")");
            diffAndSetAttribute(this._img_vision_velocityGroupElement, "state", (blink) ? "blink" : "");
            diffAndSetAttribute(this._img_vision_ghostVelocityElement, "visibility", "hidden");
        }
        diffAndSetAttribute(this._img_vision_horizonElement, "transform", "translate(0, " + (-pitch * FA18_DDI_IMAGE.YPERDEGREE + this._img_vision_projectionOffset).toFixed(1) + ")");
        diffAndSetAttribute(this._img_vision_horizonClipElement, "transform", "translate(0, " + (pitch * FA18_DDI_IMAGE.YPERDEGREE + -this._img_vision_projectionOffset).toFixed(1) + ")");
        let aoaDiff = 0;
        if (aoa < 7.4)
            aoaDiff = aoa - 7.4;
        else if (aoa > 8.8)
            aoaDiff = aoa - 8.8;
        diffAndSetAttribute(this._img_vision_eBracketElement, "transform", "translate(0, " + (aoaDiff * FA18_DDI_IMAGE.YPERDEGREE) + ")");
        if (Math.abs(bank) > 45) {
            diffAndSetAttribute(this._img_vision_bankCursorElement, "transform", "rotate(" + (Math.sign(bank) * 45) + " 500 500)");
            diffAndSetAttribute(this._img_vision_bankCursorElement, "state", "blink");
        }
        else {
            diffAndSetAttribute(this._img_vision_bankCursorElement, "transform", "rotate(" + (bank).toFixed(1) + " 500 500)");
            diffAndSetAttribute(this._img_vision_bankCursorElement, "state", "");
        }
    }
    compute_img_vision_SteeringTranslation(planeHeading, steeringBearing) {
        let steeringError = Avionics.Utils.diffAngle(planeHeading, steeringBearing);
        let translationBase = 0;
        if (Math.abs(steeringError) <= 5) {
            translationBase = steeringError;
        }
        else if (Math.abs(steeringError) > 30) {
            translationBase = 15 * Math.sign(steeringError);
        }
        else {
            translationBase = 0.4 * steeringError + (Math.sign(steeringError) * 3);
        }
        return translationBase * 12.5;
    }
    update_img_vision_CselIndicator(planeHeading, steeringMode) {
        if (this.ddi.map.isCourseSteering) {
            let deviation;
            let obs;
            switch (steeringMode) {
                case FA18_DDI_Steering_Source.TACAN:
                    let cdi = SimVar.GetSimVarValue("TACAN STATION CDI:1", "number") / 127 * 10;
                    deviation = Utils.Clamp(cdi, -8, 8);
                    obs = SimVar.GetSimVarValue("TACAN OBS:1", "degrees");
                    break;
                case FA18_DDI_Steering_Source.ILST:
                    let ilstcdi = SimVar.GetSimVarValue("NAV CDI:" + this.ddi.ilstacanindex, "number") / 127 * 10;
                    deviation = Utils.Clamp(ilstcdi, -8, 8);
                    obs = SimVar.GetSimVarValue("NAV OBS:" + this.ddi.ilstacanindex, "degrees");
                    break;
                case FA18_DDI_Steering_Source.VOR:
                    let vorcdi = SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127 * 10;
                    deviation = Utils.Clamp(vorcdi, -8, 8);
                    obs = SimVar.GetSimVarValue("NAV OBS:" + this.ddi.navindex, "degrees");
                    break;
                case FA18_DDI_Steering_Source.ILSN:
                    let ilsncdi = SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127 * 10;
                    deviation = Utils.Clamp(ilsncdi, -8, 8);
                    obs = SimVar.GetSimVarValue("NAV OBS:" + this.ddi.navindex, "degrees");
                    break;
                case FA18_DDI_Steering_Source.WYPT:
                    deviation = Utils.Clamp(SimVar.GetSimVarValue("GPS WP CROSS TRK", "nautical mile"), -2, 2) / 2 * 8;
                    obs = SimVar.GetSimVarValue("GPS WP DESIRED TRACK", "degree");
                    break;
            }
            if (deviation != null && obs != null) {
                diffAndSetAttribute(this._img_vision_cselGroupElement, "visibility", "visible");
                diffAndSetAttribute(this._img_vision_cselDotsLeftGroupElement, "visibility", (deviation < -1.25) ? "visible" : "hidden");
                diffAndSetAttribute(this._img_vision_cselDotsRightGroupElement, "visibility", (deviation > 1.25) ? "visible" : "hidden");
                diffAndSetAttribute(this._img_vision_cselArrowElement, "transform", "translate(" + Utils.mapValue(deviation, -8, 8, -100, 100) + ", 0)");
                diffAndSetAttribute(this._img_vision_cselGroupElement, "transform", "translate(500,500) rotate(" + (obs - planeHeading) + ")");
            }
            else {
                diffAndSetAttribute(this._img_vision_cselGroupElement, "visibility", "hidden");
                diffAndSetAttribute(this._img_vision_cselDotsLeftGroupElement, "visibility", "hidden");
                diffAndSetAttribute(this._img_vision_cselDotsRightGroupElement, "visibility", "hidden");
            }
        }
        else {
            diffAndSetAttribute(this._img_vision_cselGroupElement, "visibility", "hidden");
            diffAndSetAttribute(this._img_vision_cselDotsLeftGroupElement, "visibility", "hidden");
            diffAndSetAttribute(this._img_vision_cselDotsRightGroupElement, "visibility", "hidden");
        }
    }
    update_img_vision_CoupledMode() {
        var _a, _b, _c;
        let isCoupled = SimVar.GetSimVarValue("L:FA18_IS_STEERING_COUPLED", "Bool");
        if (isCoupled != this._img_vision_isCoupled) {
            if (this._img_vision_isCoupled) {
                this._img_vision_coupledTimer = 10;
            }
            else {
                switch (this.ddi.steeringSource) {
                    case FA18_DDI_Steering_Source.TACAN:
                        diffAndSetText(this._img_vision_CplModeElement, "CPL TCN");
                        break;
                    case FA18_DDI_Steering_Source.ILST:
                        diffAndSetText(this._img_vision_CplModeElement, "CPL ILST");
                        break;
                    case FA18_DDI_Steering_Source.VOR:
                        diffAndSetText(this._img_vision_CplModeElement, "CPL VOR");
                        break;
                    case FA18_DDI_Steering_Source.ILSN:
                        diffAndSetText(this._img_vision_CplModeElement, "CPL ILSN");
                        break;
                    case FA18_DDI_Steering_Source.WYPT:
                        diffAndSetText(this._img_vision_CplModeElement, ((_a = this.ddi.waypointManager) === null || _a === void 0 ? void 0 : _a.autoSequentialSteeringActive) ? "CPL SEQ" + ((_c = (_b = this.ddi.waypointManager) === null || _b === void 0 ? void 0 : _b.currentSequence) === null || _c === void 0 ? void 0 : _c.id) : "CPL WYPT");
                        break;
                }
                this._img_vision_coupledTimer = -1;
            }
            this._img_vision_isCoupled = isCoupled;
        }
        if (this._img_vision_isCoupled || this._img_vision_coupledTimer > 0) {
            diffAndSetStyle(this._img_vision_CplModeElement, StyleProperty.visibility, "visible");
        }
        else {
            diffAndSetStyle(this._img_vision_CplModeElement, StyleProperty.visibility, "hidden");
        }
        diffAndSetAttribute(this._img_vision_CplModeElement, "state", (this._img_vision_coupledTimer > 0) ? "blink" : "");
    }
    update_img_vision_SteeringInfos(planeHeading) {
        let displayed = false;
        let ident = "";
        let steeringTranslation = 0;
        let course = "";
        let showILS = false;
        let factor = 100;
        let ApOn = Simplane.getAutoPilotActive();
        let APtext = ApOn ? "A" : "";
        switch (this.ddi.steeringSource) {
            case FA18_DDI_Steering_Source.TACAN:
                if (this.ddi.tacanAvailable) {
                    let distance = SimVar.GetSimVarValue("TACAN STATION DISTANCE:1", "nautical mile");
                    let tacanIdentifier = SimVar.GetSimVarValue("TACAN STATION IDENT:1", "string");
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("TACAN STATION RADIAL:1", "degree") + 180);
                    ident = APtext + "TCN " + tacanIdentifier;
                    course = fastToFixed(bearing, 1) + "° / " + fastToFixed(distance, 1) + "NM"
                    steeringTranslation = this.compute_img_vision_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
            case FA18_DDI_Steering_Source.ILST:
                if (this.ddi.ilstacanAvailable) {
                    let distance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.ilstacanindex, "nautical mile");
                    let ilstacanIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.ilstacanindex, "string");
                    let ilstbearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.ilstacanindex, "degree") + 180);
                    ident = APtext + "ISLT " + ilstacanIdentifier;
                    course = fastToFixed(ilstbearing, 1) + "°/ " + fastToFixed(distance, 1) + "NM"
                    steeringTranslation = this.compute_img_vision_SteeringTranslation(planeHeading, ilstbearing);
                    displayed = true;
                    showILS = (this.ddi.ilstacanAvailable);
                    let cdidev = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.ilstacanindex, "number") / 127);
                    let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
                    if (backCourse) {
                        cdidev = -cdidev;
                    }
                    diffAndSetAttribute(this._img_vision_cdideviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(cdidev), -1), 1) * factor) + ")");

                    if (SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.ddi.ilstacanindex, "Bool")) {
                        let gsidev = (SimVar.GetSimVarValue("NAV GSI:" + this.ddi.ilstacanindex, "number") / 127);
                        let y = (parseFloat(gsidev) * factor);
                        let x = 0;
                        diffAndSetAttribute(this._img_vision_gsideviation, "transform", "translate(" + (x) + " " + fastToFixed(y, 0) + ")");
                    }
                }
                break;
            case FA18_DDI_Steering_Source.VOR:
                if (this.ddi.navAvailable) {
                    let vorBearing = Avionics.Utils.clampAngle(this.ddi.getCrsValue());
                    let distance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.navindex, "nautical mile");
                    let vorIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.navindex, "string");
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180);
                    ident = APtext + "NAV" + this.ddi.navindex + " " + vorIdentifier;
                    course = fastToFixed(vorBearing, 1) + "°/ " + fastToFixed(distance, 1) + "NM";
                    steeringTranslation = this.compute_img_vision_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
            case FA18_DDI_Steering_Source.ILSN:
                if (this.ddi.ilsnavAvailable) {
                    let ilsBearing = Avionics.Utils.clampAngle(this.ddi.getCrsValue());
                    let distance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.navindex, "nautical mile");
                    let ilsIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.navindex, "string");
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180);
                    ident = APtext + "ILSN" + this.ddi.navindex + " " + ilsIdentifier;
                    course = fastToFixed(ilsBearing, 1) + "°/ " + fastToFixed(distance, 1) + "NM";
                    steeringTranslation = this.compute_img_vision_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                    showILS = (this.ddi.ilsnavAvailable);

                    let cdidev = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127);
                    let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
                    if (backCourse) {
                        cdidev = -cdidev;
                    }
                    diffAndSetAttribute(this._img_vision_cdideviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(cdidev), -1), 1) * factor) + ")");

                    if (SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.ddi.navindex, "Bool")) {
                        let gsidev = (SimVar.GetSimVarValue("NAV GSI:" + this.ddi.navindex, "number") / 127);
                        let y = (parseFloat(gsidev) * factor);
                        let x = 0;
                        diffAndSetAttribute(this._img_vision_gsideviation, "transform", "translate(" + (x) + " " + fastToFixed(y, 0) + ")");
                    }
                }
                break;
            case FA18_DDI_Steering_Source.WYPT:
                if (this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentWaypoint) {
                    let distance = this.ddi.flightPlanManager.getDistanceToWaypoint(this.ddi.waypointManager.currentWaypoint);
                    let bearing = this.ddi.flightPlanManager.getBearingToWaypoint(this.ddi.waypointManager.currentWaypoint, true);
                    ident = APtext + "WP" + this.ddi.waypointManager.currentWaypointNumber;
                    course = fastToFixed(bearing, 1) + "°/" + fastToFixed(distance, 1) + "NM";
                    steeringTranslation = this.compute_img_vision_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
        }
        diffAndSetText(this._img_vision_SteeringDataElement, ident);
        diffAndSetText(this._img_vision_SteeringCrsElement, course);
        diffAndSetAttribute(this._img_vision_headingSteeringBugElement, "transform", "translate(" + fastToFixed(steeringTranslation, 1) + ", 0)");
        diffAndSetStyle(this._img_vision_SteeringDataElement, StyleProperty.visibility, ((this._img_vision_clutterLevel != 2) && displayed) ? "visible" : "hidden");
        diffAndSetStyle(this._img_vision_SteeringCrsElement, StyleProperty.visibility, ((this._img_vision_clutterLevel != 2) && displayed) ? "visible" : "hidden");
        diffAndSetAttribute(this._img_vision_headingSteeringBugElement, "visibility", ((this._img_vision_clutterLevel != 2) && displayed) ? "visible" : "hidden");
        diffAndSetStyle(this._img_vision_cdigroup, StyleProperty.visibility, (showILS) ? "visible" : "hidden");
        diffAndSetStyle(this._img_vision_gsigroup, StyleProperty.visibility, (showILS) ? "visible" : "hidden");
        this.update_img_vision_CselIndicator(planeHeading, this.ddi.steeringSource);
        this.update_img_vision_CoupledMode();
    }
    update_img_vision_Projection(_deltaTime) {
        this._img_vision_projectionOffset = FA18_DDI_IMAGE.PROJECTION_OFFSET;
    }
}
FA18_DDI_IMAGE.YPERDEGREE = 48;
FA18_DDI_IMAGE.PROJECTION_OFFSET = -200;
customElements.define("fa18-ddi-imagevision", FA18_DDI_IMAGE);
//# sourceMappingURL=FA18_DDI_IMAGE.js.map