class FA18_DDI_HUD extends FA18_DDI_Page {
    constructor() {
        super(...arguments);
        this.vVectorMinX = -17;
        this.vVectorMaxX = 17;
        this.vVectorMinY = -8;
        this.vVectorMaxY = 6;
        this._hudPeakGValue = 0;
        this.projectionOffset = 0;
        this._drawn = false;
        this.clutterLevel = -1;
        this.isCoupled = false;
        this.coupledTimer = -1;
        this.barometricSettingDisplayTimer = -1;
    }
    get templateID() { return "FA18_DDI_HUD"; }
    init(ddi) {
        super.init(ddi);
        FA18_DDI_HUD.DEBUG_INSTANCE = this;
        if (!this._drawn) {
            this._waterLineElement = this.ddi.getChildById("hud-waterline");
            this._hudMainElement = this.ddi.getElementsByClassName("hud-display")[0];
            diffAndSetAttribute(this._hudMainElement, "main_hud", (this.ddi.instrumentIndex == 4) ? "True" : "False");
            this._hudAirspeedElement = this.ddi.getChildById("hud-airspeed");
            this._hudVerticalSpeedElement = this.ddi.getChildById("hud-vertical-speed");
			this._hudRaltitudeElement = this.ddi.getChildById("hud-raltitude");
			this._hudRaltitudetext = this.ddi.getChildById("hud-raltitude-text");
            this._hudCommCassElement = this.ddi.getChildById("hud-comm-cas");																					
            this._hudAltitudeElement = this.ddi.getChildById("hud-altitude");
            this._hudAltitudeElementModeElement = this.ddi.getChildById("hud-altitude-mode");
            this._hudBarometricSettingElement = this.ddi.getChildById("hud-barometric-setting");
            this._hudAOAElement = this.ddi.getChildById("hud-aoa-value");
            this._hudMachLabel = this.ddi.getChildById("hud-mach-label");
            this._hudMachElement = this.ddi.getChildById("hud-mach-value");
            this._hudCurrentGLabel = this.ddi.getChildById("hud-current-g-label");
            this._hudCurrentGElement = this.ddi.getChildById("hud-current-g-value");
            this._hudPeakGElement = this.ddi.getChildById("hud-peak-g-value");
            this._hudCplModeElement = this.ddi.getChildById("hud-cpl-mode");
            this._hudAdvisoryElement = this.ddi.getChildById("hud-advisory");
            this._hudSteeringDataElement = this.ddi.getChildById("hud-steering-data");
            this._hudSteeringCrsElement = this.ddi.getChildById("hud-steering-crs");
            this._headingElement = this.ddi.getChildById("hud-heading-tape-group");
            this._headingCursorElement = this.ddi.getChildById("hud-heading-cursor");
            this._headingClipElement = this.ddi.getChildById("hud-heading-clip");
            this._headingSteeringBugElement = this.ddi.getChildById("hud-heading-steering-bug");
            this._horizonElement = this.ddi.getChildById("hud-horizon-group");
            this._horizonContainerElement = this.ddi.getChildById("hud-horizon-container-group");
            this._horizonClipElement = this.ddi.getChildById("hud-horizon-clip");
            this._eBracketElement = this.ddi.getChildById("hud-e-bracket-group");
            this._bankCursorElement = this.ddi.getChildById("bank-cursor");
            this._bankElement = this.ddi.getChildById("bank-tape-group");
            this._velocityGroupElement = this.ddi.getChildById("hud-velocity-vector-group");
            this._ghostVelocityElement = this.ddi.getChildById("ghost-hud-velocity-vector-group");
            this._energyCaretElement = this.ddi.getChildById("hud-energy-caret");
            this._cselGroupElement = this.ddi.getChildById("hud-csel-group");
            this._cselDotsLeftGroupElement = this.ddi.getChildById("hud-csel-dots-left-group");
            this._cselDotsRightGroupElement = this.ddi.getChildById("hud-csel-dots-right-group");
            this._cselArrowElement = this.ddi.getChildById("hud-csel-arrow");
            this._WarningElement = this.ddi.getChildById("hud-warnings");
            this._gsigroup = this.ddi.getChildById("hud-gsi-group");
            this._cdigroup = this.ddi.getChildById("hud-cdi-group");
            this._gsideviation = this.ddi.getChildById("hud-gsi-deviation");
            this._cdideviation = this.ddi.getChildById("hud-cdi-deviation");
            for (let i = -3; i < 39; i++) {
                let text = document.createElementNS(Avionics.SVG.NS, "text");
                let s = ((i + 36) % 36).toFixed(0) + "0";
                let Xspacing = 125;
                let yBottom = 145;
                s = s.padStart(3, "0");
                diffAndSetText(text, s);
                diffAndSetAttribute(text, "x", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(text, "y", (yBottom - 25) + "");
                diffAndSetAttribute(text, "font-size", "40");
                diffAndSetAttribute(text, "font-weight", "regular");
                diffAndSetAttribute(text, "text-anchor", "middle");
                diffAndSetAttribute(text, "fill", "lime");
                diffAndSetAttribute(text, "clip-path", "url(#hud-heading-clip)");
                this._headingElement.appendChild(text);
                let lineL = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(lineL, "x1", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(lineL, "y1", (yBottom - 20) + '');
                diffAndSetAttribute(lineL, "x2", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(lineL, "y2", (yBottom) + '');
                diffAndSetAttribute(lineL, "stroke", "lime");
                diffAndSetAttribute(lineL, "stroke-width", "4");
                diffAndSetAttribute(lineL, "clip-path", "url(#hud-heading-clip)");
                this._headingElement.appendChild(lineL);
                let lineS = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(lineS, "x1", (500 + i * Xspacing + Xspacing / 2).toFixed(0));
                diffAndSetAttribute(lineS, "y1", (yBottom - 10) + '');
                diffAndSetAttribute(lineS, "x2", (500 + i * Xspacing + Xspacing / 2).toFixed(0));
                diffAndSetAttribute(lineS, "y2", (yBottom) + '');
                diffAndSetAttribute(lineS, "stroke", "lime");
                diffAndSetAttribute(lineS, "stroke-width", "4");
                diffAndSetAttribute(lineS, "clip-path", "url(#hud-heading-clip)");
                this._headingElement.appendChild(lineS);
            }
            for (let i = -17; i < 18; i++) {
                let h = 20;
                if (i === 0) {
                    h = 35;
                }
                else if (i < 0) {
                    h = -20;
                }
                let y = 420 - FA18_DDI_HUD.YPERDEGREE * 5 * i;
                let path = document.createElementNS(Avionics.SVG.NS, "g");
                if (i === 0) {
                    let p1 = "0 " + y.toFixed(0);
                    let p2 = "450 " + y.toFixed(0);
                    let p3 = "550 " + y.toFixed(0);
                    let p4 = "1000 " + y.toFixed(0);
                    let d1 = "M" + p1 + " L" + p2 + " M" + p3 + " L" + p4;
                    let path1 = document.createElementNS(Avionics.SVG.NS, "path");
                    diffAndSetAttribute(path1, "d", d1);
                    diffAndSetAttribute(path1, "stroke", "lime");
                    diffAndSetAttribute(path1, "stroke-width", "4");
                    diffAndSetAttribute(path1, "fill", "none");    /** Horizon line fill */
                    diffAndSetAttribute(path1, "clip-path", "url(#hud-horizon-clip)");
                    this._horizonZeroElement = path1;
                    path.appendChild(path1);
                }
                else {
                    let p1 = "420 " + (y + h).toFixed(0); /* Bottom of left vert line*/
                    let p2 = "420 " + y.toFixed(0);  /* top left point */
                    let p3 = "470 " + (y + h / 5).toFixed(0);  /* left mid horizontal line how far right*/
                    let p4 = "530 " + (y + h / 5).toFixed(0);
                    let p5 = "580 " + y.toFixed(0);
                    let p6 = "580 " + (y + h).toFixed(0);
                    let d1 = "M" + p1 + " L" + p2;
                    let d2 = "M" + p2 + " L" + p3;
                    let d3 = "M" + p4 + " L" + p5;
                    let d4 = "M" + p5 + " L" + p6;
                    let path1 = document.createElementNS(Avionics.SVG.NS, "path");
                    let path2 = document.createElementNS(Avionics.SVG.NS, "path");
                    let path3 = document.createElementNS(Avionics.SVG.NS, "path");
                    let path4 = document.createElementNS(Avionics.SVG.NS, "path");
                    diffAndSetAttribute(path1, "d", d1);
                    diffAndSetAttribute(path2, "d", d2);
                    diffAndSetAttribute(path3, "d", d3);
                    diffAndSetAttribute(path4, "d", d4);
                    diffAndSetAttribute(path1, "stroke", "lime");
                    diffAndSetAttribute(path1, "stroke-width", "4");
                    diffAndSetAttribute(path1, "fill", "none");
                    diffAndSetAttribute(path1, "clip-path", "url(#hud-horizon-clip)");
                    diffAndSetAttribute(path2, "stroke", "lime");
                    diffAndSetAttribute(path2, "stroke-width", "4");
                    diffAndSetAttribute(path2, "fill", "none");
                    diffAndSetAttribute(path2, "clip-path", "url(#hud-horizon-clip)");
                    diffAndSetAttribute(path3, "stroke", "lime");
                    diffAndSetAttribute(path3, "stroke-width", "4");
                    diffAndSetAttribute(path3, "fill", "none");
                    diffAndSetAttribute(path3, "clip-path", "url(#hud-horizon-clip)");
                    diffAndSetAttribute(path4, "stroke", "lime");
                    diffAndSetAttribute(path4, "stroke-width", "4");
                    diffAndSetAttribute(path4, "fill", "none");
                    diffAndSetAttribute(path4, "clip-path", "url(#hud-horizon-clip)");
                    if (i < 0) {
                        diffAndSetAttribute(path2, "stroke-dasharray", "7, 7");
                        diffAndSetAttribute(path3, "stroke-dasharray", "7, 7");
                    }
                    path.appendChild(path1);
                    path.appendChild(path2);
                    path.appendChild(path3);
                    path.appendChild(path4);
                }
                diffAndSetAttribute(path, "id", "attitude-line-" + (i < 0 ? "minus-" : "") + Math.abs(i * 5).toFixed(0));
                this._horizonElement.appendChild(path);
                if (i != 0) {
                    let textPosition = 0;
                    if (i > 0) {
                        textPosition = 20;
                    }
                    let textL = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(textL, Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textL, "id", "attitude-textl-" + (i < 0 ? "minus-" : "") + Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textL, "x", "390");
                    diffAndSetAttribute(textL, "y", (y + textPosition).toFixed(0));
                    diffAndSetAttribute(textL, "font-size", "40");
                    diffAndSetAttribute(textL, "font-weight", "bold");
                    diffAndSetAttribute(textL, "text-anchor", "middle");
                    diffAndSetAttribute(textL, "fill", "lime");
                    diffAndSetAttribute(textL, "clip-path", "url(#hud-horizon-clip)");
                    this._horizonElement.appendChild(textL);
                    let textR = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(textR, Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textR, "id", "attitude-textr-" + (i < 0 ? "minus-" : "") + Math.abs(i * 5).toFixed(0));
                    diffAndSetAttribute(textR, "x", "610");
                    diffAndSetAttribute(textR, "y", (y + textPosition).toFixed(0));
                    diffAndSetAttribute(textR, "font-size", "40");
                    diffAndSetAttribute(textR, "font-weight", "bold");
                    diffAndSetAttribute(textR, "text-anchor", "middle");
                    diffAndSetAttribute(textR, "fill", "lime");
                    diffAndSetAttribute(textR, "clip-path", "url(#hud-horizon-clip)");
                    this._horizonElement.appendChild(textR);
                }
            }
            this._drawn = true;
        }
    }
    show() {
        super.show();
        this.ddi.onButtonPressed[18] = () => {
            this.ddi.showPage(FA18_DDI_Page_Type.MenuTactical);
        };
    }
    onEvent(_event) {
        super.onEvent(_event);
        switch (_event) {
            case "Altimeter_Standby_Changed":
                if (this.isCurrentDisplayedPage) {
                    this.barometricSettingDisplayTimer = 5;
                    diffAndSetAttribute(this._hudBarometricSettingElement, "state", "displayed");
                }
                break;
        }
    }
    update(deltaTime) {
        super.update(deltaTime);
        let airspeed = Simplane.getIndicatedSpeed();
        let commairspeed = Simplane.getAutoPilotAirspeedHoldValue();
        let verticalSpeed = Simplane.getVerticalSpeed();
        let bank = Simplane.getBank();
        this._cagedVelocityVector = SimVar.GetSimVarValue("L:XMLVAR_HUD_Push_VelocityVector_Cage", "Bool");
        let altitude = Simplane.getAltitude();
		let radioaltitude = SimVar.GetSimVarValue("RADIO HEIGHT", "feet");
        if (this.previousAltitude == undefined)
            this.previousAltitude = altitude;
        if (this.coupledTimer >= 0) {
            this.coupledTimer -= (deltaTime / 1000);
        }
        if (this.barometricSettingDisplayTimer >= 0) {
            this.barometricSettingDisplayTimer -= (deltaTime / 1000);
        }
        if (this.ddi.instrumentIndex === 4) {
            this.updateProjection(deltaTime);
        }
        this.updateClutterLevel();
        this.updateHudWithGearPosition();
        diffAndSetText(this._hudAirspeedElement, airspeed.toFixed(0));
        diffAndSetText(this._hudVerticalSpeedElement, verticalSpeed.toFixed(0));
        let displayedAltitude;
        if (SimVar.GetSimVarValue("L:XMLVAR_AS04F_HUD_Alt_Selector", "number") == 1) {
		    diffAndSetStyle(this._hudRaltitudeElement, "visibility", "hidden");
			diffAndSetStyle(this._hudRaltitudetext, "visibility", "hidden");
            displayedAltitude = SimVar.GetSimVarValue("RADIO HEIGHT", "feet");
            // if (displayedAltitude > 5000) {
                // displayedAltitude = altitude;
                // diffAndSetText(this._hudAltitudeElementModeElement, "B");
                // diffAndSetAttribute(this._hudAltitudeElementModeElement, "state", "blink");
            // }
            // else {
                diffAndSetText(this._hudAltitudeElementModeElement, "R");
                diffAndSetAttribute(this._hudAltitudeElementModeElement, "state", "");
            // }
        }
        else {
            displayedAltitude = altitude;
            diffAndSetText(this._hudAltitudeElementModeElement, "");
			diffAndSetStyle(this._hudRaltitudeElement, "visibility", radioaltitude <= 5000 ? "visible" : "hidden");
		    diffAndSetStyle(this._hudRaltitudetext, "visibility", radioaltitude <= 5000 ? "visible" : "hidden");
        }
        diffAndSetText(this._hudAltitudeElement, displayedAltitude.toFixed(0));
		diffAndSetText(this._hudRaltitudeElement, radioaltitude.toFixed(0));
        if (this.barometricSettingDisplayTimer <= 0 && this.previousAltitude > 10000 && altitude < 10000 && airspeed < 300) {
            this.barometricSettingDisplayTimer = 5;
            diffAndSetAttribute(this._hudBarometricSettingElement, "state", "blink");
        }
        if (this.barometricSettingDisplayTimer > 0) {
            diffAndSetText(this._hudBarometricSettingElement, fastToFixed(Simplane.getPressureValue(), 2));
        }
        else {
            diffAndSetAttribute(this._hudBarometricSettingElement, "state", "hidden");
        }
        let heading = Simplane.getHeadingMagnetic();
        diffAndSetAttribute(this._headingElement, "transform", "translate(" + (-heading * 12.5) + ", 0)");
        diffAndSetAttribute(this._headingClipElement, "transform", "translate(" + (heading * 12.5) + ", 0)");
        let aoa = Simplane.getAngleOfAttack("degree");
        let mach = Simplane.getMachSpeed();
        let pitch = Simplane.getPitch();
        let g = Simplane.getGForce();
        this._hudPeakGValue = Utils.Clamp(this._hudPeakGValue, g, 99);
        diffAndSetText(this._hudCurrentGElement, g.toFixed(1));
        diffAndSetText(this._hudPeakGElement, this._hudPeakGValue.toFixed(1));
        diffAndSetText(this._hudAOAElement, aoa.toFixed(1));
        diffAndSetText(this._hudMachElement, mach.toFixed(3).replace(/^[0]+/, ""));
        this.updateLeftInfosVisibility();
        this.updateSteeringInfos(heading);
        this.updateSituation(pitch, aoa, bank);
        let acceleration = SimVar.GetSimVarValue("ACCELERATION BODY Z", "feet per second squared");
        diffAndSetAttribute(this._energyCaretElement, "transform", "translate(0, " + (-acceleration * 4).toFixed(1) + ")");
        diffAndSetAttribute(this._energyCaretElement, "visibility", (this.clutterLevel == 0 && this._gearPosition >= 50) ? "visible" : "hidden");
        this.WarningTriggers();
        let advisoryText = "";
        let visibility = "hidden";
        if (Simplane.getIsGrounded()) {
            let nwsDegrees = SimVar.GetSimVarValue("NOSEWHEEL MAX STEERING ANGLE", "degrees");
            if (nwsDegrees > 0) {
                if (Math.round(nwsDegrees) == 75)
                    advisoryText = "NWS HI";
                else
                    advisoryText = "NWS";
                visibility = "visible";
            }
        }
        else {
            if (SimVar.GetSimVarValue("AUTOTHROTTLE ACTIVE", "Bool")) {
                visibility = "visible";
                if (Simplane.getAutoPilotAPPRActive() && Simplane.getAutoPilotGlideslopeActive()) { advisoryText = "AWLS"; }
                else {
                    advisoryText = "ATHR";
                }
            }
        }
        diffAndSetStyle(this._hudAdvisoryElement, "visibility", visibility);
        if (advisoryText)
            diffAndSetText(this._hudAdvisoryElement, advisoryText);
        this.previousAltitude = altitude;
        if (SimVar.GetSimVarValue("AUTOTHROTTLE ACTIVE", "Bool")) {
            diffAndSetStyle(this._hudCommCassElement, "visibility", "visible");
            diffAndSetText(this._hudCommCassElement, commairspeed.toFixed(0));
        }
        else { diffAndSetStyle(this._hudCommCassElement, "visibility", "hidden"); }
    }
    WarningTriggers() {
		// let triggeraltwarnings = false;
		// if (Simplane.getIsGrounded()) { triggeraltwarnings = false; }
		// else if (Simplane.getAltitudeAboveGround() <= SimVar.GetSimVarValue("L:FRIES_Ralt_Low_Limit", "number") ||  Simplane.getAltitude() <= SimVar.GetSimVarValue("L:FRIES_Alert_Baro", "number"))
		// { triggerswarnings = true; }
		let alertsOn = SimVar.GetSimVarValue("L:FRIES_Alert_Active", "boolean");
		let spdbkout = SimVar.GetSimVarValue("SPOILERS HANDLE POSITION", "percent") >= 50;															
        let spdWarning =  Simplane.getIndicatedSpeed() > SimVar.GetSimVarValue("L:FRIES_SPD_Limit", "number");
		let raltWarning =  SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false && Simplane.getAltitudeAboveGround() <= SimVar.GetSimVarValue("L:FRIES_Ralt_Low_Limit", "number");
		let baltWarning =  SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false && Simplane.getAltitude() <= SimVar.GetSimVarValue("L:FRIES_Alert_Baro", "number");
		let GWarning = Simplane.getGForce() > SimVar.GetSimVarValue("L:FRIES_G_Limit", "number");
		let terrainWarning = SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false && Simplane.getAltitudeAboveGround() < SimVar.GetSimVarValue("L:FRIES_TF_Low_limit", "number") && Simplane.getIndicatedSpeed() > 200;
		if (GWarning) {
			diffAndSetStyle(this._WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._WarningElement, "G LIMIT");
		}
		else if (terrainWarning && alertsOn) {
			diffAndSetStyle(this._WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._WarningElement, "TF LOW");
		}
		else if (raltWarning && alertsOn || baltWarning && alertsOn) {
			diffAndSetStyle(this._WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._WarningElement, "FLY UP");
		}
		else if (spdbkout) {
			diffAndSetStyle(this._WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._WarningElement, "SPD BK OUT");
		}
		else if (spdWarning) {
			diffAndSetStyle(this._WarningElement, StyleProperty.display, "block");
			diffAndSetText(this._WarningElement, "AIRSPEED");
		}
		else {
			diffAndSetStyle(this._WarningElement, StyleProperty.display, "none");
			diffAndSetText(this._WarningElement, "");
		}
    }
    updateClutterLevel() {
        let clutterLevel = SimVar.GetSimVarValue("L:XMLVAR_AS04F_HUD_Symbology_Reject", "number");
        if (clutterLevel != this.clutterLevel) {
            this.clutterLevel = clutterLevel;
            if (clutterLevel == 2) {
                diffAndSetAttribute(this._headingElement, "visibility", "hidden");
                diffAndSetAttribute(this._headingCursorElement, "visibility", "hidden");
            }
            else {
                diffAndSetAttribute(this._headingCursorElement, "visibility", "visible");
                diffAndSetAttribute(this._headingElement, "visibility", "visible");
            }
            if (clutterLevel == 0) {
                diffAndSetAttribute(this._bankCursorElement, "visibility", "visible");
                diffAndSetAttribute(this._bankElement, "visibility", "visible");
                diffAndSetStyle(this._hudAirspeedElement, StyleProperty.border, "4px solid lime");
                diffAndSetStyle(this._hudAltitudeElement, StyleProperty.border, "4px solid lime");
            }
            else {
                this._hudPeakGValue = 0;
                diffAndSetAttribute(this._bankCursorElement, "visibility", "hidden");
                diffAndSetAttribute(this._bankElement, "visibility", "hidden");
                diffAndSetStyle(this._hudAirspeedElement, StyleProperty.border, "none");
                diffAndSetStyle(this._hudAltitudeElement, StyleProperty.border, "none");
            }
        }
    }
    updateLeftInfosVisibility() {
        let visibility = "visible";
        if (this.clutterLevel != 0 || this._gearPosition >= 50)
            visibility = "hidden";
        diffAndSetStyle(this._hudMachLabel, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._hudMachElement, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._hudCurrentGLabel, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._hudCurrentGElement, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._hudPeakGElement, StyleProperty.visibility, visibility);
        diffAndSetStyle(this._hudPeakGElement, StyleProperty.visibility, (this._hudPeakGValue < 4) ? "hidden" : visibility);
    }
    updateHudWithGearPosition() {
        let gearPosition = Simplane.getGearPosition();
        if (gearPosition != this._gearPosition) {
            this._gearPosition = gearPosition;
            if (this._gearPosition < 50) {
                diffAndSetAttribute(this._horizonZeroElement, "d", "M 320 500 L 450 500 M 550 500 L 680 500");
                diffAndSetAttribute(this._horizonZeroElement, "clip-path", "url(#hud-horizon-clip)");
                diffAndSetAttribute(this._waterLineElement, "visibility", "visible");
                diffAndSetAttribute(this._eBracketElement, "visibility", "hidden");
            }
            else {
                diffAndSetAttribute(this._horizonZeroElement, "d", "M0 500 L450 500 M550 500 L1000 500");
                diffAndSetAttribute(this._horizonZeroElement, "clip-path", "");
                diffAndSetAttribute(this._waterLineElement, "visibility", "visible");
                diffAndSetAttribute(this._eBracketElement, "visibility", "visible");
            }
        }
    }
    updateSituation(pitch, aoa, bank) {
        let vBodyX = SimVar.GetSimVarValue("VELOCITY BODY X", "feet per second");
        let vBodyY = SimVar.GetSimVarValue("VELOCITY BODY Y", "feet per second");
        let vBodyZ = SimVar.GetSimVarValue("VELOCITY BODY Z", "feet per second");
        let vVectorX = (vBodyX != 0) ? Math.atan(vBodyX / vBodyZ) * Avionics.Utils.RAD2DEG : 0;
        let vVectorY = (vBodyY != 0) ? Math.atan(vBodyY / vBodyZ) * Avionics.Utils.RAD2DEG : 0;
        let blink = false;
        if (SimVar.GetSimVarValue("SIM ON GROUND", "Bool") && Simplane.getGroundSpeed() < 50) {
            vVectorX = 0;
            vVectorY = pitch;
        }
        else {
            let minY = this.vVectorMinY + this.projectionOffset / FA18_DDI_HUD.YPERDEGREE;
            let maxY = this.vVectorMaxY + this.projectionOffset / FA18_DDI_HUD.YPERDEGREE;
            blink = (vVectorX < this.vVectorMinX || vVectorX > this.vVectorMaxX || vVectorY < minY || vVectorY > maxY);
            vVectorX = Utils.Clamp(vVectorX, this.vVectorMinX, this.vVectorMaxX);
            vVectorY = Utils.Clamp(vVectorY, minY, maxY);
        }
        diffAndSetAttribute(this._horizonContainerElement, "transform", "rotate(" + bank.toFixed(1) + " 500 " + (500 + this.projectionOffset) + ")");
        diffAndSetAttribute(this._waterLineElement, "transform", "translate(0, " + (this.projectionOffset - 200) + ")");
        if (this._cagedVelocityVector) {
            diffAndSetAttribute(this._velocityGroupElement, "transform", "translate(0," + (-vVectorY * FA18_DDI_HUD.YPERDEGREE + this.projectionOffset).toFixed(1) + ")");
            if (Math.abs(vVectorX) > 2) {
                diffAndSetAttribute(this._ghostVelocityElement, "transform", "translate(" + (vVectorX * 12.5).toFixed(0) + ", " + (-vVectorY * FA18_DDI_HUD.YPERDEGREE + this.projectionOffset).toFixed(1) + ")");
                diffAndSetAttribute(this._ghostVelocityElement, "visibility", "visible");
            }
            else {
                diffAndSetAttribute(this._ghostVelocityElement, "visibility", "hidden");
            }
            diffAndSetAttribute(this._ghostVelocityElement, "state", (blink) ? "blink" : "");
            diffAndSetAttribute(this._velocityGroupElement, "state", "");
        }
        else {
            diffAndSetAttribute(this._velocityGroupElement, "transform", "translate(" + (vVectorX * 12.5).toFixed(0) + ", " + (-vVectorY * FA18_DDI_HUD.YPERDEGREE + this.projectionOffset).toFixed(1) + ")");
            diffAndSetAttribute(this._velocityGroupElement, "state", (blink) ? "blink" : "");
            diffAndSetAttribute(this._ghostVelocityElement, "visibility", "hidden");
        }
        diffAndSetAttribute(this._horizonElement, "transform", "translate(0, " + (-pitch * FA18_DDI_HUD.YPERDEGREE + this.projectionOffset).toFixed(1) + ")");
        diffAndSetAttribute(this._horizonClipElement, "transform", "translate(0, " + (pitch * FA18_DDI_HUD.YPERDEGREE + -this.projectionOffset).toFixed(1) + ")");
        let aoaDiff = 0;
        if (aoa < 7.4)
            aoaDiff = aoa - 7.4;
        else if (aoa > 8.8)
            aoaDiff = aoa - 8.8;
        diffAndSetAttribute(this._eBracketElement, "transform", "translate(0, " + (aoaDiff * FA18_DDI_HUD.YPERDEGREE) + ")");
        if (Math.abs(bank) > 45) {
            diffAndSetAttribute(this._bankCursorElement, "transform", "rotate(" + (Math.sign(bank) * 45) + " 500 500)");
            diffAndSetAttribute(this._bankCursorElement, "state", "blink");
        }
        else {
            diffAndSetAttribute(this._bankCursorElement, "transform", "rotate(" + (bank).toFixed(1) + " 500 500)");
            diffAndSetAttribute(this._bankCursorElement, "state", "");
        }
    }
    computeSteeringTranslation(planeHeading, steeringBearing) {
        let steeringError = Avionics.Utils.diffAngle(planeHeading, steeringBearing);
        let translationBase = 0;
        if (Math.abs(steeringError) <= 5) {
            translationBase = steeringError;
        }
        else if (Math.abs(steeringError) > 30) {
            translationBase = 15 * Math.sign(steeringError);
        }
        else {
            translationBase = 0.4 * steeringError + (Math.sign(steeringError) * 3);
        }
        return translationBase * 12.5;
    }
    updateCselIndicator(planeHeading, steeringMode) {
        if (this.ddi.map.isCourseSteering) {
            let deviation;
            let obs;
            switch (steeringMode) {
                case FA18_DDI_Steering_Source.TACAN:
                    let cdi = SimVar.GetSimVarValue("TACAN STATION CDI:1", "number") / 127 * 10;
                    deviation = Utils.Clamp(cdi, -8, 8);
                    obs = SimVar.GetSimVarValue("TACAN OBS:1", "degrees");
                    break;
                case FA18_DDI_Steering_Source.ILST:
                    let ilstcdi = SimVar.GetSimVarValue("NAV CDI:" + this.ddi.ilstacanindex, "number") / 127 * 10;
                    deviation = Utils.Clamp(ilstcdi, -8, 8);
                    obs = SimVar.GetSimVarValue("NAV OBS:" + this.ddi.ilstacanindex, "degrees");
                    break;
                case FA18_DDI_Steering_Source.VOR:
                    let vorcdi = SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127 * 10;
                    deviation = Utils.Clamp(vorcdi, -8, 8);
                    obs = SimVar.GetSimVarValue("NAV OBS:" + this.ddi.navindex, "degrees");
                    break;
                case FA18_DDI_Steering_Source.ILSN:
                    let ilsncdi = SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127 * 10;
                    deviation = Utils.Clamp(ilsncdi, -8, 8);
                    obs = SimVar.GetSimVarValue("NAV OBS:" + this.ddi.navindex, "degrees");
                    break;
                case FA18_DDI_Steering_Source.WYPT:
                    deviation = Utils.Clamp(SimVar.GetSimVarValue("GPS WP CROSS TRK", "nautical mile"), -2, 2) / 2 * 8;
                    obs = SimVar.GetSimVarValue("GPS WP DESIRED TRACK", "degree");
                    break;
            }
            if (deviation != null && obs != null) {
                diffAndSetAttribute(this._cselGroupElement, "visibility", "visible");
                diffAndSetAttribute(this._cselDotsLeftGroupElement, "visibility", (deviation < -1.25) ? "visible" : "hidden");
                diffAndSetAttribute(this._cselDotsRightGroupElement, "visibility", (deviation > 1.25) ? "visible" : "hidden");
                diffAndSetAttribute(this._cselArrowElement, "transform", "translate(" + Utils.mapValue(deviation, -8, 8, -100, 100) + ", 0)");
                diffAndSetAttribute(this._cselGroupElement, "transform", "translate(500,500) rotate(" + (obs - planeHeading) + ")");
            }
            else {
                diffAndSetAttribute(this._cselGroupElement, "visibility", "hidden");
                diffAndSetAttribute(this._cselDotsLeftGroupElement, "visibility", "hidden");
                diffAndSetAttribute(this._cselDotsRightGroupElement, "visibility", "hidden");
            }
        }
        else {
            diffAndSetAttribute(this._cselGroupElement, "visibility", "hidden");
            diffAndSetAttribute(this._cselDotsLeftGroupElement, "visibility", "hidden");
            diffAndSetAttribute(this._cselDotsRightGroupElement, "visibility", "hidden");
        }
    }
    updateCoupledMode() {
        var _a, _b, _c;
        let isCoupled = SimVar.GetSimVarValue("L:FA18_IS_STEERING_COUPLED", "Bool");
        if (isCoupled != this.isCoupled) {
            if (this.isCoupled) {
                this.coupledTimer = 10;
            }
            else {
                switch (this.ddi.steeringSource) {
                    case FA18_DDI_Steering_Source.TACAN:
                        diffAndSetText(this._hudCplModeElement, "CPL TCN");
                        break;
                    case FA18_DDI_Steering_Source.ILST:
                        diffAndSetText(this._hudCplModeElement, "CPL ILST");
                        break;
                    case FA18_DDI_Steering_Source.VOR:
                        diffAndSetText(this._hudCplModeElement, "CPL VOR");
                        break;
                    case FA18_DDI_Steering_Source.ILSN:
                        diffAndSetText(this._hudCplModeElement, "CPL ILSN");
                        break;
                    case FA18_DDI_Steering_Source.WYPT:
                        diffAndSetText(this._hudCplModeElement, ((_a = this.ddi.waypointManager) === null || _a === void 0 ? void 0 : _a.autoSequentialSteeringActive) ? "CPL SEQ" + ((_c = (_b = this.ddi.waypointManager) === null || _b === void 0 ? void 0 : _b.currentSequence) === null || _c === void 0 ? void 0 : _c.id) : "CPL WYPT");
                        break;
                }
                this.coupledTimer = -1;
            }
            this.isCoupled = isCoupled;
        }
        if (this.isCoupled || this.coupledTimer > 0) {
            diffAndSetStyle(this._hudCplModeElement, StyleProperty.visibility, "visible");
        }
        else {
            diffAndSetStyle(this._hudCplModeElement, StyleProperty.visibility, "hidden");
        }
        diffAndSetAttribute(this._hudCplModeElement, "state", (this.coupledTimer > 0) ? "blink" : "");
    }
    updateSteeringInfos(planeHeading) {
        let displayed = false;
        let ident = "";
        let steeringTranslation = 0;
        let course = "";
        let showILS = false;
        let factor = 100;
        let ApOn = Simplane.getAutoPilotActive();
        let APtext = ApOn ? "A" : "";
        switch (this.ddi.steeringSource) {
            case FA18_DDI_Steering_Source.TACAN:
                if (this.ddi.tacanAvailable) {
                    let distance = SimVar.GetSimVarValue("TACAN STATION DISTANCE:1", "nautical mile");
                    let tacanIdentifier = SimVar.GetSimVarValue("TACAN STATION IDENT:1", "string");
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("TACAN STATION RADIAL:1", "degree") + 180);
                    ident = APtext + "TCN " + tacanIdentifier;
                    course = fastToFixed(bearing, 1) + "° / " + fastToFixed(distance, 1) + "NM"
                    steeringTranslation = this.computeSteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
            case FA18_DDI_Steering_Source.ILST:
                if (this.ddi.ilstacanAvailable) {
                    let distance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.ilstacanindex, "nautical mile");
                    let ilstacanIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.ilstacanindex, "string");
                    let ilstbearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.ilstacanindex, "degree") + 180);
                    ident = APtext + "ISLT " + ilstacanIdentifier;
                    course = fastToFixed(ilstbearing, 1) + "°/ " + fastToFixed(distance, 1) + "NM"
                    steeringTranslation = this.computeSteeringTranslation(planeHeading, ilstbearing);
                    displayed = true;
                    showILS = (this.ddi.ilstacanAvailable);
                    let cdidev = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.ilstacanindex, "number") / 127);
                    let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
                    if (backCourse) {
                        cdidev = -cdidev;
                    }
                    diffAndSetAttribute(this._cdideviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(cdidev), -1), 1) * factor) + ")");

                    if (SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.ddi.ilstacanindex, "Bool")) {
                        let gsidev = (SimVar.GetSimVarValue("NAV GSI:" + this.ddi.ilstacanindex, "number") / 127);
                        let y = (parseFloat(gsidev) * factor);
                        let x = 0;
                        diffAndSetAttribute(this._gsideviation, "transform", "translate(" + (x) + " " + fastToFixed(y, 0) + ")");
                    }
                }
                break;
            case FA18_DDI_Steering_Source.VOR:
                if (this.ddi.navAvailable) {
                    let vorBearing = Avionics.Utils.clampAngle(this.ddi.getCrsValue());
                    let distance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.navindex, "nautical mile");
                    let vorIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.navindex, "string");
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180);
                    ident = APtext + "NAV" + this.ddi.navindex + " " + vorIdentifier;
                    course = fastToFixed(vorBearing, 1) + "°/ " + fastToFixed(distance, 1) + "NM";
                    steeringTranslation = this.computeSteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
            case FA18_DDI_Steering_Source.ILSN:
                if (this.ddi.ilsnavAvailable) {
                    let ilsBearing = Avionics.Utils.clampAngle(this.ddi.getCrsValue());
                    let distance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.navindex, "nautical mile");
                    let ilsIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.navindex, "string");
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180);
                    ident = APtext + "ILSN" + this.ddi.navindex + " " + ilsIdentifier;
                    course = fastToFixed(ilsBearing, 1) + "°/ " + fastToFixed(distance, 1) + "NM";
                    steeringTranslation = this.computeSteeringTranslation(planeHeading, bearing);
                    displayed = true;
                    showILS = (this.ddi.ilsnavAvailable);

                    let cdidev = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127);
                    let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
                    if (backCourse) {
                        cdidev = -cdidev;
                    }
                    diffAndSetAttribute(this._cdideviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(cdidev), -1), 1) * factor) + ")");

                    if (SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.ddi.navindex, "Bool")) {
                        let gsidev = (SimVar.GetSimVarValue("NAV GSI:" + this.ddi.navindex, "number") / 127);
                        let y = (parseFloat(gsidev) * factor);
                        let x = 0;
                        diffAndSetAttribute(this._gsideviation, "transform", "translate(" + (x) + " " + fastToFixed(y, 0) + ")");
                    }
                }
                break;
            case FA18_DDI_Steering_Source.WYPT:
                if (this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentWaypoint) {
                    let distance = this.ddi.flightPlanManager.getDistanceToWaypoint(this.ddi.waypointManager.currentWaypoint);
                    let bearing = this.ddi.flightPlanManager.getBearingToWaypoint(this.ddi.waypointManager.currentWaypoint, true);
                    ident = APtext + "WP" + this.ddi.waypointManager.currentWaypointNumber;
                    course = fastToFixed(bearing, 1) + "°/" + fastToFixed(distance, 1) + "NM";
                    steeringTranslation = this.computeSteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
        }
        diffAndSetText(this._hudSteeringDataElement, ident);
        diffAndSetText(this._hudSteeringCrsElement, course);
        diffAndSetAttribute(this._headingSteeringBugElement, "transform", "translate(" + fastToFixed(steeringTranslation, 1) + ", 0)");
        diffAndSetStyle(this._hudSteeringDataElement, StyleProperty.visibility, ((this.clutterLevel != 2) && displayed) ? "visible" : "hidden");
        diffAndSetStyle(this._hudSteeringCrsElement, StyleProperty.visibility, ((this.clutterLevel != 2) && displayed) ? "visible" : "hidden");
        diffAndSetAttribute(this._headingSteeringBugElement, "visibility", ((this.clutterLevel != 2) && displayed) ? "visible" : "hidden");
        diffAndSetStyle(this._cdigroup, StyleProperty.visibility, (showILS) ? "visible" : "hidden");
        diffAndSetStyle(this._gsigroup, StyleProperty.visibility, (showILS) ? "visible" : "hidden");
        this.updateCselIndicator(planeHeading, this.ddi.steeringSource);
        this.updateCoupledMode();
    }
    updateProjection(_deltaTime) {
        this.projectionOffset = FA18_DDI_HUD.PROJECTION_OFFSET;
    }
}
FA18_DDI_HUD.YPERDEGREE = 48;
FA18_DDI_HUD.PROJECTION_OFFSET = -200;
customElements.define("fa18-ddi-hud", FA18_DDI_HUD);
//# sourceMappingURL=FA18_DDI_HUD.js.map