class FA18_DDI_HSIndicator extends HTMLElement {
    constructor() {
        super(...arguments);
        this.fontSize = 7;
        this.refStartX = 0;
        this.refWidth = 0;
        this.isCoupled = false;
        this.coupledTimer = -1;
    }
    connectedCallback() {
        this.construct();
    }
    setInstrument(instrument) {
        this.ddi = instrument;
    }
    construct() {
        let posX = 0;
        let posY = 0;
        let width = 200;
        let height = 200;
        this.rootSVG = document.createElementNS(Avionics.SVG.NS, "svg");
        diffAndSetAttribute(this.rootSVG, "id", "ViewBox");
        diffAndSetAttribute(this.rootSVG, "viewBox", "0 0 " + width + " " + height);
        {
            let circleRadius = 75;
            this.rotatingCompass = document.createElementNS(Avionics.SVG.NS, "g");
            diffAndSetAttribute(this.rotatingCompass, "id", "Circle");
            this.rootSVG.appendChild(this.rotatingCompass);
            {
                this.rotatingCompassX = posX + width * 0.5;
                this.rotatingCompassY = posY + height * 0.5;
                let graduationsGroup = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(graduationsGroup, "id", "Graduations");
                this.rotatingCompass.appendChild(graduationsGroup);
                {
                    let angle = 0;
                    for (let i = 0; i < 36; i++) {
                        let isPrimary = (i % 3 == 0) ? true : false;
                        let length = 1;
                        if (isPrimary) {
                            let text = document.createElementNS(Avionics.SVG.NS, "text");
                            let textContent = "";
                            if (i === 0) {
                                textContent = "N";
                            }
                            else if (i === 9) {
                                textContent = "E";
                            }
                            else if (i === 18) {
                                textContent = "S";
                            }
                            else if (i === 27) {
                                textContent = "W";
                            }
                            else {
                                textContent = (angle / 10) + '';
                            }
                            diffAndSetText(text, textContent);
                            diffAndSetAttribute(text, "x", this.rotatingCompassX + '');
                            diffAndSetAttribute(text, "y", (this.rotatingCompassY - circleRadius) + '');
                            diffAndSetAttribute(text, "fill", "lime");
                            diffAndSetAttribute(text, "font-size", this.fontSize + '');
                            diffAndSetAttribute(text, "font-family", "Arial, Helvetica, sans-serif");
                            diffAndSetAttribute(text, "text-anchor", "middle");
                            diffAndSetAttribute(text, "alignment-baseline", "central");
                            diffAndSetAttribute(text, "transform", "rotate(" + angle + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
                            graduationsGroup.appendChild(text);
                        }
                        else {
                            let dot = document.createElementNS(Avionics.SVG.NS, "line");
                            diffAndSetAttribute(dot, "x1", this.rotatingCompassX + '');
                            diffAndSetAttribute(dot, "y1", (this.rotatingCompassY - circleRadius) + '');
                            diffAndSetAttribute(dot, "x2", this.rotatingCompassX + '');
                            diffAndSetAttribute(dot, "y2", (this.rotatingCompassY - circleRadius + length) + '');
                            diffAndSetAttribute(dot, "stroke", "lime");
                            diffAndSetAttribute(dot, "stroke-width", "1");
                            diffAndSetAttribute(dot, "transform", "rotate(" + angle + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
                            graduationsGroup.appendChild(dot);
                        }
                        angle += 360 / 36;
                    }
                }
            }
            this.magneticHeadingGroup = document.createElementNS(Avionics.SVG.NS, "g");
            diffAndSetAttribute(this.magneticHeadingGroup, "id", "magneticHeadingGroup");
            this.rootSVG.appendChild(this.magneticHeadingGroup);
            {
                this.magneticHeadingBug = document.createElementNS(Avionics.SVG.NS, "rect");
                diffAndSetAttribute(this.magneticHeadingBug, "x", this.rotatingCompassX.toFixed(0));
                diffAndSetAttribute(this.magneticHeadingBug, "y", (this.rotatingCompassY - circleRadius - 10).toFixed(0));
                diffAndSetAttribute(this.magneticHeadingBug, "width", "0.7");
                diffAndSetAttribute(this.magneticHeadingBug, "height", "15");
                diffAndSetAttribute(this.magneticHeadingBug, "fill", "lime");
                diffAndSetAttribute(this.magneticHeadingBug, "id", "magneticHeadingBug");
                this.magneticHeadingGroup.appendChild(this.magneticHeadingBug);
            }
            {
                this.currentTrackIndicator = document.createElementNS(Avionics.SVG.NS, "path");
                diffAndSetAttribute(this.currentTrackIndicator, "id", "CurrentTrack");
                let x = this.rotatingCompassX;
                let y = this.rotatingCompassY - circleRadius + 15;
                diffAndSetAttribute(this.currentTrackIndicator, "d", "M " + x + " " + y + " l -3 -3, l 3 -3, l 3 3, l -3 3, v8 Z");
                diffAndSetAttribute(this.currentTrackIndicator, "fill", "none");
                diffAndSetAttribute(this.currentTrackIndicator, "stroke", "lime");
                diffAndSetAttribute(this.currentTrackIndicator, "stroke-width", "0.7");
                this.rootSVG.appendChild(this.currentTrackIndicator);
            }
            this.selectedHeadingGroup = document.createElementNS(Avionics.SVG.NS, "g");
            diffAndSetAttribute(this.selectedHeadingGroup, "id", "selectedHeadingGroup");
            {
                let selectedHeadingMarkerBox = document.createElementNS(Avionics.SVG.NS, "rect");
                diffAndSetAttribute(selectedHeadingMarkerBox, "x", (this.rotatingCompassX - 5).toFixed(0));
                diffAndSetAttribute(selectedHeadingMarkerBox, "y", (this.rotatingCompassY - circleRadius - 7.5).toFixed(0));
                diffAndSetAttribute(selectedHeadingMarkerBox, "width", "10");
                diffAndSetAttribute(selectedHeadingMarkerBox, "height", "3");
                diffAndSetAttribute(selectedHeadingMarkerBox, "fill", "none");
                diffAndSetAttribute(selectedHeadingMarkerBox, "stroke", "lime");
                diffAndSetAttribute(selectedHeadingMarkerBox, "stroke-width", "1");
                this.selectedHeadingGroup.appendChild(selectedHeadingMarkerBox);
                let selectedHeadingMarkerCenter = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(selectedHeadingMarkerCenter, "x1", (this.rotatingCompassX).toFixed(0));
                diffAndSetAttribute(selectedHeadingMarkerCenter, "y1", (this.rotatingCompassY - circleRadius - 7.5).toFixed(0));
                diffAndSetAttribute(selectedHeadingMarkerCenter, "x2", (this.rotatingCompassX).toFixed(0));
                diffAndSetAttribute(selectedHeadingMarkerCenter, "y2", (this.rotatingCompassY - circleRadius - 7.5 + 3).toFixed(0));
                diffAndSetAttribute(selectedHeadingMarkerCenter, "stroke", "lime");
                diffAndSetAttribute(selectedHeadingMarkerCenter, "stroke-width", "2");
                this.selectedHeadingGroup.appendChild(selectedHeadingMarkerCenter);
            }
            this.rootSVG.appendChild(this.selectedHeadingGroup);
            {
                let selectedHeadingReadout = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(selectedHeadingReadout, "id", "selectedHeadingReadout");
                {
                    let x = posX + 15;
                    let y = posY + height - 150;
                    this.selectedHeadingMode = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.selectedHeadingMode, "HDG");
                    diffAndSetAttribute(this.selectedHeadingMode, "x", (x) + '');
                    diffAndSetAttribute(this.selectedHeadingMode, "y", (y) + '');
                    diffAndSetAttribute(this.selectedHeadingMode, "fill", "lime");
                    diffAndSetAttribute(this.selectedHeadingMode, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.selectedHeadingMode, "text-anchor", "start");
                    selectedHeadingReadout.appendChild(this.selectedHeadingMode);
                    this.selectedHeadingValue = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetAttribute(this.selectedHeadingValue, "x", (x) + '');
                    diffAndSetAttribute(this.selectedHeadingValue, "y", (y + 7) + '');
                    diffAndSetAttribute(this.selectedHeadingValue, "fill", "lime");
                    diffAndSetAttribute(this.selectedHeadingValue, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.selectedHeadingValue, "text-anchor", "start");
                    selectedHeadingReadout.appendChild(this.selectedHeadingValue);
                }
                this.rootSVG.appendChild(selectedHeadingReadout);
            }
            {
                this.selectedCourseReadout = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(this.selectedCourseReadout, "id", "selectedCourseReadout");
                {
                    let x = width - 15;
                    let y = posY + height - 150;
                    let selectedCourseLabel = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(selectedCourseLabel, "CRS");
                    diffAndSetAttribute(selectedCourseLabel, "x", (x) + '');
                    diffAndSetAttribute(selectedCourseLabel, "y", (y) + '');
                    diffAndSetAttribute(selectedCourseLabel, "fill", "lime");
                    diffAndSetAttribute(selectedCourseLabel, "font-size", this.fontSize + '');
                    diffAndSetAttribute(selectedCourseLabel, "text-anchor", "end");
                    this.selectedCourseReadout.appendChild(selectedCourseLabel);
                    this.selectedCourseValue = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetAttribute(this.selectedCourseValue, "x", (x) + '');
                    diffAndSetAttribute(this.selectedCourseValue, "y", (y + 7) + '');
                    diffAndSetAttribute(this.selectedCourseValue, "fill", "lime");
                    diffAndSetAttribute(this.selectedCourseValue, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.selectedCourseValue, "text-anchor", "end");
                    this.selectedCourseReadout.appendChild(this.selectedCourseValue);
                }
                this.rootSVG.appendChild(this.selectedCourseReadout);
            }
            {
                this.trueAirspeedIndicator = document.createElementNS(Avionics.SVG.NS, "text");
                diffAndSetAttribute(this.trueAirspeedIndicator, "id", "trueAirSpeedIndicator");
                diffAndSetAttribute(this.trueAirspeedIndicator, "x", (this.rotatingCompassX - 10).toFixed(0));
                diffAndSetAttribute(this.trueAirspeedIndicator, "y", (this.rotatingCompassY + 8).toFixed(0));
                diffAndSetAttribute(this.trueAirspeedIndicator, "fill", "lime");
                diffAndSetAttribute(this.trueAirspeedIndicator, "font-size", this.fontSize + '');
                diffAndSetAttribute(this.trueAirspeedIndicator, "text-anchor", "end");
                diffAndSetText(this.trueAirspeedIndicator, "000T");
                this.rootSVG.appendChild(this.trueAirspeedIndicator);
            }
            {
                this.groundSpeedIndicator = document.createElementNS(Avionics.SVG.NS, "text");
                diffAndSetAttribute(this.groundSpeedIndicator, "id", "groundSpeedIndicator");
                diffAndSetAttribute(this.groundSpeedIndicator, "x", (this.rotatingCompassX + 10).toFixed(0));
                diffAndSetAttribute(this.groundSpeedIndicator, "y", (this.rotatingCompassY + 8).toFixed(0));
                diffAndSetAttribute(this.groundSpeedIndicator, "fill", "lime");
                diffAndSetAttribute(this.groundSpeedIndicator, "font-size", this.fontSize + '');
                diffAndSetAttribute(this.groundSpeedIndicator, "text-anchor", "start");
                diffAndSetText(this.groundSpeedIndicator, "000G");
                this.rootSVG.appendChild(this.groundSpeedIndicator);
            }
            {
                this.coupledModeIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(this.coupledModeIndicator, "id", "coupledModeIndicator");
                let coupledModeText = document.createElementNS(Avionics.SVG.NS, "text");
                diffAndSetAttribute(coupledModeText, "id", "coupledModeLeftText");
                diffAndSetAttribute(coupledModeText, "x", (this.rotatingCompassX - 5).toFixed(0));
                diffAndSetAttribute(coupledModeText, "y", (this.rotatingCompassY - 5).toFixed(0));
                diffAndSetAttribute(coupledModeText, "fill", "lime");
                diffAndSetAttribute(coupledModeText, "font-size", this.fontSize + '');
                diffAndSetAttribute(coupledModeText, "text-anchor", "end");
                diffAndSetText(coupledModeText, "CPL");
                this.coupledModeIndicator.appendChild(coupledModeText);
                this.coupledModeValue = document.createElementNS(Avionics.SVG.NS, "text");
                diffAndSetAttribute(this.coupledModeValue, "id", "coupledModeValue");
                diffAndSetAttribute(this.coupledModeValue, "x", (this.rotatingCompassX + 5).toFixed(0));
                diffAndSetAttribute(this.coupledModeValue, "y", (this.rotatingCompassY - 5).toFixed(0));
                diffAndSetAttribute(this.coupledModeValue, "fill", "lime");
                diffAndSetAttribute(this.coupledModeValue, "font-size", this.fontSize + '');
                diffAndSetAttribute(this.coupledModeValue, "text-anchor", "start");
                diffAndSetText(this.coupledModeValue, "TCN");
                this.coupledModeIndicator.appendChild(this.coupledModeValue);
                this.rootSVG.appendChild(this.coupledModeIndicator);
            }
            {
                this.currentWaypointIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(this.currentWaypointIndicator, "id", "currentWaypointIndicator");
                {
                    let toIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                    diffAndSetAttribute(toIndicator, "id", "currentWaypointToIndicator");
                    let x = this.rotatingCompassX;
                    let y = this.rotatingCompassY - circleRadius + 2.5;
                    let triangle = document.createElementNS(Avionics.SVG.NS, "path");
                    diffAndSetAttribute(triangle, "d", "M " + x + " " + y + " l -4 7 h 8 Z");
                    diffAndSetAttribute(triangle, "stroke", "lime");
                    diffAndSetAttribute(triangle, "stroke-width", "1");
                    diffAndSetAttribute(triangle, "fill", "none");
                    toIndicator.appendChild(triangle);
                    let circle = document.createElementNS(Avionics.SVG.NS, "circle");
                    diffAndSetAttribute(circle, "cx", x + '');
                    diffAndSetAttribute(circle, "cy", (y + 4.5) + '');
                    diffAndSetAttribute(circle, "r", 2 + '');
                    diffAndSetAttribute(circle, "stroke", "lime");
                    diffAndSetAttribute(circle, "stroke-width", "1");
                    diffAndSetAttribute(circle, "fill", "none");
                    toIndicator.appendChild(circle);
                    this.currentWaypointIndicator.appendChild(toIndicator);
                }
                {
                    let fromIndicator = document.createElementNS(Avionics.SVG.NS, "rect");
                    diffAndSetAttribute(fromIndicator, "id", "currentWaypointFromIndicator");
                    diffAndSetAttribute(fromIndicator, "width", "2.5");
                    diffAndSetAttribute(fromIndicator, "height", "10");
                    diffAndSetAttribute(fromIndicator, "x", (this.rotatingCompassX - 1.25) + '');
                    diffAndSetAttribute(fromIndicator, "y", (this.rotatingCompassY + circleRadius - 13) + '');
                    diffAndSetAttribute(fromIndicator, "fill", "none");
                    diffAndSetAttribute(fromIndicator, "stroke", "lime");
                    diffAndSetAttribute(fromIndicator, "stroke-width", "1");
                    this.currentWaypointIndicator.appendChild(fromIndicator);
                }
                diffAndSetAttribute(this.currentWaypointIndicator, "visibility", "hidden");
                this.rootSVG.appendChild(this.currentWaypointIndicator);
            }
            {
                this.currentTacanIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                this.currentTacanIndicator.setAttribute("id", "currentTacanIndicator");
                {
                    let toIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                    toIndicator.setAttribute("id", "currentTacanToIndicator");
                    let x = this.rotatingCompassX;
                    let y = this.rotatingCompassY - circleRadius + 2.5;
                    let triangle = document.createElementNS(Avionics.SVG.NS, "path");
                    triangle.setAttribute("d", "M " + x + " " + y + " l -4 7 h 8 Z");
                    triangle.setAttribute("stroke", "lime");
                    triangle.setAttribute("stroke-width", "1");
                    triangle.setAttribute("fill", "none");
                    toIndicator.appendChild(triangle);
                    let horizontalShape = document.createElementNS(Avionics.SVG.NS, "path");
                    horizontalShape.setAttribute("d", "M " + (x - 2) + " " + (y + 5.5) + " h 4");
                    horizontalShape.setAttribute("stroke", "lime");
                    horizontalShape.setAttribute("stroke-width", "1");
                    horizontalShape.setAttribute("fill", "none");
                    toIndicator.appendChild(horizontalShape);
                    let verticalShape = document.createElementNS(Avionics.SVG.NS, "path");
                    verticalShape.setAttribute("d", "M " + x + " " + (y + 1) + " v 5");
                    verticalShape.setAttribute("stroke", "lime");
                    verticalShape.setAttribute("stroke-width", "1");
                    verticalShape.setAttribute("fill", "none");
                    toIndicator.appendChild(verticalShape);
                    let vertline = document.createElementNS(Avionics.SVG.NS, "rect");
                    vertline.setAttribute("width", "2.5");
                    vertline.setAttribute("height", "22");
                    vertline.setAttribute("x", (this.rotatingCompassX - 1.25) + '');
                    vertline.setAttribute("y", (this.rotatingCompassY + circleRadius - 141) + '');
                    vertline.setAttribute("fill", "lime");
                    toIndicator.appendChild(vertline);
                    this.currentTacanIndicator.appendChild(toIndicator);
                }
                {
                    let fromIndicator = document.createElementNS(Avionics.SVG.NS, "rect");
                    fromIndicator.setAttribute("id", "currentTacanFromIndicator");
                    fromIndicator.setAttribute("width", "2.5");
                    fromIndicator.setAttribute("height", "29");
                    fromIndicator.setAttribute("x", (this.rotatingCompassX - 1.25) + '');
                    fromIndicator.setAttribute("y", (this.rotatingCompassY + circleRadius - 31) + '');
                    fromIndicator.setAttribute("fill", "lime");
                    this.currentTacanIndicator.appendChild(fromIndicator);
                    let circlePosition = [-30, -15, 15, 30];
                    for (let i = 0; i < circlePosition.length; i++) {
                        let CDICircle = document.createElementNS(Avionics.SVG.NS, "circle");
                        diffAndSetAttribute(CDICircle, "cx", (100 + circlePosition[i]) + '');
                        diffAndSetAttribute(CDICircle, "cy", "100");
                        diffAndSetAttribute(CDICircle, "r", "2");
                        diffAndSetAttribute(CDICircle, "stroke", "lime");
                        diffAndSetAttribute(CDICircle, "stroke-width", "0.5");
                        this.currentTacanIndicator.appendChild(CDICircle);
                    }
                }
                {
                    this.tacancourseDeviation = document.createElementNS(Avionics.SVG.NS, "rect");
                    this.tacancourseDeviation.setAttribute("id", "currentTacandeviation");
                    this.tacancourseDeviation.setAttribute("width", "2.5");
                    this.tacancourseDeviation.setAttribute("height", "88");
                    this.tacancourseDeviation.setAttribute("x", (this.rotatingCompassX - 1.25) + '');
                    this.tacancourseDeviation.setAttribute("y", (this.rotatingCompassY + circleRadius - 119) + '');
                    this.tacancourseDeviation.setAttribute("fill", "lime");
                    this.currentTacanIndicator.appendChild(this.tacancourseDeviation);
                }
                diffAndSetAttribute(this.currentTacanIndicator, "visibility", "hidden");
                this.rootSVG.appendChild(this.currentTacanIndicator);
            }

            {
                this.currentNavIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                this.currentNavIndicator.setAttribute("id", "currentNavIndicator");
                {
                    let toIndicator = document.createElementNS(Avionics.SVG.NS, "g");
                    toIndicator.setAttribute("id", "currentNavToIndicator");
                    let x = this.rotatingCompassX;
                    let y = this.rotatingCompassY - circleRadius + 2.5;
                    let triangle = document.createElementNS(Avionics.SVG.NS, "path");
                    triangle.setAttribute("d", "M " + x + " " + y + " l -4 7 h 8 Z");
                    triangle.setAttribute("stroke", "lime");
                    triangle.setAttribute("stroke-width", "1");
                    triangle.setAttribute("fill", "none");
                    toIndicator.appendChild(triangle);
                    let horizontalShape = document.createElementNS(Avionics.SVG.NS, "path");
                    horizontalShape.setAttribute("d", "M " + (x - 2) + " " + (y + 5.5) + " h 4");
                    horizontalShape.setAttribute("stroke", "lime");
                    horizontalShape.setAttribute("stroke-width", "1");
                    horizontalShape.setAttribute("fill", "none");
                    toIndicator.appendChild(horizontalShape);
                    let verticalShape = document.createElementNS(Avionics.SVG.NS, "path");
                    verticalShape.setAttribute("d", "M " + x + " " + (y + 1) + " v 5");
                    verticalShape.setAttribute("stroke", "lime");
                    verticalShape.setAttribute("stroke-width", "1");
                    verticalShape.setAttribute("fill", "none");
                    toIndicator.appendChild(verticalShape);
                    let vertline = document.createElementNS(Avionics.SVG.NS, "rect");
                    vertline.setAttribute("width", "2.5");
                    vertline.setAttribute("height", "22");
                    vertline.setAttribute("x", (this.rotatingCompassX - 1.25) + '');
                    vertline.setAttribute("y", (this.rotatingCompassY + circleRadius - 141) + '');
                    vertline.setAttribute("fill", "lime");
                    toIndicator.appendChild(vertline);
                    this.currentNavIndicator.appendChild(toIndicator);
                }
                {
                    let fromIndicator = document.createElementNS(Avionics.SVG.NS, "rect");
                    fromIndicator.setAttribute("id", "currentNavFromIndicator");
                    fromIndicator.setAttribute("width", "2.5");
                    fromIndicator.setAttribute("height", "29");
                    fromIndicator.setAttribute("x", (this.rotatingCompassX - 1.25) + '');
                    fromIndicator.setAttribute("y", (this.rotatingCompassY + circleRadius - 31) + '');
                    fromIndicator.setAttribute("fill", "lime");
                    this.currentNavIndicator.appendChild(fromIndicator);
                    let circlePosition = [-30, -15, 15, 30];
                    for (let i = 0; i < circlePosition.length; i++) {
                        let CDICircle = document.createElementNS(Avionics.SVG.NS, "circle");
                        diffAndSetAttribute(CDICircle, "cx", (100 + circlePosition[i]) + '');
                        diffAndSetAttribute(CDICircle, "cy", "100");
                        diffAndSetAttribute(CDICircle, "r", "2");
                        diffAndSetAttribute(CDICircle, "stroke", "lime");
                        diffAndSetAttribute(CDICircle, "stroke-width", "0.5");
                        this.currentNavIndicator.appendChild(CDICircle);
                    }
                }
                {
                    this.navcourseDeviation = document.createElementNS(Avionics.SVG.NS, "rect");
                    this.navcourseDeviation.setAttribute("id", "currentNavdeviation");
                    this.navcourseDeviation.setAttribute("width", "2.5");
                    this.navcourseDeviation.setAttribute("height", "88");
                    this.navcourseDeviation.setAttribute("x", (this.rotatingCompassX - 1.25) + '');
                    this.navcourseDeviation.setAttribute("y", (this.rotatingCompassY + circleRadius - 119) + '');
                    this.navcourseDeviation.setAttribute("fill", "lime");
                    this.currentNavIndicator.appendChild(this.navcourseDeviation);
                }
                diffAndSetAttribute(this.currentNavIndicator, "visibility", "hidden");
                this.rootSVG.appendChild(this.currentNavIndicator);
            }


            {
                this.tacanGroup = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(this.tacanGroup, "id", "tacanInformation");
                {
                    let x = posX + 20;
                    let y = posY + 25;
                    this.tacanBearingDistance = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.tacanBearingDistance, "");
                    diffAndSetAttribute(this.tacanBearingDistance, "x", (x) + '');
                    diffAndSetAttribute(this.tacanBearingDistance, "y", (y) + '');
                    diffAndSetAttribute(this.tacanBearingDistance, "fill", "lime");
                    diffAndSetAttribute(this.tacanBearingDistance, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.tacanBearingDistance, "text-anchor", "start");
                    this.tacanGroup.appendChild(this.tacanBearingDistance);
                    this.tacanETE = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.tacanETE, "");
                    diffAndSetAttribute(this.tacanETE, "x", (x) + '');
                    diffAndSetAttribute(this.tacanETE, "y", (y + 7) + '');
                    diffAndSetAttribute(this.tacanETE, "fill", "lime");
                    diffAndSetAttribute(this.tacanETE, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.tacanETE, "text-anchor", "start");
                    this.tacanGroup.appendChild(this.tacanETE);
                    this.tacanIdentifier = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.tacanIdentifier, "");
                    diffAndSetAttribute(this.tacanIdentifier, "x", (x) + '');
                    diffAndSetAttribute(this.tacanIdentifier, "y", (y + 14) + '');
                    diffAndSetAttribute(this.tacanIdentifier, "fill", "lime");
                    diffAndSetAttribute(this.tacanIdentifier, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.tacanIdentifier, "text-anchor", "start");
                    this.tacanGroup.appendChild(this.tacanIdentifier);
                }
                diffAndSetAttribute(this.tacanGroup, "visibility", "hidden");
                this.rootSVG.appendChild(this.tacanGroup);
            }
            {
                this.navGroup = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(this.navGroup, "id", "navInformation");
                {
                    let x = posX + 20;
                    let y = posY + height - 35;
                    this.navBearingDistance = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.navBearingDistance, "");
                    diffAndSetAttribute(this.navBearingDistance, "x", (x) + '');
                    diffAndSetAttribute(this.navBearingDistance, "y", (y + 14) + '');
                    diffAndSetAttribute(this.navBearingDistance, "fill", "lime");
                    diffAndSetAttribute(this.navBearingDistance, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.navBearingDistance, "text-anchor", "start");
                    this.navGroup.appendChild(this.navBearingDistance);
                    this.navETE = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.navETE, "");
                    diffAndSetAttribute(this.navETE, "x", (x) + '');
                    diffAndSetAttribute(this.navETE, "y", (y + 7) + '');
                    diffAndSetAttribute(this.navETE, "fill", "lime");
                    diffAndSetAttribute(this.navETE, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.navETE, "text-anchor", "start");
                    this.navGroup.appendChild(this.navETE);
                    this.navIdentifier = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.navIdentifier, "");
                    diffAndSetAttribute(this.navIdentifier, "x", (x) + '');
                    diffAndSetAttribute(this.navIdentifier, "y", (y) + '');
                    diffAndSetAttribute(this.navIdentifier, "fill", "lime");
                    diffAndSetAttribute(this.navIdentifier, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.navIdentifier, "text-anchor", "start");
                    this.navGroup.appendChild(this.navIdentifier);
                }
                diffAndSetAttribute(this.navGroup, "visibility", "hidden");
                this.rootSVG.appendChild(this.navGroup);
            }
            {
                this.waypointGroup = document.createElementNS(Avionics.SVG.NS, "g");
                diffAndSetAttribute(this.waypointGroup, "id", "waypointInformation");
                {
                    let x = width - 20;
                    let y = posY + 25;
                    this.waypointBearingDistance = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.waypointBearingDistance, "---° / --.-");
                    diffAndSetAttribute(this.waypointBearingDistance, "x", (x) + '');
                    diffAndSetAttribute(this.waypointBearingDistance, "y", (y) + '');
                    diffAndSetAttribute(this.waypointBearingDistance, "fill", "lime");
                    diffAndSetAttribute(this.waypointBearingDistance, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.waypointBearingDistance, "text-anchor", "end");
                    this.waypointGroup.appendChild(this.waypointBearingDistance);
                    this.waypointETE = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.waypointETE, "-:--");
                    diffAndSetAttribute(this.waypointETE, "x", (x) + '');
                    diffAndSetAttribute(this.waypointETE, "y", (y + 7) + '');
                    diffAndSetAttribute(this.waypointETE, "fill", "lime");
                    diffAndSetAttribute(this.waypointETE, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.waypointETE, "text-anchor", "end");
                    this.waypointGroup.appendChild(this.waypointETE);
					this.waypointIdentifier = document.createElementNS(Avionics.SVG.NS, "text");
                    diffAndSetText(this.waypointIdentifier, "");
                    diffAndSetAttribute(this.waypointIdentifier, "x", (x) + '');
                    diffAndSetAttribute(this.waypointIdentifier, "y", (y + 14) + '');
                    diffAndSetAttribute(this.waypointIdentifier, "fill", "lime");
                    diffAndSetAttribute(this.waypointIdentifier, "font-size", this.fontSize + '');
                    diffAndSetAttribute(this.waypointIdentifier, "text-anchor", "end");
                    this.waypointGroup.appendChild(this.waypointIdentifier);
                }
                diffAndSetAttribute(this.waypointGroup, "visibility", "hidden");
                this.rootSVG.appendChild(this.waypointGroup);
            }
            {
                this.adfBearingSymbol = document.createElementNS(Avionics.SVG.NS, "g");
                this.adfBearingSymbol.setAttribute("id", "ADFBearingSymbol");
                {
                    let x = this.rotatingCompassX;
                    let y = this.rotatingCompassY - circleRadius - 9;
                    let circle = document.createElementNS(Avionics.SVG.NS, "circle");
                    diffAndSetAttribute(circle, "cx", x + '');
                    diffAndSetAttribute(circle, "cy", (y + 4.5) + '');
                    diffAndSetAttribute(circle, "r", 3.5 + '');
                    diffAndSetAttribute(circle, "stroke", "lime");
                    diffAndSetAttribute(circle, "stroke-width", "1");
                    diffAndSetAttribute(circle, "fill", "none");
                    this.adfBearingSymbol.appendChild(circle);
                }
                diffAndSetAttribute(this.adfBearingSymbol, "visibility", "hidden");
                this.rootSVG.appendChild(this.adfBearingSymbol);
            }
        }
        this.appendChild(this.rootSVG);
    }
    update(deltaTime) {
        var _a, _b, _c;
        let compass = SimVar.GetSimVarValue("PLANE HEADING DEGREES MAGNETIC", "Degree");
        let heading = compass;
        let track = SimVar.GetSimVarValue("GPS GROUND MAGNETIC TRACK", "degree");
        let groundSpeed = SimVar.GetSimVarValue("GPS GROUND SPEED", "knots");
        let isNorthUp = SimVar.GetSimVarValue("L:FA18_DDI_HSI_NORTH_UP", "Bool");
        if (isNorthUp)
            compass = 0;
        diffAndSetAttribute(this.rotatingCompass, "transform", "rotate(" + (-compass) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
        {
            let delta = compass - heading;
            diffAndSetAttribute(this.magneticHeadingGroup, "transform", "rotate(" + (-delta) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
        }
        {
            if (groundSpeed <= 10)
                track = compass;
            let delta = compass - track;
            diffAndSetAttribute(this.currentTrackIndicator, "transform", "rotate(" + (-delta) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
        }
        {
            let hselValue = Simplane.getAutoPilotSelectedHeadingLockValue(false);
            let delta = compass - hselValue;
            diffAndSetAttribute(this.selectedHeadingGroup, "transform", "rotate(" + (-delta) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
            diffAndSetText(this.selectedHeadingValue, Utils.leadingZeros(hselValue, 3, 0) + Avionics.Utils.DEGREE_SYMBOL);
        }
        {
            let crs = this.ddi.getCrsValue();
            diffAndSetStyle(this.selectedCourseReadout, "visibility", "visible");
            diffAndSetText(this.selectedCourseValue, Utils.leadingZeros(crs, 3, 0) + Avionics.Utils.DEGREE_SYMBOL);
        }
        diffAndSetText(this.trueAirspeedIndicator, Utils.leadingZeros(Simplane.getTrueSpeed(), 3, 0) + "T");
        diffAndSetText(this.groundSpeedIndicator, Utils.leadingZeros(groundSpeed, 3, 0) + "G");
        let adfDataSource = SimVar.GetSimVarValue("ADF SIGNAL:1", "number") || SimVar.GetSimVarValue("ADF SIGNAL:2", "number");
		let adfindex = 1;
		if (SimVar.GetSimVarValue("ADF SIGNAL:1", "number") != 0) { adfindex = 1; }
		else if (SimVar.GetSimVarValue("ADF SIGNAL:2", "number") != 0) { adfindex = 2; }
        if (adfDataSource != 0) {
            let adfbearing = SimVar.GetSimVarValue("ADF RADIAL MAG:" + adfindex, "degree");
            if (adfbearing >= -180) {
                adfbearing = Avionics.Utils.clampAngle(adfbearing + 180);
                let delta = compass - adfbearing;
                diffAndSetAttribute(this.adfBearingSymbol, "transform", "rotate(" + (-delta) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
                diffAndSetAttribute(this.adfBearingSymbol, "visibility", "visible");
            }
            else
                diffAndSetAttribute(this.adfBearingSymbol, "visibility", "hidden");
        }
        else {
            diffAndSetAttribute(this.adfBearingSymbol, "visibility", "hidden");
        }
        if (this.ddi.navAvailable || this.ddi.ilsnavAvailable) {
			let GSavailable = this.ddi.ilsnavAvailable || this.ddi.ilstacanAvailable ? "(ILS) " :  "(NAV) ";
            let navBearing = Avionics.Utils.clampAngle(this.ddi.getCrsValue());
            let navDistance = SimVar.GetSimVarValue("NAV DME:" + this.ddi.navindex, "nautical mile");
            let navIdentifier = SimVar.GetSimVarValue("NAV IDENT:" + this.ddi.navindex, "string");
            diffAndSetAttribute(this.navGroup, "visibility", "visible");
            let ete = Avionics.Utils.computeETEinSeconds(navDistance);
            if (ete == null) {
                diffAndSetText(this.navETE, "--:--:--");
            }
            else {
                diffAndSetText(this.navETE, Utils.SecondsToDisplayDuration(Math.min(ete, (9 * 3600 - 1)), true, true));
            }
            diffAndSetText(this.navBearingDistance, fastToFixed(navBearing, 1) + "°/ " + fastToFixed(navDistance, 1));
            diffAndSetText(this.navIdentifier, GSavailable + navIdentifier);
            diffAndSetAttribute(this.currentNavIndicator, "visibility", "visible");
            let deltanav = compass - navBearing;
            diffAndSetAttribute(this.currentNavIndicator, "transform", "rotate(" + (-deltanav) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
            let factor = 30;
            let navdeviation = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127);
            let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
            if (backCourse)
                navdeviation = -navdeviation;
            diffAndSetAttribute(this.navcourseDeviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(navdeviation), -1), 1) * factor) + ")");
        }
        else {
            diffAndSetAttribute(this.navGroup, "visibility", "hidden");
            diffAndSetAttribute(this.currentNavIndicator, "visibility", "hidden");
        }
        if (this.ddi.tacanAvailable || this.ddi.ilstacanAvailable) {
            let tacanBearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("TACAN STATION RADIAL:1", "degree") + 180);
            let tacanDistance = SimVar.GetSimVarValue("TACAN STATION DISTANCE:1", "nautical mile");
            let tacanIdentifier = "(TCN) "+ SimVar.GetSimVarValue("TACAN STATION IDENT:1", "string");
            diffAndSetAttribute(this.tacanGroup, "visibility", "visible");
            let ete = Avionics.Utils.computeETEinSeconds(tacanDistance);
            if (ete == null) {
                diffAndSetText(this.tacanETE, "--:--:--");
            }
            else {
                diffAndSetText(this.tacanETE, Utils.SecondsToDisplayDuration(Math.min(ete, (9 * 3600 - 1)), true, true));
            }
            diffAndSetText(this.tacanBearingDistance, fastToFixed(tacanBearing, 1) + "°" + (SimVar.GetSimVarValue("L:Glasscockpit_TACAN_Mode", "number") == 1 ? ("/ " + fastToFixed(tacanDistance, 1)) : ""));
            diffAndSetText(this.tacanIdentifier, tacanIdentifier);
            diffAndSetAttribute(this.currentTacanIndicator, "visibility", "visible");
            let delta = compass - tacanBearing;
            diffAndSetAttribute(this.currentTacanIndicator, "transform", "rotate(" + (-delta) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
            let factor = 30;
            let deviation = (SimVar.GetSimVarValue("TACAN STATION CDI:1", "number") / 127);
            let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
            if (backCourse)
                deviation = -deviation;
            diffAndSetAttribute(this.tacancourseDeviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(deviation), -1), 1) * factor) + ")");
            if (this.ddi.navAvailable || this.ddi.ilsnavAvailable || this.ddi.ilstacanAvailable) {
                diffAndSetAttribute(this.currentTacanIndicator, "visibility", "hidden");
            }
        }
        else {
            diffAndSetAttribute(this.tacanGroup, "visibility", "hidden");
            diffAndSetAttribute(this.currentTacanIndicator, "visibility", "hidden");
        }
        if (this.ddi && this.ddi.waypointManager.initialized) {
            let currentWaypoint = this.ddi.waypointManager.currentWaypoint;
            if (currentWaypoint) {
                diffAndSetAttribute(this.currentWaypointIndicator, "visibility", "visible");
                let delta = compass - this.ddi.flightPlanManager.getBearingToWaypoint(currentWaypoint, true);
                diffAndSetAttribute(this.currentWaypointIndicator, "transform", "rotate(" + (-delta) + " " + this.rotatingCompassX + " " + this.rotatingCompassY + ")");
            }
            else {
                diffAndSetAttribute(this.currentWaypointIndicator, "visibility", "hidden");
            }
            if (currentWaypoint) {
                diffAndSetAttribute(this.waypointGroup, "visibility", "visible");
				let waypointIdent = "WP" + this.ddi.waypointManager.currentWaypointNumber;
                let waypointDistance = this.ddi.flightPlanManager.getDistanceToWaypoint(currentWaypoint);
                let waypointBearing = this.ddi.flightPlanManager.getBearingToWaypoint(currentWaypoint, true);
                let ete = Avionics.Utils.computeETEinSeconds(waypointDistance);
                if (ete == null) {
                    diffAndSetText(this.waypointETE, "--:--:--");
                }
                else {
                    diffAndSetText(this.waypointETE, Utils.SecondsToDisplayDuration(Math.min(ete, (9 * 3600 - 1)), true, true));
                }
                waypointDistance = fastToFixed(waypointDistance, 1);
                waypointBearing = fastToFixed(waypointBearing, 1);
                diffAndSetText(this.waypointBearingDistance, waypointBearing + "°/" + waypointDistance);
				diffAndSetText(this.waypointIdentifier, waypointIdent);
            }
            else {
                diffAndSetAttribute(this.waypointGroup, "visibility", "hidden");
            }
        }
        let isCoupled = SimVar.GetSimVarValue("L:FA18_IS_STEERING_COUPLED", "Bool");
        if (isCoupled != this.isCoupled) {
            if (this.isCoupled) {
                this.coupledTimer = 10;
            }
            else {
                switch (this.ddi.steeringSource) {
                    case FA18_DDI_Steering_Source.TACAN:
                        diffAndSetText(this.coupledModeValue, "TCN");
                        break;
                    case FA18_DDI_Steering_Source.VOR:
                        diffAndSetText(this.coupledModeValue, "VOR");
                        break;
                    case FA18_DDI_Steering_Source.ILST:
                        diffAndSetText(this.coupledModeValue, "ILST");
                        break;
                    case FA18_DDI_Steering_Source.ILSN:
                        diffAndSetText(this.coupledModeValue, "ILSN");
                        break;
                    case FA18_DDI_Steering_Source.WYPT:
                        diffAndSetText(this.coupledModeValue, ((_a = this.ddi.waypointManager) === null || _a === void 0 ? void 0 : _a.autoSequentialSteeringActive) ? "SEQ" + ((_c = (_b = this.ddi.waypointManager) === null || _b === void 0 ? void 0 : _b.currentSequence) === null || _c === void 0 ? void 0 : _c.id) : "WYPT");
                        break;
                }
                this.coupledTimer = -1;
            }
            this.isCoupled = isCoupled;
        }
        let blinkOn = false;
        if (this.coupledTimer > 0) {
            this.coupledTimer -= (deltaTime / 1000);
            blinkOn = ((this.coupledTimer % 1) > 0.5);
        }
        if (this.isCoupled || blinkOn) {
            diffAndSetAttribute(this.coupledModeIndicator, "visibility", "visible");
        }
        else {
            diffAndSetAttribute(this.coupledModeIndicator, "visibility", "hidden");
        }
        diffAndSetText(this.selectedHeadingMode, (Simplane.getAutoPilotTRKModeActive() || Simplane.getAutoPilotTRKFPAModeActive()) ? "TRK" : "HDG");
    }
}
customElements.define("fa18-ddi-hs-indicator", FA18_DDI_HSIndicator);
//# sourceMappingURL=FA18_DDI_HSIndicator.js.map