class FA18_DDI_HSI extends FA18_DDI_Page {
    constructor() {
        super(...arguments);
        this.isModeMenuActive = false;
        this.modeMenuTimer = -1;
    }
    init(ddi) {
        super.init(ddi);
        this.ddi.map.init(this);
        SimVar.SetSimVarValue("L:FA18_DDI_HSI_BING_MAP_SHOWN", "Bool", true);
        this._hsi = this.ddi.getChildById("Compass");
        this._hsi.setInstrument(this.ddi);
        this.scaleValue = this.ddi.getChildById("HsiScaleButton");
        diffAndSetText(this.scaleValue, "RNG/" + this.ddi.map.getDisplayRange());
        this.currentWaypointNumberValue = this.ddi.getChildById("HsiCurrentWaypointIndex");
        this.sequenceNumber = this.ddi.getChildById("HsiSequenceNumber");
        this.label1 = this.getElementsByClassName("sk-label-1")[0];
        this.label2 = this.getElementsByClassName("sk-label-2")[0];
        this.label3 = this.getElementsByClassName("sk-label-3")[0];
        this.label4 = this.getElementsByClassName("sk-label-4")[0];
        this.label5 = this.getElementsByClassName("sk-label-5")[0];
        this.label11 = this.getElementsByClassName("sk-label-11")[0];
        this.label16 = this.getElementsByClassName("sk-label-16")[0];
		this.label19 = this.getElementsByClassName("sk-label-19")[0];
        this.updateWaypointIndex();
        this.updateSequenceNumber();
    }
    show() {
        super.show();
        for (let i of [6, 9, 10, 14, 16, 17, 20]) {
            this.ddi.setPageButton(i, FA18_DDI_Page_Type.NotImplemented);
        }
		 this.ddi.onButtonPressed[7] = () => {
			if (this.isMaster){
				this.ddi.waypointManager.init();
			}
        };
        this.ddi.onButtonPressed[8] = () => {
            this.ddi.map.decZoom();
            diffAndSetText(this.scaleValue, "RNG/" + this.ddi.map.getDisplayRange());
        };
        this.ddi.onButtonPressed[11] = () => {
            if (this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentWaypoint) {
                this.ddi.toggleSteeringSource(FA18_DDI_Steering_Source.WYPT);
            }
        };
        this.ddi.onButtonPressed[12] = () => {
            this.ddi.waypointManager.nextWaypoint();
        };
        this.ddi.onButtonPressed[13] = () => {
            this.ddi.waypointManager.previousWaypoint();
        };
        this.ddi.onButtonPressed[15] = () => {
            this.ddi.waypointManager.toggleSequences();
        };
        this.ddi.onButtonPressed[16] = () => {
            this.ddi.waypointManager.toggleAutoSequencialSteering();
        };
        this.ddi.setPageButton(18, FA18_DDI_Page_Type.MenuTactical);
        this.switchToRootMenu();
    }
    switchToRootMenu() {
        this.isModeMenuActive = false;
        diffAndSetText(this.label1, "I L S N");
        diffAndSetText(this.label2, "N A V");
        diffAndSetText(this.label3, "M O D E");
        diffAndSetText(this.label4, "I L S T");
        diffAndSetText(this.label5, "T C N");
        this.ddi.onButtonPressed[3] = () => {
            this.switchToModeMenu();
        };
		this.ddi.onButtonPressed[1] = () => {
            if (this.ddi.ilsnavAvailable)
                this.ddi.toggleSteeringSource(FA18_DDI_Steering_Source.ILSN);
        };
        this.ddi.onButtonPressed[2] = () => {
            if (this.ddi.navAvailable)
                this.ddi.toggleSteeringSource(FA18_DDI_Steering_Source.VOR);
        };
		this.ddi.onButtonPressed[4] = () => {
            if (this.ddi.ilstacanAvailable)
                this.ddi.toggleSteeringSource(FA18_DDI_Steering_Source.ILST);
        };
        this.ddi.onButtonPressed[5] = () => {
            if (this.ddi.tacanAvailable)
                this.ddi.toggleSteeringSource(FA18_DDI_Steering_Source.TACAN);
        };
    }
    switchToModeMenu() {
        this.isModeMenuActive = true;
        this.modeMenuTimer = 10;
        diffAndSetText(this.label1, "S L E W");
        diffAndSetText(this.label2, "D C T R");
        diffAndSetText(this.label3, "M A P");
        diffAndSetText(this.label4, "N U P");
        diffAndSetText(this.label5, "T U P");
        this.ddi.onButtonPressed[3] = () => {
            SimVar.SetSimVarValue("L:FA18_DDI_HSI_BING_MAP_SHOWN", "Bool", !SimVar.GetSimVarValue("L:FA18_DDI_HSI_BING_MAP_SHOWN", "number"));
            this.modeMenuTimer = 10;
        };
        this.ddi.onButtonPressed[4] = () => {
            SimVar.SetSimVarValue("L:FA18_DDI_HSI_NORTH_UP", "Bool", true);
            this.modeMenuTimer = 10;
        };
        this.ddi.onButtonPressed[5] = () => {
            SimVar.SetSimVarValue("L:FA18_DDI_HSI_NORTH_UP", "Bool", false);
            this.modeMenuTimer = 10;
        };
    }
    update(deltaTime) {
		var groundtrackOn = SimVar.GetSimVarValue("L:XMLVAR_TRK_FPA_MODE_ACTIVE", "bool");
        super.update(deltaTime);
        if (this.modeMenuTimer > 0) {
            this.modeMenuTimer -= (deltaTime / 1000);
        }
        else {
            if (this.isModeMenuActive)
                this.switchToRootMenu();
        }
        let bingMapShown = SimVar.GetSimVarValue("L:FA18_DDI_HSI_BING_MAP_SHOWN", "Bool");
        if (bingMapShown) {
            this.ddi.map.showBingMap();
        }
        else {
            this.ddi.map.hideBingMap();
        }
        this.ddi.map.instrument.rotateWithPlane(!SimVar.GetSimVarValue("L:FA18_DDI_HSI_NORTH_UP", "Bool"));
        if (this.label3)
            this.label3.classList.toggle("sk-label-highlight", (this.isModeMenuActive && bingMapShown));
        if (this.label5)
            this.label5.classList.toggle("sk-label-highlight", (!this.isModeMenuActive && this.ddi.tacanAvailable && this.ddi.steeringSource === FA18_DDI_Steering_Source.TACAN));
		if (this.label4)
            this.label4.classList.toggle("sk-label-highlight", (!this.isModeMenuActive && this.ddi.ilstacanAvailable && this.ddi.steeringSource === FA18_DDI_Steering_Source.ILST));
		if (this.label1)
            this.label1.classList.toggle("sk-label-highlight", (!this.isModeMenuActive && this.ddi.ilsnavAvailable && this.ddi.steeringSource === FA18_DDI_Steering_Source.ILSN));
		if (this.label2)
            this.label2.classList.toggle("sk-label-highlight", (!this.isModeMenuActive && this.ddi.navAvailable && this.ddi.steeringSource === FA18_DDI_Steering_Source.VOR));
        if (this.label11)
            this.label11.classList.toggle("sk-label-highlight", this.ddi.steeringSource === FA18_DDI_Steering_Source.WYPT);
        if (this.label16)
            this.label16.classList.toggle("sk-label-highlight", this.ddi.waypointManager.autoSequentialSteeringActive);
		if (this.label19)
            this.label19.classList.toggle("sk-label-highlight", groundtrackOn);
        this.updateSequenceNumber();
        this.updateWaypointIndex();
        if (this._hsi) {
            this._hsi.update(deltaTime);
        }
    }
    updateWaypointIndex() {
        if (this.currentWaypointNumberValue) {
            diffAndSetText(this.currentWaypointNumberValue, this.ddi.waypointManager.currentWaypointNumber + '');
        }
        if (this.ddi.map) {
            if (this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentSequence && this.ddi.waypointManager.currentSequence.selected) {
                if (!this.ddi.map.isFlightPlanShown) {
                    // this.ddi.map.showFlightPlan();
				}
            }
            else {
                if (this.ddi.map.isFlightPlanShown) {
                    // this.ddi.map.hideFlightPlan();
				}
            }
            this.ddi.map.shownWaypointIndex = this.ddi.waypointManager.currentWaypointFlightPlanIndex;
        }
    }
    updateSequenceNumber() {
        if (this.sequenceNumber && this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentSequence) {
            diffAndSetText(this.sequenceNumber, "S E Q " + this.ddi.waypointManager.currentSequence.id);
            if (this.ddi.waypointManager.currentSequence.selected)
                this.sequenceNumber.classList.add("sk-label-highlight");
            else
                this.sequenceNumber.classList.remove("sk-label-highlight");
        }
    }
	get isMaster() { return this.ddi.isMaster; }
}
//# sourceMappingURL=FA18_DDI_HSI.js.map