class FA18_DDI_HMD extends FA18_DDI_Page {
    constructor() {
        super(...arguments);
        this.brightnessMode = 0;
        this.clutterLevel = 0;
    }
    get templateID() { return "FA18_DDI_HMD"; }
    init(ddi) {
        super.init(ddi);
        this.clutterLevelElement = this.ddi.getChildById("hmd-clutter-level");
        this.brightnessElement = this.ddi.getChildById("hmd-brightness");
        this.clutterLevel = SimVar.GetSimVarValue("L:XMLVAR_AS04F_HMD_Symbology_Reject", "number");
        this.brightnessMode = SimVar.GetSimVarValue("L:XMLVAR_AS04F_HMD_BrightnessMode", "number");
        this.updateClutterLevel();
        this.updateBrightnessMode();
    }
    show() {
        super.show();
        for (let i of [1, 3, 12, 17, 19, 20]) {
            this.ddi.setPageButton(i, FA18_DDI_Page_Type.NotImplemented);
        }
        this.ddi.onButtonPressed[7] = () => {
            this.clutterLevel = (this.clutterLevel + 1) % 3;
            this.updateClutterLevel();
            SimVar.SetSimVarValue("L:XMLVAR_AS04F_HMD_Symbology_Reject", "number", this.clutterLevel);
            this.ddi.triggerEventToMultipleInstruments([...this.ddi.slavesInstances, this.ddi.masterInstance, "AS04F_HMD"], "HMD_Clutter_Level_Updated", this.clutterLevel + '');
        };
        this.ddi.onButtonPressed[11] = () => {
            this.brightnessMode = (this.brightnessMode + 1) % 3;
            this.updateBrightnessMode();
            SimVar.SetSimVarValue("L:XMLVAR_AS04F_HMD_BrightnessMode", "number", this.brightnessMode);
            this.ddi.triggerEventToMultipleInstruments([...this.ddi.slavesInstances, this.ddi.masterInstance, "AS04F_HMD"], "HMD_Brightness_Mode_Updated", this.brightnessMode + '');
        };
        this.ddi.setPageButton(18, FA18_DDI_Page_Type.MenuTactical);
    }
    onEvent(_event, _args) {
        switch (_event) {
            case "Brightness_Mode_Updated":
                if (_args.length > 0) {
                    this.brightnessMode = parseInt(_args[0]);
                    this.updateBrightnessMode();
                }
                break;
            case "Clutter_Level_Updated":
                if (_args.length > 0) {
                    this.clutterLevel = parseInt(_args[0]);
                    this.updateClutterLevel();
                }
                break;
        }
    }
    updateClutterLevel() {
        if (this.clutterLevel == 1) {
            diffAndSetText(this.clutterLevelElement, "REJ1");
        }
        else if (this.clutterLevel == 2) {
            diffAndSetText(this.clutterLevelElement, "REJ2");
        }
        else {
            diffAndSetText(this.clutterLevelElement, "NORM");
        }
    }
    updateBrightnessMode() {
        if (this.brightnessMode == 1) {
            diffAndSetText(this.brightnessElement, "D A Y");
        }
        else if (this.brightnessMode == 2) {
            diffAndSetText(this.brightnessElement, "N I G H T");
        }
        else {
            diffAndSetText(this.brightnessElement, "A U T O");
        }
    }
    update(deltaTime) {
        super.update(deltaTime);
    }
}
customElements.define("fa18-ddi-hmd", FA18_DDI_HMD);
//# sourceMappingURL=FA18_DDI_HMD.js.map