class FA18_DDI_Fuel extends FA18_DDI_Page {
    get templateID() { return "FA18_DDI_Fuel"; }
    init(ddi) {
        super.init(ddi);
		        this.bingo = SimVar.GetSimVarValue("L:FRIES_Fuel_Bingo", "number");
        if (this.bingo == 0) {
            this.bingo = 4.5;
            SimVar.SetSimVarValue("L:FRIES_Fuel_Bingo", "number", this.bingo);
        }
        this._totalValueElement = document.body.querySelector(".fuel-total-value");
        this._internalValueElement = document.body.querySelector(".fuel-internal-value");
        this._tank1ValueElement = document.body.querySelector(".fuel-tk1-value-box span");
        this._tank2ValueElement = document.body.querySelector(".fuel-lfd-value-box span");
        this._tank3ValueElement = document.body.querySelector(".fuel-rfd-value-box span");
        // this._tank4ValueElement = document.body.querySelector(".fuel-tk4-value-box span");
        this._tank1PointerElement = document.body.querySelector(".fuel-tk1-pointer");
        this._tank1PointerElement.style.left = "660px";
        this._tank2PointerElement = document.body.querySelector(".fuel-lfd-pointer");
        this._tank2PointerElement.style.left = "660px";
        this._tank3PointerElement = document.body.querySelector(".fuel-rfd-pointer");
        this._tank3PointerElement.style.left = "660px";
        // this._tank4PointerElement = document.body.querySelector(".fuel-tk4-pointer");
        // this._tank4PointerElement.style.left = "660px";
        this._tankLeftWingValueElement = document.body.querySelector(".fuel-lwg-value-box span");
        this._tankRightWingValueElement = document.body.querySelector(".fuel-rwg-value-box span");
        this._tankLeftWingPointerElement = document.body.querySelector(".fuel-lwg-pointer");
        this._tankLeftWingPointerElement.style.left = "233px";
        this._tankRightWingPointerElement = document.body.querySelector(".fuel-rwg-pointer");
        this._tankRightWingPointerElement.style.left = "899px";
        this._bingoValue = document.body.querySelector(".fuel-bingo-value");
		this._tankLeftEXTValueElement = document.body.querySelector(".fuel-lext-value-box span");
		this._tankRightEXTValueElement = document.body.querySelector(".fuel-rext-value-box span");
		this._tankCenterEXTValueElement = document.body.querySelector(".fuel-cext-value-box span");
		this._tankLeftCFTValueElement = document.body.querySelector(".fuel-lcft-value-box span");
		this._tankRightCFTValueElement = document.body.querySelector(".fuel-rcft-value-box span");

    }
    show() {
        super.show();
        this.ddi.setPageButton(18, FA18_DDI_Page_Type.MenuTactical);
        this.ddi.setPageButton(20, FA18_DDI_Page_Type.NotImplemented);
    }
    update(deltaTime) {
        super.update(deltaTime);
        let gallonToPounds = SimVar.GetSimVarValue("FUEL WEIGHT PER GALLON", "lbs");
        diffAndSetText(this._totalValueElement, (SimVar.GetSimVarValue("FUEL TOTAL CAPACITY", "gallons") * gallonToPounds).toFixed(0).padStart(3, "0"));
        diffAndSetText(this._internalValueElement, (SimVar.GetSimVarValue("FUEL TOTAL QUANTITY", "gallons") * gallonToPounds).toFixed(0).padStart(3, "0"));
        let tank1Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:1", "gallons");
        let tank2Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:3", "gallons");
        let tank3Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:2", "gallons");
        let tank1Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:1", "gallons");
        let tank2Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:3", "gallons");
        let tank3Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:2", "gallons");
        diffAndSetText(this._tank1ValueElement, (tank1Value * gallonToPounds).toFixed(0).padStart(3, "0"));
        diffAndSetText(this._tank2ValueElement, (tank2Value * gallonToPounds).toFixed(0).padStart(3, "0"));
        diffAndSetText(this._tank3ValueElement, (tank3Value * gallonToPounds).toFixed(0).padStart(3, "0"));
        this._tank1PointerElement.style.top = (27 + (1 - tank1Value / tank1Capacity) * 153).toFixed(0) + "px";
        this._tank3PointerElement.style.top = (217 + (1 - tank3Value / tank3Capacity) * 93).toFixed(0) + "px";
        this._tank2PointerElement.style.top = (346 + (1 - tank2Value / tank2Capacity) * 93).toFixed(0) + "px";
        let tank4Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:4", "gallons");
        let tank5Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:5", "gallons");
		let tank6Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:6", "gallons");
		let tank7Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:7", "gallons");
		let tank8Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:8", "gallons");
		let tank9Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:9", "gallons");
		let tank10Capacity = SimVar.GetSimVarValue("FUELSYSTEM TANK CAPACITY:10", "gallons");
        let tank4Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:4", "gallons");
        let tank5Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:5", "gallons");
		let tank6Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:6", "gallons");
		let tank7Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:7", "gallons");
		let tank8Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:8", "gallons");
		let tank9Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:9", "gallons");
		let tank10Value = SimVar.GetSimVarValue("FUELSYSTEM TANK TOTAL QUANTITY:10", "gallons");
        diffAndSetText(this._tankLeftWingValueElement, (tank4Value * gallonToPounds).toFixed(0).padStart(3, "0"));
        diffAndSetText(this._tankRightWingValueElement, (tank5Value * gallonToPounds).toFixed(0).padStart(3, "0"));
		diffAndSetText(this._tankLeftEXTValueElement, (tank6Value * gallonToPounds).toFixed(0).padStart(3, "0"));
		diffAndSetText(this._tankRightEXTValueElement, (tank7Value * gallonToPounds).toFixed(0).padStart(3, "0"));
		diffAndSetText(this._tankCenterEXTValueElement, (tank8Value * gallonToPounds).toFixed(0).padStart(3, "0"));
		if (tank9Capacity == 0 && tank10Capacity == 0) {
					diffAndSetText(this._tankLeftCFTValueElement, "---");
					diffAndSetText(this._tankRightCFTValueElement, "---");
		}
		else{
					diffAndSetText(this._tankLeftCFTValueElement, (tank9Value * gallonToPounds).toFixed(0).padStart(3, "0"));
		diffAndSetText(this._tankRightCFTValueElement, (tank10Value * gallonToPounds).toFixed(0).padStart(3, "0"));
		}
        this._tankLeftWingPointerElement.style.top = (343 + (1 - tank4Value / tank4Capacity) * 98).toFixed(0) + "px";
        this._tankRightWingPointerElement.style.top = (343 + (1 - tank5Value / tank5Capacity) * 98).toFixed(0) + "px";
        diffAndSetText(this._bingoValue, '' + (SimVar.GetSimVarValue("L:FRIES_Fuel_Bingo", "number") * 1000).toFixed(0));
    }
}
customElements.define("fa18-ddi-fuel", FA18_DDI_Fuel);
//# sourceMappingURL=FA18_DDI_Fuel.js.map