class FA18_DDI_ADI extends FA18_DDI_Page {
    get templateID() { return "FA18_DDI_ADI"; }
    init(ddi) {
        super.init(ddi);
        this._adi_AirspeedElement = this.ddi.getChildById("adi-airspeed");
        this._adi_VerticalSpeedElement = this.ddi.getChildById("adi-vertical-speed");
        this._adi_AltitudeElement = this.ddi.getChildById("adi-altitude");
        this._adi_horizonClipElement = this.ddi.getChildById("circleClip");
        this._adi_horizonElement = this.ddi.getChildById("adi-horizon-group");
        this._adi_horizonContainerElement = this.ddi.getChildById("adi-horizon-container-group");
        this._adi_turnRateElement = this.ddi.getChildById("adi-turn-rate-box");
		this._adi_gsigroup = this.ddi.getChildById("adi-gsi-container-group");
		this._adi_cdigroup = this.ddi.getChildById("adi-cdi-container-group");
		this._adi_gsideviation = this.ddi.getChildById("adi-gs-deviation");
		this._adi_cdideviation = this.ddi.getChildById("adi-crs-deviation"); 
		this._adi_aoavalue = this.ddi.getChildById("adi-alpha-value");
		this._adi_slipAngleElement = this.ddi.getChildById("adi-slip-rate-box");
		this._adi_headingElement = this.ddi.getChildById("adi-heading-tape-group");
        this._adi_headingClipElement = this.ddi.getChildById("adi-heading-clip");
        this._adi_headingSteeringBugElement = this.ddi.getChildById("adi-heading-steering-bug");
            for (let i = -3; i < 39; i++) {
                let text = document.createElementNS(Avionics.SVG.NS, "text");
                let s = ((i + 36) % 36).toFixed(0) + "0";
                let Xspacing = 125;
                let yBottom = 145;
                s = s.padStart(3, "0");
                diffAndSetText(text, s);
                diffAndSetAttribute(text, "x", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(text, "y", (yBottom - 25) + "");
                diffAndSetAttribute(text, "font-size", "40");
                diffAndSetAttribute(text, "font-weight", "regular");
                diffAndSetAttribute(text, "text-anchor", "middle");
                diffAndSetAttribute(text, "fill", "lime");
                diffAndSetAttribute(text, "clip-path", "url(#adi-heading-clip)");
                this._adi_headingElement.appendChild(text);
                let lineL = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(lineL, "x1", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(lineL, "y1", (yBottom - 20) + '');
                diffAndSetAttribute(lineL, "x2", (500 + i * Xspacing).toFixed(0));
                diffAndSetAttribute(lineL, "y2", (yBottom) + '');
                diffAndSetAttribute(lineL, "stroke", "lime");
                diffAndSetAttribute(lineL, "stroke-width", "4");
                diffAndSetAttribute(lineL, "clip-path", "url(#adi-heading-clip)");
                this._adi_headingElement.appendChild(lineL);
                let lineS = document.createElementNS(Avionics.SVG.NS, "line");
                diffAndSetAttribute(lineS, "x1", (500 + i * Xspacing + Xspacing / 2).toFixed(0));
                diffAndSetAttribute(lineS, "y1", (yBottom - 10) + '');
                diffAndSetAttribute(lineS, "x2", (500 + i * Xspacing + Xspacing / 2).toFixed(0));
                diffAndSetAttribute(lineS, "y2", (yBottom) + '');
                diffAndSetAttribute(lineS, "stroke", "lime");
                diffAndSetAttribute(lineS, "stroke-width", "4");
                diffAndSetAttribute(lineS, "clip-path", "url(#adi-heading-clip)");
                this._adi_headingElement.appendChild(lineS);
            }
        for (let i = 0; i < 200; i++) {
            let rect = document.createElementNS(Avionics.SVG.NS, "rect");
            diffAndSetAttribute(rect, "x", "0");
            diffAndSetAttribute(rect, "y", (500 + 15 * i).toFixed(1));
            diffAndSetAttribute(rect, "width", "1000");
            diffAndSetAttribute(rect, "height", "2");
            diffAndSetAttribute(rect, "fill", "lime");
            diffAndSetAttribute(rect, "clip-path", "url(#circleClip)");
            this._adi_horizonElement.appendChild(rect);
        }
        for (let i = -17; i < 18; i++) {
            let text = document.createElementNS(Avionics.SVG.NS, "text");
            let s = "";
            if (Math.abs(i) < 9) {
                s = Math.abs(i).toFixed(0) + "  0";
            }
            else if (i > 9) {
                s = Math.abs(18 - i).toFixed(0) + "  0";
            }
            else if (i < -9) {
                s = Math.abs(18 + i).toFixed(0) + "  0";
            }
            if (s != "") {
                diffAndSetText(text, s);
                diffAndSetAttribute(text, "x", "500");
                diffAndSetAttribute(text, "y", (500 - i * 500 / 3 + 18).toFixed(0));
                diffAndSetAttribute(text, "font-size", "72");
                diffAndSetAttribute(text, "text-anchor", "middle");
                diffAndSetAttribute(text, "fill", "lime");
                diffAndSetAttribute(text, "clip-path", "url(#circleClip)");
                this._adi_horizonElement.appendChild(text);
            }
            else {
                let circle = document.createElementNS(Avionics.SVG.NS, "circle");
                diffAndSetAttribute(circle, "cx", "500");
                diffAndSetAttribute(circle, "cy", (500 - i * 500 / 3).toFixed(0));
                diffAndSetAttribute(circle, "r", "30");
                diffAndSetAttribute(circle, "stroke", "lime");
                diffAndSetAttribute(circle, "stroke-width", "5");
                diffAndSetAttribute(circle, "clip-path", "url(#circleClip)");
                this._adi_horizonElement.appendChild(circle);
            }
            let line = document.createElementNS(Avionics.SVG.NS, "line");
            diffAndSetAttribute(line, "x1", "493");
            diffAndSetAttribute(line, "y1", (500 - (i + 0.5) * 500 / 3).toFixed(0));
            diffAndSetAttribute(line, "x2", "507");
            diffAndSetAttribute(line, "y2", (500 - (i + 0.5) * 500 / 3).toFixed(0));
            diffAndSetAttribute(line, "stroke", "lime");
            diffAndSetAttribute(line, "stroke-width", "4");
            diffAndSetAttribute(line, "clip-path", "url(#circleClip)");
            this._adi_horizonElement.appendChild(line);
        }
    }
    show() {
        super.show();
        for (let i of [16, 20]) {
            this.ddi.setPageButton(i, FA18_DDI_Page_Type.NotImplemented);
        }
        this.ddi.setPageButton(18, FA18_DDI_Page_Type.MenuTactical);
    }
    update(deltaTime) {
        super.update(deltaTime);
        let bank = Simplane.getBank();
        let pitch = Simplane.getPitch();
		let aoa = Simplane.getAngleOfAttack("degree");
		let beta = SimVar.GetSimVarValue("INCIDENCE BETA", "degrees") ;
		diffAndSetText(this._adi_aoavalue, aoa.toFixed(1));
		let heading = Simplane.getHeadingMagnetic();
        let airspeed = Simplane.getIndicatedSpeed();
        let verticalSpeed = Simplane.getVerticalSpeed();
        let altitude = Simplane.getAltitude();
        const formatedAltitude = Avionics.Utils.computeThousandsAltitude(altitude);
        let turnRate = Simplane.getTurnRate() / Math.PI * 180;
        diffAndSetText(this._adi_AirspeedElement, airspeed.toFixed(0));
        diffAndSetText(this._adi_VerticalSpeedElement, verticalSpeed.toFixed(0));
        diffAndSetText(this._adi_AltitudeElement, altitude.toFixed(0));
        let a = bank;
        let y = -pitch / 60 * 1000;
        diffAndSetAttribute(this._adi_horizonElement, "transform", "translate(0, " + y.toFixed(1) + ")");
        diffAndSetAttribute(this._adi_horizonContainerElement, "transform", "rotate(" + a.toFixed(1) + " 500 500)");
        diffAndSetAttribute(this._adi_horizonClipElement, "transform", "translate(0, " + (-y).toFixed(1) + ")");
        if (this._adi_turnRateElement)
            diffAndSetAttribute(this._adi_turnRateElement, "transform", "translate(" + (Math.min(Math.max(parseFloat(turnRate / 24), -1), 1) * 200) + ")");
		 if (this._adi_slipAngleElement)
            diffAndSetAttribute(this._adi_slipAngleElement, "transform", "translate(" + (Math.min(Math.max(parseFloat(beta / 10), -1), 1) * 100) + ")");
        this.update_adi_SteeringInfos(heading);

        diffAndSetAttribute(this._adi_headingElement, "transform", "translate(" + (-heading * 12.5) + ", 0)");
        diffAndSetAttribute(this._adi_headingClipElement, "transform", "translate(" + (heading * 12.5) + ", 0)");
    }		
    compute_adi_SteeringTranslation(planeHeading, steeringBearing) {
        let steeringError = Avionics.Utils.diffAngle(planeHeading, steeringBearing);
        let translationBase = 0;
        if (Math.abs(steeringError) <= 5) {
            translationBase = steeringError;
        }
        else if (Math.abs(steeringError) > 30) {
            translationBase = 15 * Math.sign(steeringError);
        }
        else {
            translationBase = 0.4 * steeringError + (Math.sign(steeringError) * 3);
        }
        return translationBase * 12.5;
    }	
    update_adi_SteeringInfos(planeHeading) {
        let displayed = false;
        let ident = "";
        let steeringTranslation = 0;
		let course = "";
		let showILS = false;
		let factor = 300;
        switch (this.ddi.steeringSource) {			
            case FA18_DDI_Steering_Source.TACAN:
                if (this.ddi.tacanAvailable) {
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("TACAN STATION RADIAL:1", "degree") + 180);
                    steeringTranslation = this.compute_adi_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
			case FA18_DDI_Steering_Source.VOR:
					if (this.ddi.navAvailable) {
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180);
                    steeringTranslation = this.compute_adi_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;
			 case FA18_DDI_Steering_Source.ILSN:
					if (this.ddi.ilsnavAvailable) 
				{						
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.navindex, "degree") + 180);
					steeringTranslation = this.compute_adi_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
					showILS = (this.ddi.ilsnavAvailable);
					let cdidev = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.navindex, "number") / 127);
					let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
					if (backCourse) {
					cdidev = -cdidev; }
					diffAndSetAttribute(this._adi_cdideviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(cdidev), -1), 1) * factor) + ")");					
					if (SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:"+ this.ddi.navindex, "Bool")) {
					let gsidev = (SimVar.GetSimVarValue("NAV GSI:" + this.ddi.navindex, "number") / 127);
                    let y = (parseFloat(gsidev) * factor);
					let x = 0;
                    diffAndSetAttribute(this._adi_gsideviation, "transform", "translate(" + (x) + " " + fastToFixed(y, 0) + ")");
					}
                }
                break;	
			 case FA18_DDI_Steering_Source.ILST:
					if (this.ddi.ilstacanAvailable) 
				{						
                    let bearing = Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.ddi.ilstacanindex, "degree") + 180);
					steeringTranslation = this.compute_adi_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
					showILS = (this.ddi.ilstacanAvailable);
					let cdidev = (SimVar.GetSimVarValue("NAV CDI:" + this.ddi.ilstacanindex, "number") / 127);
					let backCourse = SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "bool");
					if (backCourse) {
					cdidev = -cdidev; }
					diffAndSetAttribute(this._adi_cdideviation, "transform", "translate(" + (Math.min(Math.max(parseFloat(cdidev), -1), 1) * factor) + ")");					
					if (SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:"+ this.ddi.ilstacanindex, "Bool")) {
					let gsidev = (SimVar.GetSimVarValue("NAV GSI:" + this.ddi.ilstacanindex, "number") / 127);
                    let y = (parseFloat(gsidev) * factor);
					let x = 0;
                    diffAndSetAttribute(this._adi_gsideviation, "transform", "translate(" + (x) + " " + fastToFixed(y, 0) + ")");
					}
                }
                break;	
            case FA18_DDI_Steering_Source.WYPT:
                if (this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentWaypoint) {
                    let bearing = this.ddi.flightPlanManager.getBearingToWaypoint(this.ddi.waypointManager.currentWaypoint, true);
                    steeringTranslation = this.compute_adi_SteeringTranslation(planeHeading, bearing);
                    displayed = true;
                }
                break;				
        }
		diffAndSetAttribute(this._adi_headingSteeringBugElement, "transform", "translate(" + fastToFixed(steeringTranslation, 1) + ", 0)");	        
        diffAndSetAttribute(this._adi_headingSteeringBugElement, "visibility", (displayed) ? "visible" : "hidden");																														   
		diffAndSetStyle(this._adi_cdigroup, StyleProperty.visibility, (showILS) ? "visible" : "hidden");
		diffAndSetStyle(this._adi_gsigroup, StyleProperty.visibility, (showILS) ? "visible" : "hidden");					  
	    }																	   
}
customElements.define("fa18-ddi-adi", FA18_DDI_ADI);
//# sourceMappingURL=FA18_DDI_ADI.js.map