var FA18_DDI_Page_Type;
(function (FA18_DDI_Page_Type) {
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["NotImplemented"] = 0] = "NotImplemented";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["ADI"] = 1] = "ADI";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["HUD"] = 2] = "HUD";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["FPAS"] = 3] = "FPAS";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["Checklist"] = 4] = "Checklist";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["Engine"] = 5] = "Engine";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["Fuel"] = 6] = "Fuel";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["HSI"] = 7] = "HSI";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["HSIAircraftData"] = 8] = "HSIAircraftData";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["HSITacanData"] = 9] = "HSITacanData";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["HSIWaypointData"] = 10] = "HSIWaypointData";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["MenuTactical"] = 11] = "MenuTactical";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["MenuSupport"] = 12] = "MenuSupport";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["FCS"] = 13] = "FCS";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["HMD"] = 14] = "HMD";
	FA18_DDI_Page_Type[FA18_DDI_Page_Type["FLIR"] = 15] = "FLIR";
    FA18_DDI_Page_Type[FA18_DDI_Page_Type["IMAGE"] = 16] = "IMAGE";	   
	FA18_DDI_Page_Type[FA18_DDI_Page_Type["RDR"] = 17] = "RDR";	   
		
})(FA18_DDI_Page_Type || (FA18_DDI_Page_Type = {}));
var FA18_DDI_Steering_Source;
(function (FA18_DDI_Steering_Source) {
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["None"] = 0] = "None";
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["WYPT"] = 1] = "WYPT";
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["TACAN"] = 2] = "TACAN";
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["VOR"] = 3] = "VOR";
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["ILST"] = 4] = "ILST";
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["ILSN"] = 5] = "ILSN";
    FA18_DDI_Steering_Source[FA18_DDI_Steering_Source["GPS"] = 6] = "GPS";
})(FA18_DDI_Steering_Source || (FA18_DDI_Steering_Source = {}));
class FA18_DDI extends NavSystem {
    constructor() {
        super();
        this.secondsTimer = 0;
        this.timeAtBingoTriggered = 0;
        this.slavesInstances = ["AS04F_DDI_1", "AS04F_DDI_2", "AS04F_DDI_4"];
        this.masterInstance = "AS04F_DDI_3";
        this.pages = new Map();
        this._steeringSource = FA18_DDI_Steering_Source.None;
        this.onButtonPressed = [];
        this._tacanAvailable = false;
        this._navAvailable = false;
        this._ilsnavAvailable = false;
        this._ilstacanAvailable = false;
        FA18_DDI.DEBUG_INSTANCE = this;
        this.map = new FA18_DDI_Map();
        this.map.setGPS(this);
        this.waypointManager = new FA18_DDI_WaypointManager(this);
		this._apNavIndex = 1;
        this.navindex = 1;
        this.ilstacanindex = 1;
    }
    get templateID() { return "AS04F_DDI"; }
    get instrumentAlias() { return "AS04F_DDI"; }
    get isMaster() { return this.instrumentIndex === 3; }
    get currentPage() {
        return this.pages.get(this.currentPageType);
    }
    get notImplementedPage() {
        return this.pages.get(FA18_DDI_Page_Type.NotImplemented);
    }
    get steeringSource() { return this._steeringSource; }
    get planeCoordinates() { return this.flightPlanManager.planeCoordinates; }
    connectedCallback() {
        super.connectedCallback();
        this.radioNav = new RadioNav();
        this.radioNav.init(NavMode.TWO_SLOTS);
        this.warnings = new Cabin_Warnings();
        this.addIndependentElementContainer(new NavSystemElementContainer("Warnings", "Warnings", this.warnings));
    }
    Init() {
        super.Init();
        this.waypointManager.init();
        this.pages.set(FA18_DDI_Page_Type.NotImplemented, document.querySelector("fa18-ddi-not-implemented"));
        this.pages.set(FA18_DDI_Page_Type.ADI, document.querySelector("fa18-ddi-adi"));
        this.pages.set(FA18_DDI_Page_Type.HUD, document.querySelector("fa18-ddi-hud"));
        this.pages.set(FA18_DDI_Page_Type.Engine, document.querySelector("fa18-ddi-engine"));
        this.pages.set(FA18_DDI_Page_Type.Fuel, document.querySelector("fa18-ddi-fuel"));
        this.pages.set(FA18_DDI_Page_Type.MenuTactical, document.querySelector("fa18-ddi-menu-tactical"));
        this.pages.set(FA18_DDI_Page_Type.HMD, document.querySelector("fa18-ddi-hmd"));
		this.pages.set(FA18_DDI_Page_Type.FLIR, document.querySelector("fa18-ddi-flir"));
		this.pages.set(FA18_DDI_Page_Type.IMAGE, document.querySelector("fa18-ddi-imagevision"));
		this.pages.set(FA18_DDI_Page_Type.RDR, document.querySelector("fa18-ddi-rdr"));
        this.pages.forEach((page) => {
            if (page)
                page.init(this);
            else
                console.error("One of the element of pages array is null");
        });
        if (this.instrumentIndex === 1) {
            let hsiStartupPage = SimVar.GetSimVarValue("L:FA18_DDI_START_PAGE_1", "number");
            if (hsiStartupPage > 0) {
                this.showPage(hsiStartupPage);
            }
            else {
                this.showPage(FA18_DDI_Page_Type.RDR);
            }
        }
        else if (this.instrumentIndex === 2) {
            let hsiStartupPage = SimVar.GetSimVarValue("L:FA18_DDI_START_PAGE_2", "number");
            if (hsiStartupPage > 0) {
                this.showPage(hsiStartupPage);
            }
            else {
                this.showPage(FA18_DDI_Page_Type.ADI);
            }
        }
        else if (this.instrumentIndex === 3) {
            this.showPage(FA18_DDI_Page_Type.IMAGE);
        }
        else if (this.instrumentIndex === 4) {
            this.showPage(FA18_DDI_Page_Type.HUD);
        }
        else if (this.instrumentIndex === 5) {
            this.showPage(FA18_DDI_Page_Type.RDR);
        }
    }
    toggleSteeringSource(source) {
        if (this.steeringSource !== source) {
            this.setSteeringSource(source);
        }
        else {
            this.setSteeringSource(FA18_DDI_Steering_Source.None);
        }
    }
    setSteeringSource(source) {
        if (this.steeringSource !== source) {
            this._steeringSource = source;
            SimVar.SetSimVarValue("L:FA18_DDI_STEERING_SOURCE", "number", this.steeringSource);
        }
    }
    updateNavIndex() {
        let ils = this.radioNav.getBestILSBeacon();
			if (ils.id > 0) {
            this.navindex = ils.id;
            }
            else {
            let vor = this.radioNav.getBestVORBeacon();
            if (vor.id > 0) {
            this.navindex = vor.id;
            }
        }
    }
    get tacanAvailable() { return this._tacanAvailable; }
    updateTacanSignal() {
        this._tacanAvailable = SimVar.GetSimVarValue("NAV HAS TACAN:1", "Bool") && !SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.navindex, "Bool");
    }
    get ilstacanAvailable() { return this._ilstacanAvailable; }
    updateilsTacanSignal() {
        this._ilstacanAvailable = SimVar.GetSimVarValue("NAV HAS TACAN:1", "Bool") && SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.navindex, "Bool");
    }
    get navAvailable() { return this._navAvailable; }
    updateNavSignal() {
        this._navAvailable = Simplane.getNavHasNav(this.navindex) && !SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.navindex, "Bool");
    }
    get ilsnavAvailable() { return this._ilsnavAvailable; }
    updateilsNavSignal() {
        this._ilsnavAvailable = Simplane.getNavHasNav(this.navindex) && SimVar.GetSimVarValue("NAV HAS GLIDE SLOPE:" + this.navindex, "Bool");
    }
    getCrsValue() {
            if (SimVar.GetSimVarValue("NAV HAS LOCALIZER:" + this.navindex, "Bool")) {
                if (SimVar.GetSimVarValue("AUTOPILOT BACKCOURSE HOLD", "Bool")) {
                    return (SimVar.GetSimVarValue("NAV LOCALIZER:" + this.navindex, "Degrees") - 180);
                }
                else {
                    return (SimVar.GetSimVarValue("NAV LOCALIZER:" + this.navindex, "Degrees"));
                }
            }
            else {
				if (SimVar.GetSimVarValue("NAV HAS TACAN:1", "Bool")){
					return (SimVar.GetSimVarValue("TACAN OBS:1", "Degrees"));
				}
				else{
					return (SimVar.GetSimVarValue("NAV OBS:" + this.navindex, "Degrees"));
				}
            }
    }
    steeringControlLoop() {
        this._steeringSource = SimVar.GetSimVarValue("L:FA18_DDI_STEERING_SOURCE", "number");
        if (this.isMaster) {
            switch (this.steeringSource) {
                case FA18_DDI_Steering_Source.VOR:
                    if (!this.navAvailable)
                        this.setSteeringSource(FA18_DDI_Steering_Source.None);
                    break;
                case FA18_DDI_Steering_Source.ILSN:
                    if (!this.ilsnavAvailable)
                        this.setSteeringSource(FA18_DDI_Steering_Source.None);
                    break;
                case FA18_DDI_Steering_Source.TACAN:
                    if (!this.tacanAvailable)
                        this.setSteeringSource(FA18_DDI_Steering_Source.None);
                    break;
                case FA18_DDI_Steering_Source.ILST:
                    if (!this.ilstacanAvailable)
                        this.setSteeringSource(FA18_DDI_Steering_Source.None);
                    break;
                case FA18_DDI_Steering_Source.WYPT:
                    if (!this.waypointManager || !this.waypointManager.initialized || !this.waypointManager.currentWaypoint)
                        this.setSteeringSource(FA18_DDI_Steering_Source.None);
                    break;
            }
            let gpsOn = SimVar.GetSimVarValue("L:GPS_DRIVES_NAV", "Bool");
            if (gpsOn) {
                if (this.steeringSource === FA18_DDI_Steering_Source.TACAN) {
                    // if (!this.map.isCourseSteering) {
                        // SimVar.SetSimVarValue("K:TACAN1_SET", "degrees", Avionics.Utils.clampAngle(SimVar.GetSimVarValue("TACAN STATION RADIAL:1", "degree") + 180));
                    // }
                    if (Simplane.getAutopilotGPSDriven() || !SimVar.GetSimVarValue("TACAN DRIVES NAV1", "Bool")) {
                        SimVar.SetSimVarValue("TACAN DRIVES NAV1", "Bool", true);
                    }
                }
                else if (this.steeringSource === FA18_DDI_Steering_Source.VOR) {
                    // if (!this.map.isCourseSteering) {
                        // SimVar.SetSimVarValue("K:VOR" + this.navindex + "_SET", "degrees", Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.navindex, "degree") + 180));
                    // }
                    if (SimVar.GetSimVarValue("TACAN DRIVES NAV1", "Bool")) {
                        SimVar.SetSimVarValue("TACAN DRIVES NAV1", "Bool", false);
                    }
					if (Simplane.getAutopilotGPSDriven()) { 
					SimVar.SetSimVarValue("GPS DRIVES NAV1", "Bool", false); 
					}
                    let apNavIndex = 1;

                     if (this.navindex > 0) {
                        apNavIndex = this.navindex;
                    }
                    if (apNavIndex != this._apNavIndex) {
                        Simplane.setAutoPilotSelectedNav(apNavIndex);
                        this._apNavIndex = apNavIndex;
                    }
                }
				else if (this.steeringSource === FA18_DDI_Steering_Source.ILSN) {
                    // if (!this.map.isCourseSteering) {
                        // SimVar.SetSimVarValue("K:VOR" + this.navindex + "_SET", "degrees", Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.navindex, "degree") + 180));
                    // }
                    if (SimVar.GetSimVarValue("TACAN DRIVES NAV1", "Bool")) {
                        SimVar.SetSimVarValue("TACAN DRIVES NAV1", "Bool", false);
                    }
					if (Simplane.getAutopilotGPSDriven()) { 
					SimVar.SetSimVarValue("GPS DRIVES NAV1", "Bool", false); 
					}
                    let apNavIndex = 1;

                     if (this.navindex > 0) {
                        apNavIndex = this.navindex;
                    }
                    if (apNavIndex != this._apNavIndex) {
                        Simplane.setAutoPilotSelectedNav(apNavIndex);
                        this._apNavIndex = apNavIndex;
                    }
                }
				else if (this.steeringSource === FA18_DDI_Steering_Source.ILST) {
                    // if (!this.map.isCourseSteering) {
                        // SimVar.SetSimVarValue("K:VOR" + this.navindex + "_SET", "degrees", Avionics.Utils.clampAngle(SimVar.GetSimVarValue("NAV RADIAL:" + this.navindex, "degree") + 180));
                    // }
                    if (SimVar.GetSimVarValue("TACAN DRIVES NAV1", "Bool")) {
                        SimVar.SetSimVarValue("TACAN DRIVES NAV1", "Bool", false);
                    }
					if (Simplane.getAutopilotGPSDriven()) { 
					SimVar.SetSimVarValue("GPS DRIVES NAV1", "Bool", false); 
					}
                    let apNavIndex = 1;

                     if (this.navindex > 0) {
                        apNavIndex = this.navindex;
                    }
                    if (apNavIndex != this._apNavIndex) {
                        Simplane.setAutoPilotSelectedNav(apNavIndex);
                        this._apNavIndex = apNavIndex;
                    }
                }
				else { 
					if (!Simplane.getAutopilotGPSDriven()) { SimVar.SetSimVarValue("GPS DRIVES NAV1", "Bool", true); } 
				}
            }
            else {
                if (Simplane.getAutopilotGPSDriven()) { SimVar.SetSimVarValue("GPS DRIVES NAV1", "Bool", false); }
            }
        }
    }
    updateSoundRules() {
        this.warningLandingGear();
        this.secondsSinceTakeOff();
        this.isBingoTriggered();
    }
    onUpdate(_deltaTime) {
        var _a, _b, _c;
        super.onUpdate(_deltaTime);
        this.updateTacanSignal();
        this.updateNavSignal();
        this.updateilsNavSignal();
        this.updateilsTacanSignal();
        this.updateNavIndex();
        this.steeringControlLoop();
        (_a = this.waypointManager) === null || _a === void 0 ? void 0 : _a.update(_deltaTime);
        (_b = this.map) === null || _b === void 0 ? void 0 : _b.onUpdate(_deltaTime, (this.currentPageType === FA18_DDI_Page_Type.HSI));
        (_c = this.currentPage) === null || _c === void 0 ? void 0 : _c.update(this.deltaTime);
        this.updateSoundRules();
    }
    onInteractionEvent(_args) {
        let event = this.DecomposeEventFromPrefix(_args);
        if (event) {
            let result = event.match(/BTN_(\d+)/);
            if (result && this.onButtonPressed[result[1]]) {
                this.onButtonPressed[result[1]]();
            }
            else if (event.startsWith("Map_") && this.map) {
                this.map.onEvent(event.replace("Map_", ""), _args.slice(1));
            }
            else if (event.startsWith("WaypointManager_") && this.waypointManager) {
                this.waypointManager.onEvent(event.replace("WaypointManager_", ""), _args.slice(1));
            }
            else {
                for (let [pageType, page] of this.pages) {
                    if (event.startsWith(FA18_DDI_Page_Type[pageType] + "_")) {
                        page.onEvent(event.replace(FA18_DDI_Page_Type[pageType] + "_", ""), _args.slice(1));
                        break;
                    }
                }
            }
        }
    }
    setPageButton(buttonIndex, pageType) {
        this.onButtonPressed[buttonIndex] = () => {
            this.showPage(pageType);
        };
    }
    showPage(page) {
        this.onButtonPressed = [];
        this.pages.forEach((page) => {
            if (page) {
                page.style.display = "none";
                page.isCurrentDisplayedPage = false;
            }
            else
                console.error("One of the element of pages array is null");
        });
        if (page === FA18_DDI_Page_Type.NotImplemented && this.currentPageType != FA18_DDI_Page_Type.NotImplemented) {
            this.notImplementedPage.previousPage = this.currentPageType;
        }
        this.currentPageType = page;
        if (this.currentPage) {
            this.currentPage.show();
            this.currentPage.isCurrentDisplayedPage = true;
        }
        else {
            console.error("Page '" + FA18_DDI_Page_Type[page] + "' can not be displayed ==> not existing in the pages array");
        }
    }
    warningLandingGear() {
        if (SimVar.GetSimVarValue("GEAR HANDLE POSITION", "Bool") == false &&
            SimVar.GetSimVarValue("AIRSPEED TRUE", "knots") < 175 &&
            SimVar.GetSimVarValue("INDICATED ALTITUDE", "feet") < 7500 &&
            SimVar.GetSimVarValue("VERTICAL SPEED", "feet per minute") < -250) {
            SimVar.SetSimVarValue("L:FA18_Warning_Landing_Gear", "Bool", true);
        }
        else {
            SimVar.SetSimVarValue("L:FA18_Warning_Landing_Gear", "Bool", false);
        }
    }
    secondsSinceTakeOff() {
        if (SimVar.GetSimVarValue("SIM ON GROUND", "Bool") == 0) {
            if (this.secondsTimer == 0) {
                this.timeAtTakeOff = Date.now();
                this.secondsTimer = this.timeAtTakeOff;
            }
            else {
                this.secondsTimer = Date.now() - this.timeAtTakeOff;
            }
        }
        else {
            this.secondsTimer = 0;
        }
        SimVar.SetSimVarValue("L:FA_18_TIME_SINCE_TAKE_OFF", "number", this.secondsTimer / 1000);
    }
    isBingoTriggered() {
        let fuel = SimVar.GetSimVarValue("FUEL WEIGHT PER GALLON", "Pounds");
        let bingo = SimVar.GetSimVarValue("L:FRIES_Fuel_Bingo", "number");
        if (fuel < bingo && (Date.now() - this.timeAtBingoTriggered) / 1000 > 30) {
            SimVar.SetSimVarValue("L:FA18_BINGO_TRIGGERED", "Bool", true);
            this.timeAtBingoTriggered = Date.now();
        }
        else {
            SimVar.SetSimVarValue("L:FA18_BINGO_TRIGGERED", "Bool", false);
        }
    }
}
//# sourceMappingURL=FA18_DDI.js.map