/* MSFS Format */
class QuasarOLED extends BaseInstrument {

    /* Browser Format */
    // class QuasarOLED extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarOLED"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            // FUEL SYSTEM
            this.fuell_pump_fail = this.getId("fuell_pump_fail");
            this.fuell_off = this.getId("fuell_off");
            this.fuell_on = this.getId("fuell_on");
            this.fuelr_pump_fail = this.getId("fuelr_pump_fail");
            this.fuelr_off = this.getId("fuelr_off");
            this.fuelr_on = this.getId("fuelr_on");
            this.fuele1_pump_fail = this.getId("fuele1_pump_fail");
            this.fuele1_off = this.getId("fuele1_off");
            this.fuele1_on = this.getId("fuele1_on");
            this.fuele2_pump_fail = this.getId("fuele2_pump_fail");
            this.fuele2_off = this.getId("fuele2_off");
            this.fuele2_on = this.getId("fuele2_on");
            this.fuele3_pump_fail = this.getId("fuele3_pump_fail");
            this.fuele3_off = this.getId("fuele3_off");
            this.fuele3_on = this.getId("fuele3_on");
            this.fuele4_pump_fail = this.getId("fuele4_pump_fail");
            this.fuele4_off = this.getId("fuele4_off");
            this.fuele4_on = this.getId("fuele4_on");
            this.fuele4_pump_fail = this.getId("fuele4_pump_fail");
            this.fuele4_off = this.getId("fuele4_off");
            this.fuele4_on = this.getId("fuele4_on");
            
            this.fuelgenl_fail = this.getId("fuelgenl_fail");
            this.fuelgenl_off = this.getId("fuelgenl_off");
            this.fuelgenl_on = this.getId("fuelgenl_on");

            this.fuelgenr_fail = this.getId("fuelgenr_fail");
            this.fuelgenr_off = this.getId("fuelgenr_off");
            this.fuelgenr_on = this.getId("fuelgenr_on");

            // APU
            this.apumaster_off = this.getId("apumaster_off");
            this.apumaster_on = this.getId("apumaster_on");
            this.apustart_off = this.getId("apustart_off");
            this.apustart_pct = this.getId("apustart_pct");
            this.apustart_on = this.getId("apustart_on");
            this.apupct_value = this.getId("apupct_value");
            this.apubleed_avail = this.getId("apubleed_avail");
            this.apubleed_on = this.getId("apubleed_on");
            this.apubleed_off = this.getId("apubleed_off");

            // TESTS + MAINTENANCE
            this.testfcs_load = this.getId("testfcs_load");
            this.testfcs_unavail = this.getId("testfcs_unavail");
            this.testfcs_todo = this.getId("testfcs_todo");
            this.testfcs_done = this.getId("testfcs_done");
            this.testfcs_fail = this.getId("testfcs_fail");
            this.testfcs_pct = this.getId("testfcs_pct");

            this.testvector_load = this.getId("testvector_load");
            this.testvector_unavail = this.getId("testvector_unavail");
            this.testvector_todo = this.getId("testvector_todo");
            this.testvector_done = this.getId("testvector_done");
            this.testvector_fail = this.getId("testvector_fail");
            this.testvector_pct = this.getId("testvector_pct");

            this.testmach_load = this.getId("testmach_load");
            this.testmach_unavail = this.getId("testmach_unavail");
            this.testmach_todo = this.getId("testmach_todo");
            this.testmach_done = this.getId("testmach_done");
            this.testmach_fail = this.getId("testmach_fail");
            this.testmach_pct = this.getId("testmach_pct");

            this.maintldg_open = this.getId("maintldg_open");
            this.maintldg_closed = this.getId("maintldg_closed");

            this.maintnuke_open = this.getId("maintnuke_open");
            this.maintnuke_closed = this.getId("maintnuke_closed");

            // ICE PROTECTION
            this.icews_on = this.getId("icews_on");
            this.icews_off = this.getId("icews_off");
            
            this.iceeng1_on = this.getId("iceeng1_on");
            this.iceeng1_off = this.getId("iceeng1_off");
            
            this.iceeng2_on = this.getId("iceeng2_on");
            this.iceeng2_off = this.getId("iceeng2_off");
            
            this.iceeng3_on = this.getId("iceeng3_on");
            this.iceeng3_off = this.getId("iceeng3_off");
            
            this.iceeng4_on = this.getId("iceeng4_on");
            this.iceeng4_off = this.getId("iceeng4_off");

            // EXT LIGHTS
            this.lgttaxi_on = this.getId("lgttaxi_on");
            this.lgttaxi_off = this.getId("lgttaxi_off");
            this.lgttaxi_fail = this.getId("lgttaxi_fail");
            
            this.lgtnav_on = this.getId("lgtnav_on");
            this.lgtnav_off = this.getId("lgtnav_off");
            this.lgtnav_fail = this.getId("lgtnav_fail");
            
            this.lgtstr_on = this.getId("lgtstr_on");
            this.lgtstr_off = this.getId("lgtstr_off");
            this.lgtstr_fail = this.getId("lgtstr_fail");
            
            this.lgtldg_on = this.getId("lgtldg_on");
            this.lgtldg_off = this.getId("lgtldg_off");
            this.lgtldg_fail = this.getId("lgtldg_fail");
            
            this.lgtbcn_on = this.getId("lgtbcn_on");
            this.lgtbcn_off = this.getId("lgtbcn_off");
            this.lgtbcn_fail = this.getId("lgtbcn_fail");
            
            this.lgtrim_on = this.getId("lgtrim_on");
            this.lgtrim_off = this.getId("lgtrim_off");
            this.lgtrim_fail = this.getId("lgtrim_fail");
            
            // VARIOUS
            this.pressur_on = this.getId("pressur_on");
            this.pressur_off = this.getId("pressur_off");
            this.pressur_fail = this.getId("pressur_fail");

            this.parkbrk_set = this.getId("parkbrk_set");
            this.parkbrk_released = this.getId("parkbrk_released");
            
            this.avionics_on = this.getId("avionics_on");
            this.avionics_off = this.getId("avionics_off");
            this.avionics_fail = this.getId("avionics_fail");
            
            this.canopy_open = this.getId("canopy_open");
            this.canopy_closed = this.getId("canopy_closed");
            
            this.seat_open = this.getId("seat_open");
            this.seat_closed = this.getId("seat_closed");

            // OLED TEST BOXES
            this.testa1 = this.getId("testa1");
            this.testa2 = this.getId("testa2");
            this.testa3 = this.getId("testa3");
            this.testa4 = this.getId("testa4");
            this.testa5 = this.getId("testa5");
            this.testa6 = this.getId("testa6");
            
            this.testb1 = this.getId("testb1");
            this.testb2 = this.getId("testb2");
            this.testb3 = this.getId("testb3");
            this.testb4 = this.getId("testb4");
            this.testb5 = this.getId("testb5");
            this.testb6 = this.getId("testb6");
            
            this.testc1 = this.getId("testc1");
            this.testc2 = this.getId("testc2");
            this.testc3 = this.getId("testc3");
            this.testc4 = this.getId("testc4");
            this.testc5 = this.getId("testc5");
            this.testc6 = this.getId("testc6");
            
            this.testd1 = this.getId("testd1");
            this.testd2 = this.getId("testd2");
            this.testd3 = this.getId("testd3");
            this.testd4 = this.getId("testd4");
            this.testd5 = this.getId("testd5");
            this.testd6 = this.getId("testd6");
            
            this.teste1 = this.getId("teste1");
            this.teste2 = this.getId("teste2");
            this.teste3 = this.getId("teste3");
            this.teste4 = this.getId("teste4");
            this.teste5 = this.getId("teste5");
            this.teste6 = this.getId("teste6");
            
            this.testf1 = this.getId("testf1");
            this.testf2 = this.getId("testf2");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
        
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats
        
        computeAndDraw() {

            // OLED TESTS
            if (this.valTestOled) {
                this.testa1.style.display = 'block';
                this.testa2.style.display = 'block';
                this.testa3.style.display = 'block';
                this.testa4.style.display = 'block';
                this.testa5.style.display = 'block';
                this.testa6.style.display = 'block';
                
                this.testb1.style.display = 'block';
                this.testb2.style.display = 'block';
                this.testb3.style.display = 'block';
                this.testb4.style.display = 'block';
                this.testb5.style.display = 'block';
                this.testb6.style.display = 'block';
                
                this.testc1.style.display = 'block';
                this.testc2.style.display = 'block';
                this.testc3.style.display = 'block';
                this.testc4.style.display = 'block';
                this.testc5.style.display = 'block';
                this.testc6.style.display = 'block';
                
                this.testd1.style.display = 'block';
                this.testd2.style.display = 'block';
                this.testd3.style.display = 'block';
                this.testd4.style.display = 'block';
                this.testd5.style.display = 'block';
                this.testd6.style.display = 'block';
                
                this.teste1.style.display = 'block';
                this.teste2.style.display = 'block';
                this.teste3.style.display = 'block';
                this.teste4.style.display = 'block';
                this.teste5.style.display = 'block';
                this.teste6.style.display = 'block';
                
                this.testf1.style.display = 'block';
                this.testf2.style.display = 'block';
            }
            else {
                this.testa1.style.display = 'none';
                this.testa2.style.display = 'none';
                this.testa3.style.display = 'none';
                this.testa4.style.display = 'none';
                this.testa5.style.display = 'none';
                this.testa6.style.display = 'none';
                
                this.testb1.style.display = 'none';
                this.testb2.style.display = 'none';
                this.testb3.style.display = 'none';
                this.testb4.style.display = 'none';
                this.testb5.style.display = 'none';
                this.testb6.style.display = 'none';
                
                this.testc1.style.display = 'none';
                this.testc2.style.display = 'none';
                this.testc3.style.display = 'none';
                this.testc4.style.display = 'none';
                this.testc5.style.display = 'none';
                this.testc6.style.display = 'none';
                
                this.testd1.style.display = 'none';
                this.testd2.style.display = 'none';
                this.testd3.style.display = 'none';
                this.testd4.style.display = 'none';
                this.testd5.style.display = 'none';
                this.testd6.style.display = 'none';
                
                this.teste1.style.display = 'none';
                this.teste2.style.display = 'none';
                this.teste3.style.display = 'none';
                this.teste4.style.display = 'none';
                this.teste5.style.display = 'none';
                this.teste6.style.display = 'none';
                
                this.testf1.style.display = 'none';
                this.testf2.style.display = 'none';
            }
    

            // OLED1.1: Fuel Left
            if (!this.valFuelValveL) {
                this.fuell_off.style.display='block';
                this.fuell_pump_fail.style.display='none';
                this.fuell_on.style.display='none';
            }
            else if (!this.valFuelPumpL) {
                this.fuell_off.style.display='none';
                this.fuell_pump_fail.style.display='block';
                this.fuell_on.style.display='none';
            }
            else {
                this.fuell_off.style.display='none';
                this.fuell_pump_fail.style.display='none';
                this.fuell_on.style.display='block';
            }

            // OLED1.2: Fuel Right
            if (!this.valFuelValveR) {
                this.fuelr_off.style.display='block';
                this.fuelr_pump_fail.style.display='none';
                this.fuelr_on.style.display='none';
            }
            else if (!this.valFuelPumpR) {
                this.fuelr_off.style.display='none';
                this.fuelr_pump_fail.style.display='block';
                this.fuelr_on.style.display='none';
            }
            else {
                this.fuelr_off.style.display='none';
                this.fuelr_pump_fail.style.display='none';
                this.fuelr_on.style.display='block';
            }

            // OLED1.3: Fuel Engine 1 + APU
            if (!this.valFuelValveE1) {
                this.fuele1_off.style.display='block';
                this.fuele1_pump_fail.style.display='none';
                this.fuele1_on.style.display='none';
            }
            else if (!this.valFuelPumpE1 || !this.valFuelPumpTE1) {
                this.fuele1_off.style.display='none';
                this.fuele1_pump_fail.style.display='block';
                this.fuele1_on.style.display='none';
            }
            else {
                this.fuele1_off.style.display='none';
                this.fuele1_pump_fail.style.display='none';
                this.fuele1_on.style.display='block';
            }

            // OLED1.4: Fuel Engine 2
            if (!this.valFuelValveE2) {
                this.fuele2_off.style.display='block';
                this.fuele2_pump_fail.style.display='none';
                this.fuele2_on.style.display='none';
            }
            else if (!this.valFuelPumpE2 || !this.valFuelPumpTE2) {
                this.fuele2_off.style.display='none';
                this.fuele2_pump_fail.style.display='block';
                this.fuele2_on.style.display='none';
            }
            else {
                this.fuele2_off.style.display='none';
                this.fuele2_pump_fail.style.display='none';
                this.fuele2_on.style.display='block';
            }

            // OLED1.5: Fuel Engine 3
            if (!this.valFuelValveE3) {
                this.fuele3_off.style.display='block';
                this.fuele3_pump_fail.style.display='none';
                this.fuele3_on.style.display='none';
            }
            else if (!this.valFuelPumpE3 || !this.valFuelPumpTE3) {
                this.fuele3_off.style.display='none';
                this.fuele3_pump_fail.style.display='block';
                this.fuele3_on.style.display='none';
            }
            else {
                this.fuele3_off.style.display='none';
                this.fuele3_pump_fail.style.display='none';
                this.fuele3_on.style.display='block';
            }

            // OLED1.6: Fuel Engine 4
            if (!this.valFuelValveE4) {
                this.fuele4_off.style.display='block';
                this.fuele4_pump_fail.style.display='none';
                this.fuele4_on.style.display='none';
            }
            else if (!this.valFuelPumpE4 || !this.valFuelPumpTE4) {
                this.fuele4_off.style.display='none';
                this.fuele4_pump_fail.style.display='block';
                this.fuele4_on.style.display='none';
            }
            else {
                this.fuele4_off.style.display='none';
                this.fuele4_pump_fail.style.display='none';
                this.fuele4_on.style.display='block';
            }

            // OLED2.1: Fuel Generator Left
            if (!this.valFuelGenLPower) {
                this.fuelgenl_fail.style.display='block';
                this.fuelgenl_off.style.display='none';
                this.fuelgenl_on.style.display='none';
            }
            else if (!this.valFuelGenLStatus) {
                this.fuelgenl_fail.style.display='none';
                this.fuelgenl_off.style.display='block';
                this.fuelgenl_on.style.display='none';
            }
            else {
                this.fuelgenl_fail.style.display='none';
                this.fuelgenl_off.style.display='none';
                this.fuelgenl_on.style.display='block';
            }

            // OLED2.2: Fuel Generator Right
            if (!this.valFuelGenRPower) {
                this.fuelgenr_fail.style.display='block';
                this.fuelgenr_off.style.display='none';
                this.fuelgenr_on.style.display='none';
            }
            else if (!this.valFuelGenRStatus) {
                this.fuelgenr_fail.style.display='none';
                this.fuelgenr_off.style.display='block';
                this.fuelgenr_on.style.display='none';
            }
            else {
                this.fuelgenr_fail.style.display='none';
                this.fuelgenr_off.style.display='none';
                this.fuelgenr_on.style.display='block';
            }

            
            // OLED2.3: APU Master
            if (this.valAPUMaster) {
                this.apumaster_on.style.display='block';
                this.apumaster_off.style.display='none';

            } 
            else {
                this.apumaster_off.style.display='block';
                this.apumaster_on.style.display='none';
            }
        
            // OLED2.4: APU Start
            if (this.valAPUMaster) {
                if (!this.valAPURPM) {
                    this.apustart_off.style.display='block';
                    this.apustart_pct.style.display='none';
                    this.apustart_on.style.display='none';
                    this.apupct_value.style.display='none';
                }
                else if (this.valAPURPM == 1) {
                    this.apustart_off.style.display='none';
                    this.apustart_pct.style.display='none';
                    this.apustart_on.style.display='block';
                    this.apupct_value.style.display='none';
                }
                else {
                    this.apustart_off.style.display='none';
                    this.apustart_pct.style.display='block';
                    this.apustart_on.style.display='none';
                    this.apupct_value.style.display='block';
                    
                    var apu_pct_height = (this.valAPURPM*100).toFixed(0);
                    var apu_pct_top = 100 - apu_pct_height;

                    this.apustart_pct.style.top = apu_pct_top+'px';
                    this.apustart_pct.style.height = apu_pct_height+'px';

                    this.apupct_value.innerHTML= apu_pct_height+'%';
                }
            }
            else {
                this.apustart_off.style.display='none';
                this.apustart_pct.style.display='none';
                this.apustart_on.style.display='none';
                    this.apupct_value.style.display='none';
            }

            // OLED2.5: APU Bleed
            if (this.valAPUBleed) {
                    this.apubleed_avail.style.display='none';
                    this.apubleed_on.style.display='block';
                    this.apubleed_off.style.display='none';
            }
            else {
                if (this.valAPUMaster && this.valAPURPM == 1) {
                    this.apubleed_avail.style.display='block';
                    this.apubleed_on.style.display='none';
                    this.apubleed_off.style.display='none';
                }
                else {
                    this.apubleed_avail.style.display='none';
                    this.apubleed_on.style.display='none';
                    this.apubleed_off.style.display='block';
                }

            }

            // OLED2.6: Test FCS
            if (this.valTestFCS) {
                this.testfcs_unavail.style.display='none';
                this.testfcs_load.style.display='block';
                this.testfcs_todo.style.display='none';
                this.testfcs_done.style.display='none';
                this.testfcs_fail.style.display='none';

                var motion = this.valTestFCS_MOTION / 6;
                this.testfcs_pct.innerHTML = motion.toFixed(0)+'%';
            }
            else {
                if (this.valTestFCS_DONE) {
                    this.testfcs_unavail.style.display='none';
                    this.testfcs_load.style.display='none';
                    this.testfcs_todo.style.display='none';
                    this.testfcs_done.style.display='block';
                    this.testfcs_fail.style.display='none';
                }
                else if(this.valTestFCS_FAIL) {
                    this.testfcs_unavail.style.display='none';
                    this.testfcs_load.style.display='none';
                    this.testfcs_todo.style.display='none';
                    this.testfcs_done.style.display='none';
                    this.testfcs_fail.style.display='block';
                }
                else {
                    if (!this.valTestFCS_AVL) {
                        this.testfcs_unavail.style.display='block';
                        this.testfcs_load.style.display='none';
                        this.testfcs_todo.style.display='none';
                        this.testfcs_done.style.display='none';
                        this.testfcs_fail.style.display='none';
                    }
                    else {
                        this.testfcs_unavail.style.display='none';
                        this.testfcs_load.style.display='none';
                        this.testfcs_todo.style.display='block';
                        this.testfcs_done.style.display='none';
                        this.testfcs_fail.style.display='none';
                    }
                }
            }


            // OLED3.1: Ice Windshield
            if (this.valIceWShield) {
                this.icews_on.style.display='block';
                this.icews_off.style.display='none';
            }
            else {
                this.icews_on.style.display='none';
                this.icews_off.style.display='block';
            }

            // OLED3.2: Ice Engine 1
            if (this.valIceEng1) {
                this.iceeng1_on.style.display='block';
                this.iceeng1_off.style.display='none';
            }
            else {
                this.iceeng1_on.style.display='none';
                this.iceeng1_off.style.display='block';
            }

            // OLED3.3: Ice Engine 2
            if (this.valIceEng2) {
                this.iceeng2_on.style.display='block';
                this.iceeng2_off.style.display='none';
            }
            else {
                this.iceeng2_on.style.display='none';
                this.iceeng2_off.style.display='block';
            }
            
            // OLED3.4: Ice Engine 3
            if (this.valIceEng3) {
                this.iceeng3_on.style.display='block';
                this.iceeng3_off.style.display='none';
            }
            else {
                this.iceeng3_on.style.display='none';
                this.iceeng3_off.style.display='block';
            }
            
            // OLED3.5: Ice Engine 4
            if (this.valIceEng4) {
                this.iceeng4_on.style.display='block';
                this.iceeng4_off.style.display='none';
            }
            else {
                this.iceeng4_on.style.display='none';
                this.iceeng4_off.style.display='block';
            }
            
            // OLED3.6: Pressurization
            if (this.valBusPressurization) {
                this.pressur_on.style.display='none';
                this.pressur_off.style.display='none';
                this.pressur_fail.style.display='block';
            }
            else {
                if (this.valPressurization) {
                    this.pressur_on.style.display='block';
                    this.pressur_off.style.display='none';
                    this.pressur_fail.style.display='none';
                }
                else {
                    this.pressur_on.style.display='none';
                    this.pressur_off.style.display='block';
                    this.pressur_fail.style.display='none';
                }
            }            

            // OLED4.1: Light Taxi
            if (this.valBusLightLdg) {
                this.lgttaxi_on.style.display='none';
                this.lgttaxi_off.style.display='none';
                this.lgttaxi_fail.style.display='block';
            }
            else {
                if (this.valLightTaxi) {
                    this.lgttaxi_on.style.display='block';
                    this.lgttaxi_off.style.display='none';
                    this.lgttaxi_fail.style.display='none';
                }
                else {
                    this.lgttaxi_on.style.display='none';
                    this.lgttaxi_off.style.display='block';
                    this.lgttaxi_fail.style.display='none';
                }
            }

            // OLED4.2: Light Nav
            if (this.valBusLightExt) {
                this.lgtnav_on.style.display='none';
                this.lgtnav_off.style.display='none';
                this.lgtnav_fail.style.display='block';
            }
            else {
                if (this.valLightNav) {
                    this.lgtnav_on.style.display='block';
                    this.lgtnav_off.style.display='none';
                    this.lgtnav_fail.style.display='none';
                }
                else {
                    this.lgtnav_on.style.display='none';
                    this.lgtnav_off.style.display='block';
                    this.lgtnav_fail.style.display='none';
                }
            }

            // OLED4.3: Light Strobe
            if (this.valBusLightExt) {
                this.lgtstr_on.style.display='none';
                this.lgtstr_off.style.display='none';
                this.lgtstr_fail.style.display='block';
            }
            else {
                if (this.valLightStrobe) {
                    this.lgtstr_on.style.display='block';
                    this.lgtstr_off.style.display='none';
                    this.lgtstr_fail.style.display='none';
                }
                else {
                    this.lgtstr_on.style.display='none';
                    this.lgtstr_off.style.display='block';
                    this.lgtstr_fail.style.display='none';
                }
            }

            // OLED4.4: Light Landing
            if (this.valBusLightLdg) {
                this.lgtldg_on.style.display='none';
                this.lgtldg_off.style.display='none';
                this.lgtldg_fail.style.display='block';
            }
            else {
                if (this.valLightLdg) {
                    this.lgtldg_on.style.display='block';
                    this.lgtldg_off.style.display='none';
                    this.lgtldg_fail.style.display='none';
                }
                else {
                    this.lgtldg_on.style.display='none';
                    this.lgtldg_off.style.display='block';
                    this.lgtldg_fail.style.display='none';
                }
            }

            // OLED4.5: Light Beacon
            if (this.valBusLightExt) {
                this.lgtbcn_on.style.display='none';
                this.lgtbcn_off.style.display='none';
                this.lgtbcn_fail.style.display='block';
            }
            else {
                if (this.valLightBeacon) {
                    this.lgtbcn_on.style.display='block';
                    this.lgtbcn_off.style.display='none';
                    this.lgtbcn_fail.style.display='none';
                }
                else {
                    this.lgtbcn_on.style.display='none';
                    this.lgtbcn_off.style.display='block';
                    this.lgtbcn_fail.style.display='none';
                }
            }

            // OLED4.6: Light Rim
            if (this.valBusLightExt) {
                this.lgtrim_on.style.display='none';
                this.lgtrim_off.style.display='none';
                this.lgtrim_fail.style.display='block';
            }
            else {
                if (this.valLightRim) {
                    this.lgtrim_on.style.display='block';
                    this.lgtrim_off.style.display='none';
                    this.lgtrim_fail.style.display='none';
                }
                else {
                    this.lgtrim_on.style.display='none';
                    this.lgtrim_off.style.display='block';
                    this.lgtrim_fail.style.display='none';
                }
            }

            // OLED5.1: Maintenance LDG Bay
            if (this.valMaintLDG) {
                this.maintldg_open.style.display='block';
                this.maintldg_closed.style.display='none';
            }
            else {
                this.maintldg_open.style.display='none';
                this.maintldg_closed.style.display='block';
            }

            // OLED5.2: Test Thrust Vectoring
            if (this.valTestVector) {
                this.testvector_unavail.style.display='none';
                this.testvector_load.style.display='block';
                this.testvector_todo.style.display='none';
                this.testvector_done.style.display='none';
                this.testvector_fail.style.display='none';

                var motion = this.valTestVector_MOTION / 4;
                this.testvector_pct.innerHTML = motion.toFixed(0)+'%';
            }
            else {
                if (this.valTestVector_DONE) {
                    this.testvector_unavail.style.display='none';
                    this.testvector_load.style.display='none';
                    this.testvector_todo.style.display='none';
                    this.testvector_done.style.display='block';
                    this.testvector_fail.style.display='none';
                }
                else if(this.valTestVector_FAIL) {
                    this.testvector_unavail.style.display='none';
                    this.testvector_load.style.display='none';
                    this.testvector_todo.style.display='none';
                    this.testvector_done.style.display='none';
                    this.testvector_fail.style.display='block';
                }
                else {
                    if (!this.valTestVector_AVL) {
                        this.testvector_unavail.style.display='block';
                        this.testvector_load.style.display='none';
                        this.testvector_todo.style.display='none';
                        this.testvector_done.style.display='none';
                        this.testvector_fail.style.display='none';
                    }
                    else {
                        this.testvector_unavail.style.display='none';
                        this.testvector_load.style.display='none';
                        this.testvector_todo.style.display='block';
                        this.testvector_done.style.display='none';
                        this.testvector_fail.style.display='none';
                    }
                }
            }

            // OLED5.3: Parking Brake
            if (this.valParkBrake) {
                this.parkbrk_set.style.display='block';
                this.parkbrk_released.style.display='none';
            }
            else {
                this.parkbrk_set.style.display='none';
                this.parkbrk_released.style.display='block';
            }

            // OLED5.4: Avionics
            if (this.valAvionics) {
                this.avionics_on.style.display='block';
                this.avionics_off.style.display='none';
                this.avionics_fail.style.display='none';
            }
            else {
                if (this.valBusAvionics) {
                    this.avionics_on.style.display='none';
                    this.avionics_off.style.display='none';
                    this.avionics_fail.style.display='block';
                }
                else {
                    this.avionics_on.style.display='none';
                    this.avionics_off.style.display='block';
                    this.avionics_fail.style.display='none';
                }
            }

            // OLED5.5: Canopy
            if (this.valCanopy) {
                this.canopy_open.style.display='block';
                this.canopy_closed.style.display='none';
            }
            else {
                this.canopy_open.style.display='none';
                this.canopy_closed.style.display='block';
            }
            
            // OLED5.6: Seat
            if (this.valSeat) {
                this.seat_open.style.display='block';
                this.seat_closed.style.display='none';
            }
            else {
                this.seat_open.style.display='none';
                this.seat_closed.style.display='block';
            }
            
            // OLED6.1: Maintenance Nuke Bay
            if (this.valMaintNuke) {
                this.maintnuke_open.style.display='block';
                this.maintnuke_closed.style.display='none';
            }
            else {
                this.maintnuke_open.style.display='none';
                this.maintnuke_closed.style.display='block';
            }
            // OLED6.2: Test Mach Aero
            if (this.valTestMach) {
                this.testmach_unavail.style.display='none';
                this.testmach_load.style.display='block';
                this.testmach_todo.style.display='none';
                this.testmach_done.style.display='none';
                this.testmach_fail.style.display='none';

                var motion = this.valTestMach_MOTION / 4;
                this.testmach_pct.innerHTML = motion.toFixed(0)+'%';
            }
            else {
                if (this.valTestMach_DONE) {
                    this.testmach_unavail.style.display='none';
                    this.testmach_load.style.display='none';
                    this.testmach_todo.style.display='none';
                    this.testmach_done.style.display='block';
                    this.testmach_fail.style.display='none';
                }
                else if(this.valTestMach_FAIL) {
                    this.testmach_unavail.style.display='none';
                    this.testmach_load.style.display='none';
                    this.testmach_todo.style.display='none';
                    this.testmach_done.style.display='none';
                    this.testmach_fail.style.display='block';
                }
                else {
                    if (!this.valTestMach_AVL) {
                        this.testmach_unavail.style.display='block';
                        this.testmach_load.style.display='none';
                        this.testmach_todo.style.display='none';
                        this.testmach_done.style.display='none';
                        this.testmach_fail.style.display='none';
                    }
                    else {
                        this.testmach_unavail.style.display='none';
                        this.testmach_load.style.display='none';
                        this.testmach_todo.style.display='block';
                        this.testmach_done.style.display='none';
                        this.testmach_fail.style.display='none';
                    }
                }
            }
        }
    
        // Read variables from Sim
        allSimvars() {

            // FUEL SYSTEM
            this.valFuelValveL = this.getSimvar("FUELSYSTEM VALVE SWITCH:1", "bool", 1);
            this.valFuelPumpL = this.getSimvar("FUELSYSTEM PUMP ACTIVE:1", "bool", 1);
            this.valFuelValveR = this.getSimvar("FUELSYSTEM VALVE SWITCH:2", "bool", 1);
            this.valFuelPumpR = this.getSimvar("FUELSYSTEM PUMP ACTIVE:2", "bool", 1);
            this.valFuelValveE1 = this.getSimvar("FUELSYSTEM VALVE SWITCH:3", "bool", 1);
            this.valFuelPumpE1 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:3", "bool", 1);
            this.valFuelPumpTE1 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:7", "bool", 1);
            this.valFuelValveE2 = this.getSimvar("FUELSYSTEM VALVE SWITCH:4", "bool", 1);
            this.valFuelPumpE2 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:4", "bool", 1);
            this.valFuelPumpTE2 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:8", "bool", 1);
            this.valFuelValveE3 = this.getSimvar("FUELSYSTEM VALVE SWITCH:5", "bool", 1);
            this.valFuelPumpE3 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:5", "bool", 1);
            this.valFuelPumpTE3 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:9", "bool", 1);
            this.valFuelValveE4 = this.getSimvar("FUELSYSTEM VALVE SWITCH:6", "bool", 1);
            this.valFuelPumpE4 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:6", "bool", 1);
            this.valFuelPumpTE4 = this.getSimvar("FUELSYSTEM PUMP ACTIVE:10", "bool", 1);
            this.valFuelGenLPower = this.getSimvar("CIRCUIT ON:57", "bool", 1);
            this.valFuelGenLStatus = this.getSimvar("L:Hydrogen_1", "bool", 0);
            this.valFuelGenRPower = this.getSimvar("CIRCUIT ON:58", "bool", 1);
            this.valFuelGenRStatus = this.getSimvar("L:Hydrogen_2", "bool", 1);

            // APU
            this.valAPUMaster = this.getSimvar("L:QSR_APU_Master", "bool", 1);
            this.valAPURPM = this.getSimvar("L:QSR_APU_PCT", "number", 1);
            this.valAPUBleed = this.getSimvar("BLEED AIR APU", "bool", 0);

            // TESTS + MAINTENANCE
            this.valTestFCS_AVL = this.getSimvar("L:QSR_FCS_Test_AVL", "bool", 1);
            this.valTestFCS = this.getSimvar("L:QSR_FCS_Test", "bool", 1);
            this.valTestFCS_DONE = this.getSimvar("L:QSR_FCS_Test_DONE", "bool", 0);
            this.valTestFCS_FAIL = this.getSimvar("L:QSR_FCS_Test_FAIL", "bool", 0);
            this.valTestFCS_MOTION = this.getSimvar("L:QSR_FCS_Test_MOTION", "bool", 41);

            this.valTestVector_AVL = this.getSimvar("L:QSR_Vector_Test_AVL", "bool", 0);
            this.valTestVector = this.getSimvar("L:QSR_Vector_Test", "bool", 1);
            this.valTestVector_DONE = this.getSimvar("L:QSR_Vector_Test_DONE", "bool", 0);
            this.valTestVector_FAIL = this.getSimvar("L:QSR_Vector_Test_FAIL", "bool", 1);
            this.valTestVector_MOTION = this.getSimvar("L:QSR_Vector_Test_MOTION", "bool", 346);

            this.valTestMach_AVL = this.getSimvar("L:QSR_Mach_Test_AVL", "bool", 1);
            this.valTestMach = this.getSimvar("L:QSR_Mach_Test", "bool", 1);
            this.valTestMach_DONE = this.getSimvar("L:QSR_Mach_Test_DONE", "bool", 1);
            this.valTestMach_FAIL = this.getSimvar("L:QSR_Mach_Test_FAIL", "bool", 0);
            this.valTestMach_MOTION = this.getSimvar("L:QSR_Mach_Test_MOTION", "bool", 76);

            this.valMaintLDG = this.getSimvar("L:QSR_LG_Bay", "bool", 1);
            this.valMaintNuke = this.getSimvar("L:QSR_Nuke_Bay", "bool", 0);
            
            this.valTestOled = this.getSimvar("L:QSR_OLED_Test", "bool", 0);

            // ICE PROTECT
            this.valIceWShield = this.getSimvar("WINDSHIELD DEICE SWITCH", "bool", 0);
            this.valIceEng1 = this.getSimvar("ENG ANTI ICE:1", "bool", 0);
            this.valIceEng2 = this.getSimvar("ENG ANTI ICE:2", "bool", 0);
            this.valIceEng3 = this.getSimvar("ENG ANTI ICE:3", "bool", 0);
            this.valIceEng4 = this.getSimvar("ENG ANTI ICE:4", "bool", 0);

            // EXT LIGHTS
            this.valLightTaxi = this.getSimvar("LIGHT TAXI ON", "bool", 0);
            this.valLightNav = this.getSimvar("LIGHT NAV ON", "bool", 1);
            this.valLightStrobe = this.getSimvar("LIGHT STROBE ON", "bool", 1);
            this.valLightLdg = this.getSimvar("LIGHT LANDING ON", "bool", 1);
            this.valLightBeacon = this.getSimvar("LIGHT BEACON ON", "bool", 1);
            this.valLightRim = this.getSimvar("LIGHT WING ON:3", "bool", 0);

            // BREAKER BUSSES
            this.valBusAvionics = this.getSimvar("BUS BREAKER PULLED:10", "bool", 0);
            this.valBusLightLdg = this.getSimvar("BUS BREAKER PULLED:13", "bool", 0);
            this.valBusLightExt = this.getSimvar("BUS BREAKER PULLED:12", "bool", 0);
            this.valBusPressurization = this.getSimvar("BUS BREAKER PULLED:14", "bool", 0);

            // VARIOUS
            this.valPressurization = this.getSimvar("L:QSR_Pressurization_Auto", "bool", 0);
            this.valParkBrake = this.getSimvar("BRAKE PARKING POSITION", "bool", 0);
            this.valAvionics = this.getSimvar("CIRCUIT ON:18", "bool", 0);
            this.valCanopy = this.getSimvar("L:QSR_Canopy_Open", "bool", 1);
            this.valSeat = this.getSimvar("L:QSR_Ladder_Seat", "bool", 0);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-oled", QuasarOLED);
    
    /* Browser Format */
    // customElements.define('quasar-oled', QuasarOLED);