/* MSFS Format */
class nukeREACTOR extends BaseInstrument {

    /* Browser Format */
    // class nukeREACTOR extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "nukeREACTOR"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            this.nukeBus1Box = this.getId("nukeBus1Box");
            this.nukeBus1Con = this.getId("nukeBus1Con");
            this.nukeBus1Amps = this.getId("nukeBus1Amps");

            this.nukeBus2Box = this.getId("nukeBus2Box");
            this.nukeBus2Con = this.getId("nukeBus2Con");
            this.nukeBus2Amps = this.getId("nukeBus2Amps");

            this.nukeBus3Box = this.getId("nukeBus3Box");
            this.nukeBus3Con = this.getId("nukeBus3Con");
            this.nukeBus3Amps = this.getId("nukeBus3Amps");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
        
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats
        
        computeAndDraw() {


            // - Bus 1
            if (this.valBus1Con) {
                this.nukeBus1Box.classList.remove("nukeBusOFF");
                this.nukeBus1Con.classList.remove("nukeConOFF");
                this.nukeBus1Amps.classList.remove("nukeAmpsOFF");
                this.nukeBus1Con.innerHTML = 'CONNECTED - 25.4V';
                this.nukeBus1Amps.innerHTML = Math.abs(this.valBus1Amps.toFixed(0))+'A';
            }
            else {
                this.nukeBus1Box.classList.add("nukeBusOFF");
                this.nukeBus1Con.classList.add("nukeConOFF");
                this.nukeBus1Amps.classList.add("nukeAmpsOFF");
                this.nukeBus1Con.innerHTML = 'DISCONNECTED - 25.4V';
                this.nukeBus1Amps.innerHTML = '0A';
            }

            // - Bus 2
            if (this.valBus2Con) {
                this.nukeBus2Box.classList.remove("nukeBusOFF");
                this.nukeBus2Con.classList.remove("nukeConOFF");
                this.nukeBus2Amps.classList.remove("nukeAmpsOFF");
                this.nukeBus2Con.innerHTML = 'CONNECTED - 25.4V';
                this.nukeBus2Amps.innerHTML = Math.abs(this.valBus2Amps.toFixed(0))+'A';
            }
            else {
                this.nukeBus2Box.classList.add("nukeBusOFF");
                this.nukeBus2Con.classList.add("nukeConOFF");
                this.nukeBus2Amps.classList.add("nukeAmpsOFF");
                this.nukeBus2Con.innerHTML = 'DISCONNECTED - 25.4V';
                this.nukeBus2Amps.innerHTML = '0A';
            }

            // - Bus 3
            if (this.valBus3Con) {
                this.nukeBus3Box.classList.remove("nukeBusOFF");
                this.nukeBus3Con.classList.remove("nukeConOFF");
                this.nukeBus3Amps.classList.remove("nukeAmpsOFF");
                this.nukeBus3Con.innerHTML = 'CONNECTED - 25.4V';
                this.nukeBus3Amps.innerHTML = Math.abs(this.valBus3Amps.toFixed(0))+'A';
            }
            else {
                this.nukeBus3Box.classList.add("nukeBusOFF");
                this.nukeBus3Con.classList.add("nukeConOFF");
                this.nukeBus3Amps.classList.add("nukeAmpsOFF");
                this.nukeBus3Con.innerHTML = 'DISCONNECTED - 25.4V';
                this.nukeBus3Amps.innerHTML = '0A';
            }   
        }
    
        // Read variables from Sim
        allSimvars() {

            this.valBus1Con = this.getSimvar("ELECTRICAL MASTER BATTERY:3","bool", 1);
            this.valBus1Amps = this.getSimvar("ELECTRICAL MAIN BUS AMPS:5", "amperes", 141.1564);

            this.valBus2Con = this.getSimvar("ELECTRICAL MASTER BATTERY:4","bool", 1);
            this.valBus2Amps = this.getSimvar("ELECTRICAL MAIN BUS AMPS:6", "amperes", 141.1564);

            this.valBus3Con = this.getSimvar("ELECTRICAL MASTER BATTERY:5","bool", 0);
            this.valBus3Amps = this.getSimvar("ELECTRICAL MAIN BUS AMPS:7", "amperes", 0);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("nuclear-reactor", nukeREACTOR);
    
    /* Browser Format */
    // customElements.define('nuclear-reactor', nukeREACTOR);