/* MSFS Format */
class QuasarMULTI extends BaseInstrument {

    /* Browser Format */
    // class QuasarMULTI extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarMULTI"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            // Digipad
            this.digipadText = this.getId("digipadText");
            
            // Temperature
            this.tempCurrent = this.getId("tempCurrent");
            this.tempTarget = this.getId("tempTarget");

            // Fuel Ratio
            this.frLedMinus = this.getId("frLedMinus");
            this.frLedPlus = this.getId("frLedPlus");

            this.frBasic = this.getId("frBasic");
            this.frBasicText = this.getId("frBasicText");
            this.frBasicThrottlePct = this.getId("frBasicThrottlePct");
            this.frComb1 = this.getId("frComb1");
            this.frComb2 = this.getId("frComb2");
            this.frComb3 = this.getId("frComb3");
            this.frComb4 = this.getId("frComb4");
            this.frBasicFuelPct = this.getId("frBasicFuelPct");
            this.frFuel1 = this.getId("frFuel1");
            this.frFuel2 = this.getId("frFuel2");
            this.frFuel3 = this.getId("frFuel3");
            this.frFuel4 = this.getId("frFuel4");
            this.frFuel5 = this.getId("frFuel5");
            this.frFuel6 = this.getId("frFuel6");
            this.frFuel7 = this.getId("frFuel7");
            
            this.frAdvanced = this.getId("frAdvanced");
            this.frBurnText = this.getId("frBurnText");
            this.frProdText = this.getId("frProdText");
            this.frBurnBar = this.getId("frBurnBar");
            this.frProdBar = this.getId("frProdBar");    
            this.frTotalText = this.getId("frTotalText");
            this.frTotalCursor = this.getId("frTotalCursor");

            // EICAS
            this.apubleed = this.getId("apubleed");

            this.n1BarEng1 = this.getId("n1BarEng1");
            this.n2BarEng1 = this.getId("n2BarEng1");
            this.n1DigitEng1 = this.getId("n1DigitEng1");
            this.n2DigitEng1 = this.getId("n2DigitEng1");
            this.StarterEng1 = this.getId("StarterEng1");
            this.ABEng1 = this.getId("ABEng1");
            this.NoCombEng1 = this.getId("NoCombEng1");
            this.valveEng1 = this.getId("valveEng1");

            this.n1BarEng2 = this.getId("n1BarEng2");
            this.n2BarEng2 = this.getId("n2BarEng2");
            this.n1DigitEng2 = this.getId("n1DigitEng2");
            this.n2DigitEng2 = this.getId("n2DigitEng2");
            this.StarterEng2 = this.getId("StarterEng2");
            this.ABEng2 = this.getId("ABEng2");
            this.NoCombEng2 = this.getId("NoCombEng2");
            this.valveEng2 = this.getId("valveEng2");

            this.n1BarEng3 = this.getId("n1BarEng3");
            this.n2BarEng3 = this.getId("n2BarEng3");
            this.n1DigitEng3 = this.getId("n1DigitEng3");
            this.n2DigitEng3 = this.getId("n2DigitEng3");
            this.StarterEng3 = this.getId("StarterEng3");
            this.ABEng3 = this.getId("ABEng3");
            this.NoCombEng3 = this.getId("NoCombEng3");
            this.valveEng3 = this.getId("valveEng3");

            this.n1BarEng4 = this.getId("n1BarEng4");
            this.n2BarEng4 = this.getId("n2BarEng4");
            this.n1DigitEng4 = this.getId("n1DigitEng4");
            this.n2DigitEng4 = this.getId("n2DigitEng4");
            this.StarterEng4 = this.getId("StarterEng4");
            this.ABEng4 = this.getId("ABEng4");
            this.NoCombEng4 = this.getId("NoCombEng4");
            this.valveEng4 = this.getId("valveEng4");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
    
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats

        computeAndDraw() {

            // Digipad
            if (this.valDigipadOK || this.valCabinDeckOpened) {
                this.digipadText.innerHTML = 'OPENED';
            }
            else if (this.valDigipadKO) {
                this.digipadText.innerHTML = 'WRONG!';
            }
            else if (this.valGotcha) {
                this.digipadText.innerHTML = 'GOTCHA';
            }
            else {
                if (this.valDigipadCode == 0) {
                    this.digipadText.innerHTML = '______';
                }
                else {
                    var code = this.valDigipadCode+'_____';
                    code = code.substring(0,6);
                    this.digipadText.innerHTML = code;
                }
            }

            // Temperature
            if (!this.valCircuitAC) { this.tempTarget.classList.add('warning'); }
            else { this.tempTarget.classList.remove('warning'); }
            
            if (this.valTempUnitCelsius) {
                // Display in Celsius
                var tempCurrentC = this.valTempCurrent.toFixed(1);
                if (tempCurrentC < 0) { tempCurrentC = 0; }
                var tempTargetC = ((this.valTempTargetPCT * 10)+15).toFixed(1);

                this.tempCurrent.innerHTML = tempCurrentC+'C';
                this.tempTarget.innerHTML = tempTargetC+'C';

                // CSS colors
                if (Math.abs(tempCurrentC-tempTargetC) >= 5) { this.tempCurrent.classList.add('caution'); }
                else { this.tempCurrent.classList.remove('caution'); }
            }
            else {
                // Display in Fahrenheit
                var tempCurrentF = ((this.valTempCurrent*(9/5))+32).toFixed(1);
                if (tempCurrentF < 0) { tempCurrentF = 0; }
                var tempTargetF = ((((this.valTempTargetPCT * 10)+15)*(9/5))+32).toFixed(1);
                
                this.tempCurrent.innerHTML = tempCurrentF+'F';
                this.tempTarget.innerHTML = tempTargetF+'F';

                // CSS colors
                if (Math.abs(tempCurrentF-tempTargetF) >= 8) { this.tempCurrent.classList.add('caution'); }
                else { this.tempCurrent.classList.remove('caution'); }
            }

            // Fuel Ratio - CALC
            var frTotalGPM = parseInt(this.valFuelProdGPM - this.valFuelBurnGPM);

            if (frTotalGPM> 0) {
                var frSummary = '+'+frTotalGPM.toFixed(0)+' GPM';
                this.frBasicText.classList.remove('caution');
                this.frLedPlus.style.display='block';
                this.frLedMinus.style.display='none';
            }
            else {
                var frSummary = frTotalGPM.toFixed(0)+' GPM';
                this.frBasicText.classList.add('caution');
                this.frLedMinus.style.display='block';
                this.frLedPlus.style.display='none';    
            }


            //  Fuel Ratio - Display
            if (this.valFuelRatioMode == 1) {
                this.frBasic.style.display='block';
                this.frAdvanced.style.display='none';
    
                this.frBasicText.innerHTML = frSummary;

                var thrPercent = 0;
                var nbEngines = 0;

                if (!this.valCombustionEng1) { this.frComb1.classList.add('frEngineOff'); }
                else { 
                    this.frComb1.classList.remove('frEngineOff');
                    thrPercent += this.valTHRLVR_e1;
                    nbEngines += 1;
                }
                if (!this.valCombustionEng2) { this.frComb2.classList.add('frEngineOff'); }
                else {
                    this.frComb2.classList.remove('frEngineOff');
                    thrPercent += this.valTHRLVR_e2;
                    nbEngines += 1;
                }
                if (!this.valCombustionEng3) { this.frComb3.classList.add('frEngineOff'); }
                else { 
                    this.frComb3.classList.remove('frEngineOff');
                    thrPercent += this.valTHRLVR_e3;
                    nbEngines += 1;
                }
                if (!this.valCombustionEng4) { this.frComb4.classList.add('frEngineOff'); }
                else {
                    this.frComb4.classList.remove('frEngineOff');
                    thrPercent += this.valTHRLVR_e4;
                    nbEngines += 1;
                }

                if (nbEngines == 0) { this.frBasicThrottlePct.innerHTML = 'THR: 0'; }
                else {
                    thrPercent = (thrPercent/nbEngines).toFixed(0);
                    this.frBasicThrottlePct.innerHTML = 'THR: '+thrPercent;
                }

                var tank1pct = (this.valFuelQty1/this.valFuelCapacity1);
                if (tank1pct < 0.15) { this.frFuel1.classList.remove('frFuelLow'); this.frFuel1.classList.add('frFuelCrit'); }
                else if (tank1pct < 0.25) { this.frFuel1.classList.add('frFuelLow'); this.frFuel1.classList.remove('frFuelCrit'); }
                else { this.frFuel1.classList.remove('frFuelLow'); this.frFuel1.classList.remove('frFuelCrit'); }

                var tank2pct = (this.valFuelQty2/this.valFuelCapacity2);
                if (tank2pct < 0.15) { this.frFuel2.classList.remove('frFuelLow'); this.frFuel2.classList.add('frFuelCrit'); }
                else if (tank2pct < 0.25) { this.frFuel2.classList.add('frFuelLow'); this.frFuel2.classList.remove('frFuelCrit'); }
                else { this.frFuel2.classList.remove('frFuelLow'); this.frFuel2.classList.remove('frFuelCrit'); }

                var tank3pct = (this.valFuelQty3/this.valFuelCapacity3);
                if (tank3pct < 0.15) { this.frFuel3.classList.remove('frFuelLow'); this.frFuel3.classList.add('frFuelCrit'); }
                else if (tank3pct < 0.25) { this.frFuel3.classList.add('frFuelLow'); this.frFuel3.classList.remove('frFuelCrit'); }
                else { this.frFuel3.classList.remove('frFuelLow'); this.frFuel3.classList.remove('frFuelCrit'); }

                var tank4pct = (this.valFuelQty4/this.valFuelCapacity4);
                if (tank4pct < 0.15) { this.frFuel4.classList.remove('frFuelLow'); this.frFuel4.classList.add('frFuelCrit'); }
                else if (tank4pct < 0.25) { this.frFuel4.classList.add('frFuelLow'); this.frFuel4.classList.remove('frFuelCrit'); }
                else { this.frFuel4.classList.remove('frFuelLow'); this.frFuel4.classList.remove('frFuelCrit'); }

                var tank5pct = (this.valFuelQty5/this.valFuelCapacity5);
                if (tank5pct < 0.15) { this.frFuel5.classList.remove('frFuelLow'); this.frFuel5.classList.add('frFuelCrit'); }
                else if (tank5pct < 0.25) { this.frFuel5.classList.add('frFuelLow'); this.frFuel5.classList.remove('frFuelCrit'); }
                else { this.frFuel5.classList.remove('frFuelLow'); this.frFuel5.classList.remove('frFuelCrit'); }

                var tank6pct = (this.valFuelQty6/this.valFuelCapacity6);
                if (tank6pct < 0.15) { this.frFuel6.classList.remove('frFuelLow'); this.frFuel6.classList.add('frFuelCrit'); }
                else if (tank6pct < 0.25) { this.frFuel6.classList.add('frFuelLow'); this.frFuel6.classList.remove('frFuelCrit'); }
                else { this.frFuel6.classList.remove('frFuelLow'); this.frFuel6.classList.remove('frFuelCrit'); }

                var tank7pct = (this.valFuelQty7/this.valFuelCapacity7);
                if (tank7pct < 0.15) { this.frFuel7.classList.remove('frFuelLow'); this.frFuel7.classList.add('frFuelCrit'); }
                else if (tank7pct < 0.25) { this.frFuel7.classList.add('frFuelLow'); this.frFuel7.classList.remove('frFuelCrit'); }
                else { this.frFuel7.classList.remove('frFuelLow'); this.frFuel7.classList.remove('frFuelCrit'); }

                var fuelPercent = (((this.valFuelQty1 + this.valFuelQty2 + this.valFuelQty3 + this.valFuelQty4 +
                    this.valFuelQty5 + this.valFuelQty6 + this.valFuelQty7)/(this.valFuelCapacity1 + 
                        this.valFuelCapacity2 + this.valFuelCapacity3 + this.valFuelCapacity4 + this.valFuelCapacity5 + 
                        this.valFuelCapacity6 + this.valFuelCapacity7))*100).toFixed(0);

                this.frBasicFuelPct.innerHTML = 'FUEL: '+fuelPercent;
            }
            else {
                this.frAdvanced.style.display='block';
                this.frBasic.style.display='none';

                var fuelBurn = parseInt(this.valFuelBurnGPM.toFixed(0));
                var fuelProd = parseInt(this.valFuelProdGPM.toFixed(0));
                this.frBurnText.innerHTML = fuelBurn;
                this.frProdText.innerHTML = fuelProd;
                
                if (fuelBurn > 260) { fuelBurn = 260; }
                if (fuelProd > 260) { fuelProd = 260; }

                this.frBurnBar.style.width = fuelBurn+"px";
                this.frBurnBar.style.left = (289-fuelBurn)+"px";
                this.frProdBar.style.width = fuelProd+"px";

                var burnLeft = (289-fuelBurn);
                if (burnLeft > 209) { burnLeft = 200; }
                this.frBurnText.style.left = burnLeft+"px";

                var prodLeft = 289+fuelProd-60;
                if (prodLeft < 289+35) { prodLeft = 289+35; }
                this.frProdText.style.left = prodLeft+"px";
                this.frTotalText.innerHTML = frTotalGPM.toFixed(0);

                var totalPosition = parseInt(289+frTotalGPM);
                if (totalPosition < 30) { totalPosition = 30; }
                if (totalPosition > 545) { totalPosition = 545; }
                this.frTotalCursor.style.left = (totalPosition-7)+"px";
                this.frTotalText.style.left = (totalPosition-30)+"px";
            }

            // EICAS

            if (this.valAPUBleed) { this.apubleed.style.display = 'block'; }
            else { this.apubleed.style.display = 'none'; }

            // - engine 1
            var n1e1 = (45+(this.valN1Eng1*1.8));
            var n2e1 = (45+(this.valN2Eng1*1.8));
            this.n1BarEng1.style.transform = 'rotate('+n1e1+'deg)';
            this.n2BarEng1.style.transform = 'rotate('+n2e1+'deg)';
            this.n1DigitEng1.innerHTML = this.valN1Eng1.toFixed(0);
            this.n2DigitEng1.innerHTML = this.valN2Eng1.toFixed(0);

            if (this.valABEng1 && this.valCombustionEng1) { this.ABEng1.style.display = 'block'; }
            else { this.ABEng1.style.display = 'none'; }
            if (!this.valCombustionEng1) { this.NoCombEng1.style.display = 'block'; }
            else { this.NoCombEng1.style.display = 'none'; }
            if (this.valStarterEng1) { this.StarterEng1.style.display = 'block'; }
            else { this.StarterEng1.style.display = 'none'; }

            if (this.valFuelValveEng1) { this.valveEng1.style.display = 'none'; }
            else { this.valveEng1.style.display = 'block'; }

            if (this.valStarterEng1) {
                // STARTER: Light Grey bars
                this.n1BarEng1.style.borderBottom = '8px solid #aaaaaa';
                this.n2BarEng1.style.borderBottom = '8px solid #aaaaaa';
                this.n1BarEng1.style.borderRight = '8px solid #aaaaaa';
                this.n2BarEng1.style.borderRight = '8px solid #aaaaaa';
            }
            else if (!this.valCombustionEng1) {
                // No Combustion (no Starter): Dar red bars
                this.n1BarEng1.style.borderBottom = '8px solid #8b0000';
                this.n2BarEng1.style.borderBottom = '8px solid #8b0000';
                this.n1BarEng1.style.borderRight = '8px solid #8b0000';
                this.n2BarEng1.style.borderRight = '8px solid #8b0000';
            }
            else if (this.valABEng1) {
                // Afterburner: Light Red bars
                this.n1BarEng1.style.borderBottom = '8px solid #fb6c62';
                this.n2BarEng1.style.borderBottom = '8px solid #fb6c62';
                this.n1BarEng1.style.borderRight = '8px solid #fb6c62';
                this.n2BarEng1.style.borderRight = '8px solid #fb6c62';
            }
            else {
                // Default colors
                this.n1BarEng1.style.borderBottom = '8px solid #35dbed';
                this.n2BarEng1.style.borderBottom = '8px solid #35dbed';
                this.n1BarEng1.style.borderRight = '8px solid #35dbed';
                this.n2BarEng1.style.borderRight = '8px solid #35dbed';
            }

            // - engine 2
            var n1e2 = (45+(this.valN1Eng2*1.8));
            var n2e2 = (45+(this.valN2Eng2*1.8));
            this.n1BarEng2.style.transform = 'rotate('+n1e2+'deg)';
            this.n2BarEng2.style.transform = 'rotate('+n2e2+'deg)';
            this.n1DigitEng2.innerHTML = this.valN1Eng2.toFixed(0);
            this.n2DigitEng2.innerHTML = this.valN2Eng2.toFixed(0);

            if (this.valABEng2 && this.valCombustionEng2) { this.ABEng2.style.display = 'block'; }
            else { this.ABEng2.style.display = 'none'; }
            if (!this.valCombustionEng2) { this.NoCombEng2.style.display = 'block'; }
            else { this.NoCombEng2.style.display = 'none'; }
            if (this.valStarterEng2) { this.StarterEng2.style.display = 'block'; }
            else { this.StarterEng2.style.display = 'none'; }

            if (this.valFuelValveEng2) { this.valveEng2.style.display = 'none'; }
            else { this.valveEng2.style.display = 'block'; }

            if (this.valStarterEng2) {
                // STARTER: Light Grey bars
                this.n1BarEng2.style.borderBottom = '8px solid #aaaaaa';
                this.n2BarEng2.style.borderBottom = '8px solid #aaaaaa';
                this.n1BarEng2.style.borderRight = '8px solid #aaaaaa';
                this.n2BarEng2.style.borderRight = '8px solid #aaaaaa';
            }
            else if (!this.valCombustionEng2) {
                // No Combustion (no Starter): Dar red bars
                this.n1BarEng2.style.borderBottom = '8px solid #8b0000';
                this.n2BarEng2.style.borderBottom = '8px solid #8b0000';
                this.n1BarEng2.style.borderRight = '8px solid #8b0000';
                this.n2BarEng2.style.borderRight = '8px solid #8b0000';
            }
            else if (this.valABEng2) {
                // Afterburner: Light Red bars
                this.n1BarEng2.style.borderBottom = '8px solid #fb6c62';
                this.n2BarEng2.style.borderBottom = '8px solid #fb6c62';
                this.n1BarEng2.style.borderRight = '8px solid #fb6c62';
                this.n2BarEng2.style.borderRight = '8px solid #fb6c62';
            }
            else {
                // Default colors
                this.n1BarEng2.style.borderBottom = '8px solid #35dbed';
                this.n2BarEng2.style.borderBottom = '8px solid #35dbed';
                this.n1BarEng2.style.borderRight = '8px solid #35dbed';
                this.n2BarEng2.style.borderRight = '8px solid #35dbed';
            }

            // - engine 3
            var n1e3 = (45+(this.valN1Eng3*1.8));
            var n2e3 = (45+(this.valN2Eng3*1.8));
            this.n1BarEng3.style.transform = 'rotate('+n1e3+'deg)';
            this.n2BarEng3.style.transform = 'rotate('+n2e3+'deg)';
            this.n1DigitEng3.innerHTML = this.valN1Eng3.toFixed(0);
            this.n2DigitEng3.innerHTML = this.valN2Eng3.toFixed(0);

            if (this.valABEng3 && this.valCombustionEng3) { this.ABEng3.style.display = 'block'; }
            else { this.ABEng3.style.display = 'none'; }
            if (!this.valCombustionEng3) { this.NoCombEng3.style.display = 'block'; }
            else { this.NoCombEng3.style.display = 'none'; }
            if (this.valStarterEng3) { this.StarterEng3.style.display = 'block'; }
            else { this.StarterEng3.style.display = 'none'; }

            if (this.valFuelValveEng3) { this.valveEng3.style.display = 'none'; }
            else { this.valveEng3.style.display = 'block'; }

            if (this.valStarterEng3) {
                // STARTER: Light Grey bars
                this.n1BarEng3.style.borderBottom = '8px solid #aaaaaa';
                this.n2BarEng3.style.borderBottom = '8px solid #aaaaaa';
                this.n1BarEng3.style.borderRight = '8px solid #aaaaaa';
                this.n2BarEng3.style.borderRight = '8px solid #aaaaaa';
            }
            else if (!this.valCombustionEng3) {
                // No Combustion (no Starter): Dar red bars
                this.n1BarEng3.style.borderBottom = '8px solid #8b0000';
                this.n2BarEng3.style.borderBottom = '8px solid #8b0000';
                this.n1BarEng3.style.borderRight = '8px solid #8b0000';
                this.n2BarEng3.style.borderRight = '8px solid #8b0000';
            }
            else if (this.valABEng3) {
                // Afterburner: Light Red bars
                this.n1BarEng3.style.borderBottom = '8px solid #fb6c62';
                this.n2BarEng3.style.borderBottom = '8px solid #fb6c62';
                this.n1BarEng3.style.borderRight = '8px solid #fb6c62';
                this.n2BarEng3.style.borderRight = '8px solid #fb6c62';
            }
            else {
                // Default colors
                this.n1BarEng3.style.borderBottom = '8px solid #35dbed';
                this.n2BarEng3.style.borderBottom = '8px solid #35dbed';
                this.n1BarEng3.style.borderRight = '8px solid #35dbed';
                this.n2BarEng3.style.borderRight = '8px solid #35dbed';
            }

            // - engine 4
            var n1e4 = (45+(this.valN1Eng4*1.8));
            var n2e4 = (45+(this.valN2Eng4*1.8));
            this.n1BarEng4.style.transform = 'rotate('+n1e4+'deg)';
            this.n2BarEng4.style.transform = 'rotate('+n2e4+'deg)';
            this.n1DigitEng4.innerHTML = this.valN1Eng4.toFixed(0);
            this.n2DigitEng4.innerHTML = this.valN2Eng4.toFixed(0);

            if (this.valABEng4 && this.valCombustionEng4) { this.ABEng4.style.display = 'block'; }
            else { this.ABEng4.style.display = 'none'; }
            if (!this.valCombustionEng4) { this.NoCombEng4.style.display = 'block'; }
            else { this.NoCombEng4.style.display = 'none'; }
            if (this.valStarterEng4) { this.StarterEng4.style.display = 'block'; }
            else { this.StarterEng4.style.display = 'none'; }

            if (this.valFuelValveEng4) { this.valveEng4.style.display = 'none'; }
            else { this.valveEng4.style.display = 'block'; }

            if (this.valStarterEng4) {
                // STARTER: Light Grey bars
                this.n1BarEng4.style.borderBottom = '8px solid #aaaaaa';
                this.n2BarEng4.style.borderBottom = '8px solid #aaaaaa';
                this.n1BarEng4.style.borderRight = '8px solid #aaaaaa';
                this.n2BarEng4.style.borderRight = '8px solid #aaaaaa';
            }
            else if (!this.valCombustionEng4) {
                // No Combustion (no Starter): Dar red bars
                this.n1BarEng4.style.borderBottom = '8px solid #8b0000';
                this.n2BarEng4.style.borderBottom = '8px solid #8b0000';
                this.n1BarEng4.style.borderRight = '8px solid #8b0000';
                this.n2BarEng4.style.borderRight = '8px solid #8b0000';
            }
            else if (this.valABEng4) {
                // Afterburner: Light Red bars
                this.n1BarEng4.style.borderBottom = '8px solid #fb6c62';
                this.n2BarEng4.style.borderBottom = '8px solid #fb6c62';
                this.n1BarEng4.style.borderRight = '8px solid #fb6c62';
                this.n2BarEng4.style.borderRight = '8px solid #fb6c62';
            }
            else {
                // Default colors
                this.n1BarEng4.style.borderBottom = '8px solid #35dbed';
                this.n2BarEng4.style.borderBottom = '8px solid #35dbed';
                this.n1BarEng4.style.borderRight = '8px solid #35dbed';
                this.n2BarEng4.style.borderRight = '8px solid #35dbed';
            }
        }
    
        // Read variables from Sim
        allSimvars() {

            // Digipad
            this.valDigipadCode = this.getSimvar("L:Digipad_code", "number", 653);
            this.valDigipadOK = this.getSimvar("L:QSR_Digipad_OK", "bool", 0);
            this.valDigipadKO = this.getSimvar("L:QSR_Digipad_KO", "bool", 0);
            this.valCabinDeckOpened = this.getSimvar("L:QSR_Cabin_Deck_Open", "bool", 0);
            this.valGotcha = this.getSimvar("L:QSR_Gotcha", "bool", 0);

            // Temperature
            this.valTempTargetPCT = this.getSimvar("L:QSR_Temp_Target_PCT", "number", 0.65);
            this.valTempCurrent = this.getSimvar("L:QSR_Temp_Current", "number", 19.354);
            this.valTempUnitCelsius = this.getSimvar("L:FRIES_TempUnit_Celsius", "bool", 1);
            this.valCircuitAC = this.getSimvar("CIRCUIT ON:45", "bool", 0);

            // Fuel Ratio
            this.valFuelRatioMode = this.getSimvar("L:QSR_FuelRatio_Display", "bool", 1);
            this.valFuelProdGPM = this.getSimvar("L:QSR_FuelRatio_Prod_GPM", "number", 34.12341);
            this.valFuelBurnGPM = this.getSimvar("L:QSR_FuelRatio_Burn_GPM", "number", 282.0121);
            
            this.valTHRLVR_e1 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:1", "percent", 100);
            this.valTHRLVR_e2 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:2", "percent", 0);
            this.valTHRLVR_e3 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:3", "percent", 45.454);
            this.valTHRLVR_e4 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:4", "percent", 45.454);

            this.valFuelCapacity1 = this.getSimvar("FUELSYSTEM TANK CAPACITY:1", "gallons", 500);
            this.valFuelCapacity2 = this.getSimvar("FUELSYSTEM TANK CAPACITY:2", "gallons", 500);
            this.valFuelCapacity3 = this.getSimvar("FUELSYSTEM TANK CAPACITY:3", "gallons", 1500);
            this.valFuelCapacity4 = this.getSimvar("FUELSYSTEM TANK CAPACITY:4", "gallons", 250);
            this.valFuelCapacity5 = this.getSimvar("FUELSYSTEM TANK CAPACITY:5", "gallons", 250);
            this.valFuelCapacity6 = this.getSimvar("FUELSYSTEM TANK CAPACITY:6", "gallons", 250);
            this.valFuelCapacity7 = this.getSimvar("FUELSYSTEM TANK CAPACITY:7", "gallons", 250);
            
            this.valFuelQty1 = this.getSimvar("FUELSYSTEM TANK QUANTITY:1", "gallons", 74.9);
            this.valFuelQty2 = this.getSimvar("FUELSYSTEM TANK QUANTITY:2", "gallons", 0);
            this.valFuelQty3 = this.getSimvar("FUELSYSTEM TANK QUANTITY:3", "gallons", 760);
            this.valFuelQty4 = this.getSimvar("FUELSYSTEM TANK QUANTITY:4", "gallons", 250);
            this.valFuelQty5 = this.getSimvar("FUELSYSTEM TANK QUANTITY:5", "gallons", 250);
            this.valFuelQty6 = this.getSimvar("FUELSYSTEM TANK QUANTITY:6", "gallons", 250);
            this.valFuelQty7 = this.getSimvar("FUELSYSTEM TANK QUANTITY:7", "gallons", 250);

            // EICAS
            this.valAPUBleed = this.getSimvar("BLEED AIR APU", "bool", 1);

            this.valN1Eng1 = this.getSimvar("ENG N1 RPM:1", "percent", 9);
            this.valN2Eng1 = this.getSimvar("ENG N2 RPM:1", "percent", 25);
            this.valStarterEng1 = this.getSimvar("GENERAL ENG STARTER ACTIVE:1", "bool", 1);
            this.valCombustionEng1 = this.getSimvar("GENERAL ENG COMBUSTION:1", "bool", 1);
            this.valFuelValveEng1 = this.getSimvar("FUELSYSTEM VALVE SWITCH:8", "bool", 1);
            this.valABEng1 = this.getSimvar("TURB ENG AFTERBURNER:1", "bool", 1);

            this.valN1Eng2 = this.getSimvar("ENG N1 RPM:2", "percent", 9);
            this.valN2Eng2 = this.getSimvar("ENG N2 RPM:2", "percent", 25);
            this.valStarterEng2 = this.getSimvar("GENERAL ENG STARTER ACTIVE:2", "bool", 1);
            this.valCombustionEng2 = this.getSimvar("GENERAL ENG COMBUSTION:2", "bool", 0);
            this.valFuelValveEng2 = this.getSimvar("FUELSYSTEM VALVE SWITCH:9", "bool", 0);
            this.valABEng2 = this.getSimvar("TURB ENG AFTERBURNER:2", "bool", 0);

            this.valN1Eng3 = this.getSimvar("ENG N1 RPM:3", "percent", 8);
            this.valN2Eng3 = this.getSimvar("ENG N2 RPM:3", "percent", 7);
            this.valStarterEng3 = this.getSimvar("GENERAL ENG STARTER ACTIVE:3", "bool", 0);
            this.valCombustionEng3 = this.getSimvar("GENERAL ENG COMBUSTION:3", "bool", 0);
            this.valFuelValveEng3 = this.getSimvar("FUELSYSTEM VALVE SWITCH:10", "bool", 1);
            this.valABEng3 = this.getSimvar("TURB ENG AFTERBURNER:3", "bool", 0);

            this.valN1Eng4 = this.getSimvar("ENG N1 RPM:4", "percent", 62);
            this.valN2Eng4 = this.getSimvar("ENG N2 RPM:4", "percent", 78);
            this.valStarterEng4 = this.getSimvar("GENERAL ENG STARTER ACTIVE:4", "bool", 0);
            this.valCombustionEng4 = this.getSimvar("GENERAL ENG COMBUSTION:4", "bool", 1);
            this.valFuelValveEng4 = this.getSimvar("FUELSYSTEM VALVE SWITCH:11", "bool", 1);
            this.valABEng4 = this.getSimvar("TURB ENG AFTERBURNER:4", "bool", 0);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-multi", QuasarMULTI);
    
    /* Browser Format */
    // customElements.define('quasar-multi', QuasarMULTI);