/* MSFS Format */
class QuasarSTATUS extends BaseInstrument {

    /* Browser Format */
    // class QuasarSTATUS extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarSTATUS"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            this.pageTrims = this.getId("pageTrims");
            this.elevValue = this.getId("elevValue");
            this.rudderValue = this.getId("rudderValue");
            this.ailerValue = this.getId("ailerValue");
            this.trimCursorElev = this.getId("trimCursorElev");
            this.trimCursorRud = this.getId("trimCursorRud");
            this.trimCursorAil = this.getId("trimCursorAil");

            this.pageRange = this.getId("pageRange");
            this.rangeNMbox = this.getId("rangeNMbox");
            this.rangeTIMEbox = this.getId("rangeTIMEbox");

            this.pageCruise = this.getId("pageCruise");
            this.gsbox = this.getId("gsbox");
            this.machbox = this.getId("machbox");
            this.altbox = this.getId("altbox");
            this.flbox = this.getId("flbox");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
    
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats    

        warn(text) {
            return '<span class="warning">'+text+'</span><br/>';
        }
        caution(text) {
            return '<span class="caution">'+text+'</span><br/>';
        }

        computeAndDraw() {

            // --------------- COMPUTE ---------------           

            /* --- 1: RANGE --- */

            var totalQty = (this.valFuelQty1 + this.valFuelQty2 + this.valFuelQty3 + this.valFuelQty4 + this.valFuelQty5 + this.valFuelQty6 + this.valFuelQty7);
            var totalFuelFlow = (this.valEngFuelFlow1 + this.valEngFuelFlow2 + this.valEngFuelFlow3 + this.valEngFuelFlow4);
            var totalFuelProd = (this.valFuelProduction1 + this.valFuelProduction2) * 60; // From gallons per minute to gallons per hour

            var resultFuelFlow = (totalFuelFlow - totalFuelProd);

            if (resultFuelFlow <= 0) {
                var rangeNMtext = 'UNLIMITED';
                var rangeTIMEtext = 'UNLIMITED';
            }
            else {

                // Range: TIME
                var rangeTIME = totalQty/resultFuelFlow;
                if (rangeTIME >= 1) {
                    if (rangeTIME > 24) {
                       var rangeTIMEtext = '1 DAY +';
                    }
                    else {

                        var minutes = '00'+((rangeTIME-Math.floor(rangeTIME))*60).toFixed(0);
                        minutes = minutes.substring(minutes.length-2);
                        var rangeTIMEtext = ''+Math.floor(rangeTIME)+' HRS '+minutes+' MNS';
                    }
                }
                else {
                    if ((rangeTIME*60).toFixed(0) > 1) {
                        var rangeTIMEtext = ''+(rangeTIME*60).toFixed(0)+' MNS';
                    }
                    else {
                        var rangeTIMEtext = 'DANGER: 0 MN';

                    }
                }

                // Range: DISTANCE
                var rangeNM = rangeTIME*this.valGS;
                if (rangeNM > 1000) {
                    if (rangeNM > 99000) {
                        var rangeNMtext = 'A LOT!';
                    }
                    else {
                        
                        var units = ('000'+(rangeNM-(Math.floor(rangeNM/1000)*1000)).toFixed(0));
                        units = units.substring(units.length-3);
                        var rangeNMtext = ''+Math.floor(rangeNM/1000)+','+units+' NM';
                    }
                }
                else {
                    if (rangeNM.toFixed(0) > 1) {
                        var rangeNMtext = rangeNM.toFixed(0)+' NM';
                    }
                    else {
                        var rangeNMtext = 'DANGER: 0 NM';
                    }
                }
            }

            /* --- 2: CRUISE --- */

            // -- Ground speed
            this.valGS = Math.round(this.valGS);
            if (this.valGS >= 1000) {
                var units = ('000'+(this.valGS-(Math.floor(this.valGS/1000)*1000)));
                units = units.substring(units.length-3);
                var gstext = ''+Math.floor(this.valGS/1000)+','+units+' KTS';
            }
            else {
                var gstext = this.valGS+' KTS';
            }

            // -- MACH
            if (this.valMach >= 10) {
                var machtext = 'MACH '+this.valMach.toFixed(1);
            }
            else if (this.valMach >= 0.3) {
                var machtext = 'MACH '+this.valMach.toFixed(2);
            }
            else {
                var machtext = 'MACH --';
            }

            // -- Altitude
            // Round ALTITUDE to 10 feet
            if (this.valAlt > 9999990) { this.valAlt = 9999990; }
            this.valAlt = Math.round(this.valAlt/10)*10;
            this.valAlt = this.valAlt-(this.valAlt%10);


            let strAlt = ''+this.valAlt;
            var alttext = ' FT';
            for(let i=0; i<strAlt.length; i++) {
                alttext = strAlt.substring(strAlt.length-1-i,strAlt.length-i)+alttext;
                if ((i+1)%3 == 0 && i < strAlt.length-1) alttext = ','+alttext;

            }

            // -- Flight Level
            if (this.valAlt < 1000) {
                var fltext = 'FL --';
            }
            else {

                if (this.valAlt < 20000) {
                    // Round to 500 feet below 20'000 ft
                    var modulo = (this.valAlt/1000)%0.5;
                    if (modulo >= 0.25) { var altFL = this.valAlt-(modulo*1000)+500; }
                    else { var altFL = this.valAlt-(modulo*1000); }
                    altFL = altFL/100;

                    var units = ('000'+altFL);
                    units = units.substring(units.length-3);
                    
                    var fltext = 'FL '+units;
                }
                else {
                    // Round to 1000 feet from 20'000 ft and above
                    var altFL = Math.round(this.valAlt/1000)*1000;
                    altFL = (altFL-(altFL%10))/100;

                    if (altFL >= 1000) {
                        var units = ('000'+(altFL-(Math.floor(altFL/1000)*1000)));
                        units = units.substring(units.length-3);
                        var fltext = 'FL '+Math.floor(altFL/1000)+','+units;
                    }
                    else {
                        var fltext = 'FL '+altFL;
                    }
                }
            }

            // --------------- DRAW ---------------

            // DISPLAY THE CORRECT PAGE...

            switch (this.valScreen) {
                case 1:
                    this.pageRange.style.display = 'block';
                    this.pageTrims.style.display = 'none';
                    this.pageCruise.style.display = 'none';
                    break;
                case 2:
                    this.pageCruise.style.display = 'block';
                    this.pageTrims.style.display = 'none';
                    this.pageRange.style.display = 'none';
                    break;
                default:
                    this.pageTrims.style.display = 'block';
                    this.pageRange.style.display = 'none';
                    this.pageCruise.style.display = 'none';
            }

            /* --- 0: TRIMS --- */
            this.elevValue.innerHTML = this.valElevatorTrim.toFixed(2);
            this.rudderValue.innerHTML = this.valRudderTrim.toFixed(2);
            this.ailerValue.innerHTML = this.valAileronTrim.toFixed(2);

            this.trimCursorElev.style.left = (87+(this.valElevatorTrim*81))+"px";
            this.trimCursorRud.style.left = (266+(this.valRudderTrim*81))+"px";
            this.trimCursorAil.style.left = (266+(this.valAileronTrim*81))+"px";
            
            
            /* --- 1: RANGE --- */


            // Range CSS: TIME
            this.rangeTIMEbox.innerHTML = rangeTIMEtext;
            if (rangeTIME > 1) {
                this.rangeTIMEbox.classList.remove('warning');
                this.rangeTIMEbox.classList.remove('caution');
            }
            else {
                if (rangeTIME < 0.3) {
                this.rangeTIMEbox.classList.add('warning');
                this.rangeTIMEbox.classList.remove('caution');
                }
                else {
                    this.rangeTIMEbox.classList.add('caution');
                    this.rangeTIMEbox.classList.remove('warning');
                }
            }

            // Range CSS: DISTANCE
            this.rangeNMbox.innerHTML = rangeNMtext;
            if (rangeNM > 300) {
                this.rangeNMbox.classList.remove('warning');
                this.rangeNMbox.classList.remove('caution');
            }
            else {
                if (rangeNM < 100) {
                this.rangeNMbox.classList.add('warning');
                this.rangeNMbox.classList.remove('caution');
                }
                else {
                    this.rangeNMbox.classList.add('caution');
                    this.rangeNMbox.classList.remove('warning');
                }
            }

            /* --- 2: CRUISE --- */
            this.altbox.innerHTML = alttext;
            this.gsbox.innerHTML = gstext;
            this.machbox.innerHTML = machtext;
            this.flbox.innerHTML = fltext;
        }
    
        // Read variables from Sim
        allSimvars() {

            this.valScreen = this.getSimvar("L:QSR_Status_Screen", "number", 2); // 0: Trims - 1: Range - 2: Cruise

            /* --- 0: TRIMS --- */

            this.valElevatorTrim = Math.min(Math.max(this.getSimvar("ELEVATOR TRIM PCT","percent over 100", -0.54),-1),1);
            this.valRudderTrim = Math.min(Math.max(this.getSimvar("RUDDER TRIM PCT","percent over 100", 0.573144),-1),1);
            this.valAileronTrim = Math.min(Math.max(this.getSimvar("AILERON TRIM PCT","percent over 100", -0.78520),-1),1);  

            /* --- 1: RANGE --- */

            this.valFuelQty1 = this.getSimvar("FUELSYSTEM TANK QUANTITY:1", "gallons", 100);
            this.valFuelQty2 = this.getSimvar("FUELSYSTEM TANK QUANTITY:2", "gallons", 400);
            this.valFuelQty3 = this.getSimvar("FUELSYSTEM TANK QUANTITY:3", "gallons", 400);
            this.valFuelQty4 = this.getSimvar("FUELSYSTEM TANK QUANTITY:4", "gallons", 200);
            this.valFuelQty5 = this.getSimvar("FUELSYSTEM TANK QUANTITY:5", "gallons", 200);
            this.valFuelQty6 = this.getSimvar("FUELSYSTEM TANK QUANTITY:6", "gallons", 200);
            this.valFuelQty7 = this.getSimvar("FUELSYSTEM TANK QUANTITY:7", "gallons", 200);

            this.valEngFuelFlow1 = this.getSimvar("ENG FUEL FLOW GPH:1", "gallons per hour", 1400);
            this.valEngFuelFlow2 = this.getSimvar("ENG FUEL FLOW GPH:2", "gallons per hour", 845);
            this.valEngFuelFlow3 = this.getSimvar("ENG FUEL FLOW GPH:3", "gallons per hour", 845);
            this.valEngFuelFlow4 = this.getSimvar("ENG FUEL FLOW GPH:4", "gallons per hour", 845);

            this.valFuelProduction1 = this.getSimvar("L:QSR_FuelProd_L", "number", 12); // gallons per minute
            this.valFuelProduction2 = this.getSimvar("L:QSR_FuelProd_R", "number", 12); // gallons per minute

            this.valGS = this.getSimvar("GROUND VELOCITY", "knots", 5201.52);

            /* --- 2: CRUISE --- */

            this.valMach = this.getSimvar("AIRSPEED MACH", "mach", 7.812631);
            this.valAlt = this.getSimvar("PLANE ALTITUDE", "feet", 5100200);


            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-status", QuasarSTATUS);
    
    /* Browser Format */
    // customElements.define('quasar-status', QuasarSTATUS);