/* MSFS Format */
class QuasarFUEL extends BaseInstrument {

    /* Browser Format */
    // class QuasarFUEL extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarFUEL"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            this.tank1 = this.getId("tank1");
            this.tank2 = this.getId("tank2");
            this.tank3 = this.getId("tank3");
            this.tank4 = this.getId("tank4");
            this.tank5 = this.getId("tank5");
            this.tank6 = this.getId("tank6");
            this.tank7 = this.getId("tank7");
            this.tank1pct = this.getId("tank1pct");
            this.tank2pct = this.getId("tank2pct");
            this.tank3pct = this.getId("tank3pct");
            this.tank4pct = this.getId("tank4pct");
            this.tank5pct = this.getId("tank5pct");
            this.tank6pct = this.getId("tank6pct");
            this.tank7pct = this.getId("tank7pct");
            this.tank1empty = this.getId("tank1empty");
            this.tank2empty = this.getId("tank2empty");
            this.tank3empty = this.getId("tank3empty");
            this.tank4empty = this.getId("tank4empty");
            this.tank5empty = this.getId("tank5empty");
            this.tank6empty = this.getId("tank6empty");
            this.tank7empty = this.getId("tank7empty");
            this.tank1tag = this.getId("tank1tag");
            this.tank2tag = this.getId("tank2tag");
            this.tank3tag = this.getId("tank3tag");
            this.tank4tag = this.getId("tank4tag");
            this.tank5tag = this.getId("tank5tag");
            this.tank6tag = this.getId("tank6tag");
            this.tank7tag = this.getId("tank7tag");

            this.tank1summary = this.getId("tank1summary");
            this.tank2summary = this.getId("tank2summary");
            this.tank3summary = this.getId("tank3summary");
            this.tank4summary = this.getId("tank4summary");
            this.tank5summary = this.getId("tank5summary");
            this.tank6summary = this.getId("tank6summary");
            this.tank7summary = this.getId("tank7summary");
            this.tankAllsummary = this.getId("tankAllsummary");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
    
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats    

        computeAndDraw() {

            // Calculate Sums + Percentages
            var tank1pct = (this.valFuelQty1 / this.valFuelCapacity1) * 100;
            var tank2pct = (this.valFuelQty2 / this.valFuelCapacity2) * 100;
            var tank3pct = (this.valFuelQty3 / this.valFuelCapacity3) * 100;
            var tank4pct = (this.valFuelQty4 / this.valFuelCapacity4) * 100;
            var tank5pct = (this.valFuelQty5 / this.valFuelCapacity5) * 100;
            var tank6pct = (this.valFuelQty6 / this.valFuelCapacity6) * 100;
            var tank7pct = (this.valFuelQty7 / this.valFuelCapacity7) * 100;
            var totalQty = (this.valFuelQty1 + this.valFuelQty2 + this.valFuelQty3 + this.valFuelQty4 + this.valFuelQty5 + this.valFuelQty6 + this.valFuelQty7);
            var totalCapacity = (this.valFuelCapacity1 + this.valFuelCapacity2 + this.valFuelCapacity3 + this.valFuelCapacity4 + this.valFuelCapacity5 + this.valFuelCapacity6 + this.valFuelCapacity7);
            var tankTotalpct = (totalQty / totalCapacity)*100;

            // Display values
            this.tank1pct.innerHTML = tank1pct.toFixed(0);
            this.tank2pct.innerHTML = tank2pct.toFixed(0);
            this.tank3pct.innerHTML = tank3pct.toFixed(0);
            this.tank4pct.innerHTML = tank4pct.toFixed(0);
            this.tank5pct.innerHTML = tank5pct.toFixed(0);
            this.tank6pct.innerHTML = tank6pct.toFixed(0);
            this.tank7pct.innerHTML = tank7pct.toFixed(0);

            this.tank1summary.innerHTML = '1: '+this.valFuelQty1.toFixed(0)+'/'+this.valFuelCapacity1.toFixed(0)+' GALS';
            this.tank2summary.innerHTML = '2: '+this.valFuelQty2.toFixed(0)+'/'+this.valFuelCapacity2.toFixed(0)+' GALS';
            this.tank3summary.innerHTML = '3: '+this.valFuelQty3.toFixed(0)+'/'+this.valFuelCapacity3.toFixed(0)+' GALS';
            this.tank4summary.innerHTML = '4: '+this.valFuelQty4.toFixed(0)+'/'+this.valFuelCapacity4.toFixed(0)+' GALS';
            this.tank5summary.innerHTML = '5: '+this.valFuelQty5.toFixed(0)+'/'+this.valFuelCapacity5.toFixed(0)+' GALS';
            this.tank6summary.innerHTML = '6: '+this.valFuelQty6.toFixed(0)+'/'+this.valFuelCapacity6.toFixed(0)+' GALS';
            this.tank7summary.innerHTML = '7: '+this.valFuelQty7.toFixed(0)+'/'+this.valFuelCapacity7.toFixed(0)+' GALS';
            this.tankAllsummary.innerHTML = 'TOTAL: '+totalQty.toFixed(0)+'/'+totalCapacity.toFixed(0)+' GALS / '+tankTotalpct.toFixed(0)+' PCT';

            // Display graphs
            this.tank1empty.style.height = (114 * ((100 - tank1pct) / 100)).toFixed(0)+'px';
            this.tank2empty.style.height = (114 * ((100 - tank2pct) / 100)).toFixed(0)+'px';
            this.tank3empty.style.height = (114 * ((100 - tank3pct) / 100)).toFixed(0)+'px';
            this.tank4empty.style.height = (57 * ((100 - tank4pct) / 100)).toFixed(0)+'px';
            this.tank5empty.style.height = (57 * ((100 - tank5pct) / 100)).toFixed(0)+'px';
            this.tank6empty.style.height = (57 * ((100 - tank6pct) / 100)).toFixed(0)+'px';
            this.tank7empty.style.height = (57 * ((100 - tank7pct) / 100)).toFixed(0)+'px';

            // CSS warning/cautions

            // TANK 1
            if (tank1pct < 25) {
                if (tank1pct < 15) {
                    this.tank1tag.classList.add('emptyTag');
                    this.tank1tag.classList.remove('lowTag');
                    this.tank1.classList.add('emptyTank');
                    this.tank1.classList.remove('lowTank');
                    this.tank1summary.classList.add('emptyTag');
                    this.tank1summary.classList.remove('lowTag');
                }
                else {
                    this.tank1tag.classList.add('lowTag');
                    this.tank1tag.classList.remove('emptyTag');
                    this.tank1.classList.add('lowTank');
                    this.tank1.classList.remove('emptyTank');
                    this.tank1summary.classList.add('lowTag');
                    this.tank1summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank1tag.classList.remove('lowTag');
                this.tank1tag.classList.remove('emptyTag');
                this.tank1.classList.remove('lowTank');
                this.tank1.classList.remove('emptyTank');
                this.tank1summary.classList.remove('lowTag');
                this.tank1summary.classList.remove('emptyTag');
            }
            
            // TANK 2
            if (tank2pct < 25) {
                if (tank2pct < 15) {
                    this.tank2tag.classList.add('emptyTag');
                    this.tank2tag.classList.remove('lowTag');
                    this.tank2.classList.add('emptyTank');
                    this.tank2.classList.remove('lowTank');
                    this.tank2summary.classList.add('emptyTag');
                    this.tank2summary.classList.remove('lowTag');
                }
                else {
                    this.tank2tag.classList.add('lowTag');
                    this.tank2tag.classList.remove('emptyTag');
                    this.tank2.classList.add('lowTank');
                    this.tank2.classList.remove('emptyTank');
                    this.tank2summary.classList.add('lowTag');
                    this.tank2summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank2tag.classList.remove('lowTag');
                this.tank2tag.classList.remove('emptyTag');
                this.tank2.classList.remove('lowTank');
                this.tank2.classList.remove('emptyTank');
                this.tank2summary.classList.remove('lowTag');
                this.tank2summary.classList.remove('emptyTag');
            }
            
            // TANK 3
            if (tank3pct < 25) {
                if (tank3pct < 15) {
                    this.tank3tag.classList.add('emptyTag');
                    this.tank3tag.classList.remove('lowTag');
                    this.tank3.classList.add('emptyTank');
                    this.tank3.classList.remove('lowTank');
                    this.tank3summary.classList.add('emptyTag');
                    this.tank3summary.classList.remove('lowTag');
                }
                else {
                    this.tank3tag.classList.add('lowTag');
                    this.tank3tag.classList.remove('emptyTag');
                    this.tank3.classList.add('lowTank');
                    this.tank3.classList.remove('emptyTank');
                    this.tank3summary.classList.add('lowTag');
                    this.tank3summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank3tag.classList.remove('lowTag');
                this.tank3tag.classList.remove('emptyTag');
                this.tank3.classList.remove('lowTank');
                this.tank3.classList.remove('emptyTank');
                this.tank3summary.classList.remove('lowTag');
                this.tank3summary.classList.remove('emptyTag');
            }
            
            // TANK 4
            if (tank4pct < 25) {
                if (tank4pct < 15) {
                    this.tank4tag.classList.add('emptyTag');
                    this.tank4tag.classList.remove('lowTag');
                    this.tank4.classList.add('emptyTank');
                    this.tank4.classList.remove('lowTank');
                    this.tank4summary.classList.add('emptyTag');
                    this.tank4summary.classList.remove('lowTag');
                }
                else {
                    this.tank4tag.classList.add('lowTag');
                    this.tank4tag.classList.remove('emptyTag');
                    this.tank4.classList.add('lowTank');
                    this.tank4.classList.remove('emptyTank');
                    this.tank4summary.classList.add('lowTag');
                    this.tank4summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank4tag.classList.remove('lowTag');
                this.tank4tag.classList.remove('emptyTag');
                this.tank4.classList.remove('lowTank');
                this.tank4.classList.remove('emptyTank');
                this.tank4summary.classList.remove('lowTag');
                this.tank4summary.classList.remove('emptyTag');
            }
            
            // TANK 5
            if (tank5pct < 25) {
                if (tank5pct < 15) {
                    this.tank5tag.classList.add('emptyTag');
                    this.tank5tag.classList.remove('lowTag');
                    this.tank5.classList.add('emptyTank');
                    this.tank5.classList.remove('lowTank');
                    this.tank5summary.classList.add('emptyTag');
                    this.tank5summary.classList.remove('lowTag');
                }
                else {
                    this.tank5tag.classList.add('lowTag');
                    this.tank5tag.classList.remove('emptyTag');
                    this.tank5.classList.add('lowTank');
                    this.tank5.classList.remove('emptyTank');
                    this.tank5summary.classList.add('lowTag');
                    this.tank5summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank5tag.classList.remove('lowTag');
                this.tank5tag.classList.remove('emptyTag');
                this.tank5.classList.remove('lowTank');
                this.tank5.classList.remove('emptyTank');
                this.tank5summary.classList.remove('lowTag');
                this.tank5summary.classList.remove('emptyTag');
            }
            
            // TANK 6
            if (tank6pct < 25) {
                if (tank6pct < 15) {
                    this.tank6tag.classList.add('emptyTag');
                    this.tank6tag.classList.remove('lowTag');
                    this.tank6.classList.add('emptyTank');
                    this.tank6.classList.remove('lowTank');
                    this.tank6summary.classList.add('emptyTag');
                    this.tank6summary.classList.remove('lowTag');
                }
                else {
                    this.tank6tag.classList.add('lowTag');
                    this.tank6tag.classList.remove('emptyTag');
                    this.tank6.classList.add('lowTank');
                    this.tank6.classList.remove('emptyTank');
                    this.tank6summary.classList.add('lowTag');
                    this.tank6summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank6tag.classList.remove('lowTag');
                this.tank6tag.classList.remove('emptyTag');
                this.tank6.classList.remove('lowTank');
                this.tank6.classList.remove('emptyTank');
                this.tank6summary.classList.remove('lowTag');
                this.tank6summary.classList.remove('emptyTag');
            }
            
            // TANK 7
            if (tank7pct < 25) {
                if (tank7pct < 15) {
                    this.tank7tag.classList.add('emptyTag');
                    this.tank7tag.classList.remove('lowTag');
                    this.tank7.classList.add('emptyTank');
                    this.tank7.classList.remove('lowTank');
                    this.tank7summary.classList.add('emptyTag');
                    this.tank7summary.classList.remove('lowTag');
                }
                else {
                    this.tank7tag.classList.add('lowTag');
                    this.tank7tag.classList.remove('emptyTag');
                    this.tank7.classList.add('lowTank');
                    this.tank7.classList.remove('emptyTank');
                    this.tank7summary.classList.add('lowTag');
                    this.tank7summary.classList.remove('emptyTag');
                }
            }
            else {
                this.tank7tag.classList.remove('lowTag');
                this.tank7tag.classList.remove('emptyTag');
                this.tank7.classList.remove('lowTank');
                this.tank7.classList.remove('emptyTank');
                this.tank7summary.classList.remove('lowTag');
                this.tank7summary.classList.remove('emptyTag');
            }

            // TOTAL
            if (tankTotalpct < 25) {
                if (tankTotalpct < 15) {
                    this.tankAllsummary.classList.add('emptyTag');
                    this.tankAllsummary.classList.remove('lowTag');
                }
                else {
                    this.tankAllsummary.classList.add('lowTag');
                    this.tankAllsummary.classList.remove('emptyTag');
                }
            }
            else {                
                this.tankAllsummary.classList.remove('lowTag');
                this.tankAllsummary.classList.remove('emptyTag');
            }
        }
    
        // Read variables from Sim
        allSimvars() {

            // FUEL SYSTEM
            this.valFuelCapacity1 = this.getSimvar("FUELSYSTEM TANK CAPACITY:1", "gallons", 500);
            this.valFuelCapacity2 = this.getSimvar("FUELSYSTEM TANK CAPACITY:2", "gallons", 500);
            this.valFuelCapacity3 = this.getSimvar("FUELSYSTEM TANK CAPACITY:3", "gallons", 1500);
            this.valFuelCapacity4 = this.getSimvar("FUELSYSTEM TANK CAPACITY:4", "gallons", 250);
            this.valFuelCapacity5 = this.getSimvar("FUELSYSTEM TANK CAPACITY:5", "gallons", 250);
            this.valFuelCapacity6 = this.getSimvar("FUELSYSTEM TANK CAPACITY:6", "gallons", 250);
            this.valFuelCapacity7 = this.getSimvar("FUELSYSTEM TANK CAPACITY:7", "gallons", 250);
            
            this.valFuelQty1 = this.getSimvar("FUELSYSTEM TANK QUANTITY:1", "gallons", 185);
            this.valFuelQty2 = this.getSimvar("FUELSYSTEM TANK QUANTITY:2", "gallons", 176);
            this.valFuelQty3 = this.getSimvar("FUELSYSTEM TANK QUANTITY:3", "gallons", 825.15);
            this.valFuelQty4 = this.getSimvar("FUELSYSTEM TANK QUANTITY:4", "gallons", 250);
            this.valFuelQty5 = this.getSimvar("FUELSYSTEM TANK QUANTITY:5", "gallons", 200);
            this.valFuelQty6 = this.getSimvar("FUELSYSTEM TANK QUANTITY:6", "gallons", 230);
            this.valFuelQty7 = this.getSimvar("FUELSYSTEM TANK QUANTITY:7", "gallons", 245);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-fuel", QuasarFUEL);
    
    /* Browser Format */
    // customElements.define('quasar-fuel', QuasarFUEL);