/* MSFS Format */
class QuasarENG extends BaseInstrument {

    /* Browser Format */
    // class QuasarENG extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarENG"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            this.temptitle = this.getId("temptitle");
            
            // Engine 1
            this.ffbar_e1 = this.getId("ffbar_e1");
            this.ffvalue_e1 = this.getId("ffvalue_e1");

            this.oilpbar_e1 = this.getId("oilpbar_e1");
            this.oilpRB1_e1 = this.getId("oilpRB1_e1");
            this.oilpRB2_e1 = this.getId("oilpRB2_e1");
            this.oilpYB1_e1 = this.getId("oilpYB1_e1");
            this.oilpYB2_e1 = this.getId("oilpYB2_e1");
            this.oilpvalue_e1 = this.getId("oilpvalue_e1");

            this.ittbar_e1 = this.getId("ittbar_e1");
            this.ittRB_e1 = this.getId("ittRB_e1");
            this.ittvalue_e1 = this.getId("ittvalue_e1");

            this.egtbar_e1 = this.getId("egtbar_e1");
            this.egtvalue_e1 = this.getId("egtvalue_e1");

            this.thrlvrbar_e1 = this.getId("thrlvrbar_e1");
            this.thrlvrvalue_e1 = this.getId("thrlvrvalue_e1");

            this.thrn1bar_e1 = this.getId("thrn1bar_e1");
            this.thrn1value_e1 = this.getId("thrn1value_e1");

            this.jetvalue_e1 = this.getId("jetvalue_e1");


            // Engine 2
            this.ffbar_e2 = this.getId("ffbar_e2");
            this.ffvalue_e2 = this.getId("ffvalue_e2");

            this.oilpbar_e2 = this.getId("oilpbar_e2");
            this.oilpRB1_e2 = this.getId("oilpRB1_e2");
            this.oilpRB2_e2 = this.getId("oilpRB2_e2");
            this.oilpYB1_e2 = this.getId("oilpYB1_e2");
            this.oilpYB2_e2 = this.getId("oilpYB2_e2");
            this.oilpvalue_e2 = this.getId("oilpvalue_e2");

            this.ittbar_e2 = this.getId("ittbar_e2");
            this.ittRB_e2 = this.getId("ittRB_e2");
            this.ittvalue_e2 = this.getId("ittvalue_e2");

            this.egtbar_e2 = this.getId("egtbar_e2");
            this.egtvalue_e2 = this.getId("egtvalue_e2");

            this.thrlvrbar_e2 = this.getId("thrlvrbar_e2");
            this.thrlvrvalue_e2 = this.getId("thrlvrvalue_e2");

            this.thrn1bar_e2 = this.getId("thrn1bar_e2");
            this.thrn1value_e2 = this.getId("thrn1value_e2");

            this.jetvalue_e2 = this.getId("jetvalue_e2");


            // Engine 3
            this.ffbar_e3 = this.getId("ffbar_e3");
            this.ffvalue_e3 = this.getId("ffvalue_e3");

            this.oilpbar_e3 = this.getId("oilpbar_e3");
            this.oilpRB1_e3 = this.getId("oilpRB1_e3");
            this.oilpRB2_e3 = this.getId("oilpRB2_e3");
            this.oilpYB1_e3 = this.getId("oilpYB1_e3");
            this.oilpYB2_e3 = this.getId("oilpYB2_e3");
            this.oilpvalue_e3 = this.getId("oilpvalue_e3");

            this.ittbar_e3 = this.getId("ittbar_e3");
            this.ittRB_e3 = this.getId("ittRB_e3");
            this.ittvalue_e3 = this.getId("ittvalue_e3");

            this.egtbar_e3 = this.getId("egtbar_e3");
            this.egtvalue_e3 = this.getId("egtvalue_e3");

            this.thrlvrbar_e3 = this.getId("thrlvrbar_e3");
            this.thrlvrvalue_e3 = this.getId("thrlvrvalue_e3");

            this.thrn1bar_e3 = this.getId("thrn1bar_e3");
            this.thrn1value_e3 = this.getId("thrn1value_e3");

            this.jetvalue_e3 = this.getId("jetvalue_e3");            


            // Engine 4
            this.ffbar_e4 = this.getId("ffbar_e4");
            this.ffvalue_e4 = this.getId("ffvalue_e4");

            this.oilpbar_e4 = this.getId("oilpbar_e4");
            this.oilpRB1_e4 = this.getId("oilpRB1_e4");
            this.oilpRB2_e4 = this.getId("oilpRB2_e4");
            this.oilpYB1_e4 = this.getId("oilpYB1_e4");
            this.oilpYB2_e4 = this.getId("oilpYB2_e4");
            this.oilpvalue_e4 = this.getId("oilpvalue_e4");

            this.ittbar_e4 = this.getId("ittbar_e4");
            this.ittRB_e4 = this.getId("ittRB_e4");
            this.ittvalue_e4 = this.getId("ittvalue_e4");

            this.egtbar_e4 = this.getId("egtbar_e4");
            this.egtvalue_e4 = this.getId("egtvalue_e4");

            this.thrlvrbar_e4 = this.getId("thrlvrbar_e4");
            this.thrlvrvalue_e4 = this.getId("thrlvrvalue_e4");

            this.thrn1bar_e4 = this.getId("thrn1bar_e4");
            this.thrn1value_e4 = this.getId("thrn1value_e4");

            this.jetvalue_e4 = this.getId("jetvalue_e4");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
    
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats    

        /**
         * 
         * Finds the Y value for a given X on a graph defined by a series of coordinates.
         * Uses linear interpolation within the range, clamps to nearest endpoint if out of range.
         *
         * @param {Array<{x:number, y:number}>} points - Array of {x, y} coordinates (not necessarily sorted).
         * @param {number} targetX - The X value to find Y for.
         * @returns {number} Interpolated or clamped Y value.
         */
        getYforX(points, targetX) {
            if (!points || points.length < 2) { return 0; }

            // Ensure points are sorted by x
            points.sort((a, b) => a.x - b.x);

            // Clamp left
            if (targetX <= points[0].x) { return points[0].y; }

            // Clamp right
            if (targetX >= points[points.length - 1].x) { return points[points.length - 1].y; }

            // Interpolation inside range
            for (let i = 0; i < points.length - 1; i++) {
                const p1 = points[i];
                const p2 = points[i + 1];

                if (targetX >= p1.x && targetX <= p2.x) {
                const slope = (p2.y - p1.y) / (p2.x - p1.x);
                return p1.y + slope * (targetX - p1.x);
                }
            }
            // Fallback return
            return 0;
        }


        computeAndDraw() {

            if (this.valTempUnitCelsius) { this.temptitle.innerHTML = 'TEMPERATURES (CELSIUS)'; }
            else { this.temptitle.innerHTML = 'TEMPERATURES (FAHRENHEIT)'; }


            var FFScale = (100 / 2000); // Max value = 2000 | Min value = 0
            var OILPScale = (100 / 150); // Max value = 110 | Min value = 0
            var ITTScale = (100 / (2200 - 80)); // Max value = 2200 | Min value = 80
            var EGTScale = (100 / (2200 - 80)); // Max value = 2200 | Min value = 80

            // afterburner_on_thrust_table (from engines.cfg) 
            var abThrust = [
                { x: 0.0, y: 1.58 },
                { x: 0.4, y: 1.69 },
                { x: 0.8, y: 1.8 },
                { x: 1.2, y: 1.84 },
                { x: 1.6, y: 1.85 },
                { x: 2.0, y: 1.85 },
                { x: 3.0, y: 2.0 },
                { x: 4.0, y: 2.50 },
                { x: 7.0, y: 2.75 }
            ];

            /* ---- ENGINE 1 ---- */

            // Convert temperatures from rankine to celsius
            var ITTe1 = ((this.valITT_e1 - 491.67) * 5 / 9);
            var EGTe1 = ((this.valEGT_e1 - 491.67) * 5 / 9);

            // Draw RED and YELLOW bars
            this.oilpYB1_e1.style.left = (60 * OILPScale).toFixed(0)+'px';
            this.oilpYB2_e1.style.left = (90 * OILPScale).toFixed(0)+'px';
            this.oilpRB1_e1.style.left = (40 * OILPScale).toFixed(0)+'px';
            this.oilpRB2_e1.style.left = (100 * OILPScale).toFixed(0)+'px';
            this.ittRB_e1.style.left = ((1600 - 80) * ITTScale).toFixed(0)+'px';

            // Draw BARS
            this.ffbar_e1.style.width = (this.valFF_e1 * FFScale).toFixed(0)+'px';
            this.oilpbar_e1.style.width = (this.valOILP_e1 * OILPScale).toFixed(0)+'px';
            var ittBarVal_e1 = ((((this.valITT_e1 - 491.67) * 5 / 9) - 80) * ITTScale).toFixed(0);
            if (ittBarVal_e1 < 0) { ittBarVal_e1 = 0; }
            this.ittbar_e1.style.width = ittBarVal_e1+'px';
            var egtBarVal_e1 = ((((this.valEGT_e1 - 491.67) * 5 / 9) - 80) * EGTScale).toFixed(0);
            if (egtBarVal_e1 < 0) { egtBarVal_e1 = 0; }
            this.egtbar_e1.style.width = egtBarVal_e1+'px';
            this.thrlvrbar_e1.style.width = this.valTHRLVR_e1.toFixed(0)+'px';
            this.thrn1bar_e1.style.width = this.valTHRN1_e1.toFixed(0)+'px';

            // Draw VALUES
            this.ffvalue_e1.innerHTML = this.valFF_e1.toFixed(0);
            this.oilpvalue_e1.innerHTML = this.valOILP_e1.toFixed(0);

            if (this.valTempUnitCelsius) {
                this.ittvalue_e1.innerHTML = ITTe1.toFixed(0);
                this.egtvalue_e1.innerHTML = EGTe1.toFixed(0);
            }
            else {
                this.ittvalue_e1.innerHTML = (this.valITT_e1 - 459.67).toFixed(0);
                this.egtvalue_e1.innerHTML = (this.valEGT_e1 - 459.67).toFixed(0);
            }

            this.thrlvrvalue_e1.innerHTML = this.valTHRLVR_e1.toFixed(0);
            this.thrn1value_e1.innerHTML = this.valTHRN1_e1.toFixed(0);
            if (this.valABEng1) {
                this.jetvalue_e1.innerHTML = ((this.valJET_e1*this.getYforX(abThrust,this.valMach))/1000).toFixed(2);
            }
            else { this.jetvalue_e1.innerHTML = (this.valJET_e1/1000).toFixed(2); }

            // Stylize bars
            if (this.valOILP_e1 < 40 || this.valOILP_e1 > 100) {
                this.oilpbar_e1.classList.add('redFill');
                this.oilpbar_e1.classList.remove('yellowFill');
            }
            else if (this.valOILP_e1 < 60 || this.valOILP_e1 > 90) {
                this.oilpbar_e1.classList.remove('redFill');
                this.oilpbar_e1.classList.add('yellowFill');
            }
            else {
                this.oilpbar_e1.classList.remove('redFill');
                this.oilpbar_e1.classList.remove('yellowFill');
            }
            if (((this.valITT_e1 - 491.67) * 5 / 9) > 1600) { this.ittbar_e1.classList.add('redFill'); }
            else { this.ittbar_e1.classList.remove('redFill'); }


            /* ---- ENGINE 2 ---- */
            
            // Convert temperatures from rankine to celsius
            var ITTe2 = ((this.valITT_e2 - 491.67) * 5 / 9);
            var EGTe2 = ((this.valEGT_e2 - 491.67) * 5 / 9);

            // Draw RED and YELLOW bars
            this.oilpYB1_e2.style.left = (60 * OILPScale).toFixed(0)+'px';
            this.oilpYB2_e2.style.left = (90 * OILPScale).toFixed(0)+'px';
            this.oilpRB1_e2.style.left = (40 * OILPScale).toFixed(0)+'px';
            this.oilpRB2_e2.style.left = (100 * OILPScale).toFixed(0)+'px';
            this.ittRB_e2.style.left = ((1600 - 80) * ITTScale).toFixed(0)+'px';

            // Draw BARS
            this.ffbar_e2.style.width = (this.valFF_e2 * FFScale).toFixed(0)+'px';
            this.oilpbar_e2.style.width = (this.valOILP_e2 * OILPScale).toFixed(0)+'px';
            var ittBarVal_e2 = ((((this.valITT_e2 - 491.67) * 5 / 9) - 80) * ITTScale).toFixed(0);
            if (ittBarVal_e2 < 0) { ittBarVal_e2 = 0; }
            this.ittbar_e2.style.width = ittBarVal_e2+'px';
            var egtBarVal_e2 = ((((this.valEGT_e2 - 491.67) * 5 / 9) - 80) * EGTScale).toFixed(0);
            if (egtBarVal_e2 < 0) { egtBarVal_e2 = 0; }
            this.egtbar_e2.style.width = egtBarVal_e2+'px';
            this.thrlvrbar_e2.style.width = this.valTHRLVR_e2.toFixed(0)+'px';
            this.thrn1bar_e2.style.width = this.valTHRN1_e2.toFixed(0)+'px';

            // Draw VALUES
            this.ffvalue_e2.innerHTML = this.valFF_e2.toFixed(0);
            this.oilpvalue_e2.innerHTML = this.valOILP_e2.toFixed(0);

            if (this.valTempUnitCelsius) {
                this.ittvalue_e2.innerHTML = ITTe2.toFixed(0);
                this.egtvalue_e2.innerHTML = EGTe2.toFixed(0);
            }
            else {
                this.ittvalue_e2.innerHTML = (this.valITT_e2 - 459.67).toFixed(0);
                this.egtvalue_e2.innerHTML = (this.valEGT_e2 - 459.67).toFixed(0);
            }

            this.thrlvrvalue_e2.innerHTML = this.valTHRLVR_e2.toFixed(0);
            this.thrn1value_e2.innerHTML = this.valTHRN1_e2.toFixed(0);
            if (this.valABEng2) {
                this.jetvalue_e2.innerHTML = ((this.valJET_e2*this.getYforX(abThrust,this.valMach))/1000).toFixed(2);
            }
            else { this.jetvalue_e2.innerHTML = (this.valJET_e2/1000).toFixed(2); }

            // Stylize bars
            if (this.valOILP_e2 < 40 || this.valOILP_e2 > 100) {
                this.oilpbar_e2.classList.add('redFill');
                this.oilpbar_e2.classList.remove('yellowFill');
            }
            else if (this.valOILP_e2 < 60 || this.valOILP_e2 > 90) {
                this.oilpbar_e2.classList.remove('redFill');
                this.oilpbar_e2.classList.add('yellowFill');
            }
            else {
                this.oilpbar_e2.classList.remove('redFill');
                this.oilpbar_e2.classList.remove('yellowFill');
            }
            if (((this.valITT_e2 - 491.67) * 5 / 9) > 1600) { this.ittbar_e2.classList.add('redFill'); }
            else { this.ittbar_e2.classList.remove('redFill'); }


            /* ---- ENGINE 3 ---- */
            
            // Convert temperatures from rankine to celsius
            var ITTe3 = ((this.valITT_e3 - 491.67) * 5 / 9);
            var EGTe3 = ((this.valEGT_e3 - 491.67) * 5 / 9);

            // Draw RED and YELLOW bars
            this.oilpYB1_e3.style.left = (60 * OILPScale).toFixed(0)+'px';
            this.oilpYB2_e3.style.left = (90 * OILPScale).toFixed(0)+'px';
            this.oilpRB1_e3.style.left = (40 * OILPScale).toFixed(0)+'px';
            this.oilpRB2_e3.style.left = (100 * OILPScale).toFixed(0)+'px';
            this.ittRB_e3.style.left = ((1600 - 80) * ITTScale).toFixed(0)+'px';

            // Draw BARS
            this.ffbar_e3.style.width = (this.valFF_e3 * FFScale).toFixed(0)+'px';
            this.oilpbar_e3.style.width = (this.valOILP_e3 * OILPScale).toFixed(0)+'px';
            var ittBarVal_e3 = ((((this.valITT_e3 - 491.67) * 5 / 9) - 80) * ITTScale).toFixed(0);
            if (ittBarVal_e3 < 0) { ittBarVal_e3 = 0; }
            this.ittbar_e3.style.width = ittBarVal_e3+'px';
            var egtBarVal_e3 = ((((this.valEGT_e3 - 491.67) * 5 / 9) - 80) * EGTScale).toFixed(0);
            if (egtBarVal_e3 < 0) { egtBarVal_e3 = 0; }
            this.egtbar_e3.style.width = egtBarVal_e3+'px';
            this.thrlvrbar_e3.style.width = this.valTHRLVR_e3.toFixed(0)+'px';
            this.thrn1bar_e3.style.width = this.valTHRN1_e3.toFixed(0)+'px';

            // Draw VALUES
            this.ffvalue_e3.innerHTML = this.valFF_e3.toFixed(0);
            this.oilpvalue_e3.innerHTML = this.valOILP_e3.toFixed(0);

            if (this.valTempUnitCelsius) {
                this.ittvalue_e3.innerHTML = ITTe3.toFixed(0);
                this.egtvalue_e3.innerHTML = EGTe3.toFixed(0);
            }
            else {
                this.ittvalue_e3.innerHTML = (this.valITT_e3 - 459.67).toFixed(0);
                this.egtvalue_e3.innerHTML = (this.valEGT_e3 - 459.67).toFixed(0);
            }

            this.thrlvrvalue_e3.innerHTML = this.valTHRLVR_e3.toFixed(0);
            this.thrn1value_e3.innerHTML = this.valTHRN1_e3.toFixed(0);
            if (this.valABEng3) {
                this.jetvalue_e3.innerHTML = ((this.valJET_e3*this.getYforX(abThrust,this.valMach))/1000).toFixed(2);
            }
            else { this.jetvalue_e3.innerHTML = (this.valJET_e3/1000).toFixed(2); }

            // Stylize bars
            if (this.valOILP_e3 < 40 || this.valOILP_e3 > 100) {
                this.oilpbar_e3.classList.add('redFill');
                this.oilpbar_e3.classList.remove('yellowFill');
            }
            else if (this.valOILP_e3 < 60 || this.valOILP_e3 > 90) {
                this.oilpbar_e3.classList.remove('redFill');
                this.oilpbar_e3.classList.add('yellowFill');
            }
            else {
                this.oilpbar_e3.classList.remove('redFill');
                this.oilpbar_e3.classList.remove('yellowFill');
            }
            if (((this.valITT_e3 - 491.67) * 5 / 9) > 1600) { this.ittbar_e3.classList.add('redFill'); }
            else { this.ittbar_e3.classList.remove('redFill'); }


            /* ---- ENGINE 4 ---- */
            
            // Convert temperatures from rankine to celsius
            var ITTe4 = ((this.valITT_e4 - 491.67) * 5 / 9);
            var EGTe4 = ((this.valEGT_e4 - 491.67) * 5 / 9);

            // Draw RED and YELLOW bars
            this.oilpYB1_e4.style.left = (60 * OILPScale).toFixed(0)+'px';
            this.oilpYB2_e4.style.left = (90 * OILPScale).toFixed(0)+'px';
            this.oilpRB1_e4.style.left = (40 * OILPScale).toFixed(0)+'px';
            this.oilpRB2_e4.style.left = (100 * OILPScale).toFixed(0)+'px';
            this.ittRB_e4.style.left = ((1600 - 80) * ITTScale).toFixed(0)+'px';

            // Draw BARS
            this.ffbar_e4.style.width = (this.valFF_e4 * FFScale).toFixed(0)+'px';
            this.oilpbar_e4.style.width = (this.valOILP_e4 * OILPScale).toFixed(0)+'px';
            var ittBarVal_e4 = ((((this.valITT_e4 - 491.67) * 5 / 9) - 80) * ITTScale).toFixed(0);
            if (ittBarVal_e4 < 0) { ittBarVal_e4 = 0; }
            this.ittbar_e4.style.width = ittBarVal_e4+'px';
            var egtBarVal_e4 = ((((this.valEGT_e4 - 491.67) * 5 / 9) - 80) * EGTScale).toFixed(0);
            if (egtBarVal_e4 < 0) { egtBarVal_e4 = 0; }
            this.egtbar_e4.style.width = egtBarVal_e4+'px';
            this.thrlvrbar_e4.style.width = this.valTHRLVR_e4.toFixed(0)+'px';
            this.thrn1bar_e4.style.width = this.valTHRN1_e4.toFixed(0)+'px';

            // Draw VALUES
            this.ffvalue_e4.innerHTML = this.valFF_e4.toFixed(0);
            this.oilpvalue_e4.innerHTML = this.valOILP_e4.toFixed(0);

            if (this.valTempUnitCelsius) {
                this.ittvalue_e4.innerHTML = ITTe4.toFixed(0);
                this.egtvalue_e4.innerHTML = EGTe4.toFixed(0);
            }
            else {
                this.ittvalue_e4.innerHTML = (this.valITT_e4 - 459.67).toFixed(0);
                this.egtvalue_e4.innerHTML = (this.valEGT_e4 - 459.67).toFixed(0);
            }

            this.thrlvrvalue_e4.innerHTML = this.valTHRLVR_e4.toFixed(0);
            this.thrn1value_e4.innerHTML = this.valTHRN1_e4.toFixed(0);
            if (this.valABEng4) {
                this.jetvalue_e4.innerHTML = ((this.valJET_e4*this.getYforX(abThrust,this.valMach))/1000).toFixed(2);
            }
            else { this.jetvalue_e4.innerHTML = (this.valJET_e4/1000).toFixed(2); }

            // Stylize bars
            if (this.valOILP_e4 < 40 || this.valOILP_e4 > 100) {
                this.oilpbar_e4.classList.add('redFill');
                this.oilpbar_e4.classList.remove('yellowFill');
            }
            else if (this.valOILP_e4 < 60 || this.valOILP_e4 > 90) {
                this.oilpbar_e4.classList.remove('redFill');
                this.oilpbar_e4.classList.add('yellowFill');
            }
            else {
                this.oilpbar_e4.classList.remove('redFill');
                this.oilpbar_e4.classList.remove('yellowFill');
            }
            if (((this.valITT_e4 - 491.67) * 5 / 9) > 1600) { this.ittbar_e4.classList.add('redFill'); }
            else { this.ittbar_e4.classList.remove('redFill'); }
        }
    
        // Read variables from Sim
        allSimvars() {

            this.valTempUnitCelsius = this.getSimvar("L:FRIES_TempUnit_Celsius", "bool", 0);
            this.valMach = this.getSimvar("AIRSPEED MACH", "Mach", 1.57); // INFO (cruise)

            // ENGINE 1
            this.valFF_e1 = this.getSimvar("ENG FUEL FLOW GPH:1", "gallons per hour", 4500.454);
            this.valOILP_e1 = this.getSimvar("GENERAL ENG OIL PRESSURE:1", "psi", 78.854);
            
            this.valITT_e1 = this.getSimvar("TURB ENG ITT:1", "rankine", 3350.151);
            this.valEGT_e1 = this.getSimvar("GENERAL ENG EXHAUST GAS TEMPERATURE:1", "rankine", 2818.454);
            
            this.valTHRLVR_e1 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:1", "percent", 45.454);
            this.valTHRN1_e1 = this.getSimvar("TURB ENG THROTTLE COMMANDED N1:1", "percent", 54.454);
            
            this.valJET_e1 = this.getSimvar("TURB ENG JET THRUST:1", "pounds", 207000.454);
            this.valABEng1 = this.getSimvar("TURB ENG AFTERBURNER:1", "bool", 1);


            // ENGINE 2
            this.valFF_e2 = this.getSimvar("ENG FUEL FLOW GPH:2", "gallons per hour", 400.454);
            this.valOILP_e2 = this.getSimvar("GENERAL ENG OIL PRESSURE:2", "psi", 92.854);
            
            this.valITT_e2 = this.getSimvar("TURB ENG ITT:2", "rankine", 3650.151);
            this.valEGT_e2 = this.getSimvar("GENERAL ENG EXHAUST GAS TEMPERATURE:2", "rankine", 1518.454);
            
            this.valTHRLVR_e2 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:2", "percent", 75.454);
            this.valTHRN1_e2 = this.getSimvar("TURB ENG THROTTLE COMMANDED N1:2", "percent", 103.454);
            
            this.valJET_e2 = this.getSimvar("TURB ENG JET THRUST:2", "pounds", 15378.454);
            this.valABEng2 = this.getSimvar("TURB ENG AFTERBURNER:2", "bool", 1);


            // ENGINE 3
            this.valFF_e3 = this.getSimvar("ENG FUEL FLOW GPH:3", "gallons per hour", 400.454);
            this.valOILP_e3 = this.getSimvar("GENERAL ENG OIL PRESSURE:3", "psi", 92.854);
            
            this.valITT_e3 = this.getSimvar("TURB ENG ITT:3", "rankine", 3650.151);
            this.valEGT_e3 = this.getSimvar("GENERAL ENG EXHAUST GAS TEMPERATURE:3", "rankine", 1518.454);
            
            this.valTHRLVR_e3 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:3", "percent", 75.454);
            this.valTHRN1_e3 = this.getSimvar("TURB ENG THROTTLE COMMANDED N1:3", "percent", 103.454);
            
            this.valJET_e3 = this.getSimvar("TURB ENG JET THRUST:3", "pounds", 45378.454);
            this.valABEng3 = this.getSimvar("TURB ENG AFTERBURNER:3", "bool", 1);


            // ENGINE 4
            this.valFF_e4 = this.getSimvar("ENG FUEL FLOW GPH:4", "gallons per hour", 400.454);
            this.valOILP_e4 = this.getSimvar("GENERAL ENG OIL PRESSURE:4", "psi", 92.854);
            
            this.valITT_e4 = this.getSimvar("TURB ENG ITT:4", "rankine", 850.151);
            this.valEGT_e4 = this.getSimvar("GENERAL ENG EXHAUST GAS TEMPERATURE:4", "rankine", 1518.454);
            
            this.valTHRLVR_e4 = this.getSimvar("GENERAL ENG THROTTLE LEVER POSITION:4", "percent", 75.454);
            this.valTHRN1_e4 = this.getSimvar("TURB ENG THROTTLE COMMANDED N1:4", "percent", 103.454);
            
            this.valJET_e4 = this.getSimvar("TURB ENG JET THRUST:4", "pounds", 150378.454);
            this.valABEng4 = this.getSimvar("TURB ENG AFTERBURNER:4", "bool", 1);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-eng", QuasarENG);
    
    /* Browser Format */
    // customElements.define('quasar-eng', QuasarENG);