/* MSFS Format */
class QuasarCOMP extends BaseInstrument {

    /* Browser Format */
    // class QuasarCOMP extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarCOMP"; } // ID of <script> tag in html
        get isInteractive() { return true; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            /* COMPUTER */
            this.computer_display = this.getId("computer_display");   this.computer_display.addEventListener("mousedown",this.soundTest.bind(this));
            this.computer_live = this.getId("computer_live");   this.computer_live.addEventListener("mousedown",this.soundTest.bind(this));       
            this.computer_vol = this.getId("computer_vol");   this.computer_vol.addEventListener("mousedown",this.soundTest.bind(this));        
            this.computer_vol_filled = this.getId("computer_vol_filled");   this.computer_vol_filled.addEventListener("mousedown",this.soundTest.bind(this));      

            /* TIMER */
            this.timer_data = this.getId("timer_data");

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
    
        // * INTERACTION FUNCTIONS
        // *_____________________________________________________________________
    
        soundTest(e) {
            SimVar.SetSimVarValue("L:KARA_Sound_Test", "bool", (1-this.valSoundTest));   
            SimVar.SetSimVarValue("L:QSR_CompVol_Timer", "number", "0");  
            SimVar.SetSimVarValue("L:QSR_Computer_Vol_Set", "bool", "1");
        }
    
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats    

        computeAndDraw() {

            /* COMPUTER */
            if (this.valBlink && !this.valVolumeVisible) { this.computer_live.style.display = 'block'; }
            else { this.computer_live.style.display = 'none'; }

            // - Volume
            if (this.valVolumeVisible) { this.computer_vol.style.display = 'block'; }
            else { this.computer_vol.style.display = 'none'; }
            this.computer_vol_filled.style.width = (180*this.valVolume)+'px';


            /* TIMER */
            var hours = Math.floor(this.valTimerS/3600);
            var minutes = Math.floor((this.valTimerS-(hours*3600))/60);
            var seconds = this.valTimerS-(hours*3600)-(minutes*60);

            var minutesDisp = '00'+minutes;
            minutesDisp = minutesDisp.substring(minutesDisp.length-2);
            var secondsDisp = '00'+seconds;
            secondsDisp = secondsDisp.substring(secondsDisp.length-2);

            this.timer_data.innerHTML = hours+'h '+minutesDisp+'mn '+secondsDisp+'s';
            
        }
    
        // Read variables from Sim
        allSimvars() {

            /* COMPUTER */
            this.valBlink = this.getSimvar("L:QSR_Computer_Talks", "bool", 0);
            this.valVolume = this.getSimvar("L:QSR_Computer_Vol", "bool", 0.2);
            this.valVolumeVisible = this.getSimvar("L:QSR_Computer_Vol_Set", "bool", 1);
            this.valSoundTest = this.getSimvar("L:KARA_Sound_Test", "bool", 0);

            /* TIMER */
            this.valTimerS = this.getSimvar("L:QSR_Timer_S", "number", 8274);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-computer", QuasarCOMP);
    
    /* Browser Format */
    // customElements.define('quasar-computer', QuasarCOMP);