/* MSFS Format */
class QuasarCAS extends BaseInstrument {

    /* Browser Format */
    // class QuasarCAS extends HTMLElement {
    
        constructor() {
            super();
            this._isConnected = false;

            /* MSFS/Browser: Auto-Detect*/
            (window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1) ? this.browser = true: this.browser = false;
        }
        get templateID() { return "QuasarCAS"; } // ID of <script> tag in html
        get isInteractive() { return false; }
    
        // * CONNECTED CALLBACK
        // *_____________________________________________________________________
    
        connectedCallback() {
    
            if (!this.browser) {  super.connectedCallback(); }

            this.warning_box = this.getId("warning_box");
            this.caution_box = this.getId("caution_box");
            this.advisory_box = this.getId("advisory_box");            

            if (this.browser) { this.Update(); }
                    
            this._isConnected = true;
        }
    
        // * DISCONNECTED CALLBACK
        // *_____________________________________________________________________
    
        disconnectedCallback() {
            super.disconnectedCallback();
        }
        
        // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
        // *_____________________________________________________________________
    
        Update() {
            if (!this.browser) { super.Update(); }
            this.allSimvars();
        }
    
        // * CUSTOM FUCTIONS
        // *_____________________________________________________________________
    
        // Function identical for browser and MSFS formats    

        doYouBlink(value, text) {
            if (this.valBlink && value == 1) { return '<span class="cas blinked">'+text+'</span>'; }
            else if (value != 0) { return '<span class="cas">'+text+'</span>'; }
            return null;
        }
        neverBlink(value, text) {
            if (value) { return '<span class="cas">'+text+'</span>'; }
            return null;
        }


        computeAndDraw() {

            /* WARNING */      
            var warnArray = [];
            warnArray.push(this.doYouBlink(this.valW_E1_COMB,'ENGINE #1 NO COMBUSTION'));
            warnArray.push(this.doYouBlink(this.valW_E1_OILP,'ENGINE #1 OIL PRESSURE'));
            warnArray.push(this.doYouBlink(this.valW_E1_FUELP,'ENGINE #1 FUEL PRESSURE'));

            warnArray.push(this.doYouBlink(this.valW_E2_COMB,'ENGINE #2 NO COMBUSTION'));
            warnArray.push(this.doYouBlink(this.valW_E2_OILP,'ENGINE #2 OIL PRESSURE'));
            warnArray.push(this.doYouBlink(this.valW_E2_FUELP,'ENGINE #2 FUEL PRESSURE'));

            warnArray.push(this.doYouBlink(this.valW_E3_COMB,'ENGINE #3 NO COMBUSTION'));
            warnArray.push(this.doYouBlink(this.valW_E3_OILP,'ENGINE #3 OIL PRESSURE'));
            warnArray.push(this.doYouBlink(this.valW_E3_FUELP,'ENGINE #3 FUEL PRESSURE'));

            warnArray.push(this.doYouBlink(this.valW_E4_COMB,'ENGINE #4 NO COMBUSTION'));
            warnArray.push(this.doYouBlink(this.valW_E4_OILP,'ENGINE #4 OIL PRESSURE'));
            warnArray.push(this.doYouBlink(this.valW_E4_FUELP,'ENGINE #4 FUEL PRESSURE'));

            warnArray.push(this.doYouBlink(this.valW_BAT1_VOLT,'BATTERY #1 LOW VOLTAGE'));
            warnArray.push(this.doYouBlink(this.valW_BAT2_VOLT,'BATTERY #2 LOW VOLTAGE'));

            warnArray.push(this.doYouBlink(this.valW_FUEL_T1,'FUEL TANK #1 CRITICAL'));
            warnArray.push(this.doYouBlink(this.valW_FUEL_T2,'FUEL TANK #2 CRITICAL'));
            warnArray.push(this.doYouBlink(this.valW_FUEL_T3,'FUEL TANK #3 CRITICAL'));
            warnArray.push(this.doYouBlink(this.valW_FUEL_T4,'FUEL TANK #4 CRITICAL'));
            warnArray.push(this.doYouBlink(this.valW_FUEL_T5,'FUEL TANK #5 CRITICAL'));
            warnArray.push(this.doYouBlink(this.valW_FUEL_T6,'FUEL TANK #6 CRITICAL'));
            warnArray.push(this.doYouBlink(this.valW_FUEL_T7,'FUEL TANK #7 CRITICAL'));

            warnArray.push(this.doYouBlink(this.valW_MACH_SURF,'MACH SURFACES FAIL'));
            warnArray.push(this.doYouBlink(this.valW_CABIN_PRES,'CABIN PRESSURIZATION'));
            warnArray.push(this.doYouBlink(this.valW_HYD_ELEC_1,'HYDROGEN ELECTROLYZER #1 OFF'));
            warnArray.push(this.doYouBlink(this.valW_HYD_ELEC_2,'HYDROGEN ELECTROLYZER #2 OFF'));

            // Remove NULL entries + limit array length + push to HTML
            var warnArray = warnArray.filter(function (el) { return el != null; });
            if (warnArray.length > 25) { warnArray = warnArray.slice(0,25); }
            this.warning_box.innerHTML = warnArray.join('<br/>');

            /* CAUTION */
            var cautArray = [];
            cautArray.push(this.doYouBlink(this.valC_FUEL_T1,'FUEL TANK #1 LOW'));
            cautArray.push(this.doYouBlink(this.valC_FUEL_T2,'FUEL TANK #2 LOW'));
            cautArray.push(this.doYouBlink(this.valC_FUEL_T3,'FUEL TANK #3 LOW'));
            cautArray.push(this.doYouBlink(this.valC_FUEL_T4,'FUEL TANK #4 LOW'));
            cautArray.push(this.doYouBlink(this.valC_FUEL_T5,'FUEL TANK #5 LOW'));
            cautArray.push(this.doYouBlink(this.valC_FUEL_T6,'FUEL TANK #6 LOW'));
            cautArray.push(this.doYouBlink(this.valC_FUEL_T7,'FUEL TANK #7 LOW'));
            
            cautArray.push(this.doYouBlink(this.valC_BAT1_OFF,'BATTERY #1 OFF'));
            cautArray.push(this.doYouBlink(this.valC_BAT2_OFF,'BATTERY #2 OFF'));
            cautArray.push(this.doYouBlink(this.valC_BAT_DISCH,'BATTERIES DISCHARGE'));

            cautArray.push(this.doYouBlink(this.valC_CABIN_PRES,'CABIN PRESSURIZATION'));
            cautArray.push(this.doYouBlink(this.valC_CANOPY,'CANOPY UNSEALED'));
            cautArray.push(this.doYouBlink(this.valC_PARK,'PARKING BRAKE'));
            cautArray.push(this.doYouBlink(this.valC_AUTOTRIM_AIL,'AILERONS AUTO TRIM OFF'));
            cautArray.push(this.doYouBlink(this.valC_FACT,'F.A.C.T. ARMED'));

            // Remove NULL entries + limit array length + push to HTML
            var cautArray = cautArray.filter(function (el) { return el != null; });
            if (cautArray.length > 15) { cautArray = cautArray.slice(0,15); }
            this.caution_box.innerHTML = cautArray.join('<br/>');

            /* ADVISORY */
            var advArray = [];
            advArray.push(this.neverBlink(this.valA_APU_ON,'APU ON'));
            advArray.push(this.neverBlink(this.valA_APU_BLEED,'APU BLEED'));

            advArray.push(this.neverBlink(this.valA_PITOT,'PITOT HEAT ON'));
            advArray.push(this.neverBlink(this.valA_ENG_AICE,'ENGINE ANTI-ICE ON'));
            advArray.push(this.neverBlink(this.valA_WS_AICE,'WINDSHIELD ANTI-ICE ON'));

            advArray.push(this.neverBlink(this.valA_NUKE_BAY,'NUCLEAR BAY OPEN'));
            advArray.push(this.neverBlink(this.valA_LDG_MAINT,'LDG GEAR MAINTENANCE OPEN'));
            advArray.push(this.neverBlink(this.valA_LDG_LTS,'LANDING LIGHTS'));
            advArray.push(this.neverBlink(this.valA_HYPERSONIC,'HYPERSONIC'));
            advArray.push(this.neverBlink(this.valA_CARGO,'CARGO LOADED'));


            // Remove NULL entries + limit array length + push to HTML
            var advArray = advArray.filter(function (el) { return el != null; });
            if (advArray.length > 8) { advArray = advArray.slice(0,8); }
            this.advisory_box.innerHTML = advArray.join('<br/>');
        }
    
        // Read variables from Sim
        allSimvars() {

            this.valBlink = this.getSimvar("L:FRIES_CAS_Blink", "bool", 1);

            /* WARNING */            
            this.valW_E1_COMB = this.getSimvar("L:FRIES_CAS_W_ENG1_COMB", "number", 0);
            this.valW_E2_COMB = this.getSimvar("L:FRIES_CAS_W_ENG2_COMB", "number", 0);
            this.valW_E3_COMB = this.getSimvar("L:FRIES_CAS_W_ENG3_COMB", "number", 0);
            this.valW_E4_COMB = this.getSimvar("L:FRIES_CAS_W_ENG4_COMB", "number", 0);

            this.valW_E1_OILP = this.getSimvar("L:FRIES_CAS_W_ENG1_OILP", "number", 0);
            this.valW_E2_OILP = this.getSimvar("L:FRIES_CAS_W_ENG2_OILP", "number", 0);
            this.valW_E3_OILP = this.getSimvar("L:FRIES_CAS_W_ENG3_OILP", "number", 0);
            this.valW_E4_OILP = this.getSimvar("L:FRIES_CAS_W_ENG4_OILP", "number", 0);

            this.valW_E1_FUELP = this.getSimvar("L:FRIES_CAS_W_ENG1_FUELP", "number", 1);
            this.valW_E2_FUELP = this.getSimvar("L:FRIES_CAS_W_ENG2_FUELP", "number", 1);
            this.valW_E3_FUELP = this.getSimvar("L:FRIES_CAS_W_ENG3_FUELP", "number", 0);
            this.valW_E4_FUELP = this.getSimvar("L:FRIES_CAS_W_ENG4_FUELP", "number", 0);
            
            this.valW_BAT1_VOLT = this.getSimvar("L:FRIES_CAS_W_BAT1_VOLT", "number", 2);
            this.valW_BAT2_VOLT = this.getSimvar("L:FRIES_CAS_W_BAT2_VOLT", "number", 2);
            
            this.valW_FUEL_T1 = this.getSimvar("L:FRIES_CAS_W_FUEL_T1", "number", 2);
            this.valW_FUEL_T2 = this.getSimvar("L:FRIES_CAS_W_FUEL_T2", "number", 2);
            this.valW_FUEL_T3 = this.getSimvar("L:FRIES_CAS_W_FUEL_T3", "number", 2);
            this.valW_FUEL_T4 = this.getSimvar("L:FRIES_CAS_W_FUEL_T4", "number", 2);
            this.valW_FUEL_T5 = this.getSimvar("L:FRIES_CAS_W_FUEL_T5", "number", 2);
            this.valW_FUEL_T6 = this.getSimvar("L:FRIES_CAS_W_FUEL_T6", "number", 2);
            this.valW_FUEL_T7 = this.getSimvar("L:FRIES_CAS_W_FUEL_T7", "number", 2);

            this.valW_MACH_SURF = this.getSimvar("L:FRIES_CAS_W_MACH_SURF", "number", 2);
            this.valW_CABIN_PRES = this.getSimvar("L:FRIES_CAS_W_CABIN_PRES", "number", 2);
            this.valW_HYD_ELEC_1 = this.getSimvar("L:FRIES_CAS_W_HYD_ELEC_1", "number", 2);
            this.valW_HYD_ELEC_2 = this.getSimvar("L:FRIES_CAS_W_HYD_ELEC_2", "number", 2);

            /* CAUTION */
            this.valC_FUEL_T1 = this.getSimvar("L:FRIES_CAS_C_FUEL_T1", "number", 0);
            this.valC_FUEL_T2 = this.getSimvar("L:FRIES_CAS_C_FUEL_T2", "number", 0);
            this.valC_FUEL_T3 = this.getSimvar("L:FRIES_CAS_C_FUEL_T3", "number", 0);
            this.valC_FUEL_T4 = this.getSimvar("L:FRIES_CAS_C_FUEL_T4", "number", 1);
            this.valC_FUEL_T5 = this.getSimvar("L:FRIES_CAS_C_FUEL_T5", "number", 0);
            this.valC_FUEL_T6 = this.getSimvar("L:FRIES_CAS_C_FUEL_T6", "number", 2);
            this.valC_FUEL_T7 = this.getSimvar("L:FRIES_CAS_C_FUEL_T7", "number", 2);

            this.valC_BAT1_OFF = this.getSimvar("L:FRIES_CAS_C_BAT1_OFF", "number", 2);
            this.valC_BAT2_OFF = this.getSimvar("L:FRIES_CAS_C_BAT2_OFF", "number", 2);
            this.valC_BAT_DISCH = this.getSimvar("L:FRIES_CAS_C_BAT_DISCH", "number", 2);

            this.valC_CABIN_PRES = this.getSimvar("L:FRIES_CAS_C_CABIN_PRES", "number", 2);
            this.valC_CANOPY = this.getSimvar("L:FRIES_CAS_C_CANOPY", "number", 2);
            this.valC_PARK = this.getSimvar("L:FRIES_CAS_C_PARK", "number", 2);
            this.valC_AUTOTRIM_AIL = this.getSimvar("L:FRIES_CAS_C_AUTOTRIM_AILERONS", "number", 2);
            this.valC_FACT = this.getSimvar("L:FRIES_CAS_C_FACT", "number", 1);

            /* ADVISORY */
            this.valA_APU_ON = this.getSimvar("L:FRIES_CAS_A_APU_ON", "number", 0);
            this.valA_APU_BLEED = this.getSimvar("L:FRIES_CAS_A_APU_BLEED", "number", 0);
            
            this.valA_PITOT = this.getSimvar("L:FRIES_CAS_A_PITOT", "number", 1);
            this.valA_ENG_AICE = this.getSimvar("L:FRIES_CAS_A_ENG_AICE", "number", 1);
            this.valA_WS_AICE = this.getSimvar("L:FRIES_CAS_A_WS_AICE", "number", 1);
            
            this.valA_NUKE_BAY = this.getSimvar("L:FRIES_CAS_A_NUKE_BAY", "number", 0);
            this.valA_LDG_MAINT = this.getSimvar("L:FRIES_CAS_A_LDG_MAINT", "number", 0);
            this.valA_LDG_LTS = this.getSimvar("L:FRIES_CAS_A_LDG_LTS", "number", 1);
            this.valA_HYPERSONIC = this.getSimvar("L:FRIES_CAS_A_HYPERSONIC", "number", 1);
            this.valA_CARGO = this.getSimvar("L:FRIES_CAS_A_CARGO", "number", 1);

            this.computeAndDraw();
        }
    
        // * GET ELEMENT/CHILD BY ID
        // *_____________________________________________________________________
    
        getId(domid) {
            if (this.browser) return document.getElementById(domid);
            else return this.getChildById(domid);
        }
    
        // * GET VARIABLE
        // *_____________________________________________________________________
        
        getSimvar(name, unit, browVal) {
            if (this.browser) return browVal;
            else return SimVar.GetSimVarValue(name, unit);
        }
    }
    
    /* MSFS Format */
    registerInstrument("quasar-cas", QuasarCAS);
    
    /* Browser Format */
    // customElements.define('quasar-cas', QuasarCAS);