class FA18ACC_UFCD extends FA18_UFCD_Base {
    get templateID() { return "AS04F_ACC_UFCD"; }
    Init() {
        super.Init();
        if (this.topRightFixedButton)
            this.topRightFixedButton.onEmptyScratchpadCb = this.switchToComSubMenu.bind(this);
        if (this.bottomRightFixedButton)
            this.bottomRightFixedButton.onEmptyScratchpadCb = this.switchToComSubMenu.bind(this);
        this.apManager = new FA18ACC_AP_Manager(this);
        this.apSubMenu.setManager(this.apManager);
    }
    createMenus() {
        this.ilsSubMenu = new FA18_UFCD_ILSSubMenu(this);
        this.comSubMenu = new FA18_UFCD_ComSubMenu(this);
        this.apSubMenu = new FA18ACC_UFCD_APSubMenu(this);
        this.lawSubMenu = new FA18_UFCD_LAWSubMenu(this);
        this.tcnSubMenu = new FA18ACC_UFCD_TacanSubMenu(this);
        this.iffSubMenu = new FA18_UFCD_IFFSubMenu(this);
        this.rootMenu = new FA18_UFCD_RightMenu("", () => { }, [
            new FA18_UFCD_ButtonContent("D/L", "BCN", "ILS"),
            (this.topRightFixedButton != null) ? this.topRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "A/P", "", this.switchToApSubMenu.bind(this), this.apSubMenu.apCornerStatus.bind(this.apSubMenu)),
            new FA18_UFCD_ButtonContent("", "RALT", this.lawSubMenu.getAltitudeAlertValue.bind(this.lawSubMenu), this.switchToLawSubMenu.bind(this), this.lawSubMenu.getAltitudeAlertStatus.bind(this.lawSubMenu)),
            new FA18_UFCD_ButtonContent("", "TCN", this.tcnSubMenu.getTacanChannel.bind(this.tcnSubMenu), this.switchToTacanSubMenu.bind(this), this.tcnSubMenu.getTacanActiveStatus.bind(this.tcnSubMenu)),
            new FA18_UFCD_ButtonContent("", "EW", ""),
            new FA18_UFCD_ButtonContent("IFF", this.iffSubMenu.getIffMode3Code.bind(this.iffSubMenu), "", this.switchToIffSubMenu.bind(this), this.iffSubMenu.iffCornerStatus.bind(this.iffSubMenu)),
            new FA18_UFCD_ButtonContent("", "FLR", ""),
            new FA18_UFCD_ButtonContent("", "DDI", ""),
            (this.bottomRightFixedButton != null) ? this.bottomRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
        ]);
        this.wptDataSubMenu = new FA18ACC_UFCD_WaypointDataSubMenu(this);
        this.wptSeqSubMenu = new FA18ACC_UFCD_WaypointSequenceSubMenu(this);
    }
    switchToIlsSubMenu() {
        if (this.ilsSubMenu)
            this.gui.switchToButtonGroup(this.ilsSubMenu);
    }
    switchToComSubMenu(com) {
        if (this.comSubMenu) {
            this.comSubMenu.setSelectedCom(com);
            this.gui.switchToButtonGroup(this.comSubMenu);
        }
    }
    switchToApSubMenu() {
        if (this.apSubMenu)
            this.gui.switchToButtonGroup(this.apSubMenu);
    }
    switchToLawSubMenu(forceSwitch = false) {
        if (this.lawSubMenu)
            this.gui.switchToButtonGroup(this.lawSubMenu);
    }
    switchToIffSubMenu() {
        if (this.iffSubMenu) {
            if (this.gui.currentInput.length > 0)
                this.iffSubMenu.setIffMode3Code();
            else
                this.gui.switchToButtonGroup(this.iffSubMenu);
        }
    }
    switchToWPDataSubMenu() {
        if (this.wptDataSubMenu)
            this.gui.switchToButtonGroup(this.wptDataSubMenu);
    }
    switchToWPSeqSubMenu() {
        if (this.wptSeqSubMenu)
            this.gui.switchToButtonGroup(this.wptSeqSubMenu);
    }
    switchToTacanSubMenu(forceSwitch = false) {
        if (this.tcnSubMenu) {
            if (this.gui.currentInput.length > 0 && !forceSwitch)
                this.tcnSubMenu.setTacanChannel();
            else
                this.gui.switchToButtonGroup(this.tcnSubMenu);
        }
    }
    Update() {
        super.Update();
        if (this.apManager)
            this.apManager.Update(this.deltaTime);
    }
    onInteractionEvent(_args) {
        var _a;
        super.onInteractionEvent(_args);
        if (this.isElectricityAvailable()) {
            let event = _args[0];
            if (_args[0].startsWith(this.instrumentIdentifier + "_")) {
                event = _args[0].slice((this.instrumentIdentifier + "_").length);
            }
            switch (event) {
                case "AS04F_HSI_HDG_TK_RESYNC":
                    if (this.apManager)
                        this.apManager.synchronizeHeadingTrackValue();
                    break;
                case "ShowWaypointDataSubMenu":
                    this.switchToWPDataSubMenu();
                    break;
                case "ShowWaypointSeqSubMenu":
                    this.switchToWPSeqSubMenu();
                    break;
                case "ShowTacanSubMenu":
                    this.switchToTacanSubMenu(true);
                    break;
                case "ShowLawSubMenu":
                    if (_args.length > 1 && this.lawSubMenu) {
                        switch (_args[1]) {
                            case "Baro":
                                this.lawSubMenu.setSelectedAlert(1);
                                break;
                            case "Radar":
                                this.lawSubMenu.setSelectedAlert(2);
                                break;
                        }
                    }
                    this.switchToLawSubMenu(true);
                    break;
                case "CurrentSteeringWaypointChanged":
                    if (_args.length > 4) {
                        this.onCurrentSteeringWaypoint(_args[1], parseFloat(_args[2]), parseFloat(_args[3]), parseFloat(_args[4]));
                    }
                    break;
                case "Map_CRS_Set_Steering":
                    if (_args.length > 1 && this.apManager)
                        (_a = this.apManager) === null || _a === void 0 ? void 0 : _a.setCourseSteeringEnable(!!parseInt(_args[1]));
                    break;
            }
        }
    }
}
class FA18ACC_AP_Manager extends FA18_AP_Manager {
    constructor() {
        super(...arguments);
        this.activeLatMode = FA18_AP_Mode.NONE;
        this.activeLonMode = FA18_AP_Mode.NONE;
        this.courseSteeringEnable = undefined;
    }
    setCourseSteeringEnable(enabled) {
        if (this.courseSteeringEnable === undefined && this.courseSteeringEnableRequestId)
            clearInterval(this.courseSteeringEnableRequestId);
        this.courseSteeringEnable = enabled;
    }
    Update(_deltaTime) {
        super.Update(_deltaTime);
        if (!this.courseSteeringEnableRequestId) {
            this.courseSteeringEnableRequestId = setInterval(() => {
                this.instrument.triggerEventToInstrument("AS04F_DDI_2", "Map_CRS_Steering_Enable_Request", this.instrument.instrumentIdentifier);
            }, 500);
        }
    }
    setModeState(_mode, state) {
        super.setModeState(_mode, state);
        switch (_mode) {
            case FA18_AP_Mode.BALT:
                (state) ? this.engageBalt() : this.disengageBalt();
                break;
            case FA18_AP_Mode.RALT:
                (state) ? this.engageRalt() : this.disengageRalt();
                break;
            case FA18_AP_Mode.GTRK:
                (state) ? this.engageGtrk() : this.disengageGtrk();
                break;
            case FA18_AP_Mode.GSEL:
                (state) ? this.engageGsel() : this.disengageGsel();
                break;
            case FA18_AP_Mode.ROLL:
                (state) ? this.engageRoll() : this.disengageRoll();
                break;
            case FA18_AP_Mode.CPL_TCN:
                (state) ? this.engageCplTCN() : this.disengageCplTCN();
                break;
            case FA18_AP_Mode.CPL_WYPT:
                (state) ? this.engageCplWYPT() : this.disengageCplWYPT();
                break;
            case FA18_AP_Mode.CPL_SEQ:
                (state) ? this.engageCplSeq() : this.disengageCplSeq();
                break;
            default:
                break;
        }
    }
    updateLongitudinal() {
        super.updateLongitudinal();
        if (this.isAutopilotActive) {
            if (this.activeLonMode == FA18_AP_Mode.BALT) {
                if (this.wasStickMovedY)
                    this.disengageMode(this.activeLonMode);
            }
            if (this.activeLonMode == FA18_AP_Mode.RALT) {
                if (this.wasStickMovedY || Math.abs(Simplane.getBank()) > 60 || SimVar.GetSimVarValue("RADIO HEIGHT", "feet") > 5000) {
                    this.disengageMode(this.activeLonMode);
                }
            }
        }
    }
    engageBalt() {
        if (this.activeLonMode != FA18_AP_Mode.BALT) {
            this.disengageMode(this.activeLonMode);
            SimVar.SetSimVarValue("K:AP_ALT_HOLD_ON", "number", 0);
            SimVar.SetSimVarValue("K:AP_ALT_RADIO_MODE_OFF", "number", 0);
            SimVar.SetSimVarValue("K:AP_ALT_VAR_SET_ENGLISH", "feet", SimVar.GetSimVarValue("INDICATED ALTITUDE", "feet"));
            this.activeLonMode = FA18_AP_Mode.BALT;
        }
    }
    disengageBalt() {
        if (this.activeLonMode == FA18_AP_Mode.BALT) {
            SimVar.SetSimVarValue("K:AP_ALT_HOLD_OFF", "number", 0);
            this.activeLonMode = FA18_AP_Mode.NONE;
        }
    }
    getApBaltTarget() {
        return this.getActiveLongitudinalMode() == FA18_AP_Mode.BALT ? SimVar.GetSimVarValue("AUTOPILOT ALTITUDE LOCK VAR", "Feet").toFixed(0) : "";
    }
    engageRalt() {
        if (this.activeLonMode != FA18_AP_Mode.RALT) {
            let currentRalt = SimVar.GetSimVarValue("RADIO HEIGHT", "feet");
            if (currentRalt <= 5000) {
                this.disengageMode(this.activeLonMode);
                SimVar.SetSimVarValue("K:AP_ALT_HOLD_ON", "number", 0);
                SimVar.SetSimVarValue("K:AP_ALT_RADIO_MODE_ON", "number", 0);
                SimVar.SetSimVarValue("K:AP_ALT_VAR_SET_ENGLISH", "feet", currentRalt);
                this.activeLonMode = FA18_AP_Mode.RALT;
            }
        }
    }
    disengageRalt() {
        if (this.activeLonMode == FA18_AP_Mode.RALT) {
            SimVar.SetSimVarValue("K:AP_ALT_HOLD_OFF", "number", 0);
            this.activeLonMode = FA18_AP_Mode.NONE;
        }
    }
    getApRaltTarget() {
        return this.getActiveLongitudinalMode() == FA18_AP_Mode.RALT ? SimVar.GetSimVarValue("AUTOPILOT ALTITUDE LOCK VAR", "Feet").toFixed(0) : "";
    }
    updateLateral() {
        var _a;
        super.updateLateral();
        if (this.isAutopilotActive) {
            switch (this.activeLatMode) {
                case FA18_AP_Mode.GTRK:
                case FA18_AP_Mode.GSEL:
                    if (this.activeLatMode == FA18_AP_Mode.GTRK && this.wasStickMovedX) {
                        this.setHdgTrkModeSimvarWithRoll();
                        this.trackReference = SimVar.GetSimVarValue("GPS GROUND MAGNETIC TRACK", "degrees");
                    }
                    let currentTrack = SimVar.GetSimVarValue("GPS GROUND MAGNETIC TRACK", "degrees");
                    let currentHeading = SimVar.GetSimVarValue("PLANE HEADING DEGREES MAGNETIC", "degrees");
                    SimVar.SetSimVarValue("K:HEADING_BUG_SET", "degree", currentHeading + this.trackReference - currentTrack);
                    break;
                case FA18_AP_Mode.ROLL:
                    if (this.wasStickMovedX) {
                        SimVar.SetSimVarValue("K:AP_BANK_HOLD_OFF", "number", 0);
                        SimVar.SetSimVarValue("K:AP_BANK_HOLD_ON", "number", 0);
                    }
                    break;
                case FA18_AP_Mode.CPL_TCN:
                    if (SimVar.GetSimVarValue("L:FA18_DDI_STEERING_SOURCE", "number") != 2) {
                        this.engageHdg(true);
                    }
                    else {
                        if (SimVar.GetSimVarValue("TACAN STATION DISTANCE:1", "nautical mile") < 2) {
                            this.engageHdg(true);
                        }
                    }
                    break;
                case FA18_AP_Mode.CPL_WYPT:
                    if (SimVar.GetSimVarValue("L:FA18_DDI_STEERING_SOURCE", "number") != 1 || SimVar.GetSimVarValue("L:FA18_DDI_AUTO_SEQ_STEERING", "bool")) {
                        this.engageHdg(true);
                    }
                    else {
                        if (!this.instrument.currentSteeringWaypoint) {
                            this.instrument.triggerEventToInstrument("AS04F_DDI_2", "WaypointManager_UfcdRequestCurrentWaypointInfos");
                        }
                        else if (Avionics.Utils.computeDistance((_a = this.instrument.currentSteeringWaypoint) === null || _a === void 0 ? void 0 : _a.coordinates, SimVar.GetSimVarValue("STRUCT LATLONALT", "latlonalt")) < 2) {
                            this.engageHdg(true);
                        }
                    }
                    break;
                case FA18_AP_Mode.CPL_SEQ:
                    if (SimVar.GetSimVarValue("L:FA18_DDI_STEERING_SOURCE", "number") != 1 || !SimVar.GetSimVarValue("L:FA18_DDI_AUTO_SEQ_STEERING", "bool")) {
                        this.engageHdg(true);
                    }
                    break;
            }
        }
    }
    engageGtrk() {
        if (this.activeLatMode != FA18_AP_Mode.GTRK) {
            this.disengageMode(this.activeLatMode);
            this.setHdgTrkModeSimvarWithRoll();
            this.trackReference = SimVar.GetSimVarValue("GPS GROUND MAGNETIC TRACK", "degrees");
            this.activeLatMode = FA18_AP_Mode.GTRK;
        }
    }
    disengageGtrk() {
        if (this.activeLatMode == FA18_AP_Mode.GTRK) {
            SimVar.SetSimVarValue("K:AP_PANEL_HEADING_OFF", "number", 0);
            this.activeLatMode = FA18_AP_Mode.NONE;
        }
    }
    engageGsel() {
        if (this.activeLatMode != FA18_AP_Mode.GSEL) {
            this.disengageMode(this.activeLatMode);
            SimVar.SetSimVarValue("K:AP_PANEL_HEADING_ON", "number", 0);
            this.trackReference = SimVar.GetSimVarValue("L:XMLVAR_AS04F_HSI_HDG_TK", "degrees");
            SimVar.SetSimVarValue("L:FA18_HEADING_SELECT_MODE", "number", 1);
            this.activeLatMode = FA18_AP_Mode.GSEL;
        }
    }
    disengageGsel() {
        if (this.activeLatMode == FA18_AP_Mode.GSEL) {
            SimVar.SetSimVarValue("K:AP_PANEL_HEADING_OFF", "number", 0);
            SimVar.SetSimVarValue("L:FA18_HEADING_SELECT_MODE", "number", 0);
            this.activeLatMode = FA18_AP_Mode.NONE;
        }
    }
    synchronizeHeadingTrackValue() {
        super.synchronizeHeadingTrackValue();
        if (this.activeLatMode == FA18_AP_Mode.GSEL) {
            this.trackReference = SimVar.GetSimVarValue("L:XMLVAR_AS04F_HSI_HDG_TK", "degrees");
        }
    }
    engageRoll() {
        if (this.activeLatMode != FA18_AP_Mode.ROLL) {
            this.disengageMode(this.activeLatMode);
            SimVar.SetSimVarValue("K:AP_BANK_HOLD_ON", "number", 0);
            this.activeLatMode = FA18_AP_Mode.ROLL;
        }
    }
    disengageRoll() {
        if (this.activeLatMode == FA18_AP_Mode.ROLL) {
            SimVar.SetSimVarValue("K:AP_BANK_HOLD_OFF", "number", 0);
            this.activeLatMode = FA18_AP_Mode.NONE;
        }
    }
    engageNavMode() {
        SimVar.SetSimVarValue("K:AP_NAV1_HOLD_ON", "number", 1);
        SimVar.SetSimVarValue("L:FA18_IS_STEERING_COUPLED", "number", 1);
    }
    disengageNavMode() {
        SimVar.SetSimVarValue("K:AP_NAV1_HOLD_OFF", "number", 0);
        SimVar.SetSimVarValue("L:FA18_IS_STEERING_COUPLED", "number", 0);
    }
    engageCplTCN() {
        if (this.activeLatMode != FA18_AP_Mode.CPL_TCN) {
            this.disengageMode(this.activeLatMode);
            SimVar.SetSimVarValue("AUTOPILOT NAV SELECTED", "number", 1);
            this.engageNavMode();
            this.activeLatMode = FA18_AP_Mode.CPL_TCN;
        }
    }
    disengageCplTCN() {
        if (this.activeLatMode == FA18_AP_Mode.CPL_TCN) {
            this.disengageNavMode();
            this.activeLatMode = FA18_AP_Mode.NONE;
        }
    }
    engageCplWYPT() {
        if (this.activeLatMode != FA18_AP_Mode.CPL_WYPT) {
            this.disengageMode(this.activeLatMode);
            this.engageNavMode();
            this.activeLatMode = FA18_AP_Mode.CPL_WYPT;
        }
    }
    disengageCplWYPT() {
        if (this.activeLatMode == FA18_AP_Mode.CPL_WYPT) {
            this.disengageNavMode();
            this.activeLatMode = FA18_AP_Mode.NONE;
        }
    }
    engageCplSeq() {
        if (this.activeLatMode != FA18_AP_Mode.CPL_SEQ) {
            this.disengageMode(this.activeLatMode);
            this.engageNavMode();
            this.activeLatMode = FA18_AP_Mode.CPL_SEQ;
        }
    }
    disengageCplSeq() {
        if (this.activeLatMode == FA18_AP_Mode.CPL_SEQ) {
            this.disengageNavMode();
            this.activeLatMode = FA18_AP_Mode.NONE;
        }
    }
}
class FA18ACC_UFCD_APSubMenu extends FA18_UFCD_APSubMenu {
    constructor(_instrument, _manager) {
        super(_instrument, _manager);
        this.displayedCplMode = FA18_AP_Mode.NONE;
        this.buttons[0] = new FA18_UFCD_ButtonContent("", "CPL", this.getApCplMode.bind(this), this.toggleApCpl.bind(this), this.getApCplStatus.bind(this));
        this.buttons[2] = new FA18_UFCD_ButtonContent("", "BALT", this.getApBaroAltTarget.bind(this), this.toggleApBaroAlt.bind(this), this.getApBaroAltStatus.bind(this));
        this.buttons[3] = new FA18_UFCD_ButtonContent("", "ROLL", "", this.toggleApRoll.bind(this), this.getApRollStatus.bind(this));
        this.buttons[4] = new FA18_UFCD_ButtonContent("", "RALT", this.getApRadarAltTarget.bind(this), this.toggleApRadarAlt.bind(this), this.getApRadarAltStatus.bind(this));
        this.buttons[5] = new FA18_UFCD_ButtonContent("", this.getApGtrkIsSelectedText.bind(this), "", this.toggleApGtrk.bind(this), this.getApGtrkStatus.bind(this));
    }
    toggleApBaroAlt() {
        if (this.manager) {
            if (this.manager.getActiveLongitudinalMode() != FA18_AP_Mode.BALT)
                this.manager.engageMode(FA18_AP_Mode.BALT);
            else
                this.manager.disengageMode(FA18_AP_Mode.BALT);
        }
    }
    getApBaroAltStatus() {
        return (this.manager && this.manager.getActiveLongitudinalMode() == FA18_AP_Mode.BALT) ? "Border" : "";
    }
    getApBaroAltTarget() {
        return (this.manager) ? this.manager.getApBaltTarget() : "";
    }
    toggleApRadarAlt() {
        if (this.manager) {
            if (this.manager.getActiveLongitudinalMode() != FA18_AP_Mode.RALT)
                this.manager.engageMode(FA18_AP_Mode.RALT);
            else
                this.manager.disengageMode(FA18_AP_Mode.RALT);
        }
    }
    getApRadarAltStatus() {
        return (this.manager && this.manager.getActiveLongitudinalMode() == FA18_AP_Mode.RALT) ? "Border" : "";
    }
    getApRadarAltTarget() {
        return (this.manager) ? this.manager.getApRaltTarget() : "";
    }
    toggleApRoll() {
        if (this.manager) {
            if (this.manager.getActiveLateralMode() != FA18_AP_Mode.ROLL)
                this.manager.engageMode(FA18_AP_Mode.ROLL);
            else
                this.manager.disengageMode(FA18_AP_Mode.ROLL);
        }
    }
    getApRollStatus() {
        return (this.manager && this.manager.getActiveLateralMode() == FA18_AP_Mode.ROLL) ? "Border" : "";
    }
    toggleApGtrk() {
        if (this.manager) {
            let activeLateralMode = this.manager.getActiveLateralMode();
            if (activeLateralMode == FA18_AP_Mode.GTRK) {
                this.manager.engageMode(FA18_AP_Mode.GSEL);
            }
            else if (activeLateralMode == FA18_AP_Mode.GSEL) {
                this.manager.disengageMode(FA18_AP_Mode.GSEL);
                this.manager.disengageMode(FA18_AP_Mode.GTRK);
            }
            else {
                this.manager.engageMode(FA18_AP_Mode.GTRK);
            }
        }
    }
    getApGtrkIsSelectedText() {
        return (this.manager && this.manager.getActiveLateralMode() == FA18_AP_Mode.GSEL) ? "GSEL" : "GTRK";
    }
    getApGtrkStatus() {
        if (this.manager) {
            let activeLateralMode = this.manager.getActiveLateralMode();
            return (activeLateralMode == FA18_AP_Mode.GTRK || activeLateralMode == FA18_AP_Mode.GSEL) ? "Border" : "";
        }
        return "";
    }
    Update(_deltaTime) {
        super.Update(_deltaTime);
        switch (SimVar.GetSimVarValue("L:FA18_DDI_STEERING_SOURCE", "number")) {
            case 1:
                if (SimVar.GetSimVarValue("L:FA18_DDI_AUTO_SEQ_STEERING", "bool"))
                    this.displayedCplMode = FA18_AP_Mode.CPL_SEQ;
                else
                    this.displayedCplMode = FA18_AP_Mode.CPL_WYPT;
                break;
            case 2:
                this.displayedCplMode = FA18_AP_Mode.CPL_TCN;
                break;
            default:
                this.displayedCplMode = FA18_AP_Mode.NONE;
                break;
        }
    }
    toggleApCpl() {
        var _a, _b, _c;
        if (this.displayedCplMode != FA18_AP_Mode.NONE)
            if (((_a = this.manager) === null || _a === void 0 ? void 0 : _a.getActiveLateralMode()) != this.displayedCplMode)
                (_b = this.manager) === null || _b === void 0 ? void 0 : _b.engageMode(this.displayedCplMode);
            else
                (_c = this.manager) === null || _c === void 0 ? void 0 : _c.disengageMode(this.displayedCplMode);
    }
    getApCplStatus() {
        var _a;
        return [FA18_AP_Mode.CPL_SEQ, FA18_AP_Mode.CPL_TCN, FA18_AP_Mode.CPL_WYPT].includes((_a = this.manager) === null || _a === void 0 ? void 0 : _a.getActiveLateralMode()) ? "Border" : "";
    }
    getApCplMode() {
        switch (this.displayedCplMode) {
            case FA18_AP_Mode.CPL_WYPT:
                return "WYPT";
            case FA18_AP_Mode.CPL_SEQ:
                return "SEQ" + (SimVar.GetSimVarValue("L:FA18_DDI_CURRENT_SEQUENCE_INDEX", "number") + 1);
            case FA18_AP_Mode.CPL_TCN:
                return "TCN";
        }
        return "";
    }
}
class FA18ACC_UFCD_TacanSubMenu extends FA18_UFCD_RightMenu {
    constructor(_instrument) {
        super("", () => { }, []);
        this.instrument = _instrument;
        this.entCallback = this.setTacanChannel.bind(this);
        this.buttons = [
            new FA18_UFCD_ButtonContent("", "T/R", "", this.setTacanMode.bind(this, 1), this.getTacanModeStatus.bind(this, 1)),
            (this.instrument.topRightFixedButton != null) ? this.instrument.topRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "RCV", "", this.setTacanMode.bind(this, 2), this.getTacanModeStatus.bind(this, 2)),
            new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "A/A", ""),
            new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", this.getTacanChannelAndMode.bind(this), "", this.setTacanChannel.bind(this)),
            new FA18_UFCD_ButtonContent("", this.getTacanActiveOnOff.bind(this), "", this.switchTacanOnOff.bind(this), this.getTacanActiveStatus.bind(this)),
            new FA18_UFCD_ButtonContent("", "CNI", "", this.instrument.switchToRootMenu.bind(this.instrument)),
            (this.instrument.bottomRightFixedButton != null) ? this.instrument.bottomRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
        ];
    }
    getTacanChannel() {
        const channel = SimVar.GetSimVarValue("TACAN ACTIVE CHANNEL:1", "number");
        return channel;
    }
    getTacanChannelAndMode() {
        const channel = SimVar.GetSimVarValue("TACAN ACTIVE CHANNEL:1", "number");
        const mode = SimVar.GetSimVarValue("TACAN ACTIVE MODE:1", "number");
        return `${channel}${mode == 0 ? 'X' : 'Y'}`;
    }
    setTacanChannel() {
        const mode = SimVar.GetSimVarValue("TACAN ACTIVE MODE:1", "number");
        if (this.instrument.gui.currentInput.length > 0) {
            let val = parseFloat(this.instrument.gui.currentInput);
            if (val > 0 && val < 127) {
                SimVar.SetSimVarValue("K:TACAN1_ACTIVE_CHANNEL_SET", "number", val);
                this.instrument.gui.currentInput = "";
            }
            else {
                this.instrument.gui.displayError();
            }
        }
        else {
            SimVar.SetSimVarValue("K:TACAN1_ACTIVE_MODE_SET", "number", 1 - mode % 2);
        }
    }
    setTacanMode(_mode) {
        SimVar.SetSimVarValue("L:Glasscockpit_TACAN_Mode", "number", _mode);
    }
    getTacanModeStatus(_mode) {
        return SimVar.GetSimVarValue("L:Glasscockpit_TACAN_Mode", "number") == _mode ? "Border" : "";
    }
    switchTacanOnOff() {
        SimVar.SetSimVarValue("L:Glasscockpit_TACAN_Mode", "number", SimVar.GetSimVarValue("L:Glasscockpit_TACAN_Mode", "number") == 0 ? 1 : 0);
    }
    getTacanActiveStatus() {
        return SimVar.GetSimVarValue("L:Glasscockpit_TACAN_Mode", "number") != 0 ? "TopLeft" : "";
    }
    getTacanActiveOnOff() {
        return SimVar.GetSimVarValue("L:Glasscockpit_TACAN_Mode", "number") != 0 ? "ON" : "OFF";
    }
}
var FA18_UFCD_WaypointDataSubMenu_State;
(function (FA18_UFCD_WaypointDataSubMenu_State) {
    FA18_UFCD_WaypointDataSubMenu_State[FA18_UFCD_WaypointDataSubMenu_State["NONE"] = 0] = "NONE";
    FA18_UFCD_WaypointDataSubMenu_State[FA18_UFCD_WaypointDataSubMenu_State["LATITUDE"] = 1] = "LATITUDE";
    FA18_UFCD_WaypointDataSubMenu_State[FA18_UFCD_WaypointDataSubMenu_State["LONGITUDE"] = 2] = "LONGITUDE";
    FA18_UFCD_WaypointDataSubMenu_State[FA18_UFCD_WaypointDataSubMenu_State["ELEVATION"] = 3] = "ELEVATION";
    FA18_UFCD_WaypointDataSubMenu_State[FA18_UFCD_WaypointDataSubMenu_State["NSEW"] = 4] = "NSEW";
})(FA18_UFCD_WaypointDataSubMenu_State || (FA18_UFCD_WaypointDataSubMenu_State = {}));
class FA18ACC_UFCD_WaypointDataSubMenu extends FA18_UFCD_RightMenu {
    constructor(_instrument) {
        super("", () => { }, []);
        this.isNorth = true;
        this.isEast = true;
        this.latLonDisplayMode = 0;
        this.instrument = _instrument;
        this.scratchpadLeftText = this.LeftText.bind(this);
        this.entCallback = this.EnterPress.bind(this);
        this.clrCallback = this.ClrPress.bind(this);
        this.inactivityCallback = this.onInactivityCallback.bind(this);
        this.buttons = [
            new FA18_UFCD_ButtonContent("", "POSN", "", this.SwitchToState.bind(this, FA18_UFCD_WaypointDataSubMenu_State.NSEW), this.GetPosnStatus.bind(this)),
            (this.instrument.topRightFixedButton != null) ? this.instrument.topRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "ELEV", "", this.SwitchToState.bind(this, FA18_UFCD_WaypointDataSubMenu_State.ELEVATION), this.GetStateStatus.bind(this, FA18_UFCD_WaypointDataSubMenu_State.ELEVATION)),
            new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "O/S", ""),
            new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "GRID", ""),
            new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "CNI", "", this.instrument.switchToRootMenu.bind(this.instrument)),
            (this.instrument.bottomRightFixedButton != null) ? this.instrument.bottomRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
        ];
    }
    SwitchToState(_state) {
        this.currentState = _state;
        if (this.currentState == FA18_UFCD_WaypointDataSubMenu_State.NSEW) {
            this.instrument.gui.setKeyboard("NSEW");
        }
        else {
            this.instrument.gui.setKeyboard("");
        }
        this.instrument.gui.currentInput = "";
    }
    GetStateStatus(_state) {
        return _state == this.currentState ? "Border" : "";
    }
    GetPosnStatus() {
        switch (this.currentState) {
            case FA18_UFCD_WaypointDataSubMenu_State.LATITUDE:
            case FA18_UFCD_WaypointDataSubMenu_State.LONGITUDE:
            case FA18_UFCD_WaypointDataSubMenu_State.NSEW:
                return "Border";
            default:
                return "";
        }
    }
    onEnter() {
        this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.NONE);
        this.instrument.gui.inactivityTimerResetTime = 10000;
    }
    Update(_deltaTime) {
        super.Update(_deltaTime);
        this.latLonDisplayMode = SimVar.GetSimVarValue("L:FA18_DDI_LAT_LON_DISPLAY_MODE", "number");
        let currentEditWaypointNumber = SimVar.GetSimVarValue("L:FA18_DDI_CURRENT_WAYPOINT_NUMBER", "number");
        if (currentEditWaypointNumber != this.currentEditWaypointNumber) {
            this.currentEditWaypointNumber = currentEditWaypointNumber;
            this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.NONE);
            this.instrument.gui.resetInactivityTimer();
        }
    }
    FormatInput(_input) {
        if (_input == "ERROR") {
            return _input;
        }
        switch (this.currentState) {
            case FA18_UFCD_WaypointDataSubMenu_State.LATITUDE:
                if (this.latLonDisplayMode == 0) {
                    this.instrument.gui.currentInput = _input.slice(0, 8);
                    let val = _input.padStart(8, "0");
                    return val.slice(0, 2) + Avionics.Utils.DEGREE_SYMBOL + "" + val.slice(2, 4) + "." + val.slice(4, 8) + "'";
                }
                else {
                    this.instrument.gui.currentInput = _input.slice(0, 6);
                    let val = _input.padStart(6, "0");
                    return val.slice(0, 2) + Avionics.Utils.DEGREE_SYMBOL + "" + val.slice(2, 4) + "'" + val.slice(4, 6) + '"';
                }
            case FA18_UFCD_WaypointDataSubMenu_State.LONGITUDE:
                if (this.latLonDisplayMode == 0) {
                    this.instrument.gui.currentInput = _input.slice(0, 9);
                    let val = _input.padStart(9, "0");
                    return val.slice(0, 3) + Avionics.Utils.DEGREE_SYMBOL + "" + val.slice(3, 5) + "." + val.slice(5, 9) + "'";
                }
                else {
                    this.instrument.gui.currentInput = _input.slice(0, 7);
                    let val = _input.padStart(7, "0");
                    return val.slice(0, 3) + Avionics.Utils.DEGREE_SYMBOL + "" + val.slice(3, 5) + "'" + val.slice(5, 7) + '"';
                }
            case FA18_UFCD_WaypointDataSubMenu_State.ELEVATION:
                return _input + " FT";
        }
        return _input;
    }
    LeftText() {
        switch (this.currentState) {
            case FA18_UFCD_WaypointDataSubMenu_State.ELEVATION:
                return "ELEV:";
            case FA18_UFCD_WaypointDataSubMenu_State.LATITUDE:
                return (this.isNorth ? "N" : "S");
            case FA18_UFCD_WaypointDataSubMenu_State.LONGITUDE:
                return (this.isEast ? "E" : "W");
        }
        return "";
    }
    ClrPress() {
        if (this.currentState == FA18_UFCD_WaypointDataSubMenu_State.LATITUDE || this.currentState == FA18_UFCD_WaypointDataSubMenu_State.LONGITUDE) {
            if (this.instrument.gui.currentInput == "") {
                this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.NSEW);
            }
        }
    }
    onInactivityCallback() {
        this.instrument.gui.currentInput = "";
        this.instrument.switchToRootMenu();
    }
    EnterPress(input) {
        let degrees = 0, minutes = 0, seconds = 0, dd = 0;
        switch (this.currentState) {
            case FA18_UFCD_WaypointDataSubMenu_State.NSEW:
                if (input == "N" || input == "S") {
                    this.isNorth = (input == "N");
                    this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.LATITUDE);
                }
                else if (input == "E" || input == "W") {
                    this.isEast = (input == "E");
                    this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.LONGITUDE);
                }
                else {
                    this.instrument.gui.displayError();
                }
                break;
            case FA18_UFCD_WaypointDataSubMenu_State.LATITUDE:
                if (this.latLonDisplayMode == 0) {
                    let val = input.padStart(8, "0");
                    degrees = parseFloat(val.slice(0, 2));
                    minutes = parseFloat(val.slice(2, 8)) / 10000;
                }
                else {
                    let val = input.padStart(6, "0");
                    degrees = parseFloat(val.slice(0, 2));
                    minutes = parseFloat(val.slice(2, 4));
                    seconds = parseFloat(val.slice(4, 6));
                }
                dd = degrees + minutes / 60 + seconds / 3600;
                if (dd > 90 || minutes >= 60 || seconds >= 60) {
                    this.instrument.gui.displayError();
                }
                else {
                    if (!this.isNorth)
                        dd = -dd;
                    this.instrument.triggerEventToInstrument("AS04F_DDI_2", "WaypointManager_WaypointEditSet", "Latitude", dd + '');
                    this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.NSEW);
                }
                break;
            case FA18_UFCD_WaypointDataSubMenu_State.LONGITUDE:
                if (this.latLonDisplayMode == 0) {
                    let val = input.padStart(9, "0");
                    degrees = parseFloat(val.slice(0, 3));
                    minutes = parseFloat(val.slice(3, 9)) / 10000;
                }
                else {
                    let val = input.padStart(7, "0");
                    degrees = parseFloat(val.slice(0, 3));
                    minutes = parseFloat(val.slice(3, 5));
                    seconds = parseFloat(val.slice(5, 7));
                }
                dd = degrees + minutes / 60 + seconds / 3600;
                if (dd > 180 || minutes >= 60 || seconds >= 60) {
                    this.instrument.gui.displayError();
                }
                else {
                    if (!this.isEast)
                        dd = -dd;
                    this.instrument.triggerEventToInstrument("AS04F_DDI_2", "WaypointManager_WaypointEditSet", "Longitude", dd + '');
                    this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.NONE);
                }
                break;
            case FA18_UFCD_WaypointDataSubMenu_State.ELEVATION:
                this.instrument.triggerEventToInstrument("AS04F_DDI_2", "WaypointManager_WaypointEditSet", "Altitude", input);
                this.SwitchToState(FA18_UFCD_WaypointDataSubMenu_State.NONE);
                break;
        }
    }
}
var FA18_UFCD_WaypointSequenceSubMenu_State;
(function (FA18_UFCD_WaypointSequenceSubMenu_State) {
    FA18_UFCD_WaypointSequenceSubMenu_State[FA18_UFCD_WaypointSequenceSubMenu_State["NONE"] = 0] = "NONE";
    FA18_UFCD_WaypointSequenceSubMenu_State[FA18_UFCD_WaypointSequenceSubMenu_State["GSPD"] = 1] = "GSPD";
    FA18_UFCD_WaypointSequenceSubMenu_State[FA18_UFCD_WaypointSequenceSubMenu_State["TGT"] = 2] = "TGT";
    FA18_UFCD_WaypointSequenceSubMenu_State[FA18_UFCD_WaypointSequenceSubMenu_State["TOT"] = 3] = "TOT";
    FA18_UFCD_WaypointSequenceSubMenu_State[FA18_UFCD_WaypointSequenceSubMenu_State["INSERT"] = 4] = "INSERT";
    FA18_UFCD_WaypointSequenceSubMenu_State[FA18_UFCD_WaypointSequenceSubMenu_State["DELETE"] = 5] = "DELETE";
})(FA18_UFCD_WaypointSequenceSubMenu_State || (FA18_UFCD_WaypointSequenceSubMenu_State = {}));
class FA18ACC_UFCD_WaypointSequenceSubMenu extends FA18_UFCD_RightMenu {
    constructor(_instrument) {
        super("", () => { }, []);
        this.instrument = _instrument;
        this.scratchpadLeftText = this.LeftText.bind(this);
        this.entCallback = this.EnterPress.bind(this);
        this.inactivityCallback = this.onInactivityCallback.bind(this);
        this.buttons = [
            new FA18_UFCD_ButtonContent("", "GSPD", ""),
            (this.instrument.topRightFixedButton != null) ? this.instrument.topRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "TGT", ""),
            new FA18_UFCD_ButtonContent("", "TOT", ""),
            new FA18_UFCD_ButtonContent("", "INSERT", "", this.SwitchToState.bind(this, FA18_UFCD_WaypointSequenceSubMenu_State.INSERT), this.GetStateStatus.bind(this, FA18_UFCD_WaypointSequenceSubMenu_State.INSERT)),
            new FA18_UFCD_ButtonContent("", "DELETE", "", this.SwitchToState.bind(this, FA18_UFCD_WaypointSequenceSubMenu_State.DELETE), this.GetStateStatus.bind(this, FA18_UFCD_WaypointSequenceSubMenu_State.DELETE)),
            new FA18_UFCD_ButtonContent("", "GRID", ""),
            new FA18_UFCD_ButtonContent("", "", ""),
            new FA18_UFCD_ButtonContent("", "CNI", "", this.instrument.switchToRootMenu.bind(this.instrument)),
            (this.instrument.bottomRightFixedButton != null) ? this.instrument.bottomRightFixedButton : new FA18_UFCD_ButtonContent("", "", ""),
        ];
    }
    SwitchToState(_state) {
        this.currentState = _state;
        this.instrument.gui.currentInput = "";
    }
    onEnter() {
        this.instrument.gui.setKeyboard("");
        this.SwitchToState(FA18_UFCD_WaypointSequenceSubMenu_State.NONE);
        this.instrument.gui.inactivityTimerResetTime = 10000;
    }
    onInactivityCallback() {
        this.instrument.gui.currentInput = "";
        this.instrument.switchToRootMenu();
    }
    FormatInput(_input) {
        if (_input == "ERROR") {
            return _input;
        }
        switch (this.currentState) {
            case FA18_UFCD_WaypointSequenceSubMenu_State.GSPD:
                return _input;
            case FA18_UFCD_WaypointSequenceSubMenu_State.TGT:
                return _input;
            case FA18_UFCD_WaypointSequenceSubMenu_State.TOT:
                return _input;
            case FA18_UFCD_WaypointSequenceSubMenu_State.INSERT:
                return _input;
            case FA18_UFCD_WaypointSequenceSubMenu_State.DELETE:
                return _input;
        }
        return _input;
    }
    LeftText() {
        return "";
    }
    GetStateStatus(_state) {
        return _state == this.currentState ? "Border" : "";
    }
    EnterPress(input) {
        switch (this.currentState) {
            case FA18_UFCD_WaypointSequenceSubMenu_State.GSPD:
                break;
            case FA18_UFCD_WaypointSequenceSubMenu_State.TGT:
                break;
            case FA18_UFCD_WaypointSequenceSubMenu_State.TOT:
                break;
            case FA18_UFCD_WaypointSequenceSubMenu_State.INSERT:
                if (input == "") {
                    this.instrument.gui.displayError();
                }
                else {
                    let n = parseInt(input);
                    if (n < 0 || n > 59) {
                        this.instrument.gui.displayError();
                    }
                    else {
                        this.instrument.triggerEventToInstrument("AS04F_DDI_2", "WaypointManager_SequenceInsertWaypoint", n + '');
                        this.instrument.gui.currentInput = "";
                    }
                }
                break;
            case FA18_UFCD_WaypointSequenceSubMenu_State.DELETE:
                if (input == "") {
                    this.instrument.gui.displayError();
                }
                else {
                    let n = parseInt(input);
                    if (n < 0 || n > 59) {
                        this.instrument.gui.displayError();
                    }
                    else {
                        this.instrument.triggerEventToInstrument("AS04F_DDI_2", "WaypointManager_SequenceRemoveWaypoint", n + '');
                        this.instrument.gui.currentInput = "";
                    }
                }
                break;
        }
    }
}
registerInstrument("fa18acc-ufcd-element", FA18ACC_UFCD);
//# sourceMappingURL=FA18ACC_UFCD.js.map