class FA18ACC_DDI_HSIWaypointData extends FA18_DDI_Page {
    get templateID() { return "FA18ACC_DDI_HSIWaypointData"; }
    init(ddi) {
        super.init(ddi);
        this.waypointNameElement = this.ddi.getChildById("HsiWaypointDataWaypointName");
        this.latitudeElement = this.ddi.getChildById("HsiWaypointDataWaypointLat");
        this.longitudeElement = this.ddi.getChildById("HsiWaypointDataWaypointLon");
        this.elevationElement = this.ddi.getChildById("HsiWaypointDataWaypointElevation");
        this.currentSequenceOrder = this.ddi.getChildById("HsiWaypointDataWaypointSequenceOrder");
        this.waypointIndexValueElement = this.ddi.getChildById("HsiWaypointDataWaypointIndex");
        this.sequenceNumberElement = this.ddi.getChildById("HsiWaypointDataSequenceNumber");
    }
    show() {
        super.show();
        for (let i of [2, 9, 11, 14, 16, 17, 19, 20]) {
            this.ddi.setPageButton(i, FA18_DDI_Page_Type.NotImplemented);
        }
        this.ddi.onButtonPressed[1] = () => {
            if (this.ddi.waypointManager.initialized)
                this.ddi.triggerEventToInstrument("AS04F_ACC_UFCD", "ShowWaypointSeqSubMenu");
        };
		this.ddi.onButtonPressed[4] = () => {
			if (this.isMaster){
				this.ddi.waypointManager.init();
			}

        };
        this.ddi.onButtonPressed[5] = () => {
            if (this.ddi.waypointManager.initialized)
                this.ddi.triggerEventToInstrument("AS04F_ACC_UFCD", "ShowWaypointDataSubMenu");
        };
        this.ddi.setPageButton(6, FA18_DDI_Page_Type.HSIAircraftData);
        this.ddi.setPageButton(8, FA18_DDI_Page_Type.HSITacanData);
        this.ddi.setPageButton(10, FA18_DDI_Page_Type.HSI);
        this.ddi.onButtonPressed[12] = () => {
            this.ddi.waypointManager.nextWaypoint();
        };
        this.ddi.onButtonPressed[13] = () => {
            this.ddi.waypointManager.previousWaypoint();
        };
        this.ddi.onButtonPressed[15] = () => {
            this.ddi.waypointManager.toggleSequences();
        };
        this.ddi.onButtonPressed[18] = () => {
            this.ddi.showPage(FA18_DDI_Page_Type.MenuTactical);
        };
    }
    updateWaypointNumber() {
        if (this.waypointIndexValueElement)
            diffAndSetText(this.waypointIndexValueElement, this.ddi.waypointManager.currentWaypointNumber + '');
        if (this.waypointNameElement)
            diffAndSetText(this.waypointNameElement, "WYPT " + this.ddi.waypointManager.currentWaypointNumber);
    }
    updateSequenceNumber() {
        if (this.sequenceNumberElement && this.ddi.waypointManager.initialized && this.ddi.waypointManager.currentSequence) {
            diffAndSetText(this.sequenceNumberElement, "S E Q " + this.ddi.waypointManager.currentSequence.id);
            if (this.ddi.waypointManager.currentSequence.selected)
                this.sequenceNumberElement.classList.add("sk-label-highlight");
            else
                this.sequenceNumberElement.classList.remove("sk-label-highlight");
        }
    }
    update(deltaTime) {
        super.update(deltaTime);
        if (this.ddi.waypointManager.initialized) {
            this.updateSequenceNumber();
            this.updateWaypointNumber();
            let wp = this.ddi.waypointManager.currentWaypoint;
            if (wp) {
                diffAndSetText(this.latitudeElement, this.ddi.coordinatesDisplay(wp.latitudeFP, true));
                diffAndSetText(this.longitudeElement, this.ddi.coordinatesDisplay(wp.longitudeFP, false));
                diffAndSetText(this.elevationElement, "ELEV " + (wp.altitudeinFP).toFixed() + " FT");
            }
            else {
                diffAndSetText(this.latitudeElement, this.ddi.coordinatesDisplay(0, true));
                diffAndSetText(this.longitudeElement, this.ddi.coordinatesDisplay(0, false));
                diffAndSetText(this.elevationElement, "ELEV " + (0).toFixed() + " FT");
            }
            if (this.ddi.waypointManager.currentSequence)
                diffAndSetText(this.currentSequenceOrder, this.ddi.waypointManager.currentSequence.waypointsNumber.join(" - "));
        }
    }
	get isMaster() { return this.ddi.isMaster; }
}
customElements.define("fa18-acc-ddi-hsi-waypoint-data", FA18ACC_DDI_HSIWaypointData);
//# sourceMappingURL=FA18ACC_DDI_HSIWaypointData.js.map