class FA18ACC_DDI_HSITacanData extends FA18_DDI_Page {
    get templateID() { return "FA18ACC_DDI_HSITacanData"; }
    init(ddi) {
        super.init(ddi);
        this._titleTacanElement = this.ddi.getChildById("tacan-title-value");
        this._latitudeTacanElement = this.ddi.getChildById("tacan-lat-value");
        this._longitudeTacanElement = this.ddi.getChildById("tacan-lon-value");
        this._elevationTacanElement = this.ddi.getChildById("tacan-elev-value");
    }
    show() {
        super.show();
        for (let i of [11, 12, 13, 16]) {
            this.ddi.setPageButton(i, FA18_DDI_Page_Type.NotImplemented);
        }
        this.ddi.onButtonPressed[5] = () => {
            this.ddi.triggerEventToInstrument("AS04F_ACC_UFCD", "ShowTacanSubMenu");
        };
        this.ddi.setPageButton(6, FA18_DDI_Page_Type.HSIAircraftData);
        this.ddi.setPageButton(7, FA18_DDI_Page_Type.HSIWaypointData);
        this.ddi.setPageButton(10, FA18_DDI_Page_Type.HSI);
        this.ddi.setPageButton(18, FA18_DDI_Page_Type.MenuTactical);
    }
    update(deltaTime) {
        super.update(deltaTime);
        diffAndSetText(this._titleTacanElement, SimVar.GetSimVarValue("TACAN ACTIVE CHANNEL:1", "number") + (SimVar.GetSimVarValue("TACAN ACTIVE MODE:1", "Bool") == 0 ? "X" : "Y"));
        if (this.ddi.tacanAvailable) {
            let tacanStationLatLonAlt = SimVar.GetSimVarValue("TACAN STATION LATLONALT:1", "latlonalt");
            diffAndSetText(this._latitudeTacanElement, this.ddi.coordinatesDisplay(tacanStationLatLonAlt.lat, true));
            diffAndSetStyle(this._latitudeTacanElement, "text-align", "left");
            diffAndSetText(this._longitudeTacanElement, this.ddi.coordinatesDisplay(tacanStationLatLonAlt.long, false));
            diffAndSetText(this._elevationTacanElement, "ELEV " + fastToFixed(tacanStationLatLonAlt.alt * Avionics.Utils.METER2FEET, 1) + " FT");
        }
        else {
            diffAndSetText(this._latitudeTacanElement, "NO SIGNAL");
            diffAndSetStyle(this._latitudeTacanElement, "text-align", "center");
            diffAndSetText(this._longitudeTacanElement, "");
            diffAndSetText(this._elevationTacanElement, "");
        }
    }
}
customElements.define("fa18-acc-ddi-hsi-tacan-data", FA18ACC_DDI_HSITacanData);
//# sourceMappingURL=FA18ACC_DDI_HSITacanData.js.map