class FA18ACC_DDI_HSI extends FA18_DDI_HSI {
    get templateID() { return "FA18ACC_DDI_HSI"; }
    show() {
        super.show();
        this.ddi.onButtonPressed[10] = () => {
            this.ddi.showPage(FA18_DDI_Page_Type.HSIWaypointData);
        };
		this.ddi.onButtonPressed[19] = () => {
					var groundtrackOn = SimVar.GetSimVarValue("L:XMLVAR_TRK_FPA_MODE_ACTIVE", "bool");
					SimVar.SetSimVarValue("L:XMLVAR_TRK_FPA_MODE_ACTIVE", "bool", !groundtrackOn);
        };
    }
    update(deltaTime) {
        super.update(deltaTime);
        if (this.ddi.tacanAvailable) {
            this.ddi.map.shownTacanIdent = SimVar.GetSimVarValue("TACAN STATION IDENT:1", "string");
        }
		else if (this.ddi.ilstacanAvailable) {
            this.ddi.map.shownTacanIdent = SimVar.GetSimVarValue("NAV IDENT:" +  this.ddi.ilstacanindex, "string");
        }
		else if (this.ddi.navAvailable) {
            this.ddi.map.shownTacanIdent = SimVar.GetSimVarValue("NAV IDENT:" +  this.ddi.navindex, "string");
        }
		else if (this.ddi.ilsnavAvailable) {
            this.ddi.map.shownTacanIdent = SimVar.GetSimVarValue("NAV IDENT:" +  this.ddi.navindex, "string");
        }
        else {
            this.ddi.map.shownTacanIdent = "";
        }
    }
}
customElements.define("fa18-acc-ddi-hsi", FA18ACC_DDI_HSI);
//# sourceMappingURL=FA18ACC_DDI_HSI.js.map