class FA18ACC_DDI_FCS extends FA18_DDI_Page {
    constructor() {
        super(...arguments);
        this.blinId = 1;
    }
    get templateID() { return "FA18ACC_DDI_FCS"; }
    init(ddi) {
        super.init(ddi);
        this.blinIdElement = this.ddi.getChildById("fcs-blin-id");
        this.spoilersElement = new FA18ACC_DDI_FCS_Surface(this.ddi.getChildById("fcs-spoilers"));
        this.leadingEdgeFlapsElement = new FA18ACC_DDI_FCS_Surface(this.ddi.getChildById("fcs-leading-edge-flaps"));
        this.trailingEdgeFlapsElement = new FA18ACC_DDI_FCS_Surface(this.ddi.getChildById("fcs-trailing-edge-flaps"));
        this.aileronsElement = new FA18ACC_DDI_FCS_Surface(this.ddi.getChildById("fcs-ailerons"));
        this.rudderElement = new FA18ACC_DDI_FCS_Surface(this.ddi.getChildById("fcs-rudder"));
        this.stabilatorElement = new FA18ACC_DDI_FCS_Surface(this.ddi.getChildById("fcs-stabilator"));
        this.gLimiterElement = this.ddi.getChildById("fcs-g-limiter");
        this.leftAoaElement = this.ddi.getChildById("fcs-left-aoa");
        this.mainAoaElement = this.ddi.getChildById("fcs-main-aoa");
        this.rightAoaElement = this.ddi.getChildById("fcs-right-aoa");
    }
    show() {
        super.show();
        this.ddi.onButtonPressed[2] = () => {
            this.blinId = (this.blinId % 4) + 1;
            diffAndSetText(this.blinIdElement, this.blinId.toFixed(0));
        };
        this.ddi.onButtonPressed[18] = () => {
            this.ddi.showPage(FA18_DDI_Page_Type.MenuTactical);
        };
    }
    formatArrow(element, value, upDownArrow = true) {
        if (element) {
            if (value == null || Math.round(value) == 0) {
                diffAndSetText(element, "");
            }
            else {
                if (upDownArrow) {
                    diffAndSetHTML(element, (value > 0) ? "&#8593;" : "&#8595;");
                }
                else {
                    diffAndSetHTML(element, (value > 0) ? "&#8594;" : "&#8592;");
                }
            }
        }
    }
    formatValue(element, value) {
        if (element) {
            if (value == null) {
                diffAndSetText(element, "");
            }
            else {
                diffAndSetText(element, Math.abs(value).toFixed(0));
            }
        }
    }
    updateSpoilers(deltaTime) {
        if (this.spoilersElement) {
            let leftSpoilerValue = SimVar.GetSimVarValue("SPOILERS LEFT POSITION", "percent over 100") * 60;
            let rightSpoilerValue = SimVar.GetSimVarValue("SPOILERS RIGHT POSITION", "percent over 100") * 60;
            this.leftSpoilerValue = Utils.SmoothPow(this.leftSpoilerValue, leftSpoilerValue, 1.1, deltaTime / 1000);
            this.rightSpoilerValue = Utils.SmoothPow(this.rightSpoilerValue, rightSpoilerValue, 1.1, deltaTime / 1000);
            this.formatValue(this.spoilersElement.leftValue, this.leftSpoilerValue);
            this.formatValue(this.spoilersElement.rightValue, this.rightSpoilerValue);
            this.formatArrow(this.spoilersElement.leftArrow, this.leftSpoilerValue);
            this.formatArrow(this.spoilersElement.rightArrow, this.rightSpoilerValue);
        }
    }
    updateLeadingEdgeFlaps(deltaTime) {
        if (this.leadingEdgeFlapsElement) {
            let leftLefValue = SimVar.GetSimVarValue("LEADING EDGE FLAPS LEFT ANGLE", "degrees");
            let rightLefValue = SimVar.GetSimVarValue("LEADING EDGE FLAPS RIGHT ANGLE", "degrees");
            this.leftLefValue = Utils.SmoothPow(this.leftLefValue, leftLefValue, 1.1, deltaTime / 1000);
            this.rightLefValue = Utils.SmoothPow(this.rightLefValue, rightLefValue, 1.1, deltaTime / 1000);
            this.formatValue(this.leadingEdgeFlapsElement.leftValue, this.leftLefValue);
            this.formatValue(this.leadingEdgeFlapsElement.rightValue, this.rightLefValue);
            this.formatArrow(this.leadingEdgeFlapsElement.leftArrow, this.leftLefValue);
            this.formatArrow(this.leadingEdgeFlapsElement.rightArrow, this.rightLefValue);
        }
    }
    updateTrailingEdgeFlaps(deltaTime) {
        if (this.trailingEdgeFlapsElement) {
            let leftTefValue = SimVar.GetSimVarValue("TRAILING EDGE FLAPS LEFT ANGLE", "degrees");
            let rightTefValue = SimVar.GetSimVarValue("TRAILING EDGE FLAPS RIGHT ANGLE", "degrees");
            this.leftTefValue = Utils.SmoothPow(this.leftTefValue, leftTefValue, 1.1, deltaTime / 1000);
            this.rightTefValue = Utils.SmoothPow(this.rightTefValue, rightTefValue, 1.1, deltaTime / 1000);
            this.formatValue(this.trailingEdgeFlapsElement.leftValue, this.leftTefValue);
            this.formatValue(this.trailingEdgeFlapsElement.rightValue, this.rightTefValue);
            this.formatArrow(this.trailingEdgeFlapsElement.leftArrow, this.leftTefValue);
            this.formatArrow(this.trailingEdgeFlapsElement.rightArrow, this.rightTefValue);
        }
    }
    updateAilerons(deltaTime) {
        if (this.aileronsElement) {
            let leftAileronValue = SimVar.GetSimVarValue("AILERON LEFT DEFLECTION", "degrees");
            let rightAileronValue = SimVar.GetSimVarValue("AILERON RIGHT DEFLECTION", "degrees");
            this.leftAileronValue = Utils.SmoothPow(this.leftAileronValue, leftAileronValue, 1.1, deltaTime / 1000);
            this.rightAileronValue = Utils.SmoothPow(this.rightAileronValue, rightAileronValue, 1.1, deltaTime / 1000);
            this.formatValue(this.aileronsElement.leftValue, this.leftAileronValue);
            this.formatValue(this.aileronsElement.rightValue, this.rightAileronValue);
            this.formatArrow(this.aileronsElement.leftArrow, this.leftAileronValue);
            this.formatArrow(this.aileronsElement.rightArrow, this.rightAileronValue);
        }
    }
    updateRudder(deltaTime) {
        if (this.rudderElement) {
            let rudderValue = SimVar.GetSimVarValue("RUDDER DEFLECTION", "degrees");
            this.rudderValue = Utils.SmoothPow(this.rudderValue, rudderValue, 1.1, deltaTime / 1000);
            this.formatValue(this.rudderElement.leftValue, this.rudderValue);
            this.formatValue(this.rudderElement.rightValue, this.rudderValue);
            this.formatArrow(this.rudderElement.leftArrow, this.rudderValue, false);
            this.formatArrow(this.rudderElement.rightArrow, this.rudderValue, false);
        }
    }
    updateStabilator(deltaTime) {
        if (this.stabilatorElement) {
            let elevatorValue = SimVar.GetSimVarValue("ELEVATOR DEFLECTION", "degrees");
            this.elevatorValue = Utils.SmoothPow(this.elevatorValue, elevatorValue, 1.1, deltaTime / 1000);
            this.formatValue(this.stabilatorElement.leftValue, this.elevatorValue);
            this.formatValue(this.stabilatorElement.rightValue, this.elevatorValue);
            this.formatArrow(this.stabilatorElement.leftArrow, this.elevatorValue);
            this.formatArrow(this.stabilatorElement.rightArrow, this.elevatorValue);
        }
    }
    updateGLimiter() {
        if (SimVar.GetSimVarValue("G LIMITER SETTING", "Enum") == 1) {
            diffAndSetText(this.gLimiterElement, "G - LIM 7.5 G");
        }
        else {
            diffAndSetText(this.gLimiterElement, "G - LIM 9.9 G");
        }
    }
    updateAoa() {
        let aoa = Simplane.getAngleOfAttack("degree");
        diffAndSetText(this.leftAoaElement, "L " + Utils.leadingZeros(aoa, 2, 1));
        diffAndSetText(this.mainAoaElement, "AOA " + Utils.leadingZeros(aoa, 2, 1));
        diffAndSetText(this.rightAoaElement, "R " + Utils.leadingZeros(aoa, 2, 1));
    }
    update(deltaTime) {
        super.update(deltaTime);
        this.updateSpoilers(deltaTime);
        this.updateLeadingEdgeFlaps(deltaTime);
        this.updateTrailingEdgeFlaps(deltaTime);
        this.updateAilerons(deltaTime);
        this.updateRudder(deltaTime);
        this.updateStabilator(deltaTime);
        this.updateGLimiter();
        this.updateAoa();
    }
}
class FA18ACC_DDI_FCS_Surface {
    constructor(rootElement) {
        if (rootElement) {
            let leftArrowElements = rootElement.getElementsByClassName("fcs-left-arrow");
            if (leftArrowElements.length > 0)
                this.leftArrow = leftArrowElements[0];
            let leftValueElements = rootElement.getElementsByClassName("fcs-left-value");
            if (leftValueElements.length > 0)
                this.leftValue = leftValueElements[0];
            let rightArrowElements = rootElement.getElementsByClassName("fcs-right-arrow");
            if (rightArrowElements.length > 0)
                this.rightArrow = rightArrowElements[0];
            let rightValueElements = rootElement.getElementsByClassName("fcs-right-value");
            if (rightValueElements.length > 0)
                this.rightValue = rightValueElements[0];
        }
    }
}
customElements.define("fa18-acc-ddi-fcs", FA18ACC_DDI_FCS);
//# sourceMappingURL=FA18ACC_DDI_FCS.js.map