class FA18ACC_DDI_Checklist extends FA18_DDI_Page {
    get templateID() { return "FA18ACC_DDI_Checklist"; }
    init(ddi) {
        super.init(ddi);
        this.checklistAircraftWeightElement = this.ddi.getChildById("checklist-aircraft-weight");
        this.checklistMaxNZElement = this.ddi.getChildById("checklist-max-nz");
        this.checklistStabPosElement = this.ddi.getChildById("checklist-stab-pos");
    }
    show() {
        super.show();
        this.ddi.setPageButton(18, FA18_DDI_Page_Type.MenuTactical);
        this.ddi.setPageButton(11, FA18_DDI_Page_Type.NotImplemented);
    }
    update(deltaTime) {
        super.update(deltaTime);
        let weight = Simplane.getWeight() * 2.204623;
        diffAndSetText(this.checklistAircraftWeightElement, "A/C WT    " + fastToFixed(weight, 0));
        diffAndSetText(this.checklistMaxNZElement, "MAX NZ    " + fastToFixed(SimVar.GetSimVarValue("MAX G FORCE", "gforce"), 2));
        let trim = Simplane.getTrimPos();
        let trimString = Math.abs(trim).toFixed(0) + Avionics.Utils.DEGREE_SYMBOL + (trim >= 0 ? "NU" : "ND");
        diffAndSetText(this.checklistStabPosElement, trimString + "    STAB POS    " + trimString);
    }
}
customElements.define("fa18-acc-ddi-checklist", FA18ACC_DDI_Checklist);
//# sourceMappingURL=FA18ACC_DDI_Checklist.js.map