const SimvarService = class SimvarService {
  constructor(realSimVarService = null) {
    this.InMemorySimVars = {};
    this.IsRunningInBrowser =
      window.navigator.userAgent.toLowerCase().indexOf("coherent") == -1;
    this.RealSimVarService = realSimVarService;
  }

  GetSimVar(key, type) {
    return this.IsRunningInBrowser
      ? this.InMemorySimVars[key] || 0
      : this.RealSimVarService.GetSimVarValue(key, type);
  }

  GetMultipleSimVars(simVars) {
    let result = {};
    for (const [key, type] of Object.entries(simVars)) {
      result[key] = this.GetSimVar(key, type);
    }
    return result;
  }

  GetMultipleSimVarsAsArray(simVars, type) {
    let result = [];
    for (let key of simVars) {
      result.push(this.GetSimVar(key, type));
    }
    return result;
  }

  SetSimVar(key, type, value) {
    if (this.IsRunningInBrowser) {
      this.InMemorySimVars[key] = value;
    } else {
      this.RealSimVarService.SetSimVarValue(key, type, value);
    }
  }

  SetMultipleSimVars(simVars, type) {
    console.log("setting simvars", simVars);
    for (const [key, value] of Object.entries(simVars)) {
      this.SetSimVar(key, type, value);
    }
  }
};
