const Pagination = class Pagination {
    constructor() {
        this.Items = [];
        this.PageSize = 6;
        this.CurrentPage = 1;
    }

    setItems(items) {
        this.Items = items;
    }

    goToPage(page) {
        this.CurrentPage = page;
    }

    isOnLastPage() {
        return this.CurrentPage == this.getTotalPages();
    }

    nextPage() {
        if (this.isOnLastPage()) {
            return;
        }

        this.CurrentPage++;
    }

    isOnFirstPage() {
        return this.CurrentPage == 1;
    }

    previousPage() {
        if (this.isOnFirstPage()) {
            return;
        }

        this.CurrentPage--;
    }

    getPage() {
        let end = (this.CurrentPage * this.PageSize);
        let start = end - this.PageSize;

        return this.Items.slice(start, end);
    }

    getTotalPages() {
        return Math.ceil(this.Items.length / this.PageSize);
    }
}