const CargoJob = class CargoJob {
    constructor(
        arrivalAirport,
        departureLatitude,
        departureLongitude,
        cargoItemName
    ) {
        this.ArrivalAirport = arrivalAirport;
        this.DepartureLatitude = departureLatitude;
        this.DepartureLongitude = departureLongitude;
        this.CargoItemName = cargoItemName;
    }
}

const CargoJobBuilder = class CargoJobBuilder {
    constructor() {
        this.ArrivalAirport = null;
        this.DepartureLatitude = null;
        this.DepartureLongitude = null;
        this.CargoItemName = "";
    }

    static create() {
        return new CargoJobBuilder();
    }

    withArrivalAirport(arrivalAirport) {
        this.ArrivalAirport = arrivalAirport;
        return this;
    }

    withDepartureLatitude(departureLatitude) {
        this.DepartureLatitude = departureLatitude;
        return this;
    }

    withDepartureLongitude(departureLongitude) {
        this.DepartureLongitude = departureLongitude;
        return this;
    }

    withCargoItemName(cargoItemName) {
        this.CargoItemName = cargoItemName;
        return this;
    }

    build() {
        return new CargoJob(
            this.ArrivalAirport,
            this.DepartureLatitude,
            this.DepartureLongitude,
            this.CargoItemName
        );
    }
}