const Airport = class Airport {
    constructor(
        id,
        icao,
        country,
        latitude,
        longitude,
        runwayLength,
        distanceFromStart,
        cargoItem
    ) {
        this.Id = id;
        this.Icao = icao;
        this.Country = country;
        this.Latitude = latitude;
        this.Longitude = longitude;
        this.RunwayLength = runwayLength;
        this.DistanceFromStart = distanceFromStart;
        this.CargoItem = cargoItem;
    }
}

const AirportBuilder = class AirportBuilder {
    constructor() {
        this.Id = -1;
        this.Icao = "";
        this.Country = "";
        // Nullable int; -1 is a valid latitude close to equator
        this.Latitude = null;
        // Nullable int; -1 is a valid longitude close to prime meridian
        this.Longitude = null;
        this.RunwayLength = -1;
        this.DistanceFromStartInNm = -1;
        this.CargoItem = "";
    }

    static create() {
        return new AirportBuilder();
    }

    withId(id) {
        this.Id = id;
        return this;
    }

    withIcao(icao) {
        this.Icao = icao;
        return this;
    }

    withCountry(country) {
        this.Country = country;
        return this;
    }

    withLatitude(latitude) {
        this.Latitude = latitude;
        return this;
    }

    withLongitude(longitude) {
        this.Longitude = longitude;
        return this;
    }

    withRunwayLength(runwayLength) {
        this.RunwayLength = runwayLength;
        return this;
    }

    withDistanceFromStart(distanceFromStart) {
        this.DistanceFromStart = distanceFromStart;
        return this;
    }

    withCargoItem(cargoItem) {
        this.CargoItem = cargoItem;
        return this;
    }

    build() {
        return new Airport(
            this.Id,
            this.Icao,
            this.Country,
            this.Latitude,
            this.Longitude,
            this.RunwayLength,
            this.DistanceFromStart,
            this.CargoItem
        );
    }
}