/* MSFS Format */
class QuasarEFB extends BaseInstrument {

/* Browser Format */
// class QuasarEFB extends HTMLElement {

    constructor() {
        super();

        this.Restrictions = {
            IsOnGround: false,
            IsParkingBrakeOn: false,
            IsCanopyOpen: false,
        }

        this.RangeSlider = {};
        this._isConnected = false;
        this.MusicLines = [];
        this.CargoService = new CargoService();
        this.SeenAirports = 0;
        this.CurrentRange = "";
        this.OnFinalMissionPage = false;
        this.EventListeners = {
            "cargoMissionCancel.mousedown": this.cargoMissionCancel.bind(this),
            "cargoMissionCancelManual.mousedown": this.cargoMissionCancelManual.bind(this),
            "cargoMissionComplete.mousedown": this.cargoMissionComplete.bind(this),
        };
        this.TickCounter = 0;

        /* MSFS/Browser: Auto-Detect*/
        this.Browser = window.navigator.userAgent.toLowerCase().indexOf('coherent') == -1;

        if (!this.Browser) {
            this.SimvarService = new SimvarService(SimVar);
        } else {
            this.SimvarService = new SimvarService();
            this.SimvarService.SetMultipleSimVars(default_simvars);
        }
    }
    get templateID() { return "QuasarEFB"; } // ID of <script> tag in html
    get isInteractive() { return true; }

    // * CONNECTED CALLBACK
    // *_____________________________________________________________________

    connectedCallback() {

        if (!this.Browser) {
            super.connectedCallback();
        }

        // this.RangeSlider.configure(1, 2);
        this.RangeSlider = new RangeSlider(
            this,
            document.querySelector(".mission-range-wrapper"),
            100,
            200
        );

        // -------------------- PAGE DRAW AND DOM ELEMENTS LOAD: THESE ITEMS WILL NOT BE REFRESHED BY THE SIM -----------------------------

        // 1- IF NEEDED > LOAD SIMVARS NECESSARY TO DRAW PAGE DYNAMICALLY

        

        // 2- DRAW DYNAMIC ELEMETS (COLLECT REQUIRED DOMS TO PUSH NEW DATA IN)

        this.cargoPersonalDataElement = this.getId("cargoTitle > span");
        this.updateCargoPersonalData();

        this.musTable = this.getId("musTable");

        var musTableContent = music_titles
            .map((item, i) => `            
                <div id="musLine${i}" class="musLine" data-music-line-id="${i}">
                    <span class="musIcon" id="musIcon${i}" data-music-line-id="${i}"></span>
                    <span class="musTitle" data-music-line-id="${i}">${item.title}</span>
                    <span class="musArtist" data-music-line-id="${i}">${item.artist}</span>
                    <span class="musGenre" data-music-line-id="${i}">${item.genre}</span>
                </div>
            `)
            .join('');
        this.musTable.innerHTML = musTableContent;

        // Additional (MUSIC) items
        music_titles.forEach((_, i) => {
            let line = document.querySelector(`div[data-music-line-id='${i}']`);
            line.addEventListener('mousedown', this.playMusic.bind(this));

            let icon = document.querySelector(`div[data-music-line-id='${i}'] .musIcon`);
            icon.addEventListener('mousedown', this.playMusic.bind(this));

            this.MusicLines[i] = {
                line: line,
                icon: icon,
            };
        });
        
        // 3- COLLECT DOM IDS AND ADD EVENT LISTENERS

        var nonInteractiveItems = [
            'homebar', 'hometext', 'menubar',
            'bg_blur', 'version', 'flighthours',
            'brgtOverlay', 'brgtActionFilled',
            'pageFuel', 'fuelPreset0', 'fuelPreset29', 'fuelPreset50', 'fuelPreset100',
            'pageAboard', 'aboardPic0', 'aboardPic1', 'aboardPic2', 'aboardName0', 'aboardName1', 'aboardName2', 'aboardBio0', 'aboardBio1', 'aboardBio2',
            'pageRbf', 'rbfPicNose', 'rbfPicRoof', 'rbfPicIntakes', 'rbfPicEngines', 'rbfPicChocks',
            'pageCargo', 'cargoCount',
            'pageOptions',
            'pageSpeed',
            'pageInfos',
            'pageMusic', 'musDisclaimer', 'musActionFilled'
        ];
        nonInteractiveItems.forEach(item => { this[item] = this.getId(item); });

        var interactiveItems = [
            { 'id': 'homeFuel', fn: this.goToPage1 },
            { 'id': 'iconfuel', fn: this.goToPage1 },
            { 'id': 'menuFuel', fn: this.goToPage1 },
            { 'id': 'homeAboard', fn: this.goToPage2 },
            { 'id': 'iconaboard', fn: this.goToPage2 },
            { 'id': 'menuAboard', fn: this.goToPage2 },
            { 'id': 'homeRbf', fn: this.goToPage3 },
            { 'id': 'iconrbf', fn: this.goToPage3 },
            { 'id': 'menuRbf', fn: this.goToPage3 },
            { 'id': 'homeOptions', fn: this.goToPage4 },
            { 'id': 'iconoptions', fn: this.goToPage4 },
            { 'id': 'menuOptions', fn: this.goToPage4 },
            { 'id': 'homeSpeeds', fn: this.goToPage5 },
            { 'id': 'iconspeed', fn: this.goToPage5 },
            { 'id': 'menuSpeeds', fn: this.goToPage5 },
            { 'id': 'homeInfos', fn: this.goToPage6 },
            { 'id': 'iconinfos', fn: this.goToPage6 },
            { 'id': 'menuInfos', fn: this.goToPage6 },
            { 'id': 'homeCargo', fn: this.goToPage7 },
            { 'id': 'iconcargo', fn: this.goToPage7 },
            { 'id': 'menuCargo', fn: this.goToPage7 },
            { 'id': 'homeMusic', fn: this.goToPage8 },
            { 'id': 'iconmusic', fn: this.goToPage8 },
            { 'id': 'menuMusic', fn: this.goToPage8 },
            { 'id': 'menuHome', fn: this.goToPage0 },
            { 'id': 'brgtIcon', fn: this.optionClick },
            { 'id': 'brgtClose', fn: this.optionClick },
            { 'id': 'fuelPS0Img', fn: this.optionClick },
            { 'id': 'fuelPS0Text', fn: this.optionClick },
            { 'id': 'fuelPS29Img', fn: this.optionClick },
            { 'id': 'fuelPS29Text', fn: this.optionClick },
            { 'id': 'fuelPS50Img', fn: this.optionClick },
            { 'id': 'fuelPS50Text', fn: this.optionClick },
            { 'id': 'fuelPS100Img', fn: this.optionClick },
            { 'id': 'fuelPS100Text', fn: this.optionClick },
            { 'id': 'aboardPrev', fn: this.optionClick },
            { 'id': 'aboardNext', fn: this.optionClick },
            { 'id': 'rbfNose', fn: this.optionClick },
            { 'id': 'rbfRoof', fn: this.optionClick },
            { 'id': 'rbfIntakes', fn: this.optionClick },
            { 'id': 'rbfEngines', fn: this.optionClick },
            { 'id': 'rbfChocks', fn: this.optionClick },
            { 'id': 'optNR', fn: this.optionClick },
            { 'id': 'optVibr', fn: this.optionClick },
            { 'id': 'optVFX', fn: this.optionClick },
            { 'id': 'optTemp', fn: this.optionClick },
            { 'id': 'optShiver', fn: this.optionClick },
            { 'id': 'optGraffiti', fn: this.optionClick },
            { 'id': 'optFood', fn: this.optionClick },
            { 'id': 'cargoNavButtons > #cargoNavPrev', fn: this.cargoPreviousPage },
            { 'id': 'cargoNavButtons > #cargoNavNext', fn: this.cargoNextPage },
        ];

        interactiveItems.forEach(item => {
            this[item.id] = this.getId(item.id);
            this[item.id].addEventListener("mousedown", item.fn.bind(this));
        });

        [
            { selector: "button.cargoBtn", fn: this.cargoBtnClick },
        ].forEach(item => {
            this[item.selector] = this.getDomItems(item.selector);
            this[item.selector].forEach(x => {
                x.addEventListener("mousedown", item.fn.bind(this))
            });
        })

        // Drag & drop items
        var dragAndDropItems = [
            { id: "musAction", fnDown: "grabMusicVolume", fnUp: "releaseMusicVolume", fnMove: "setMusicVolume", },
            { id: "brgtAction", fnDown: "grabBrightness", fnUp: "releaseBrightness", fnMove: "setBrightness" },
        ];

        dragAndDropItems.forEach(item => {
            let x = $(`#${item.id}`);
            this[item.id] = x;

            x
                .on("mousedown", this[item.fnDown].bind(this))
                .on("mousemove", this[item.fnMove].bind(this))
                .on("mouseup", this[item.fnMove].bind(this));

            x
                .on("mousedown", (e) => {
                    x.off("mousedown", "mousemove", "mouseup");
                    this[item.fnDown](e);
                    $(document)
                        .on("mousemove", this[item.fnMove].bind(this))
                        .on("mouseup", this[item.fnUp].bind(this));
                })
                .on("mousemove", this[item.fnMove].bind(this))
                .on("mouseup", this[item.fnUp].bind(this));
        });
        


        // -------------------- BELOW THIS POINT THE SIM WILL RUN THE TESTS AND ACTIONS CONTINUOUSLY -----------------------------

        if (this.Browser) {
            setInterval(function () {
                this.Update();
            }.bind(this), 100);
        }
        this._isConnected = true;
    }

    // * INTERACTION FUNCTIONS
    // *_____________________________________________________________________

    goToPage0(e) { this.goToPage(0); } goToPage1(e) { this.goToPage(1); } goToPage2(e) { this.goToPage(2); } goToPage3(e) { this.goToPage(3); }
    goToPage4(e) { this.goToPage(4); } goToPage5(e) { this.goToPage(5); } goToPage6(e) { this.goToPage(6); } goToPage7(e) { this.goToPage(7); }
    goToPage8(e) { this.goToPage(8); }

    goToPage(num) {
        this.SimvarService.SetSimVar("L:FRIES_EFB_Page_Click", "bool", (1 - this.valEFBPageClick));
        this.SimvarService.SetSimVar("L:FRIES_EFB_Page", "number", num);
    }

    optionClick(e) {
        this.SimvarService.SetSimVar("L:FRIES_EFB_Click", "bool", (1 - this.valEFBClick));

        switch (e.target.id) {

            // Brightness popup
            case "brgtIcon":
                this.SimvarService.SetSimVar("L:FRIES_EFB_Brgt", "bool", 1);
                break;

            case "brgtClose":
                this.SimvarService.SetSimVar("L:FRIES_EFB_Brgt", "bool", 0);
                break;

            // FUEL
            case "fuelPS0Text":
                var tanks = [0, 0, 0, 0, 0, 0, 0];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS0Img":
                var tanks = [0, 0, 0, 0, 0, 0, 0];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS29Text":
                var tanks = [0, 0, 0, 1, 1, 1, 1];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS29Img":
                var tanks = [0, 0, 0, 1, 1, 1, 1];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS50Text":
                var tanks = [0, 0, 0.51, 1, 1, 1, 1];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS50Img":
                var tanks = [0, 0, 0.51, 1, 1, 1, 1];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS100Text":
                var tanks = [1, 1, 1, 1, 1, 1, 1];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;
            case "fuelPS100Img":
                var tanks = [1, 1, 1, 1, 1, 1, 1];
                for (let i = 0; i < tanks.length; i++) { this.SimvarService.SetSimVar("FUELSYSTEM TANK LEVEL:" + (i + 1), "Percent Over 100", tanks[i]); }
                break;

            // ABOARD
            case "aboardPrev":
                if (this.valCharSelected > 0) this.valCharSelected -= 1;
                else this.valCharSelected = (this.valCharsNumber - 1);
                this.SimvarService.SetSimVar("L:QSR_Char_Selected", "number", this.valCharSelected);
                break;

            case "aboardNext":
                if (this.valCharSelected < this.valCharsNumber - 1) this.valCharSelected += 1;
                else this.valCharSelected = 0;
                this.SimvarService.SetSimVar("L:QSR_Char_Selected", "number", this.valCharSelected);
                break;

            // RBF
            case "rbfNose":
                if (!this.valMachTest && this.valGS < 1) this.SimvarService.SetSimVar("L:QSR_Nose_Covers", "bool", (1 - this.valRBFNose));
                break;
            case "rbfRoof":
                if (this.valGS < 5) this.SimvarService.SetSimVar("L:QSR_Roof_Cover", "bool", (1 - this.valRBFRoof));
                break;
            case "rbfIntakes":
                if (this.valGS < 5) this.SimvarService.SetSimVar("L:QSR_TopIntakes_Covers", "bool", (1 - this.valRBFIntakes));
                break;
            case "rbfEngines":
                if (!this.valEng1On || !this.valEng2On || !this.valEng3On || !this.valEng4On) this.SimvarService.SetSimVar("L:QSR_Engine_Covers", "bool", (1 - this.valRBFEngines));
                break;
            case "rbfChocks":
                if (this.valCPoint0 && this.valCPoint1 && this.valCPoint2 && this.valGS < 1) this.SimvarService.SetSimVar("L:QSR_Wheel_Chocks", "bool", (1 - this.valRBFChocks));
                break;

            // OPTIONS
            case "optNR":
                this.SimvarService.SetSimVar("L:FRIES_Headphones", "bool", (1 - this.valNR));
                break;
            case "optVibr":
                if (this.valVibr && this.valVibrIntensity == 1) this.SimvarService.SetSimVar("L:FRIES_Vibrations_Intensity", "number", 2);
                else if (this.valVibr && this.valVibrIntensity == 2) {
                    this.SimvarService.SetSimVar("L:FRIES_Vibrations", "bool", 0);
                    this.SimvarService.SetSimVar("L:FRIES_Vibrations_Intensity", "number", 1);
                }
                else if (!this.valVibr) {
                    this.SimvarService.SetSimVar("L:FRIES_Vibrations", "bool", 1);
                    this.SimvarService.SetSimVar("L:FRIES_Vibrations_Intensity", "number", 1);
                }
                break;
            case "optVFX":
                this.SimvarService.SetSimVar("L:FRIES_VFX", "bool", (1 - this.valVFX));
                break;
            case "optTemp":
                this.SimvarService.SetSimVar("L:FRIES_TempUnit_Celsius", "bool", (1 - this.valTempUnit));
                break;
            case "optShiver":
                this.SimvarService.SetSimVar("L:QSR_Shiver", "bool", (1 - this.valShiver));
                break;
            case "optGraffiti":
                this.SimvarService.SetSimVar("L:QSR_Graffiti", "bool", (1 - this.valGraffiti));
                break;
            case "optFood":
                if (this.valFries < 4) { this.SimvarService.SetSimVar("L:QSR_Fries", "number", 4); }
                this.valCans.forEach((item, index) => {
                    // console.log(`Can ${index + 1}: ${item}`);
                    if (item == 3) {
                        this.SimvarService.SetSimVar(`L:CAN${index + 1}`, "number", 0);
                    }
                })
                break;
        }
    }

    updateCargoPersonalData(
        currentTotalDistance = -1,
        currentTotalDistanceMillions = -1,
        currentTotalMissionsCompleted = -1
    ) {
        if (currentTotalDistance < 0 || currentTotalDistanceMillions < 0 || currentTotalMissionsCompleted < 0) {
            currentTotalDistance = +this.SimvarService.GetSimVar("L:QSR_Cargo_Distance", "number");
            currentTotalDistanceMillions = +this.SimvarService.GetSimVar("L:QSR_Cargo_Distance_Millions", "number");
            currentTotalMissionsCompleted = +this.SimvarService.GetSimVar("L:QSR_Cargo_Missions", "number");
        }

        this.CargoService.setupPersonalData(+currentTotalDistance, +currentTotalDistanceMillions, +currentTotalMissionsCompleted);

        let personalDataHtml = `
            ${this.CargoService.TotalMissionsCompleted}
            missions finished //
            ${this.CargoService.TotalDistanceTraveledInNm.toLocaleString("en-US")}
            NM
        `;
        this.cargoPersonalDataElement.innerHTML = personalDataHtml;
    }

    cargoBtnClean() {
        this['button.cargoBtn'].forEach(x => x.classList.remove("cargoBtnSelected"));
    }

    cargoBtnClick(e) {
        let that = this;
        this.cargoBtnClean();

        let btn = e.currentTarget || e.target;
        btn.classList.add("cargoBtnSelected");

        this.cargoServiceReset();

        $("#cargoLeft").animate({
            width: "160px",
        }, {
            duration: 400,
            complete: function () {
                $("#cargoRight").fadeIn();
                $("#cargoGrid").css({
                    "display": "grid",
                    "grid-template-columns": "160px 1fr",
                })
            }
        });

        let selectedRange = btn.getAttribute('data-cargo-length');
        this.updateCargoList(selectedRange, true);

        $("#rangeSlider").fadeIn();
        $("#cargoNavButtons").fadeIn();
    }

    cargoServiceReset() {
        this.CargoService
            .setupLocation(
                this.SimvarService.GetSimVar("A:GPS POSITION LAT", "degrees"),
                this.SimvarService.GetSimVar("A:GPS POSITION LON", "degrees")
            )
            .setupAirports();
        this.updateCargoPersonalData();
    }

    updateCargoListItems() {
        if (this.CargoService.MissionPagination.isOnFirstPage()) {
            $("#cargoNavPrev").css("color", "gray");
        } else {
            $("#cargoNavPrev").css("color", "white");
        }

        if (this.CargoService.MissionPagination.isOnLastPage()) {
            $("#cargoNavNext").css("color", "gray");
        } else {
            $("#cargoNavNext").css("color", "white");
        }

        let tableContent = this
            .CargoService
            .MissionPagination
            .getPage()
            .map(item => {
                return `
                    <tr class="cargo-row" data-airport-id="${item.Id}">
                        <td class="cargo-item cargo-item-country">${item.Country}</td>
                        <td class="cargo-item cargo-item-icao">${item.Icao}</td>
                        <td class="cargo-item cargo-item-distance">${item.DistanceFromStart} NM</td>
                        <td class="cargo-item cargo-item-cargo" data-cargo-item-name="${item.CargoItem}">
                            ${item.CargoItem}
                        </td>
                    </tr>
                `
            })
            .join('');

        $("#cargoTable > tbody").html(tableContent);
        let that = this;
        $(".cargo-row").each(function(index) {
            $(this).on("click", that.cargoRowClick.bind(that));
        })
    }

    updateCargoListWithMinMax(minRadius, maxRadius) {
        let airports = this.CargoService.getAirportsWithinRadiusRange(minRadius, maxRadius);

        this.CargoService.MissionPagination.setItems(airports);

        this.updateCargoListItems();
    }

    updateCargoList(selectedRange, isRangeButton = false) {
        let [minRadius, maxRadius] = [-1, -1];
        switch (selectedRange) {
            case "short":
                minRadius = 100;
                maxRadius = 1000;
                break;
            case "medium":
                minRadius = 1000;
                maxRadius = 3000;
                break;
            case "long":
                minRadius = 3000;
                maxRadius = 6000;
                break;
            case "extreme":
                minRadius = 6000;
                maxRadius = this.CargoService.Airports[
                    this.CargoService.Airports.length - 1
                ].DistanceFromStart;
                break;
        }

        if(isRangeButton){
            this.RangeSlider.updateMinMax(minRadius, maxRadius);
        }

        this.updateCargoListWithMinMax(minRadius, maxRadius);
    }

    confirm(
        title,
        message,
        yesText = "Yes",
        noText = "No",
        yesClick = null,
        yesClickParams = null
    ) {
        let [
            overlayElement,
            titleElement,
            bodyElement,
            yesElement,
            noElement
        ] = [
            $("#confirm-overlay"),
            $("#confirm-title"),
            $("#confirm-body"),
            $("#confirm-yes"),
            $("#confirm-no"),
        ];

        titleElement.html(title);
        bodyElement.html(message);
        yesElement.html(yesText);
        noElement.html(noText);

        if (yesClick != null) {
            if (yesClickParams !== null) {
                Object
                    .entries(yesClickParams)
                    .forEach(([key, value]) => {
                        yesElement.attr(key, value);
                    });
            }
            yesElement.on("click", yesClick);
        } else {
            yesElement.on("click", function () {
                overlayElement.fadeOut();
            });
        }

        noElement.on("click", function () {
            overlayElement.fadeOut();
        });

        overlayElement.fadeIn();
    }

    warning(message) {
        $("#warning-body").html(message);
        $("#warning-overlay").fadeIn();
        $("#warning-close").on("click", function() {
            $("#warning-overlay").fadeOut();
        })
    }

    cargoRowClick(e) {
        console.log(this.Restrictions);
        if (
            !this.Restrictions.IsOnGround ||
            !this.Restrictions.IsCanopyOpen ||
            !this.Restrictions.IsParkingBrakeOn
        ) {
            this.warning("You must be stopped with your canopy open and parking brake set.");
            return;
        }

        let row = e.currentTarget || e.target;
        let airportId = row.getAttribute("data-airport-id");
        let cargoItemName = row.querySelector("td.cargo-item-cargo").getAttribute("data-cargo-item-name");
        let airport = this.CargoService.getAirportById(airportId);

        let cargoJob = CargoJobBuilder
            .create()
            .withDepartureLatitude(this.CargoService.StartingLatitude)
            .withDepartureLongitude(this.CargoService.StartingLongitude)
            .withArrivalAirport(airport)
            .withCargoItemName(cargoItemName)
            .build();

        this.CargoService.CurrentJob = cargoJob;

        this.cargoStartMission();
    }

    cargoPreviousPage() {
        this.CargoService.MissionPagination.previousPage();
        this.updateCargoListItems();
    }

    cargoNextPage() {
        this.CargoService.MissionPagination.nextPage();
        this.updateCargoListItems();
    }

    cargoStartMission() {
        if (
            this.CargoService.CurrentJob == null ||
            typeof (this.CargoService.CurrentJob) === undefined
        ) {
            console.error("Tried to start mission which doesn't exist");
            return;
        }

        let [cargoGrid, cargoMission] = [
            $("#cargoGrid"),
            $("#cargoMission"),
        ]

        let that = this;

        cargoGrid.hide();
        $("#cargoMission").fadeIn();

        $("#loading-container")
            .css("display", "flex")
            .hide()
            .fadeIn(400);
        $("#loading-value").addClass("animate");

        let [loadingLabel, securingLabel, confirmingLabel, distanceLabel] = [
            $("#loading-label-loading"),
            $("#loading-label-securing"),
            $("#loading-label-confirming"),
            $("#loading-label-distance"),
        ];

        loadingLabel.html(`
            Loading
            <span>${that.CargoService.CurrentJob.CargoItemName}</span>
        `);
        securingLabel.html("Securing cargo");
        confirmingLabel.html(`
            Confirming mission to
            <span>${that.CargoService.CurrentJob.ArrivalAirport.Icao}</span>
            with Mission Control
        `);
        distanceLabel.html(`
            Estimated travel distance:
            <span>${that.CargoService.CurrentJob.ArrivalAirport.DistanceFromStart} NM</span>
        `);

        // "Loading <item name>"
        // for 4 seconds
        loadingLabel.fadeIn(200).delay(4000).queue(function () {
            loadingLabel.hide().dequeue();
            // "Securing cargo"
            // for 2 seconds
            securingLabel.fadeIn(200).delay(2000).queue(function () {
                securingLabel.hide().dequeue();
                // "Confirming flight to <icao> with Mission Control"
                // for 3 seconds
                confirmingLabel.fadeIn(200).delay(3000).queue(function () {
                    confirmingLabel.hide().dequeue();
                    // "Estimated distance: <distance> NM"
                    // for 3 seconds
                    distanceLabel.fadeIn(200).delay(4000).queue(function () {
                        distanceLabel.fadeOut().dequeue();

                        let html = `
                            <div id="cargoMissionTop">
                                <div id="cargoMissionLabel">
                                    <div>Active Mission:</div>
                                    <div id="cargoMissionWarning">
                                        Some airports could be missing from your
                                        flight simulator installation.
                                        <br>
                                        <br>
                                        If you are unable to find the destination
                                        ICAO in your Garmin G3000, please cancel
                                        this mission and select another destination.
                                    </div>
                                </div>
                                <div id="cargoMissionSummary">
                                    <div>
                                        <span class="cargo-mission-label">Destination Country:</span>
                                        ${that.CargoService.CurrentJob.ArrivalAirport.Country}
                                    </div>
                                    <div>
                                        <span class="cargo-mission-label">Destination Airport ICAO:</span>
                                        ${that.CargoService.CurrentJob.ArrivalAirport.Icao} <span class="highlight">*</span>
                                    </div>
                                    <div>
                                        <span class="cargo-mission-label">Runway Length:</span>
                                        ${that.CargoService.CurrentJob.ArrivalAirport.RunwayLength} FT
                                    </div>
                                    <div>
                                        <span class="cargo-mission-label">Total Distance:</span>
                                        ${that.CargoService.CurrentJob.ArrivalAirport.DistanceFromStart} NM
                                    </div>
                                    <div>
                                        <span class="cargo-mission-label">Cargo:</span>
                                        ${that.CargoService.CurrentJob.CargoItemName}
                                    </div>
                                </div>
                            </div>
                            <div id="cargoMissionInstructions">
                                <span class="qurple">${that.CargoService.CurrentJob.CargoItemName}</span> Loaded.
                                Reach target airport (
                                    <span class="qurple">${that.CargoService.CurrentJob.ArrivalAirport.Icao}</span>
                                    in
                                    <span class="qurple">${that.CargoService.CurrentJob.ArrivalAirport.Country}</span>
                                ), park and open your canopy to be allowed to unload the cargo and complete the mission.
                            </div>
                            <div id="cargoProgressBar">
                                <div class="progress-label"></div>
                                <div class="progress-bar"></div>
                            </div>
                            <div id="cargoMissionButtons">
                                <button class="cargoMissionCancel">CANCEL MISSION</button>
                                <button class="cargoMissionComplete disabled">COMPLETE MISSION</button>
                            </div>
                        `;

                        cargoMission.html(html);
                        
                        let cancelButton = that.getDomItem(".cargoMissionCancel");
                        let confirmButton = that.getDomItem(".cargoMissionComplete");
                        cancelButton.playSound = true;
                        confirmButton.playSound = true;
                        cancelButton.addEventListener("mousedown", that.getEventListener(that.cargoMissionCancelManual.name, "mousedown"));

                        that.cargoBtnClean();

                        that.SimvarService.SetSimVar("L:QSR_Cargo_Active", "number", 1);
                        that.SimvarService.SetSimVar("L:KARA_Cargo_Started", "number", 1 - that.SimvarService.GetSimVar("L:KARA_Cargo_Started", "number"));
                    })
                })
            })
        })
    }

    resetCargoMissionContainer() {
        $("#cargoMission").html(`
            <div id="loading-container">
                <div id="loading-label-loading"></div>
                <div id="loading-label-securing"></div>
                <div id="loading-label-confirming"></div>
                <div id="loading-label-distance"></div>
                <div id="loading">
                    <div id="loading-value"></div>
                </div>
            </div>
        `);
    }

    cargoMissionCancelManual(e) {
        this.confirm(
            "Are you sure you want to cancel?",
            `
                You will not be able to start a new mission unless you are stopped,
                on the ground, with your parking brake set and canopy open.
            `,
            "I'm sure",
            "Go Back",
            this.cargoMissionCancel.bind(this),
            { playSound: true }
        )
    }

    cargoMissionCancel(e) {
        let tgt = e.target || e;
        let playSound = $(tgt).attr("playSound") == "true";
        let [cargoGrid, cargoMission] = [
            $("#cargoGrid"),
            $("#cargoMission"),
        ];

        $("#confirm-overlay").fadeOut();
        this.CargoService.reset();

        this.SimvarService.SetSimVar("L:QSR_Cargo_Active", "number", 0);
        if (playSound) {
            this.SimvarService.SetSimVar(
                "L:KARA_Cargo_Failed",
                "number",
                1 - this.SimvarService.GetSimVar("L:KARA_Cargo_Failed", "number")
            );
        }

        let that = this;
        cargoMission.fadeOut(600).queue(function () {
            that.resetCargoMissionContainer();

            let cargoTable = $("#cargoTable > tbody");
            cargoTable.html("");
            $("#rangeSlider").fadeOut();
            $("#cargoNavButtons").fadeOut();

            $("#cargoLeft").css("width", "");
            $("#cargoRight").fadeIn();
            $("#cargoGrid").css({
                "display": "",
            });

            cargoGrid
                .fadeIn(600)
                .queue(function () {
                    $("#loading-label-loading").html("");
                    $("#loading-label-securing").html("");
                    $("#loading-label-confirming").html("");
                    $("#loading-label-distance").html("");
                    $("#loading-container").fadeOut();
                })
                .dequeue();
        })
            .dequeue();
    }

    cargoMissionComplete() {
        let range = +this.CargoService.CurrentJob.ArrivalAirport.DistanceFromStart;
        let currentTotalDistance = +this.SimvarService.GetSimVar("L:QSR_Cargo_Distance", "number")
        let currentTotalDistanceMillions = +this.SimvarService.GetSimVar("L:QSR_Cargo_Distance_Millions", "number")
        let currentTotalMissionsCompleted = +this.SimvarService.GetSimVar("L:QSR_Cargo_Missions", "number")

        currentTotalDistance += range;
        if(currentTotalDistance > 1000000){
            currentTotalDistance -= 1000000;
            currentTotalDistanceMillions++;
        }
        currentTotalMissionsCompleted++;

        this.SimvarService.SetMultipleSimVars({
            "L:QSR_Cargo_Distance": +currentTotalDistance,
            "L:QSR_Cargo_Distance_Millions": +currentTotalDistanceMillions,
            "L:QSR_Cargo_Missions": +currentTotalMissionsCompleted,
        }, "number")

        this.updateCargoPersonalData(
            currentTotalDistance,
            currentTotalDistanceMillions,
            currentTotalMissionsCompleted
        );

        this.resetCargoMissionContainer();

        let that = this;
        $("#loading-container")
            .css("display", "flex")
            .hide()
            .fadeIn(400);
        $("#loading-value").addClass("animate");

        let [loadingLabel, securingLabel, confirmingLabel, distanceLabel] = [
            $("#loading-label-loading"),
            $("#loading-label-securing"),
            $("#loading-label-confirming"),
            $("#loading-label-distance"),
        ];

        loadingLabel.html(`
            Completing mission to
            <span>${that.CargoService.CurrentJob.ArrivalAirport.Icao}</span>
            with Mission Control
        `);
        securingLabel.html("Unsecuring cargo");
        confirmingLabel.html(`
            Unloading
            <span>${that.CargoService.CurrentJob.CargoItemName}</span>
        `);
        distanceLabel.html(`
            <span>${that.CargoService.CurrentJob.ArrivalAirport.DistanceFromStart} NM</span>
            journey completed
        `);

        // "Completing mission to <icao> with Mission Control"
        // for 4 seconds
        loadingLabel.fadeIn(200).delay(4000).queue(function () {
            loadingLabel.hide().dequeue();
            // "Unsecuring cargo"
            // for 2 seconds
            securingLabel.fadeIn(200).delay(2000).queue(function () {
                securingLabel.hide().dequeue();
                // "Unloading <item name>"
                // for 3 seconds
                confirmingLabel.fadeIn(200).delay(3000).queue(function () {
                    confirmingLabel.hide().dequeue();
                    // "<distance> NM journey completed"
                    // for 3 seconds
                    distanceLabel.fadeIn(200).delay(4000).queue(function () {
                        distanceLabel.fadeOut().dequeue();

                        let missionHtml = `
                            <div id="cargoMissionCompletePage">
                                <div>
                                    <span>${that.CargoService.CurrentJob.CargoItemName}</span>
                                    has been delivered succesfully.
                                </div>
                                <div>
                                    You traveled
                                    <span>${range} NM</span>.
                                </div>
                                <div>
                                    You have now traveled a total of
                                    <span>${that.CargoService.TotalDistanceTraveledInNm.toLocaleString("en-US")}NM</span>
                                    <br>
                                    and completed
                                    <span>${that.CargoService.TotalMissionsCompleted}</span>
                                    missions.
                                </div>
                                <div>
                                    <button id="mission-finish">Finish</button>
                                </div>
                            </div>
                        `;
                        let missionDiv = that.getId("cargoMission");
                        missionDiv.innerHTML = missionHtml;

                        let finishButton = $("#mission-finish")
                        finishButton.attr("playSound", false);
                        finishButton.on("click", that.cargoMissionCancel.bind(that));

                        that.CargoService.HasTakenOffWithJob = false;
                        that.CargoService.HasLandedWithJob = false;
                        that.CargoService.HasParkedWithJob = false;
                        that.CargoService.HasCompletedJob = false;
                        
                        that.SimvarService.SetSimVar("L:QSR_Cargo_Active", "number", 0);
                        that.SimvarService.SetSimVar("L:KARA_Cargo_Done", "number", 1 - that.SimvarService.GetSimVar("L:KARA_Cargo_Done", "number"));
                    })
                })
            })
        })
    }

    grabBrightness(e) {
        this.playClick();

        this.isSettingBrightness = true;
        this.setBrightness(e);
    }

    releaseBrightness(_) {
        this.playClick();
        this.isSettingBrightness = false;

        this.SimvarService.SetSimVar("K:LIGHT_POTENTIOMETER_18_SET", "number", Math.round(this.pctBrightness));
    }

    setBrightness(e) {
        if (!this.isSettingBrightness) {
            return;
        }

        var initPosX = 194;
        var posX = e.pageX - initPosX;
        var pct = posX / 520 * 100;

        pct = Math.round(this.clamp(pct, 1, 1, 99, 100, true));

        this.brgtActionFilled.style.width = pct + "%";
        this.pctBrightness = pct;
    }

    playMusic(e) {
        this.SimvarService.SetSimVar("L:FRIES_EFB_Click", "bool", (1 - this.valEFBClick));

        var id = +e.target.getAttribute('data-music-line-id');
        if (id == this.valMusPlay) {
            id = -1;
        }

        // Account for 0-indexed array vs 1-indexed simvar
        this.SimvarService.SetSimVar("L:QSR_Music_Playing", "number", id + 1);
    }

    grabMusicVolume(e) {
        this.SimvarService.SetSimVar("L:FRIES_EFB_Click", "bool", (1 - this.valEFBClick));

        this.isSettingVolume = true;
        this.setMusicVolume(e);
    }

    releaseMusicVolume(e) {
        this.SimvarService.SetSimVar("L:FRIES_EFB_Click", "bool", (1 - this.valEFBClick));

        this.isSettingVolume = false;
        this.SimvarService.SetSimVar("L:QSR_Music_Vol", "number", this.musicPct);
    }

    setMusicVolume(e) {
        if (!this.isSettingVolume) {
            return;
        }

        var initPosX = 116;
        var posX = e.pageX - initPosX;
        var pct = posX / 750;

        pct = this.clamp(pct, 0.02, 0, 0.99, 100, true)

        this.musActionFilled.style.width = Math.round(pct * 100) + "%";
        this.musicPct = pct;
    }

    // * PAGE DRAWING FUCTIONS
    // *_____________________________________________________________________

    computeAndDrawMenuPage() {
        var pageDisplay = [
            ["homebar","hometext"],
            ["pageFuel"],
            ["pageAboard"],
            ["pageRbf"],
            ["pageOptions"],
            ["pageSpeed"],
            ["pageInfos"],
            ["pageCargo"],
            ["pageMusic", "musDisclaimer"],
        ];

        var pageMenuSel = [
            [],
            ["menuFuel"],
            ["menuAboard"],
            ["menuRbf"],
            ["menuOptions"],
            ["menuSpeeds"],
            ["menuInfos"],
            ["menuCargo"],
            ["menuMusic"],
        ];

        if (this.valEFBPage == 0) {
            this.menubar.style.display = "none";
            this.bg_blur.style.display = "none";
        } else {
            this.menubar.style.display = "block";
            this.bg_blur.style.display = "block";
        }

        for (let i = 0; i < pageMenuSel.length; i++) {
            if (this.valEFBPage == i) {
                pageDisplay[i].forEach((item) => { this[item].style.display = "block"; });
                pageMenuSel[i].forEach((item) => { this[item].classList.add("menuSel"); });
            } else {
                pageDisplay[i].forEach((item) => { this[item].style.display = "none"; });
                pageMenuSel[i].forEach((item) => { this[item].classList.remove("menuSel"); });
            }
        }
    }

    computeAndDrawAboardPage() {
        var charsElements = ["aboardPic", "aboardName", "aboardBio"];
        for (let i = 0; i < this.valCharsNumber; i++) {
            charsElements.forEach((item) =>
                this[item + i].style.display = `${i == this.valCharSelected ? "block" : "none"}`
            );
        }
    }

    computeAndDrawRbfPage() {
        // - Nose
        if (!this.valMachTest && this.valGS < 1) {
            this.rbfNose.classList.remove("rbfNotAvl");
            if (this.valRBFNose) {
                this.rbfNose.classList.remove("rbfOff");
                this.rbfPicNose.style.display = "block";
            } else {
                this.rbfNose.classList.add("rbfOff");
                this.rbfPicNose.style.display = "none";
            }
        } else {
            this.rbfNose.classList.add("rbfNotAvl");
            this.rbfNose.classList.remove("rbfOff");
            this.rbfPicNose.style.display = "none";
        }

        // - Roof
        if (this.valGS < 5) {
            this.rbfRoof.classList.remove("rbfNotAvl");
            if (this.valRBFRoof) {
                this.rbfRoof.classList.remove("rbfOff");
                this.rbfPicRoof.style.display = "block";
            } else {
                this.rbfRoof.classList.add("rbfOff");
                this.rbfPicRoof.style.display = "none";
            }
        } else {
            this.rbfRoof.classList.add("rbfNotAvl");
            this.rbfRoof.classList.remove("rbfOff");
            this.rbfPicRoof.style.display = "none";
        }

        // - Intakes
        if (this.valGS < 5) {
            this.rbfIntakes.classList.remove("rbfNotAvl");
            if (this.valRBFIntakes) {
                this.rbfIntakes.classList.remove("rbfOff");
                this.rbfPicIntakes.style.display = "block";
            } else {
                this.rbfIntakes.classList.add("rbfOff");
                this.rbfPicIntakes.style.display = "none";
            }
        } else {
            this.rbfIntakes.classList.add("rbfNotAvl");
            this.rbfIntakes.classList.remove("rbfOff");
            this.rbfPicIntakes.style.display = "none";
        }

        // - Engines
        if (!this.valEng1On || !this.valEng2On || !this.valEng3On || !this.valEng4On) {
            this.rbfEngines.classList.remove("rbfNotAvl");
            if (this.valRBFEngines) {
                this.rbfEngines.classList.remove("rbfOff");
                this.rbfPicEngines.style.display = "block";
            } else {
                this.rbfEngines.classList.add("rbfOff");
                this.rbfPicEngines.style.display = "none";
            }
        } else {
            this.rbfEngines.classList.add("rbfNotAvl");
            this.rbfEngines.classList.remove("rbfOff");
            this.rbfPicEngines.style.display = "none";
        }

        // - Chocks
        if (this.valCPoint0 && this.valCPoint1 && this.valCPoint2 && this.valGS < 1) {
            this.rbfChocks.classList.remove("rbfNotAvl");
            if (this.valRBFChocks) {
                this.rbfChocks.classList.remove("rbfOff");
                this.rbfPicChocks.style.display = "block";
            } else {
                this.rbfChocks.classList.add("rbfOff");
                this.rbfPicChocks.style.display = "none";
            }
        } else {
            this.rbfChocks.classList.add("rbfNotAvl");
            this.rbfChocks.classList.remove("rbfOff");
            this.rbfPicChocks.style.display = "none";
        }
    }

    computeAndDrawCargoPage() {
        if (
            this.CargoService.CurrentJob != null
        ) {
            let cancelButton = this.getDomItem(".cargoMissionCancel");
            let completeButton = this.getDomItem(".cargoMissionComplete");

            if (
                !this.CargoService.HasTakenOffWithJob &&
                !this.Restrictions.IsOnGround
            ) {
                console.log("Taken off");
                this.CargoService.HasTakenOffWithJob = true;
            }

            if(
                this.CargoService.HasTakenOffWithJob &&
                !this.CargoService.HasLandedWithJob &&
                this.Restrictions.IsOnGround
            ){
                console.log("Landed");
                this.CargoService.HasLandedWithJob = true;
            }

            if(
                this.CargoService.HasTakenOffWithJob &&
                this.CargoService.HasLandedWithJob &&
                !this.CargoService.HasParkedWithJob &&
                this.Restrictions.IsParkingBrakeOn &&
                this.Restrictions.IsCanopyOpen
            ){
                let groundVelocity = this.SimvarService.GetSimVar("GROUND VELOCITY", "knots");
                if(groundVelocity > 1){
                    console.log("still moving...")
                    return;
                }

                console.log("Stopped and parked");
                this.CargoService.HasParkedWithJob = true;
                this.cargoServiceReset();

                let distanceFromArrival = this
                    .CargoService
                    .getDistanceBetweenTwoPointsInNauticalMiles(
                        this.CargoService.CurrentJob.ArrivalAirport.Latitude,
                        this.CargoService.CurrentJob.ArrivalAirport.Longitude,
                        this.SimvarService.GetSimVar("A:GPS POSITION LAT", "degrees"),
                        this.SimvarService.GetSimVar("A:GPS POSITION LON", "degrees")
                    )

                if (
                    distanceFromArrival < 3 &&
                    !this.CargoService.HasCompletedJob
                ) {
                    console.log("Able to finish");
                    this.CargoService.HasCompletedJob = true;
                    completeButton.classList.remove("disabled");
                    completeButton.addEventListener(
                        "mousedown",
                        this.getEventListener(this.cargoMissionComplete.name, "mousedown")
                    );
                } else {
                    console.log("Not able to finish yet - going back to waiting period");
                    this.CargoService.HasTakenOffWithJob = false;
                    this.CargoService.HasLandedWithJob = false;
                    this.CargoService.HasParkedWithJob = false;
                    this.CargoService.HasCompletedJob = false;

                    completeButton.classList.add("disabled");
                    completeButton.removeEventListener(
                        "mousedown",
                        this.getEventListener(this.cargoMissionComplete.name, "mousedown")
                    );

                    cancelButton.playSound = true;
                }
            }
        }
    }

    computeAndDrawOptionsPage() {
        if (this.valNR) { this.optNR.innerHTML = 'Noise Reduction: ON'; }
        else { this.optNR.innerHTML = 'Noise Reduction: OFF'; }

        if (this.valVibr) {
            if (this.valVibrIntensity == 2) this.optVibr.innerHTML = 'Vibrations: NORMAL';
            else this.optVibr.innerHTML = 'Vibrations: LOW';
        }
        else this.optVibr.innerHTML = 'Vibrations: OFF';

        if (this.valVFX) this.optVFX.innerHTML = 'VFX: ON';
        else this.optVFX.innerHTML = 'VFX: OFF';

        if (this.valTempUnit) this.optTemp.innerHTML = 'Temp. Unit: CELSIUS';
        else this.optTemp.innerHTML = 'Temp. Unit: FAHRENHEIT';

        if (this.valShiver) this.optShiver.innerHTML = 'Shiver SFX: ON';
        else this.optShiver.innerHTML = 'Shiver SFX: OFF';

        if (this.valGraffiti) this.optGraffiti.innerHTML = 'Pseud\'s Graffiti: VISIBILE';
        else this.optGraffiti.innerHTML = 'Pseud\'s Graffiti: HIDDEN';

        if (this.valFries < 4 || this.valCans.some(c => c == 3)) {
            this.optFood.classList.remove('optGreyed');
        } else {
            this.optFood.classList.add('optGreyed');
        }
    }

    computeAndDrawMusicPage() {
        this.musActionFilled.style.width = (this.vol * 100) + "%";

        // revert this when back
        this.MusicLines.forEach((item, i) => {
            if (this.valMusPlay == i) {
                item.line.classList.add("musPlaying");
                item.icon.classList.remove("iconMusPlay");
                item.icon.classList.add("iconMusStop");
            } else {
                item.line.classList.remove("musPlaying");
                item.icon.classList.remove("iconMusStop");
                item.icon.classList.add("iconMusPlay");
            }
        });
    }

    computeAndDrawFooter() {
        // General Info
        this.versionText = this.valVMaj + '.' + this.valVMin + '.' + this.valVFix;
        this.version.innerHTML = this.versionText;
        this.flighthours.innerHTML = this.valFlightTime.toFixed(1);

        // Brightness
        if (this.valEFBBrgtPopup) { this.brgtOverlay.style.display = 'block'; }
        else { this.brgtOverlay.style.display = 'none'; }
        this.brgtActionFilled.style.width = this.pctBrightness + "%";
    }

    updateRestrictions() {
        this.Restrictions = {
            IsOnGround: this.SimvarService.GetSimVar("SIM ON GROUND", "bool"),
            IsParkingBrakeOn: this.SimvarService.GetSimVar("BRAKE PARKING POSITION", "bool"),
            IsCanopyOpen: this.SimvarService.GetSimVar("L:QSR_Canopy_Open", "bool"),
        }
    }

    updateCargoProgressBar() {
        if (this.CargoService.CurrentJob == null) {
            return;
        }

        let label = $("#cargoProgressBar > .progress-label"),
            bar = $("#cargoProgressBar > .progress-bar");

        let currentLatitude = this.SimvarService.GetSimVar("A:GPS POSITION LAT", "degrees"),
            currentLongitude = this.SimvarService.GetSimVar("A:GPS POSITION LON", "degrees");

        let progress = this.CargoService.getCurrentProgress(
            currentLatitude,
            currentLongitude
        );

        label.html(`
            Current progress: <span>${progress.percentage}%</span>
            |
            Remaining Distance: <span>${progress.distance} NM<span>
        `);
        bar.css(
            "width",
            `${progress.percentage}%`
        );
    }

    computeAndDraw() {
        // We'll only run this every 5 ticks
        if (this.TickCounter < 5) {
            this.TickCounter++;
        } else {
            this.TickCounter = 0;
            this.updateCargoProgressBar();
        }

        this.updateRestrictions();

        // General Info & EFB Brightness
        this.computeAndDrawFooter();

        // MENU - PAGES
        this.computeAndDrawMenuPage();

        // PAGE - ABOARD
        this.computeAndDrawAboardPage();

        // PAGE - R.B.F.
        this.computeAndDrawRbfPage();

        // PAGE - CARGO
        this.computeAndDrawCargoPage();

        // PAGE - OPTIONS
        this.computeAndDrawOptionsPage();

        // PAGE - MUSIC
        this.computeAndDrawMusicPage();
    }

    // * READ VARIABLES FROM THE SIM
    // *_____________________________________________________________________

    allSimvars() {
        // console.log("Loading vars")
        this.valVMaj = this.SimvarService.GetSimVar("L:Version_Major", "number");
        this.valVMin = this.SimvarService.GetSimVar("L:Version_Minor", "number");
        this.valVFix = this.SimvarService.GetSimVar("L:Version_Fix", "number");
        this.valEFBStatus = this.SimvarService.GetSimVar("L:FRIES_EFB", "bool");
        this.valEFBPage = this.SimvarService.GetSimVar("L:FRIES_EFB_Page", "number");
        this.valSimOnGround = this.SimvarService.GetSimVar("SIM ON GROUND", "bool");
        this.valEFBClick = this.SimvarService.GetSimVar("L:FRIES_EFB_Click", "bool");
        this.valEFBPageClick = this.SimvarService.GetSimVar("L:FRIES_EFB_Page_Click", "bool");
        this.valFlightTime = this.SimvarService.GetSimVar("L:FRIES_FlightTime", "number");
        this.valEFBBrgtPopup = this.SimvarService.GetSimVar("L:FRIES_EFB_Brgt", "bool");
        // this.pctBrightness = this.simvarService.GetSimVar("LIGHT POTENTIOMETER:18", "percent");

        // ABOARD
        this.valCharsNumber = this.SimvarService.GetSimVar("L:QSR_Chars_Number", "number");
        this.valCharSelected = this.SimvarService.GetSimVar("L:QSR_Char_Selected", "number");

        // R.B.F.
        this.valGS = this.SimvarService.GetSimVar("GROUND VELOCITY", "knots");
        this.valCPoint0 = this.SimvarService.GetSimVar("CONTACT POINT IS ON GROUND:0", "bool");
        this.valCPoint1 = this.SimvarService.GetSimVar("CONTACT POINT IS ON GROUND:1", "bool");
        this.valCPoint2 = this.SimvarService.GetSimVar("CONTACT POINT IS ON GROUND:2", "bool");
        this.valEng1On = this.SimvarService.GetSimVar("ENG COMBUSTION:1", "bool");
        this.valEng2On = this.SimvarService.GetSimVar("ENG COMBUSTION:2", "bool");
        this.valEng3On = this.SimvarService.GetSimVar("ENG COMBUSTION:3", "bool");
        this.valEng4On = this.SimvarService.GetSimVar("ENG COMBUSTION:4", "bool");
        this.valMachTest = this.SimvarService.GetSimVar("L:QSR_Mach_Test", "bool");

        this.valRBFNose = this.SimvarService.GetSimVar("L:QSR_Nose_Covers", "bool");
        this.valRBFEngines = this.SimvarService.GetSimVar("L:QSR_Engine_Covers", "bool");
        this.valRBFIntakes = this.SimvarService.GetSimVar("L:QSR_TopIntakes_Covers", "bool");
        this.valRBFRoof = this.SimvarService.GetSimVar("L:QSR_Roof_Cover", "bool");
        this.valRBFChocks = this.SimvarService.GetSimVar("L:QSR_Wheel_Chocks", "bool");

        // OPTIONS
        this.valNR = this.SimvarService.GetSimVar("L:FRIES_Headphones", "bool");
        this.valVibr = this.SimvarService.GetSimVar("L:FRIES_Vibrations", "bool");
        this.valVibrIntensity = this.SimvarService.GetSimVar("L:FRIES_Vibrations_Intensity", "number");
        this.valVFX = this.SimvarService.GetSimVar("L:FRIES_VFX", "bool");
        this.valTempUnit = this.SimvarService.GetSimVar("L:FRIES_TempUnit_Celsius", "bool");
        this.valShiver = this.SimvarService.GetSimVar("L:QSR_Shiver", "bool");
        this.valGraffiti = this.SimvarService.GetSimVar("L:QSR_Graffiti", "bool");

        this.valFries = this.SimvarService.GetSimVar("L:QSR_Fries", "number");


        this.valCans = this.SimvarService.GetMultipleSimVarsAsArray([
            "L:CAN1", "L:CAN2", "L:CAN3", "L:CAN4",
            "L:CAN5", "L:CAN6", "L:CAN7", "L:CAN8"
        ], "number");

        // MUSIC (account for 0-indexed array vs 1-indexed simvar)
        this.valMusPlay = this.SimvarService.GetSimVar("L:QSR_Music_Playing", "number") - 1;

        this.computeAndDraw();
    }

    // -------------------- DEFAULT GAUGE FUNCTIONS WITH BROWSER/SIM COMPATIBILTY -----------------------------

    // * GET ELEMENT/CHILD BY ID    
    // getId(domid) { if (this.browser) return document.getElementById(domid); else return this.getChildById(domid); }
    getDomItem(itemSelector) { return document.querySelector(itemSelector); }
    getDomItems(itemsSelector) { return document.querySelectorAll(itemsSelector); }
    getClass(domClass) { return this.getDomItems(`.${domClass}`); }
    getId(domId) { return this.getDomItem(`#${domId}`); }

    // In the case of percentages our clamp will set to 0 and 100 instead of min and max
    clamp(num, min, minTarget, max, maxTarget) {
        return num < min ? minTarget : num > max ? maxTarget : num;
    }

    playClick() {
        this.SimvarService.SetSimVar("L:FRIES_EFB_Click", "bool", (1 - this.valEFBClick));
    }

    // * GET VARIABLE
    // getSimvar(name, unit, browVal) { if (this.browser) return browVal; else return SimVar.GetSimVarValue(name, unit); }

    // * GAUGE UPDATE CALLED ON SIM UPDATE CYCLE
    Update() { if (!this.Browser) { super.Update(); } this.allSimvars(); }

    // * DISCONNECTED CALLBACK
    disconnectedCallback() { super.disconnectedCallback(); }

    saveEventListener(id, type, listener) {
        this.EventListeners[`${id}.${type}`] = listener;
    }

    getEventListener(id, type) {
        return this.EventListeners[`${id}.${type}`];
    }
}

// Couldn't get this working with a modern class, without arrow funcs
// A tidy-up is already planned here
class RangeSlider {
    constructor(parent, container, min, max) {
        this.parent = parent;
        this.container = container;
        this.track = container.querySelector('.mission-range-track');
        this.fill = container.querySelector('.mission-range-fill');
        this.minHandle = container.querySelector('#minHandle');
        this.maxHandle = container.querySelector('#maxHandle');
        this.minValue = container.querySelector('#mission-range1');
        this.maxValue = container.querySelector('#mission-range2');

        this.min = min;
        this.max = max;
        this.activeHandle = null;

        // Bind methods to preserve 'this' context
        this.onHandleMouseDown = this.onHandleMouseDown.bind(this);
        this.onDrag = this.onDrag.bind(this);
        this.onDragEnd = this.onDragEnd.bind(this);

        this.init();
    }

    updateMinMax(min, max) {
        this.min = min;
        this.max = max;
        this.resetLabels();
        this.resetHandles();
    }

    resetHandles() {
        this.setPosition(this.minHandle, 0);
        this.setPosition(this.maxHandle, 100);
        this.updateFill();
    }

    resetLabels() {
        this.minValue.textContent = `${Math.round(this.percentToValue(0))} NM`;
        this.maxValue.textContent = `${Math.round(this.percentToValue(100))} NM`;
    }

    init() {
        this.setPosition(this.minHandle, 0);
        this.setPosition(this.maxHandle, 100);
        this.updateFill();

        this.minHandle.addEventListener('mousedown', this.onHandleMouseDown);
        this.maxHandle.addEventListener('mousedown', this.onHandleMouseDown);
    }

    setPosition(handle, percent) {
        handle.style.left = percent + '%';
    }

    updateFill() {
        var minPercent = parseFloat(this.minHandle.style.left);
        var maxPercent = parseFloat(this.maxHandle.style.left);
        this.fill.style.left = minPercent + '%';
        this.fill.style.width = (maxPercent - minPercent) + '%';
    }

    percentToValue(percent) {
        return this.min + (percent / 100) * (this.max - this.min);
    }
}

RangeSlider.prototype.onHandleMouseDown = function (e) {
    this.activeHandle = e.target;
    document.addEventListener('mousemove', this.onDrag);
    document.addEventListener('mouseup', this.onDragEnd);
    e.preventDefault();
};

RangeSlider.prototype.onDrag = function (e) {
    if (!this.activeHandle) {
        return;
    }

    var rect = this.track.getBoundingClientRect();
    var percent = ((e.clientX - rect.left) / rect.width) * 100;
    percent = Math.min(Math.max(percent, 0), 100);

    if (this.activeHandle === this.minHandle) {
        var maxPercent = parseFloat(this.maxHandle.style.left);
        if (percent < maxPercent) {
            this.setPosition(this.minHandle, percent);
            this.minValue.textContent = Math.round(this.percentToValue(percent)) + " NM";
        }
    } else {
        var minPercent = parseFloat(this.minHandle.style.left);
        if (percent > minPercent) {
            this.setPosition(this.maxHandle, percent);
            this.maxValue.textContent = Math.round(this.percentToValue(percent)) + " NM";
        }
    }

    this.updateFill();
};

RangeSlider.prototype.onDragEnd = function () {
    this.activeHandle = null;
    document.removeEventListener('mousemove', this.onDrag);
    document.removeEventListener('mouseup', this.onDragEnd);

    let [min, max] = [
        parseInt(this.minValue.textContent),
        parseInt(this.maxValue.textContent),
    ];

    this.parent.updateCargoListWithMinMax(min, max);
};

/* MSFS Format */
registerInstrument("quasar-efb", QuasarEFB);

/* Browser Format */
// customElements.define('quasar-efb', QuasarEFB);